<?php

function hello_elementor_child_enqueue_styles()
{
    wp_enqueue_style('hello-elementor-parent-style', get_template_directory_uri() . '/../hello-elementor-child/style.css');
    wp_enqueue_style('hello-elementor-parent-ecommerce', get_template_directory_uri() . '/../hello-elementor-child/ecommerce.css');
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles');


// Enqueue Booststrap 
function enqueue_bootstrap()
{
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js', array('jquery'), null, true);

}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');


//  Slick carousel script and styles
function enqueue_slick_scripts()
{
    wp_enqueue_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js', array('jquery'), null, true);
    wp_enqueue_style('slick-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_slick_scripts');


function enqueue_custom_script()
{
    wp_enqueue_script(
        'custom-script',
        get_template_directory_uri() . '../../hello-elementor-child/custom-script.js',
        array('jquery'),
        null,
        true
    );
}
add_action('wp_enqueue_scripts', 'enqueue_custom_script');



// custom code



// blog related start --------------------

function get_related_articles($post_id, $number_of_posts = 5)
{

    $args = array(
        'post_type' => 'post',
        'post__not_in' => array($post_id),
        'posts_per_page' => $number_of_posts,
        'ignore_sticky_posts' => 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );

    return get_posts($args);

    $related_posts = get_related_articles(get_the_ID());

    // If not enough related posts by category, get related posts by tag
    if (count($related_posts) < $number_of_posts) {
        $tags = wp_get_post_tags($post_id);
        if ($tags) {
            $tag_ids = array();
            foreach ($tags as $tag) {
                $tag_ids[] = $tag->term_id;
            }
            $args = array(
                'tag__in' => $tag_ids,
                'post__not_in' => array_merge(array($post_id), wp_list_pluck($related_posts, 'ID')),
                'posts_per_page' => $number_of_posts - count($related_posts),
                'ignore_sticky_posts' => 1,
            );
            $more_related_posts = get_posts($args);
            $related_posts = array_merge($related_posts, $more_related_posts);
        }
    }

    return $related_posts;
}

// blog related end --------------------




// woocommerce code start here ---------------------


//  WooCommerce product  image wrap  ----------
add_action('woocommerce_before_shop_loop_item_title', 'wrap_product_image_in_div', 5);
function wrap_product_image_in_div()
{
    echo '<div class="product-image-wrapper">';
}
add_action('woocommerce_before_shop_loop_item_title', 'close_product_image_div', 15);
function close_product_image_div()
{
    echo '</div>';
}
//  WooCommerce product image wrap ----------



function change_related_products_heading($translated_text, $text, $domain)
{
    if ('Related products' === $text) {
        $translated_text = __('Similar Products', 'your-text-domain');
    }
    return $translated_text;
}
add_filter('gettext', 'change_related_products_heading', 20, 3);






// product-categories start ----------------------------------------- 
function wpb_woocommerce_product_categories_accordion()
{
    // Get the current queried product category
    $queried_object = get_queried_object();
    $current_category_id = ($queried_object && isset($queried_object->term_id)) ? $queried_object->term_id : 0;

    // Get all parent categories of the current category
    $current_category_parents = [];
    if ($current_category_id) {
        $parent_categories = get_ancestors($current_category_id, 'product_cat');
        $current_category_parents = array_map('intval', $parent_categories);
    }

    // Recursive function to get subcategories with checkboxes
    function get_subcategories($parent_id, $level = 1, $current_category_id, $current_category_parents)
    {
        $args = array(
            'taxonomy' => 'product_cat',
            'orderby' => 'name',
            'order' => 'ASC',
            'parent' => $parent_id,
            'hide_empty' => true
        );
        $sub_categories = get_terms($args);

        if (!empty($sub_categories)) {
            echo '<ul class="list-unstyled ps-2">';
            foreach ($sub_categories as $sub_category) {
                $is_checked = ($sub_category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($sub_category->term_id == $current_category_id) ? 'current-category' : '';

                echo '<li class="' . $active_class . '">';
                echo '<div class="in-menu">';
                echo '<input type="checkbox" class="category-checkbox me-2" data-category-id="' . $sub_category->term_id . '" ' . $is_checked . '> ';

                echo '<a href="' . get_term_link($sub_category) . '">  <span class="customcheck"></span>' . $sub_category->name . '</a>';
                echo '</div>';
                get_subcategories($sub_category->term_id, $level + 1, $current_category_id, $current_category_parents);
                echo '</li>';
            }
            echo '</ul>';
        }
    }

    // Get main product categories (parent categories)
    $args = array(
        'taxonomy' => 'product_cat',
        'orderby' => 'name',
        'order' => 'ASC',
        'parent' => 0,
        'hide_empty' => true
    );
    $product_categories = get_terms($args);

    if ($product_categories) {
        ob_start();
        ?>
        <div class="accordion" id="productCategoriesAccordion">

            <?php
            $shop_page_url = wc_get_page_permalink('shop');
            $is_shop_page = is_shop();
            ?>

            <div class="accordion-item">
                <div class="accordion-header <?php echo $is_shop_page ? 'current-category' : ''; ?>">
                    <label>
                        <a href="<?php echo esc_url($shop_page_url); ?>" class="main-category">
                            All
                        </a>
                    </label>
                </div>
            </div>


            <?php
            $i = 0;
            foreach ($product_categories as $category) {
                $i++;

                // Check if the category has subcategories
                $sub_args = array(
                    'taxonomy' => 'product_cat',
                    'parent' => $category->term_id,
                    'hide_empty' => true
                );
                $sub_categories = get_terms($sub_args);
                $has_subcategories = !empty($sub_categories);

                // Determine if this category should be expanded
                $is_checked = ($category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'current-category' : '';
                $show_collapse = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'show' : '';
                ?>
                <div class="accordion-item <?php echo $active_class; ?>">
                    <div class="accordion-header d-flex align-items-center" id="heading<?php echo $i; ?>">
                        <label for="cat<?php echo $category->term_id; ?>">
                            <input type="checkbox" class="category-checkbox me-2" id="cat<?php echo $category->term_id; ?>"
                                data-category-id="<?php echo $category->term_id; ?>" <?php echo $is_checked; ?>>

                            <a href="<?php echo get_term_link($category); ?>" class="main-category">
                                <span class="customcheck"></span> <?php echo $category->name; ?>
                            </a>
                        </label>

                        <?php if ($has_subcategories) { ?>
                            <button class="accordion-button ms-auto <?php echo ($show_collapse == '') ? 'collapsed' : ''; ?>"
                                type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>"
                                aria-expanded="<?php echo ($show_collapse) ? 'true' : 'false'; ?>"
                                aria-controls="collapse<?php echo $i; ?>" data-category-id="<?php echo $category->term_id; ?>">
                                <i class="fa fa-angle-down"></i>
                            </button>
                        <?php } ?>
                    </div>
                    <?php if ($has_subcategories) { ?>
                        <div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse <?php echo $show_collapse; ?>"
                            aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#productCategoriesAccordion">
                            <div class="accordion-body ps-0 pe-0">
                                <?php get_subcategories($category->term_id, 1, $current_category_id, $current_category_parents); ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
                <?php
            }
            ?>
        </div>

        <script>
            document.addEventListener("DOMContentLoaded", function () {
                var savedCategories = JSON.parse(localStorage.getItem("checkedCategories")) || [];

                savedCategories.forEach(function (categoryId) {
                    var checkbox = document.querySelector('.category-checkbox[data-category-id="' + categoryId + '"]');
                    if (checkbox) {
                        checkbox.checked = true;
                    }
                });

                document.querySelectorAll(".category-checkbox").forEach(function (checkbox) {
                    checkbox.addEventListener("change", function () {
                        var categoryId = this.getAttribute("data-category-id");
                        if (this.checked) {
                            if (!savedCategories.includes(categoryId)) {
                                savedCategories.push(categoryId);
                            }
                        } else {
                            savedCategories = savedCategories.filter(id => id !== categoryId);
                        }
                        localStorage.setItem("checkedCategories", JSON.stringify(savedCategories));
                    });
                });

                var activeCategory = localStorage.getItem("activeCategory");
                if (activeCategory) {
                    var activeAccordion = document.querySelector('[data-category-id="' + activeCategory + '"]');
                    if (activeAccordion) {
                        var collapseElement = activeAccordion.getAttribute("data-bs-target");
                        document.querySelector(collapseElement).classList.add("show");
                        activeAccordion.classList.remove("collapsed");
                        activeAccordion.setAttribute("aria-expanded", "true");
                    }
                }

                document.querySelectorAll(".accordion-button").forEach(function (button) {
                    button.addEventListener("click", function () {
                        var categoryId = this.getAttribute("data-category-id");
                        if (document.querySelector(this.getAttribute("data-bs-target")).classList.contains("show")) {
                            localStorage.removeItem("activeCategory");
                        } else {
                            localStorage.setItem("activeCategory", categoryId);
                        }
                    });
                });
            });
        </script>

        <style>
            .current-category>a {
                font-weight: bold;
                color: #ff6600;
            }

            .category-checkbox {
                display: none;
            }

            span.customcheck {
                background: #FFFFFF 0% 0% no-repeat padding-box;
                border: 1px solid #B7DBEE;
                border-radius: 5px;
                width: 15px;
                height: 15px;
                position: relative;
                margin-right: 6px;
                margin-top: 0px;
                top: 2px;
                display: none;
            }

            .current-category [type=checkbox]:checked~a span.customcheck {
                background: #326783;
                border-color: #326783;
            }

            .current-category [type=checkbox]~a .customcheck:after {
                content: "";
                position: absolute;
            }

            .current-category a input:checked~.customcheck:after {
                display: block;
            }

            .current-category a .customcheck:after {
                left: 5px;
                top: 2px;
                width: 4px;
                height: 8px;
                border: solid white;
                border-width: 0 2px 2px 0;
                -webkit-transform: rotate(45deg);
                -ms-transform: rotate(45deg);
                transform: rotate(45deg);
            }
        </style>
        <?php
        return ob_get_clean();
    }
}

add_shortcode('product_categories_accordion', 'wpb_woocommerce_product_categories_accordion');

// product category for sidebar end -------------------------------





// brand filter -------------------

// brand start --------
function apply_brand_checkbox_filter_to_products($query)
{
    if (is_admin() || !$query->is_main_query()) {
        return;
    }

    // Only apply on shop or product archive pages
    if (is_post_type_archive('product') || is_tax('product_cat')) {

        if (!empty($_GET['product_brand']) && is_array($_GET['product_brand'])) {
            $brands = array_map('sanitize_text_field', $_GET['product_brand']);

            // Fetch existing tax_query and merge
            $tax_query = (array) $query->get('tax_query');

            $tax_query[] = array(
                'taxonomy' => 'product_brand',
                'field' => 'slug',
                'terms' => $brands,
                'operator' => 'IN',
            );

            $query->set('tax_query', $tax_query);
        }
    }
}
add_action('pre_get_posts', 'apply_brand_checkbox_filter_to_products');



function brand_archive_checkbox_filter_shortcode()
{
    $terms = get_terms(array(
        'taxonomy' => 'product_brand',
        'hide_empty' => true,
    ));

    if (empty($terms) || is_wp_error($terms)) {
        return '<p>No brands available.</p>';
    }

    $current_term = is_tax('product_brand') ? get_queried_object() : null;

    ob_start(); ?>
    <form method="get" id="brand-archive-filter" class="brand-filter-form">
        <div class="brand-filter-checkboxes">
            <?php foreach ($terms as $term): ?>
                <?php
                $checked = ($current_term && $current_term->term_id === $term->term_id) ? 'checked' : '';
                ?>
                <label>
                    <p class="mb-0 d-inline"><?php echo esc_html($term->name); ?> </p>
                    <input type="checkbox" name="brand" value="<?php echo esc_url(get_term_link($term)); ?>"
                        onchange="window.location.href = this.value;" <?php echo $checked; ?>>

                    <!-- <span class="customcheckbox"> </span> -->
                </label>
            <?php endforeach; ?>
        </div>
    </form>
    <?php
    return ob_get_clean();
}
add_shortcode('brand_checkbox_filter', 'brand_archive_checkbox_filter_shortcode');








// single shop banner  start ---------------------------
// Remove default breadcrumb location
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);

// Add breadcrumb before product title
add_action('woocommerce_single_product_summary', 'woocommerce_breadcrumb', 4);














// validation start -----------------------------------------------------------



// validation woocommerce start 


add_action('woocommerce_save_account_details_errors', 'validate_my_account_fields', 10, 1);

function validate_my_account_fields($errors)
{
    // Validate First Name
    if (isset($_POST['account_first_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_first_name'])) {
        $errors->add('validation', __('Allowed characters for First Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Last Name
    if (isset($_POST['account_last_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_last_name'])) {
        $errors->add('validation', __('Allowed characters for Last Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Display Name
    if (isset($_POST['account_display_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_display_name'])) {
        $errors->add('validation', __('Allowed characters for Display Name are alphabets and spaces only.', 'woocommerce'));
    }
}




add_action('woocommerce_after_save_address_validation', 'validate_billing_address_fields', 10, 2);

function validate_billing_address_fields($user_id, $address_type)
{
    if ('billing' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $billing_first_name = isset($_POST['billing_first_name']) ? sanitize_text_field($_POST['billing_first_name']) : '';
        $billing_last_name = isset($_POST['billing_last_name']) ? sanitize_text_field($_POST['billing_last_name']) : '';
        $billing_city = isset($_POST['billing_city']) ? sanitize_text_field($_POST['billing_city']) : '';
        $billing_address_1 = isset($_POST['billing_address_1']) ? sanitize_text_field($_POST['billing_address_1']) : '';

        $billing_postcode = isset($_POST['billing_postcode']) ? sanitize_text_field($_POST['billing_postcode']) : '';
        $billing_email = isset($_POST['billing_email']) ? sanitize_email($_POST['billing_email']) : '';

        // Validate Billing First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_first_name)) {
            $validation_errors[] = __('Allowed characters for Billing First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_last_name)) {
            $validation_errors[] = __('Allowed characters for Billing Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_city)) {
            $validation_errors[] = __('Allowed characters for Billing City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $billing_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $billing_postcode)) {
            $validation_errors[] = __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate Billing Email (Basic Email validation)
        if (!is_email($billing_email)) {
            $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}








add_action('woocommerce_after_save_address_validation', 'validate_shipping_address_fields', 10, 2);

function validate_shipping_address_fields($user_id, $address_type)
{
    if ('shipping' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $shipping_first_name = isset($_POST['shipping_first_name']) ? sanitize_text_field($_POST['shipping_first_name']) : '';
        $shipping_last_name = isset($_POST['shipping_last_name']) ? sanitize_text_field($_POST['shipping_last_name']) : '';
        $shipping_city = isset($_POST['shipping_city']) ? sanitize_text_field($_POST['shipping_city']) : '';
        $shipping_address_1 = isset($_POST['shipping_address_1']) ? sanitize_text_field($_POST['shipping_address_1']) : '';

        $shipping_postcode = isset($_POST['shipping_postcode']) ? sanitize_text_field($_POST['shipping_postcode']) : '';
        //  $shipping_email = isset($_POST['shipping_email']) ? sanitize_email($_POST['shipping_email']) : '';

        // Validate shipping First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_first_name)) {
            $validation_errors[] = __('Allowed characters for shipping First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_last_name)) {
            $validation_errors[] = __('Allowed characters for shipping Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_city)) {
            $validation_errors[] = __('Allowed characters for shipping City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $shipping_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $shipping_postcode)) {
            $validation_errors[] = __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate shipping Email (Basic Email validation)
        // if (!is_email($shipping_email)) {
        //     $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        // }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}




// validation woocommerce end --------------------







// contact form validation 

// Validate text fields (only alphabets allowed)
add_filter('wpcf7_validate_text', 'alpha_validation_filter_text', 20, 2);
add_filter('wpcf7_validate_text*', 'alpha_validation_filter_text', 20, 2);

function alpha_validation_filter_text($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('names' === $tag->name) {
        $name_of_the_input = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input)) {
            $result->invalidate($tag, "Allowed characters are Alphabets only.");
        }
    }

    if ('lname' === $tag->name) {
        $name_of_the_input = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input)) {
            $result->invalidate($tag, "Allowed characters are Alphabets only.");
        }
    }

    return $result;
}

// Validate phone number (must be exactly 10 digits)
add_filter('wpcf7_validate_tel', 'numeric_phone_validation_filter', 20, 2);
add_filter('wpcf7_validate_tel*', 'numeric_phone_validation_filter', 20, 2);

function numeric_phone_validation_filter($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('phone' === $tag->name) {
        $phone_number = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!preg_match('/^\d{8}$/', $phone_number)) {
            $result->invalidate($tag, "Phone number must contain exactly 8 digits.");
        }
    }

    return $result;
}



// Validate email (must be a valid email format)
add_filter('wpcf7_validate_email', 'validate_email_filter', 20, 2);
add_filter('wpcf7_validate_email*', 'validate_email_filter', 20, 2);

function validate_email_filter($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('email' === $tag->name) {
        $email = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $result->invalidate($tag, "Please enter a valid email address.");
        }
    }

    return $result;
}


// Validate textarea field (message)
add_filter('wpcf7_validate_textarea', 'validate_textarea_filter', 20, 2);
add_filter('wpcf7_validate_textarea*', 'validate_textarea_filter', 20, 2);

function validate_textarea_filter($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('message' === $tag->name) {
        $message = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        // Allowed characters: alphabets, spaces, common punctuation marks
        if (!preg_match('/^[a-zA-Z0-9\s.,!?()-]+$/', $message)) {
            $result->invalidate($tag, "Message contains invalid characters. Only letters, numbers, spaces, and punctuation are allowed.");
        }

        // Min 10 characters, Max 500 characters
        if (strlen($message) < 10 || strlen($message) > 500) {
            $result->invalidate($tag, "Message must be between 10 and 500 characters.");
        }
    }

    return $result;
}




// validation end -----------------------------------------------------------


// Add custom quantity buttons JS start -----------

add_action('wp_footer', 'custom_quantity_buttons_script');
function custom_quantity_buttons_script()
{
    if (!is_product())
        return;
    ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const qtyContainers = document.querySelectorAll('.quantity');
            qtyContainers.forEach(qty => {
                const input = qty.querySelector('input.qty');
                if (!input) return;

                // Remove existing buttons (if any)
                if (qty.querySelector('.custom-plus')) return;

                // Create buttons
                const minus = document.createElement('button');
                minus.type = 'button';
                minus.innerHTML = '−';
                minus.className = 'custom-minus';

                const plus = document.createElement('button');
                plus.type = 'button';
                plus.innerHTML = '+';
                plus.className = 'custom-plus';

                // Insert buttons
                qty.insertBefore(minus, input);
                qty.appendChild(plus);

                // Event listeners
                minus.addEventListener('click', () => {
                    if (input.value > 1) input.value = parseInt(input.value) - 1;
                });
                plus.addEventListener('click', () => {
                    input.value = parseInt(input.value) + 1;
                });
            });
        });
    </script>
    <?php
}

// Add custom quantity buttons JS end --------------






// theme code start 




// promotion start 
function display_promotion($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 4,
        ),
        $atts,
        'promotion'
    );

    // Query args
    $args = array(
        'post_type' => 'promotion',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );

    $promotion_query = new WP_Query($args);

    ob_start();

    if ($promotion_query->have_posts()): ?>
        <div class="project-page project-main">
            <div class="row g-md-5 g-3">
                <?php while ($promotion_query->have_posts()):
                    $promotion_query->the_post(); ?>
                    <div class="col-lg-6">
                        <div class="promotion-box">
                            <a href="<?php echo get_the_permalink(); ?>">
                                <div class="promotion-wrap-content">
                                    <?php $tag_title = get_field('tag_title');
                                    if ($tag_title): ?>
                                        <span class="badge"><?php echo $tag_title; ?></span>
                                    <?php endif; ?>
                                    <h3 class="mb-2"><?php echo get_the_title(); ?> </h3>
                                    <p><?php echo get_the_excerpt(); ?></p>
                                </div>
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                } ?>
                            </a>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>

            <?php if ($promotion_query->max_num_pages > 1): ?>
                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                    <div class="pagination-style-one">
                        <?php
                        echo paginate_links(array(
                            'total' => $promotion_query->max_num_pages,
                            'current' => max(1, get_query_var('paged')),
                            'format' => '?paged=%#%',
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => '<i class="eicon-angle-left"></i>',
                            'next_text' => '<i class="eicon-angle-right"></i>',
                            'end_size' => 2,
                            'mid_size' => 2
                        ));
                        ?>
                    </div>
                </div>
            <?php endif; ?>

            <script>
            document.addEventListener("DOMContentLoaded", function() {
                function matchHeights(selector) {
                    const screenWidth = window.innerWidth;
                    const elements = document.querySelectorAll(selector);

                    elements.forEach(el => el.style.height = 'auto');

                    if (screenWidth > 767) {
                        for (let i = 0; i < elements.length; i += 2) {
                            const group = [elements[i], elements[i + 1]].filter(Boolean);
                            const maxHeight = Math.max(...group.map(el => el.offsetHeight));
                            group.forEach(el => el.style.height = maxHeight + 'px');
                        }
                    }
                }

                function applyEqualHeights() {
                    matchHeights('.promotion-box h3');
                    matchHeights('.promotion-box p');
                }

                applyEqualHeights();
                window.addEventListener('resize', applyEqualHeights);
            });
            </script>

        </div>
    <?php
    else:
        echo 'No promotion found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('our_promotion', 'display_promotion');

// promotion end


// testimonials slider start------------------
function display_testimonials_slider($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => -1,
        ),
        $atts,
        'testimonials'
    );

    $args = array(
        'post_type' => 'testimonial',
        'posts_per_page' => $atts['posts_per_page'],
        'meta_query' => array(
            array(
                'key' => '_is_ns_featured_post',
                'value' => 'yes',
                'compare' => '='
            )
        )
    );

    $testimonials_query = new WP_Query($args);


    ob_start();

    if ($testimonials_query->have_posts()): ?>
            <div class="testimonials-slider">
                <div class="testimonials-slider-one">
                    <?php while ($testimonials_query->have_posts()):
                        $testimonials_query->the_post();
                        $post_id = get_the_ID();
                        ?>

                        <div class="item ps-2 pe-2">
                            <div class="testimonials-box-one">
                                <div class="testimonial-header d-flex align-items-center mb-4">
                                    <div class="img-wrap">
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                        } ?>
                                    </div>
                                    <div class="testimonials-wrap">
                                        <h1 class="title"> <?php echo get_the_title(); ?> </h1>

                                        <?php
                                        $rating = get_field('rating');
                                        if ($rating):
                                            echo '<div class="rating">';
                                            echo str_repeat('★', $rating);
                                            echo '</div>';
                                        endif;
                                        ?>

                                    </div>

                                    <?php
                                    $google_url = get_field('google_url');

                                    if ($google_url) {
                                        $google_url = esc_url($google_url);
                                        echo '<a href="' . $google_url . '" target="_blank" rel="noopener noreferrer">
                                       <img src="https://draftsite1.com/aande-unisex-salon/wp-content/uploads/2025/09/google.svg" alt="" class="testimonial-type">
                                    </a>';
                                    }
                                    ?>



                                </div>

                                <div class="content-box">
                                    <div class="description">
                                        <?php
                                        $content = get_the_content();
                                        $clean_content = wp_strip_all_tags(strip_shortcodes($content));
                                        $char_limit = 200;

                                        if (strlen($clean_content) > $char_limit) {
                                            echo mb_substr($clean_content, 0, $char_limit) . '...';
                                        } else {
                                            echo $clean_content;
                                        }
                                        ?>

                                    </div>
                                    <?php if (strlen($clean_content) > $char_limit): ?>
                                        <a data-bs-toggle="modal" data-bs-target="#testimonialpopup<?php echo $post_id; ?>"
                                            class="read-more">Read More</a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>

                <?php while ($testimonials_query->have_posts()):
                    $testimonials_query->the_post();
                    $post_id = get_the_ID(); ?>
                    <div class="model-testimonial modal " id="testimonialpopup<?php echo $post_id; ?>" tabindex="-1"
                        aria-labelledby="testimonialpopupLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                <div class="modal-body p-0">
                                    <div class="testimonial-model">
                                        <div class="testimonial-heading">
                                            <div class="testimonial-header d-flex align-items-center mb-4">
                                                <div class="img-wrap">
                                                    <?php if (has_post_thumbnail()) {
                                                        the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                                    } ?>
                                                </div>
                                                <div class="testimonials-wrap">
                                                    <h1 class="title"> <?php echo get_the_title(); ?> </h1>

                                                    <?php
                                                    $rating = get_field('rating');
                                                    if ($rating):
                                                        echo '<div class="rating">';
                                                        echo str_repeat('★', $rating);
                                                        echo '</div>';
                                                    endif;
                                                    ?>

                                                </div>

                                                <?php
                                                $google_url = get_field('google_url');

                                                if ($google_url) {
                                                    $google_url = esc_url($google_url);
                                                    echo '<a href="' . $google_url . '" target="_blank" rel="noopener noreferrer">
                                       <img src="https://draftsite1.com/aande-unisex-salon/wp-content/uploads/2025/09/google.svg" alt="" class="testimonial-type">
                                    </a>';
                                                }
                                                ?>



                                            </div>

                                            <div class="testimonial-text-full pt-2 mb-4">
                                                <?php echo get_the_content(); ?>
                                            </div>
                                        </div>
                                    </div>


                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>

            </div>

        <?php else:
        echo 'No testimonials found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('testimonials_featured', 'display_testimonials_slider');
// testimonials slider end ------------------------------



// testimonials page start------------------

function display_testimonials($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 12,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'testimonials'
    );
    // Get the current page
    $args = array(
        'post_type' => 'testimonial',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );
    $testimonials_query = new WP_Query($args);
    ob_start();

    if ($testimonials_query->have_posts()): ?>
            <div class="testimonials">
                <div class="row g-md-4 g-3">
                    <?php while ($testimonials_query->have_posts()):
                        $testimonials_query->the_post();
                        $post_id = get_the_ID();
                        ?>
                        <div class="col-lg-4 col-md-6" id="<?php echo $post_id; ?>">
                            <div class="testimonials-box-one">
                                <div class="testimonial-header d-flex align-items-center mb-4">
                                    <div class="img-wrap">
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                        } ?>
                                    </div>
                                    <div class="testimonials-wrap">
                                        <h1 class="title"> <?php echo get_the_title(); ?> </h1>

                                        <?php
                                        $rating = get_field('rating');
                                        if ($rating):
                                            echo '<div class="rating">';
                                            echo str_repeat('★', $rating);
                                            echo '</div>';
                                        endif;
                                        ?>

                                    </div>

                                    <?php
                                    $google_url = get_field('google_url');

                                    if ($google_url) {
                                        $google_url = esc_url($google_url);
                                        echo '<a href="' . $google_url . '" target="_blank" rel="noopener noreferrer">
                                       <img src="https://draftsite1.com/aande-unisex-salon/wp-content/uploads/2025/09/google.svg" alt="" class="testimonial-type">
                                    </a>';
                                    }
                                    ?>



                                </div>

                                <div class="content-box">
                                    <div class="description">
                                        <?php
                                        $content = get_the_content();
                                        $clean_content = wp_strip_all_tags(strip_shortcodes($content));
                                        $char_limit = 200;

                                        if (strlen($clean_content) > $char_limit) {
                                            echo mb_substr($clean_content, 0, $char_limit) . '...';
                                        } else {
                                            echo $clean_content;
                                        }
                                        ?>

                                    </div>
                                    <?php if (strlen($clean_content) > $char_limit): ?>
                                        <a data-bs-toggle="modal" data-bs-target="#testimonialpopup<?php echo $post_id; ?>"
                                            class="read-more">Read More</a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>

                <?php while ($testimonials_query->have_posts()):
                    $testimonials_query->the_post();
                    $post_id = get_the_ID(); ?>
                    <div class="model-testimonial modal " id="testimonialpopup<?php echo $post_id; ?>" tabindex="-1"
                        aria-labelledby="testimonialpopupLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                <div class="modal-body p-0">
                                    <div class="testimonial-model">
                                        <div class="testimonial-heading">
                                            <div class="testimonial-header d-flex align-items-center mb-4">
                                                <div class="img-wrap">
                                                    <?php if (has_post_thumbnail()) {
                                                        the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                                    } ?>
                                                </div>
                                                <div class="testimonials-wrap">
                                                    <h1 class="title"> <?php echo get_the_title(); ?> </h1>

                                                    <?php
                                                    $rating = get_field('rating');
                                                    if ($rating):
                                                        echo '<div class="rating">';
                                                        echo str_repeat('★', $rating);
                                                        echo '</div>';
                                                    endif;
                                                    ?>

                                                </div>

                                                <?php
                                                $google_url = get_field('google_url');

                                                if ($google_url) {
                                                    $google_url = esc_url($google_url);
                                                    echo '<a href="' . $google_url . '" target="_blank" rel="noopener noreferrer">
                                       <img src="https://draftsite1.com/aande-unisex-salon/wp-content/uploads/2025/09/google.svg" alt="" class="testimonial-type">
                                    </a>';
                                                }
                                                ?>



                                            </div>

                                            <div class="testimonial-text-full pt-2 mb-4">
                                                <?php echo get_the_content(); ?>
                                            </div>
                                        </div>
                                    </div>


                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>


            <?php if ($testimonials_query->max_num_pages > 1): ?>
                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                    <div class="pagination-style-one">
                        <?php
                        echo paginate_links(array(
                            'total' => $testimonials_query->max_num_pages,
                            'current' => max(1, get_query_var('paged')),
                            'format' => '?paged=%#%',
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => '<i class="eicon-angle-left"></i>',
                            'next_text' => '<i class="eicon-angle-right"></i>',
                            'end_size' => 2,
                            'mid_size' => 2
                        ));
                        ?>
                    </div>
                </div>
            <?php endif; ?>


        <?php else:
        echo 'No Testimonial found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('testimonials', 'display_testimonials');
// testimonials page end------------------









// gallery start ----------
function display_featured_gallery($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => -1,
        ),
        $atts,
        'gallery'
    );

    $args = array(
        'post_type' => 'pgallery',
        'posts_per_page' => $atts['posts_per_page'],
        'meta_query' => array(
            array(
                'key' => '_is_ns_featured_post',
                'value' => 'yes',
                'compare' => '='
            )
        )
    );

    $gallery_query = new WP_Query($args);

    ob_start();

    if ($gallery_query->have_posts()): ?>
            <div class="gallery-wrap">
                <div class="gallery-slider-one">

                    <?php while ($gallery_query->have_posts()):
                        $gallery_query->the_post();
                        ?>

                        <div class="items ps-2 pe-2">
                            <div class="gallery-box">
                                <?php
                                if (has_post_thumbnail()) { ?>
                                    <a href="#" data-bs-toggle="modal" data-bs-target="#videoModal<?php echo get_the_ID(); ?>">
                                        <div class="img-box mb-0">
                                            <?php the_post_thumbnail('full', array('class' => 'w-100 main-img mb-3')); ?>
                                        </div>
                                    </a>
                                <?php } ?>
                                <p class="text-center mt-2"> <?php echo get_the_title(); ?> </p>
                            </div>

                            <div class="event-box">

                            </div>
                        </div>

                    <?php endwhile; ?>
                </div>

                <?php while ($gallery_query->have_posts()):
                    $gallery_query->the_post();
                    ?>

                    <div class="modal gallery-model" id="videoModal<?php echo get_the_ID(); ?>">

                        <div class="modal-dialog modal-dialog-centered modal-lg">
                            <div class="modal-content bg-transparent border-0 rounded-0">
                                <div class="modal-body bg-transparent border-0">
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                                    <?php
                                    if (has_post_thumbnail()) {
                                        echo '<div class="img-box mb-0">';
                                        the_post_thumbnail('full', array('class' => 'w-100 main-img mb-0'));
                                        echo '</div>';
                                    }
                                    ?>
                                    <p class="text-center mt-2 text-white"> <?php echo get_the_title(); ?> </p>
                                </div>
                            </div>
                        </div>
                    </div>

                <?php endwhile; ?>

            </div>

            <script type="text/javascript">
                document.addEventListener('DOMContentLoaded', function () {
                    // category filter
                    var listItems = document.querySelectorAll('#category-filter-list a');
                    listItems.forEach(function (item) {
                        item.addEventListener('click', function (event) {
                            // handled by link
                        });
                    });

                    // Stop video on modal close
                    var modals = document.querySelectorAll('.modal');
                    modals.forEach(function (modal) {
                        modal.addEventListener('hidden.bs.modal', function () {
                            // Stop <video>
                            var videos = modal.querySelectorAll('video');
                            videos.forEach(function (video) {
                                video.pause();
                                video.currentTime = 0;
                            });

                            // Stop YouTube <iframe>
                            var iframes = modal.querySelectorAll('iframe');
                            iframes.forEach(function (iframe) {
                                var src = iframe.src;
                                iframe.src = src; // reset iframe to stop video
                            });
                        });
                    });
                });
            </script>


        <?php else:
        echo 'No gallery found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('featured_gallery', 'display_featured_gallery');



// gallery page end ------------------------------------------------------------


// gallery start ----------
function display_gallery($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'gallery'
    );

    $args = array(
        'post_type' => 'pgallery',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );

    if (!empty($atts['category'])) {
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'gallery-category',
                'field' => 'slug',
                'terms' => $atts['category'],
            ),
        );
    }

    // Get categories
    $categories = get_terms(array(
        'taxonomy' => 'gallery-category',
        'hide_empty' => true,
        'orderby' => 'date',
        'order' => 'DESC',
    ));

    if ($categories): ?>
            <div class="col-lg-12 mb-5 text-center">
                <ul id="category-filter-list" class="gallery-filter">
                    <li><a href="<?php echo esc_url(add_query_arg('category', '', home_url('/gallery'))); ?>"
                            class="all-cat-head <?php echo empty($atts['category']) ? 'active' : ''; ?>"> All </a></li>
                    <?php foreach ($categories as $category):
                        $active_class = ($atts['category'] === $category->slug) ? 'active' : '';
                        ?>
                        <li>
                            <a href="<?php echo esc_url(add_query_arg('category', $category->slug, home_url('/gallery'))); ?>"
                                class="cats <?php echo esc_attr($active_class); ?>">
                                <?php echo esc_html($category->name); ?>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        <?php endif;

    $gallery_query = new WP_Query($args);

    ob_start();

    if ($gallery_query->have_posts()): ?>
            <div class="gallery-wrap">
                <div class="row gy-3 mx-0">

                    <?php while ($gallery_query->have_posts()):
                        $gallery_query->the_post();
                        ?>

                        <div class="col-lg-6 col-md-6">
                            <div class="gallery-box">
                                <?php
                                if (has_post_thumbnail()) { ?>
                                    <a href="#" data-bs-toggle="modal" data-bs-target="#videoModal<?php echo get_the_ID(); ?>">
                                        <div class="img-box mb-0">
                                            <?php the_post_thumbnail('full', array('class' => 'w-100 main-img mb-3')); ?>
                                        </div>
                                    </a>
                                <?php } ?>
                                <p class="text-center mt-2"> <?php echo get_the_title(); ?> </p>
                            </div>

                            <div class="event-box">

                            </div>
                        </div>

                    <?php endwhile; ?>
                </div>

                <?php while ($gallery_query->have_posts()):
                    $gallery_query->the_post();
                    ?>

                    <div class="modal gallery-model" id="videoModal<?php echo get_the_ID(); ?>">

                        <div class="modal-dialog modal-dialog-centered modal-lg">
                            <div class="modal-content bg-transparent border-0 rounded-0">
                                <div class="modal-body bg-transparent border-0">
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                                    <?php
                                    if (has_post_thumbnail()) {
                                        echo '<div class="img-box mb-0">';
                                        the_post_thumbnail('full', array('class' => 'w-100 main-img mb-0'));
                                        echo '</div>';
                                    }
                                    ?>
                                    <p class="text-center mt-2 text-white"> <?php echo get_the_title(); ?> </p>
                                </div>
                            </div>
                        </div>
                    </div>

                <?php endwhile; ?>

            </div>

            <script type="text/javascript">
                document.addEventListener('DOMContentLoaded', function () {
                    // category filter
                    var listItems = document.querySelectorAll('#category-filter-list a');
                    listItems.forEach(function (item) {
                        item.addEventListener('click', function (event) {
                            // handled by link
                        });
                    });

                    // Stop video on modal close
                    var modals = document.querySelectorAll('.modal');
                    modals.forEach(function (modal) {
                        modal.addEventListener('hidden.bs.modal', function () {
                            // Stop <video>
                            var videos = modal.querySelectorAll('video');
                            videos.forEach(function (video) {
                                video.pause();
                                video.currentTime = 0;
                            });

                            // Stop YouTube <iframe>
                            var iframes = modal.querySelectorAll('iframe');
                            iframes.forEach(function (iframe) {
                                var src = iframe.src;
                                iframe.src = src; // reset iframe to stop video
                            });
                        });
                    });
                });
            </script>

            <?php if ($gallery_query->max_num_pages > 1): ?>
                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                    <div class="pagination-style-one">
                        <?php
                        echo paginate_links(
                            array(
                                'total' => $gallery_query->max_num_pages,
                                'current' => max(1, get_query_var('paged')),
                                'format' => '?paged=%#%',
                                'show_all' => false,
                                'type' => 'plain',
                                'prev_text' => '<i class="eicon-angle-left"></i>',
                                'next_text' => '<i class="eicon-angle-right"></i>',
                                'end_size' => 2,
                                'mid_size' => 2
                            )
                        );
                        ?>
                    </div>
                </div>
            <?php endif; ?>

        <?php else:
        echo 'No gallery found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('gallery', 'display_gallery');



// gallery page end ------------------------------------------------------------