<?php
// Enqueue the parent theme's stylesheet

function hello_elementor_child_enqueue_styles()
{
    wp_enqueue_style('hello-elementor-parent-style', get_template_directory_uri() . '/../hello-elementor-child/style.css');
    wp_enqueue_style('hello-elementor-parent-ecommerce', get_template_directory_uri() . '/../hello-elementor-child/ecommerce.css');
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles');


// Enqueue Booststrap 
function enqueue_bootstrap()
{
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');

//  Slick carousel script and styles
function enqueue_slick_scripts()
{
    //  Slick carousel script
    wp_enqueue_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js', array('jquery'), null, true);
    //  Slick carousel CSS
    wp_enqueue_style('slick-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_slick_scripts');

// custom code









// Home slider Start --------------------------------------------
function display_banner_home($atts)
{
    $args = array(
        'post_type' => 'main-slider',
    );

    $mainslider_query = new WP_Query($args);

    ob_start();

    if ($mainslider_query->have_posts()):
        $total_slides = $mainslider_query->post_count;
        $slide_num = 1;
        ?>
        <div id="demo" class="carousel slide hero-banner" data-bs-ride="carousel">
            <div class="carousel-inner">
                <?php
                $first = true;
                $slide_index = 0;
                while ($mainslider_query->have_posts()):
                    $mainslider_query->the_post(); ?>

                    <div class="carousel-item <?php echo $first ? 'active' : ''; ?>">

                        <?php
                        $featured_video = get_field('featured_video');
                        ?>
                        <?php
                        if ($featured_video) {
                            $file_url = is_array($featured_video) ? $featured_video['url'] : $featured_video;
                            echo ' <video controls autoplay width="100%">
                                            <source src="' . esc_url($file_url) . '" type="video/mp4" class="video-box">
                                        </video>
                            ';
                        } elseif (has_post_thumbnail()) {
                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                        }
                        ?>

                        <?php ?>
                        <div class="carousel-caption">
                            <h1><?php the_title(); ?></h1>
                            <div class="desription"> <?php the_content(); ?> </div>
                            <div class="btnlight animated-btn">
                                <?php
                                $links = get_field('button_link');
                                if ($links) {
                                    $link_url = $links['url'];
                                    $link_title = $links['title'];
                                    ?>
                                    <a href="<?php echo esc_url($link_url); ?>"
                                        class="elementor-button"><?php echo esc_html($link_title); ?> <i
                                            class="icon icon-arrow-right"></i></a>
                                <?php } ?>
                            </div>
                            <div class="row banner-other-text">
                                <div class="col-md-4">

                                    <?php
                                    $service = get_field('service-one'); // SCF group field (not a loop/repeater)
                        
                                    if (!empty($service)) {
                                        $image_id = $service['image'];
                                        $image_url = $image_id ? wp_get_attachment_url($image_id) : '';
                                        $stitle = esc_html($service['service_title']);
                                        $sdescription = esc_html($service['service_description']);
                                        ?>
                                        <div class="banner-box">
                                            <?php if ($image_url): ?>
                                                <img src="<?php echo esc_url($image_url); ?>" alt="" class="img-fluid" />
                                            <?php endif; ?>

                                            <?php if ($stitle): ?>
                                                <h5 class="service-title"><?php echo $stitle; ?></h5>
                                            <?php endif; ?>

                                            <?php if ($sdescription): ?>
                                                <p class="service-description"><?php echo $sdescription; ?></p>
                                            <?php endif; ?>
                                        </div>
                                        <?php
                                    }
                                    ?>

                                </div>

                                <div class="col-md-4">
                                    <?php
                                    $service = get_field('service-two'); // SCF group field (not a loop/repeater)
                        
                                    if (!empty($service)) {
                                        $image_id = $service['image'];
                                        $image_url = $image_id ? wp_get_attachment_url($image_id) : '';
                                        $stitle = esc_html($service['service_title']);
                                        $sdescription = esc_html($service['service_description']);
                                        ?>
                                        <div class="banner-box">
                                            <?php if ($image_url): ?>
                                                <img src="<?php echo esc_url($image_url); ?>" alt="" class="img-fluid" />
                                            <?php endif; ?>

                                            <?php if ($stitle): ?>
                                                <h5 class="service-title"><?php echo $stitle; ?></h5>
                                            <?php endif; ?>

                                            <?php if ($sdescription): ?>
                                                <p class="service-description"><?php echo $sdescription; ?></p>
                                            <?php endif; ?>
                                        </div>
                                        <?php
                                    }
                                    ?>
                                </div>
                                <div class="col-md-4">
                                    <?php
                                    $service = get_field(selector: 'service-three'); // SCF group field (not a loop/repeater)
                        
                                    if (!empty($service)) {
                                        $image_id = $service['image'];
                                        $image_url = $image_id ? wp_get_attachment_url($image_id) : '';
                                        $stitle = esc_html($service['service_title']);
                                        $sdescription = esc_html($service['service_description']);
                                        ?>
                                        <div class="banner-box">
                                            <?php if ($image_url): ?>
                                                <img src="<?php echo esc_url($image_url); ?>" alt="" class="img-fluid" />
                                            <?php endif; ?>

                                            <?php if ($stitle): ?>
                                                <h5 class="service-title"><?php echo $stitle; ?></h5>
                                            <?php endif; ?>

                                            <?php if ($sdescription): ?>
                                                <p class="service-description"><?php echo $sdescription; ?></p>
                                            <?php endif; ?>
                                        </div>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    $first = false;
                    $slide_index++;
                endwhile; ?>
            </div>


            <?php if ($total_slides > 1): ?>
                <div class="indicators-num d-none">
                    <div class="carousel-indicator">
                        <p id="current-slide-number" class="mb-0 startslide"> <span
                                id="current-slide"><?php echo $slide_num; ?></span> </p>

                        <?php for ($i = 0; $i < $total_slides; $i++): ?>
                            <div class="numbtn">
                                <button type="button" data-bs-target="#demo" data-bs-slide-to="<?php echo $i; ?>"
                                    class="<?php echo $i === 0 ? 'active' : ''; ?>">
                                </button>
                                <span> <?php //echo str_pad($i + 1, 2, '0', STR_PAD_LEFT); 
                                                ?></span>
                            </div>

                        <?php endfor; ?>
                        <p id="current-slide-number" class="mb-0 endslide">
                            <?php echo $total_slides; ?>
                        </p>
                    </div>
                </div>

            <?php endif; ?>

            <?php if ($total_slides > 0): ?>
                <div class="arrow-control">
                    <span class="carousel-control-prev" data-bs-target="#demo" data-bs-slide="prev">
                        <i class="elementor-icons-manager__tab__item__icon icon icon-left-arrow"></i>
                    </span>
                    <span class="carousel-control-next" data-bs-target="#demo" data-bs-slide="next">
                        <i class="elementor-icons-manager__tab__item__icon icon icon-arrow-right"></i>
                    </span>
                </div>
            <?php endif; ?>


            <script>
                document.addEventListener("DOMContentLoaded", function () {
                    var myCarousel = document.querySelector("#demo");
                    var currentSlideElement = document.querySelector("#current-slide");

                    myCarousel.addEventListener("slid.bs.carousel", function (event) {
                        var activeIndex = event.to + 1; // Carousel index starts from 0, so add 1
                        currentSlideElement.textContent = activeIndex;
                    });
                });
            </script>

        </div>

    <?php else: ?>
        <div>No Slider found.</div>
    <?php endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('banner_home', 'display_banner_home');


// Home slider end --------------------------------------------



// news  start here ---------------------------

function display_articles_slider($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
        ),
        $atts,
        'articles'
    );

    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['posts_per_page'],
    );

    $articles_query = new WP_Query($args);

    ob_start();

    if ($articles_query->have_posts()): ?>
        <div class="news-slider">
            <div class="slick-slider-news pb-2">
                <?php while ($articles_query->have_posts()):
                    $articles_query->the_post();
                    ?>

                    <div class="item p-2">
                        <div class="news-box">
                            <div class="img-box">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100 thumbnail-image'));
                                } ?>
                            </div>
                            <div class="news-text">
                                <span class="date"><?php echo get_the_date('M j, Y'); ?></span>
                                <h5 class="title"><?php echo get_the_title(); ?></h5>
                                <p class="description"> <?php echo get_the_excerpt(); ?> </p>


                                <div class="animated-btn"><a href="<?php the_permalink(); ?>" class="elementor-button">Learn More <i
                                            class="icon icon-right-arrow"></i></a></div>
                            </div>
                        </div>
                    </div>

                <?php endwhile; ?>
            </div>

        </div>


        <script>
            jQuery(document).ready(function ($) {
                $(".slick-slider-news").slick({
                    dots: false,
                    infinite: true,
                    speed: 300,
                    slidesToShow: 2,
                    slidesToScroll: 1,
                    adaptiveHeight: true,
                    prevArrow: '<div class="left-btn arrowbtn"><i class="icon icon-left-arrows"></i></div>',
                    nextArrow: '<div class="right-btn arrowbtn"><i class="icon icon-right-arrow1"></i></div>',
                    responsive: [{
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 1,
                        },
                    },
                    {
                        breakpoint: 1024,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 1,
                        },
                    },
                    {
                        breakpoint: 800,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                        },
                    },
                    ],
                });

            });
        </script>


    <?php else:
        echo 'No articles found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('articles_slider', 'display_articles_slider');



// blog page start ------------------------------------------------------------


function display_articles($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'blog'
    );

    // Get the current page

    $selected_category = isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '';

    // Query arguments
    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );


    if (!empty($selected_category)) {
        $args['category_name'] = $selected_category;
    }


    $articles_query = new WP_Query($args);

    ob_start();

    if ($articles_query->have_posts()): ?>
        <div class="news-slider">
            <div class="row g-lg-4 g-3">
                <?php while ($articles_query->have_posts()):
                    $articles_query->the_post();
                    ?>

                    <div class="col-lg-4 col-md-6 col-sm-6">
                        <div class="news-box" data-post-id="<?php echo get_the_ID(); ?>">
                            <div class="img-box">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                } ?>
                            </div>
                            <div class="news-text">
                                <span class="date"><?php echo get_the_date('M j, Y'); ?></span>
                                <h5 class="title"><?php echo get_the_title(); ?></h5>
                                <p class="description"> <?php echo get_the_excerpt(); ?> </p>
                                <div class="animated-btn"><a href="<?php the_permalink(); ?>" class="elementor-button">Learn More <i
                                            class="icon icon-right-arrow"></i></a></div>
                            </div>
                        </div>
                    </div>

                <?php endwhile; ?>
            </div>


            <?php if ($articles_query->max_num_pages > 1): ?>
                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                    <div class="pagination-two">
                        <?php
                        echo paginate_links(array(
                            'total' => $articles_query->max_num_pages,
                            'current' => max(1, get_query_var('paged')),
                            'format' => '?paged=%#%',
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => '<i aria-hidden="true" class="icon icon-left-arrow"></i>',
                            'next_text' => '<i aria-hidden="true" class="icon icon-right-arrow"></i>',
                            'end_size' => 2,
                            'mid_size' => 2
                        ));
                        ?>
                    </div>
                </div>
            <?php endif; ?>



        <?php else:
        echo 'No articles found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('articles', 'display_articles');

// news  end here ---------------------------



// testimonials slider  start ------------------------------------------------------------

function display_testimonials($atts)
{

    $atts = shortcode_atts(
        array(
            'posts_per_page' => 4,
        ),
        $atts,
        'testimonials_slider'
    );

    $args = array(
        'post_type' => 'testimonials',
        'posts_per_page' => $atts['posts_per_page'],
    );

    $testimonials_query = new WP_Query($args);

    ob_start();

    if ($testimonials_query->have_posts()):

        ?>
            <div class="testimonial-slider-outer">
                <div id="demo1" class="carousel slide" data-bs-ride="carousel">
                    <div class="carousel-inner">
                        <?php
                        $first = true;
                        $slide_index = 0;
                        while ($testimonials_query->have_posts()):
                            $testimonials_query->the_post(); ?>

                            <div class="carousel-item <?php echo $first ? 'active' : ''; ?>">
                                <div class="row align-items-center">
                                    <div class="col-md-6">
                                        <div class="user-details text-white">
                                            <h4 class="mb-1"><?php the_title(); ?></h4>

                                            <?php
                                            $designation = get_field('designation');
                                            if ($designation): ?>
                                                <p class="mb-2">
                                                    <?php echo $designation; ?>
                                                </p>
                                            <?php endif; ?>

                                            <div class="rating mb-4">
                                                <?php
                                                $rating = get_field('rating');
                                                if ($rating):
                                                    echo '<span class="ratingicon">';
                                                    echo str_repeat('★', $rating);
                                                    echo '</span>';
                                                endif;
                                                ?>
                                            </div>
                                            <div class="description mb-4">
                                                <?php the_content(); ?>
                                            </div>

                                            <?php
                                            $view_all_url = get_field('view_all');

                                            if ($view_all_url):
                                                ?>


                                                <div class="animated-btn"><a href="<?php echo esc_url($view_all_url); ?>"
                                                        class="elementor-button">View All <i class="icon icon-right-arrow"></i></a>
                                                </div>

                                            <?php endif; ?>




                                        </div>
                                    </div>
                                    <div class="col-md-6 video_or_img">

                                        

                                        <?php
                                        $file = get_field('featured_video'); 
                            
                                        if ($file) {
                                            $file_url = is_array($file) ? $file['url'] : $file;

                                            $file_ext = pathinfo($file_url, PATHINFO_EXTENSION);

                                            if (in_array(strtolower($file_ext), ['mp4', 'webm', 'ogg'])) {
                                                echo '<video controls autoplay muted width="100%" class="video-box">
                                                <source src="' . esc_url($file_url) . '" type="video/' . esc_attr($file_ext) . '">
                                                Your browser does not support the video tag.
                                            </video>';
                                            } elseif (in_array(strtolower($file_ext), ['jpg', 'jpeg', 'png', 'gif', 'webp'])) {
                                                echo '<img src="' . esc_url($file_url) . '" alt="Image or Video" class="img-fluid d-block w-100">';
                                            }
                                        }
                                        ?>


                                        
                                    </div>
                                </div>
                            </div>
                            <?php
                            $first = false;
                            $slide_index++;
                        endwhile; ?>
                    </div>

                    <?php
                    // Re-run the same query again for the indicators
                    $indicator_query = new WP_Query($args);
                    $indicator_index = 0; ?>
                    <div class="carousel-indicators">
                        <?php if ($indicator_query->have_posts()):
                            while ($indicator_query->have_posts()):
                                $indicator_query->the_post();
                                ?>
                                <button type="button" data-bs-target="#demo1" data-bs-slide-to="<?php echo $indicator_index; ?>"
                                    class="<?php echo $indicator_index === 0 ? 'active' : ''; ?>">
                                    <?php if (has_post_thumbnail()): ?>
                                        <div class="indicator-thumbnail">
                                            <?php the_post_thumbnail('full'); ?>
                                        </div>
                                    <?php endif; ?>
                                    <span>
                                        <?php the_title(); ?>
                                        <?php
                                        $designation = get_field('designation');
                                        if ($designation): ?>
                                            <small>
                                                <?php echo $designation; ?>
                                            </small>
                                        <?php endif; ?>
                                    </span>

                                    <div class="indicator-title">
                                        <?php
                                        $thumb_title_title = get_field('thumb_title_title');
                                        if ($thumb_title_title):
                                            echo '<p class="tumbtitle">';
                                            echo $thumb_title_title;
                                            echo '</p>';
                                        endif; ?>
                                    </div>
                                </button>
                                <?php
                                $indicator_index++;
                            endwhile;
                            wp_reset_postdata();
                        endif;
                        ?>
                    </div>
                    <script>
                        document.addEventListener("DOMContentLoaded", function () {
                            var myCarousel = document.querySelector("#demo");
                            var currentSlideElement = document.querySelector("#current-slide");

                            myCarousel.addEventListener("slid.bs.carousel", function (event) {
                                var activeIndex = event.to + 1; // Carousel index starts from 0, so add 1
                                currentSlideElement.textContent = activeIndex;
                            });
                        });
                    </script>

                </div>
            </div>

        <?php else: ?>
            <div>No Slider found.</div>
        <?php endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('testimonials_slider', 'display_testimonials');

// testimonials slider  end ------------------------------------------------------------


// jobsportal page start ------------------------------------------------------------

function display_jobsportal($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 20,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'jobsportal'
    );

    // Get the current page


    $args = array(
        'post_type' => 'jobs-portal',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );


    // Filter by category if provided
    if (!empty($atts['category'])) {
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'portal-category',
                'field' => 'slug',
                'terms' => $atts['category'],
            ),
        );
    }
    // Get categories
    $categories = get_terms(array(
        'taxonomy' => 'portal-category',
        'hide_empty' => true,
    ));



    $jobsportal_query = new WP_Query($args);

    ob_start();

    ?>


        <div class="job-portal-container">
            <div class="row m-0">
                <?php

                if ($categories):
                    ?>
                    <div class="col-md-3 pe-lg-5 mb-4 mb-md-0">
                        <div class="sidebar">
                            <h4>Categories</h4>
                            <ul>
                                <li>
                                    <a href="<?php echo esc_url(add_query_arg('category', '', home_url('/jobs-portal'))); ?>"
                                        class="all-cat-head <?php echo empty($atts['category']) ? 'active' : ''; ?>"> All </a>
                                </li>
                                <?php foreach ($categories as $category):
                                    $active_class = ($atts['category'] === $category->slug) ? 'active' : '';
                                    ?>
                                    <li>
                                        <a href="<?php echo esc_url(add_query_arg('category', $category->slug, home_url('/jobs-portal'))); ?>"
                                            class="cats <?php echo esc_attr($active_class); ?>">
                                            <?php echo esc_html($category->name); ?>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                    <?php
                endif;

                if ($jobsportal_query->have_posts()): ?>
                    <div class="col-md-9 ps-lg-5">
                        <div class="job-portal-box">
                            <?php while ($jobsportal_query->have_posts()):
                                $jobsportal_query->the_post();
                                ?>

                                <div class="animated-btn"><button data-bs-toggle="modal"
                                        data-bs-target="#jobportalModal<?php echo get_the_ID(); ?>" class="elementor-button"><span
                                            class="btn-text"><?php echo get_the_title(); ?> <span class="btn-badge">

                                                <?php
                                                $terms = get_the_terms(get_the_ID(), 'portal-category');
                                                if ($terms && !is_wp_error($terms)) { ?>
                                                    <div class="category-wrap">
                                                        <?php
                                                        foreach ($terms as $term) {
                                                            $category_name = strtolower($term->name); ?>

                                                            <?php echo $category_name; ?>

                                                            <?php
                                                        } ?>
                                                    </div>
                                                <?php }
                                                ?>

                                            </span></span> <i class="icon icon-right-arrow"></i></button></div>
                            <?php endwhile; ?>
                        </div>

                        <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                            <div class="pagination-two d-inline-block">
                                <?php
                                echo paginate_links(
                                    array(
                                        'total' => $jobsportal_query->max_num_pages,
                                        'current' => max(1, get_query_var('paged')),
                                        'format' => '?paged=%#%',
                                        'show_all' => false,
                                        'type' => 'plain',
                                        'prev_text' => '<i aria-hidden="true" class="icon icon-left-arrow"></i>',
                                        'next_text' => '<i aria-hidden="true" class="icon icon-right-arrow"></i>',
                                        'end_size' => 2,
                                        'mid_size' => 2
                                    )
                                );
                                ?>
                            </div>
                        </div>

                    </div>
                </div>
            </div>



            <?php while ($jobsportal_query->have_posts()):
                $jobsportal_query->the_post(); ?>

                <div class="modal fade jobportalModal" id="jobportalModal<?php echo get_the_ID(); ?>">
                    <div class="modal-dialog modal-dialog modal-lg modal-dialog-centered">
                        <div class="modal-content border-0 rounded-4">
                            <!-- Modal body -->
                            <div class="modal-body p-lg-5 p-3">
                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                <div class="row mx-0 mb-5 border-bottom align-items-center">
                                    <div class="col-md-9 p-0">
                                        <div class="portal-modal-header">
                                            <?php
                                            $terms = get_the_terms(get_the_ID(), 'portal-category');
                                            if ($terms && !is_wp_error($terms)) { ?>
                                                <div class="category-wrap">
                                                    <?php
                                                    foreach ($terms as $term) {
                                                        $category_name = strtolower($term->name); ?>

                                                        <span class="btn-badge"> <?php echo $category_name; ?> </span>

                                                        <?php
                                                    } ?>
                                                </div>
                                            <?php }
                                            ?>


                                            <h2 class="modal-title mb-3"> <?php echo get_the_title(); ?> </small>
                                            </h2>

                                            <?php
                                            $employer = get_field('employer');
                                            if ($employer): ?>
                                                <p class="fw-bold mb-4">
                                                    Employer/Representative:
                                                    <?php echo $employer; ?>
                                                </p>
                                            <?php endif; ?>


                                            <p class="qualities">
                                                <?php
                                                $time = get_field('time');
                                                if ($time): ?>
                                                    <span class="d-inline-flex align-items-center me-4"><img class="me-2"
                                                            src="https://draftsite1.com/aat-training-hub/wp-content/uploads/2025/05/Time.svg"
                                                            alt=""> <?php echo $time; ?> </span>
                                                <?php endif; ?>

                                                <?php
                                                $location = get_field('location');
                                                if ($location): ?>
                                                    <span class="d-inline-flex align-items-center me-4"><img class="me-2"
                                                            src="https://draftsite1.com/aat-training-hub/wp-content/uploads/2025/05/Location-1.svg"
                                                            alt=""> <?php echo $location; ?></span>
                                                <?php endif; ?>


                                                <?php
                                                $industry_sector = get_field('industry_sector');
                                                if ($industry_sector): ?>
                                                    <span class="d-inline-flex align-items-center me-4"><img class="me-2"
                                                            src="https://draftsite1.com/aat-training-hub/wp-content/uploads/2025/05/Category.svg"
                                                            alt=""> <?php echo $industry_sector; ?></span>
                                                <?php endif; ?>


                                                <?php
                                                $pay_amount = get_field('pay_amount');
                                                if ($pay_amount): ?>
                                                    <span class="d-inline-flex align-items-center me-4"><img class="me-2"
                                                            src="https://draftsite1.com/aat-training-hub/wp-content/uploads/2025/05/Salary.svg"
                                                            alt=""> <?php echo $pay_amount; ?> SGD </span>
                                                <?php endif; ?>
                                            </p>
                                        </div>
                                    </div>
                                    <div class="col-md-3 text-md-end px-0 pb-md-0 pb-3">
                                        <div class="animated-btn"><a href="<?php echo esc_url(home_url('apply-now')); ?>"
                                                class="elementor-button">Apply Now <i class="icon icon-right-arrow"></i></a></div>
                                    </div>
                                </div>

                                <?php
                                $desctiption = get_field('desctiption');
                                if (!empty($desctiption)) { ?>
                                    <div class="description-box mb-3">
                                        <h5>Description</h5>
                                        <?php echo wp_kses_post(wpautop($desctiption)); ?>
                                    </div>
                                <?php }
                                ?>

                                <?php
                                $requirements = get_field('requirements');
                                if (!empty($requirements)) { ?>
                                    <div class="description-box mb-3">
                                        <h5>Requirements</h5>
                                        <?php echo wp_kses_post(wpautop($requirements)); ?>
                                    </div>
                                <?php }
                                ?>

                            </div>



                        </div>
                    </div>
                </div>


            <?php endwhile; ?>

            <script type="text/javascript">
                document.addEventListener('DOMContentLoaded', function () {
                    var listItems = document.querySelectorAll('#category-filter-list a');
                    listItems.forEach(function (item) {
                        item.addEventListener('click', function (event) {
                            // No need to prevent default here; the link's href handles the filtering
                        });
                    });
                });
            </script>



        <?php else:
                    echo 'No jobsportal found.';
                endif;

                wp_reset_postdata();

                return ob_get_clean();
}
add_shortcode('jobsportal', 'display_jobsportal');


// jobsportal page End ------------------------------------------------------------




// promotions page start ------------------------------------------------------------


function display_promotions($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'blog'
    );

    // Get the current page

    $selected_category = isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '';

    // Query arguments
    $args = array(
        'post_type' => 'promotions',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );


    if (!empty($selected_category)) {
        $args['category_name'] = $selected_category;
    }


    $promotions_query = new WP_Query($args);

    ob_start();

    if ($promotions_query->have_posts()): ?>
            <div class="promotions-container">
                <div class="promotion-box">
                    <?php while ($promotions_query->have_posts()):
                        $promotions_query->the_post();
                        ?>

                        <div class="row g-3 mb-5" id="<?php echo get_the_ID(); ?>">
                            <div class="col-md-6">
                                <div class="img-box">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('full', array('class' => 'w-100 rounded-4'));
                                    } ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="promo-text h-100">
                                    <h5 class="title mt-0 mb-2"><?php echo get_the_title(); ?></h5>
                                    <p class="description mb-4"><?php echo get_the_excerpt(); ?> </p>
                                    <p class="qualities mb-4">

                                        <?php
                                        $duration = get_field('duration');
                                        if ($duration): ?>
                                            <span class="d-inline-flex align-items-center me-4"><img class="me-2"
                                                    src="https://draftsite1.com/aat-training-hub/wp-content/uploads/2025/05/Time.svg"
                                                    alt=""> <?php echo $duration; ?> </span>
                                        <?php endif; ?>


                                        <?php
                                        $language = get_field('language');
                                        if ($language): ?>
                                            <span class="d-inline-flex align-items-center me-4"><img class="me-2"
                                                    src="https://draftsite1.com/aat-training-hub/wp-content/uploads/2025/05/Language.svg"
                                                    alt=""> <?php echo $language; ?></span>
                                        <?php endif; ?>

                                        <?php
                                        $location = get_field('location');
                                        if ($location): ?>
                                            <span class="d-inline-flex align-items-center me-4"><img class="me-2"
                                                    src="https://draftsite1.com/aat-training-hub/wp-content/uploads/2025/05/Location-1.svg"
                                                    alt=""> <?php echo $location; ?> </span>
                                        <?php endif; ?>

                                    </p>

                                    <?php
                                    $price = get_field('price');
                                    if ($price): ?>
                                        <h2 class="mb-5">$<?php echo $price; ?></h2>
                                    <?php endif; ?>


                                    <div class="animated-btn"><a href="<?php the_permalink(); ?>" class="elementor-button">View More
                                            <i class="icon icon-right-arrow"></i></a></div>
                                </div>
                            </div>
                        </div>

                    <?php endwhile; ?>
                </div>


                <?php if ($promotions_query->max_num_pages > 1): ?>
                    <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                        <div class="pagination-two">
                            <?php
                            echo paginate_links(array(
                                'total' => $promotions_query->max_num_pages,
                                'current' => max(1, get_query_var('paged')),
                                'format' => '?paged=%#%',
                                'show_all' => false,
                                'type' => 'plain',
                                'prev_text' => '<i aria-hidden="true" class="icon icon-left-arrow"></i>',
                                'next_text' => '<i aria-hidden="true" class="icon icon-right-arrow"></i>',
                                'end_size' => 2,
                                'mid_size' => 2
                            ));
                            ?>
                        </div>
                    </div>
                <?php endif; ?>

            </div>



        <?php else:
        echo 'No promotions found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('promotions', 'display_promotions');

// news  end here ---------------------------

//promotions
function all_promotions()
{ ?>

        <div class="promotions-container">
            <div class="promotion-box">
                <div class="row g-3 mb-5">
                    <div class="col-md-6">
                        <div class="img-box">
                            <img src="https://draftsite1.com/aat-training-hub/wp-content/uploads/2025/05/Sample-1.jpg"
                                alt="" class="w-100 rounded-4">
                        </div>
                    </div>
                    <div class="col-md-6 ">
                        <div class="promo-text h-100">
                            <h5 class="title mt-0 mb-2">Fire Safety Event/Seminar</h5>
                            <p class="description mb-4">We will send our qualified trainer to your premises for
                                a
                                safety
                                talk and fire fighting training.</p>
                            <p class="qualities mb-4">
                                <span class="d-inline-flex align-items-center me-4"><img class="me-2"
                                        src="https://draftsite1.com/aat-training-hub/wp-content/uploads/2025/05/Time.svg"
                                        alt=""> Full Time</span>
                                <span class="d-inline-flex align-items-center me-4"><img class="me-2"
                                        src="https://draftsite1.com/aat-training-hub/wp-content/uploads/2025/05/Language.svg"
                                        alt=""> English</span>
                                <span class="d-inline-flex align-items-center me-4"><img class="me-2"
                                        src="https://draftsite1.com/aat-training-hub/wp-content/uploads/2025/05/Location-1.svg"
                                        alt=""> Customer Premises</span>
                            </p>
                            <h2 class="mb-5">$600.00</h2>
                            <div class="animated-btn"><a href="" class="elementor-button">View More <i
                                        class="icon icon-right-arrow"></i></a></div>
                        </div>
                    </div>
                </div>
                <div class="row g-3 mb-5">
                    <div class="col-md-6">
                        <div class="img-box">
                            <img src="https://draftsite1.com/aat-training-hub/wp-content/uploads/2025/05/Sample-1.jpg"
                                alt="" class="w-100 rounded-4">
                        </div>
                    </div>
                    <div class="col-md-6 ">
                        <div class="promo-text h-100">
                            <h5 class="title mt-0 mb-2">Fire Safety Event/Seminar</h5>
                            <p class="description mb-4">We will send our qualified trainer to your premises for
                                a
                                safety
                                talk and fire fighting training.</p>
                            <p class="qualities mb-4">
                                <span class="d-inline-flex align-items-center me-4"><img class="me-2"
                                        src="https://draftsite1.com/aat-training-hub/wp-content/uploads/2025/05/Time.svg"
                                        alt=""> Full Time</span>
                                <span class="d-inline-flex align-items-center me-4"><img class="me-2"
                                        src="https://draftsite1.com/aat-training-hub/wp-content/uploads/2025/05/Language.svg"
                                        alt=""> English</span>
                                <span class="d-inline-flex align-items-center me-4"><img class="me-2"
                                        src="https://draftsite1.com/aat-training-hub/wp-content/uploads/2025/05/Location-1.svg"
                                        alt=""> Customer Premises</span>
                            </p>
                            <h2 class="mb-5">$600.00</h2>
                            <div class="animated-btn"><a href="" class="elementor-button">View More <i
                                        class="icon icon-right-arrow"></i></a></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    <?php }
add_shortcode('all_promotions', 'all_promotions');


//promotions
function SpecialTrainingEvents()
{ ?>

        <div class="row justify-content-center mb-5">
            <div class="col-lg-3 col-md-4 text-center">
                <div class="dropdown gallery-filter">
                    <button type="button" class="btn btn-primary dropdown-toggle show" data-bs-toggle="dropdown"
                        aria-expanded="true">
                        Special Training Events
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item active"
                                href="https://draftsite1.com/aat-training-hub/event-highlights">Special
                                Training
                                Events</a></li>
                        <li>
                            <a class="dropdown-item " href="https://draftsite1.com/aat-training-hub/workshops">
                                Workshops </a>
                        </li>
                        <li>
                            <a class="dropdown-item " href="https://draftsite1.com/aat-training-hub/company-milestones">
                                Company Milestones </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

    <?php }
add_shortcode('SpecialTrainingEvents', 'SpecialTrainingEvents');

function Workshops()
{ ?>

        <div class="row justify-content-center mb-5">
            <div class="col-lg-3 col-md-4 text-center">
                <div class="dropdown gallery-filter">
                    <button type="button" class="btn btn-primary dropdown-toggle show" data-bs-toggle="dropdown"
                        aria-expanded="true">
                        Workshops
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item active"
                                href="https://draftsite1.com/aat-training-hub/event-highlights">Special
                                Training
                                Events</a></li>
                        <li>
                            <a class="dropdown-item " href="https://draftsite1.com/aat-training-hub/workshops">
                                Workshops </a>
                        </li>
                        <li>
                            <a class="dropdown-item " href="https://draftsite1.com/aat-training-hub/company-milestones">
                                Company Milestones </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

    <?php }
add_shortcode('Workshops', 'Workshops');


function CompanyMilestones()
{ ?>

        <div class="row justify-content-center mb-5">
            <div class="col-lg-3 col-md-4 text-center">
                <div class="dropdown gallery-filter">
                    <button type="button" class="btn btn-primary dropdown-toggle show" data-bs-toggle="dropdown"
                        aria-expanded="true">
                        Company Milestones
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item active"
                                href="https://draftsite1.com/aat-training-hub/event-highlights">Special
                                Training
                                Events</a></li>
                        <li>
                            <a class="dropdown-item " href="https://draftsite1.com/aat-training-hub/workshops">
                                Workshops </a>
                        </li>
                        <li>
                            <a class="dropdown-item " href="https://draftsite1.com/aat-training-hub/company-milestones">
                                Company Milestones </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

    <?php }
add_shortcode('CompanyMilestones', 'CompanyMilestones');


// wocoomerce 

function move_product_price_after_short_description()
{
    // Remove price from its default position
    remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 10);

    // Add price after the short description (priority 25)
    add_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 25);
}
add_action('wp', 'move_product_price_after_short_description');


add_action('woocommerce_single_product_summary', 'show_product_category_before_title', 4);

function show_product_category_before_title()
{
    global $product;

    $terms = get_the_terms($product->get_id(), 'product_cat');

    if ($terms && !is_wp_error($terms)) {
        echo '<div class="product-category"> ';

        $categories = array();
        foreach ($terms as $term) {
            echo '<a href="' . esc_url(get_term_link($term)) . '">' . esc_html($term->name) . '</a> ';
        }

        echo implode(', ', $categories);
        echo '</div>';
    }
}


// product-categories start -----------------------------------------

function wpb_woocommerce_product_categories_accordion()
{
    // Get the current queried product category
    $queried_object = get_queried_object();
    $current_category_id = ($queried_object && isset($queried_object->term_id)) ? $queried_object->term_id : 0;

    // Get all parent categories of the current category
    $current_category_parents = [];
    if ($current_category_id) {
        $parent_categories = get_ancestors($current_category_id, 'product_cat');
        $current_category_parents = array_map('intval', $parent_categories);
    }

    // Recursive function to get subcategories with checkboxes
    function get_subcategories($parent_id, $level = 1, $current_category_id, $current_category_parents)
    {
        $args = array(
            'taxonomy' => 'product_cat',
            'orderby' => 'name',
            'order' => 'ASC',
            'parent' => $parent_id,
            'hide_empty' => false
        );
        $sub_categories = get_terms($args);

        if (!empty($sub_categories)) {
            echo '<ul class="list-unstyled ps-2">';
            foreach ($sub_categories as $sub_category) {
                $is_checked = ($sub_category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($sub_category->term_id == $current_category_id) ? 'current-category' : '';

                echo '<li class="' . $active_class . '">';
                echo '<div class="in-menu">';
                echo '<input type="checkbox" class="category-checkbox me-2" data-category-id="' . $sub_category->term_id . '" ' . $is_checked . '> ';

                echo '<a href="' . get_term_link($sub_category) . '">  <span class="customcheck"></span>' . $sub_category->name . '</a>';
                echo '</div>';
                get_subcategories($sub_category->term_id, $level + 1, $current_category_id, $current_category_parents);
                echo '</li>';
            }
            echo '</ul>';
        }
    }

    // Get main product categories (parent categories)
    $args = array(
        'taxonomy' => 'product_cat',
        'orderby' => 'name',
        'order' => 'ASC',
        'parent' => 0,
        'hide_empty' => false
    );
    $product_categories = get_terms($args);

    if ($product_categories) {
        ob_start();
        ?>
            <div class="accordion" id="productCategoriesAccordion">

                <?php
                $shop_page_url = wc_get_page_permalink('shop');
                $is_shop_page = is_shop();
                ?>

                <div class="accordion-item">
                    <div class="accordion-header <?php echo $is_shop_page ? 'current-category' : '';
                    ?>">
                        <label>
                            <a href="<?php echo esc_url($shop_page_url);
                            ?>" class="main-category">
                                All Product
                            </a>
                        </label>
                    </div>
                </div>


                <?php
                $i = 0;
                foreach ($product_categories as $category) {
                    $i++;

                    // Check if the category has subcategories
                    $sub_args = array(
                        'taxonomy' => 'product_cat',
                        'parent' => $category->term_id,
                        'hide_empty' => true
                    );
                    $sub_categories = get_terms($sub_args);
                    $has_subcategories = !empty($sub_categories);

                    // Determine if this category should be expanded
                    $is_checked = ($category->term_id == $current_category_id) ? 'checked' : '';
                    $active_class = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'current-category' : '';
                    $show_collapse = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'show' : '';
                    ?>
                    <div class="accordion-item <?php echo $active_class; ?>">
                        <div class="accordion-header d-flex align-items-center" id="heading<?php echo $i; ?>">
                            <label for="cat<?php echo $category->term_id; ?>">
                                <input type="checkbox" class="category-checkbox me-2" id="cat<?php echo $category->term_id; ?>"
                                    data-category-id="<?php echo $category->term_id; ?>" <?php echo $is_checked; ?>>

                                <a href="<?php echo get_term_link($category); ?>" class="main-category">
                                    <span class="customcheck"></span>
                                    <?php echo $category->name . ' <span class="count">(' . $category->count . ')</span>'; ?>
                                </a>
                            </label>

                            <?php if ($has_subcategories) { ?>
                                <button class="accordion-button ms-auto <?php echo ($show_collapse == '') ? 'collapsed' : ''; ?>"
                                    type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>"
                                    aria-expanded="<?php echo ($show_collapse) ? 'true' : 'false'; ?>"
                                    aria-controls="collapse<?php echo $i; ?>" data-category-id="<?php echo $category->term_id; ?>">
                                    <i class="fa fa-angle-down"></i>
                                </button>
                            <?php } ?>
                        </div>
                        <?php if ($has_subcategories) { ?>
                            <div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse <?php echo $show_collapse; ?>"
                                aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#productCategoriesAccordion">
                                <div class="accordion-body ps-0 pe-0">
                                    <?php get_subcategories($category->term_id, 1, $current_category_id, $current_category_parents); ?>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                    <?php
                }
                ?>
            </div>

            <script>
                document.addEventListener("DOMContentLoaded", function () {
                    var savedCategories = JSON.parse(localStorage.getItem("checkedCategories")) || [];

                    savedCategories.forEach(function (categoryId) {
                        var checkbox = document.querySelector('.category-checkbox[data-category-id="' + categoryId + '"]');
                        if (checkbox) {
                            checkbox.checked = true;
                        }
                    });

                    document.querySelectorAll(".category-checkbox").forEach(function (checkbox) {
                        checkbox.addEventListener("change", function () {
                            var categoryId = this.getAttribute("data-category-id");
                            if (this.checked) {
                                if (!savedCategories.includes(categoryId)) {
                                    savedCategories.push(categoryId);
                                }
                            } else {
                                savedCategories = savedCategories.filter(id => id !== categoryId);
                            }
                            localStorage.setItem("checkedCategories", JSON.stringify(savedCategories));
                        });
                    });

                    var activeCategory = localStorage.getItem("activeCategory");
                    if (activeCategory) {
                        var activeAccordion = document.querySelector('[data-category-id="' + activeCategory + '"]');
                        if (activeAccordion) {
                            var collapseElement = activeAccordion.getAttribute("data-bs-target");
                            document.querySelector(collapseElement).classList.add("show");
                            activeAccordion.classList.remove("collapsed");
                            activeAccordion.setAttribute("aria-expanded", "true");
                        }
                    }

                    document.querySelectorAll(".accordion-button").forEach(function (button) {
                        button.addEventListener("click", function () {
                            var categoryId = this.getAttribute("data-category-id");
                            if (document.querySelector(this.getAttribute("data-bs-target")).classList.contains("show")) {
                                localStorage.removeItem("activeCategory");
                            } else {
                                localStorage.setItem("activeCategory", categoryId);
                            }
                        });
                    });
                });
            </script>

            <style>
                .current-category>a {
                    font-weight: bold;
                    color: #ff6600;
                }

                .category-checkbox {
                    display: none;
                }

                span.customcheck {
                    background: #FFFFFF 0% 0% no-repeat padding-box;
                    border: 1px solid #BEC0C5;
                    border-radius: 0px;
                    width: 15px;
                    height: 15px;
                    position: relative;
                    margin-right: 2px;
                    margin-top: 0px;
                    top: 2px;
                    display: inline-block;
                }

                .current-category [type=checkbox]:checked~a span.customcheck {
                    background: #BEC0C5;
                    border-color: #BEC0C5;
                }

                .current-category [type=checkbox]~a .customcheck:after {
                    content: "";
                    position: absolute;
                }

                .current-category a input:checked~.customcheck:after {
                    display: block;
                }

                .current-category a .customcheck:after {
                    left: 5px;
                    top: 2px;
                    width: 4px;
                    height: 8px;
                    border: solid white;
                    border-width: 0 2px 2px 0;
                    -webkit-transform: rotate(45deg);
                    -ms-transform: rotate(45deg);
                    transform: rotate(45deg);
                }
            </style>
            <?php
            return ob_get_clean();
    }
}

add_shortcode('product_categories_accordion', 'wpb_woocommerce_product_categories_accordion');

// product category for sidebar end -------------------------------

// add short descrition 
add_action('woocommerce_after_shop_loop_item_title', 'custom_show_short_description', 6);
function custom_show_short_description()
{
    global $post;
    echo '<p class="custom-snippet">' . wp_trim_words(get_the_excerpt(), 8) . '</p>';
}




// add view product button 
add_action('woocommerce_before_shop_loop_item_title', 'custom_view_product_button', 20);
function custom_view_product_button()
{
    global $product;
    echo '<div class="custom-view-button">
            <div class="animated-btn"><a href="' . get_permalink($product->get_id()) . '" class="view-product-link elementor-button">
                View Product <i class="icon icon-right-arrow"></i>
            </a></div>
          </div>';
}

// product quantity 
// Add custom quantity buttons JS
add_action('wp_footer', 'custom_quantity_buttons_script');
function custom_quantity_buttons_script()
{
    if (!is_product())
        return;
    ?>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                const qtyContainers = document.querySelectorAll('.quantity');
                qtyContainers.forEach(qty => {
                    const input = qty.querySelector('input.qty');
                    if (!input) return;

                    // Remove existing buttons (if any)
                    if (qty.querySelector('.custom-plus')) return;

                    // Create buttons
                    const minus = document.createElement('button');
                    minus.type = 'button';
                    minus.innerHTML = '−';
                    minus.className = 'custom-minus';

                    const plus = document.createElement('button');
                    plus.type = 'button';
                    plus.innerHTML = '+';
                    plus.className = 'custom-plus';

                    // Insert buttons
                    qty.insertBefore(minus, input);
                    qty.appendChild(plus);

                    // Event listeners
                    minus.addEventListener('click', () => {
                        if (input.value > 1) input.value = parseInt(input.value) - 1;
                    });
                    plus.addEventListener('click', () => {
                        input.value = parseInt(input.value) + 1;
                    });
                });
            });
        </script>
        <?php
}


add_filter('woocommerce_product_related_products_heading', 'custom_related_products_title');
function custom_related_products_title($title)
{
    return 'You May Also Like'; // Change this to whatever you want
}







// validation woocommerce start --------------------

add_action('woocommerce_save_account_details_errors', 'validate_my_account_fields', 10, 1);

function validate_my_account_fields($errors)
{
    // Validate First Name
    if (isset($_POST['account_first_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_first_name'])) {
        $errors->add('validation', __('Allowed characters for First Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Last Name
    if (isset($_POST['account_last_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_last_name'])) {
        $errors->add('validation', __('Allowed characters for Last Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Display Name
    if (isset($_POST['account_display_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_display_name'])) {
        $errors->add('validation', __('Allowed characters for Display Name are alphabets and spaces only.', 'woocommerce'));
    }
}




add_action('woocommerce_after_save_address_validation', 'validate_billing_address_fields', 10, 2);

function validate_billing_address_fields($user_id, $address_type)
{
    if ('billing' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $billing_first_name = isset($_POST['billing_first_name']) ? sanitize_text_field($_POST['billing_first_name']) : '';
        $billing_last_name = isset($_POST['billing_last_name']) ? sanitize_text_field($_POST['billing_last_name']) : '';
        $billing_city = isset($_POST['billing_city']) ? sanitize_text_field($_POST['billing_city']) : '';
        $billing_address_1 = isset($_POST['billing_address_1']) ? sanitize_text_field($_POST['billing_address_1']) : '';

        $billing_postcode = isset($_POST['billing_postcode']) ? sanitize_text_field($_POST['billing_postcode']) : '';
        $billing_email = isset($_POST['billing_email']) ? sanitize_email($_POST['billing_email']) : '';

        // Validate Billing First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_first_name)) {
            $validation_errors[] = __('Allowed characters for Billing First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_last_name)) {
            $validation_errors[] = __('Allowed characters for Billing Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_city)) {
            $validation_errors[] = __('Allowed characters for Billing City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $billing_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $billing_postcode)) {
            $validation_errors[] = __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate Billing Email (Basic Email validation)
        if (!is_email($billing_email)) {
            $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}








add_action('woocommerce_after_save_address_validation', 'validate_shipping_address_fields', 10, 2);

function validate_shipping_address_fields($user_id, $address_type)
{
    if ('shipping' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $shipping_first_name = isset($_POST['shipping_first_name']) ? sanitize_text_field($_POST['shipping_first_name']) : '';
        $shipping_last_name = isset($_POST['shipping_last_name']) ? sanitize_text_field($_POST['shipping_last_name']) : '';
        $shipping_city = isset($_POST['shipping_city']) ? sanitize_text_field($_POST['shipping_city']) : '';
        $shipping_address_1 = isset($_POST['shipping_address_1']) ? sanitize_text_field($_POST['shipping_address_1']) : '';

        $shipping_postcode = isset($_POST['shipping_postcode']) ? sanitize_text_field($_POST['shipping_postcode']) : '';
        //  $shipping_email = isset($_POST['shipping_email']) ? sanitize_email($_POST['shipping_email']) : '';

        // Validate shipping First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_first_name)) {
            $validation_errors[] = __('Allowed characters for shipping First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_last_name)) {
            $validation_errors[] = __('Allowed characters for shipping Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_city)) {
            $validation_errors[] = __('Allowed characters for shipping City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $shipping_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $shipping_postcode)) {
            $validation_errors[] = __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate shipping Email (Basic Email validation)
        // if (!is_email($shipping_email)) {
        //     $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        // }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}




// validation woocommerce end --------------------




// form validation start --------------------

// Validate text fields (only alphabets allowed)
add_filter('wpcf7_validate_text', 'alpha_validation_filter_text', 20, 2);
add_filter('wpcf7_validate_text*', 'alpha_validation_filter_text', 20, 2);

function alpha_validation_filter_text($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('names' === $tag->name) {
        $name_of_the_input = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input)) {
            $result->invalidate($tag, "Allowed characters are Alphabets only.");
        }
    }

    return $result;
}

// Validate phone number (must be exactly 10 digits)
add_filter('wpcf7_validate_tel', 'numeric_phone_validation_filter', 20, 2);
add_filter('wpcf7_validate_tel*', 'numeric_phone_validation_filter', 20, 2);

function numeric_phone_validation_filter($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('phone' === $tag->name) {
        $phone_number = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!preg_match('/^\d{10}$/', $phone_number)) {
            $result->invalidate($tag, "Phone number must contain exactly 10 digits.");
        }
    }

    return $result;
}



// Validate email (must be a valid email format)
add_filter('wpcf7_validate_email', 'validate_email_filter', 20, 2);
add_filter('wpcf7_validate_email*', 'validate_email_filter', 20, 2);

function validate_email_filter($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('email' === $tag->name) {
        $email = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $result->invalidate($tag, "Please enter a valid email address.");
        }
    }

    return $result;
}


// Validate textarea field (message)
add_filter('wpcf7_validate_textarea', 'validate_textarea_filter', 20, 2);
add_filter('wpcf7_validate_textarea*', 'validate_textarea_filter', 20, 2);

function validate_textarea_filter($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('message' === $tag->name) {
        $message = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        // Allowed characters: alphabets, spaces, common punctuation marks
        if (!preg_match('/^[a-zA-Z0-9\s.,!?()-]+$/', $message)) {
            $result->invalidate($tag, "Message contains invalid characters. Only letters, numbers, spaces, and punctuation are allowed.");
        }

        // Min 10 characters, Max 500 characters
        if (strlen($message) < 10 || strlen($message) > 500) {
            $result->invalidate($tag, "Message must be between 10 and 500 characters.");
        }
    }

    return $result;
}

// form validation end ----------------------




















?>