<?php get_header(); ?>

<div class="article-detail">

    <div class="container pt-4">

        <?php
        if (have_posts()):
            while (have_posts()):
                the_post();
        ?>

                <div class="news-detail-page">
                    <div class="row g-lg-4 g-3 justify-content-between m-0">
                        <div class="col-lg-12">
                            <?php if (has_post_thumbnail()) {
                                the_post_thumbnail('full', array('class' => 'd-block w-100 rounded-4'));
                            } ?>
                        </div>

                        <div class="col-lg-5 col-md-6">
                            <div class="news-text">
                                <span class="date"><?php echo get_the_date('M j, Y'); ?></span>
                                <h5 class="title mt-0"><?php echo the_title(); ?></h5>
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-6">
                            <p class="description mt-lg-4 pt-2">
                                <?php echo get_the_excerpt(); ?>
                            </p>
                        </div>
                        <div class="col-12">
                            <hr>
                        </div>
                        <div class="col-lg-12">
                            <?php the_content(); ?>
                        </div>
                        <div class="col-lg-12 text-center news-details-btn pt-4">
                            <div class="animated-btn"><a href="<?php echo esc_url(home_url('news-updates')); ?>" class="elementor-button">Back To News & Updates <i
                                        class="icon icon-right-arrow"></i></a></div>
                        </div>
                    </div>
                </div>
        <?php
            endwhile;
        else:
            echo 'No post found.';
        endif;
        ?>

        <?php wp_reset_postdata();    ?>

    </div>
</div>





<?php get_footer(); ?>