<?php
/**
 * Template Name:  Blog Page
 */

get_header();
?>

<div class="container my-5">

    <div class="pt-md-5 pb-md-5 pt-4 pb-4">
        <div class="container">
            <div class="row g-md-3 align-items-center">
                <div class="col-md-12">
                    <div class="banner-title text-center">
                        <img src="https://draftsite1.com/ace-vet-care/wp-content/uploads/2025/07/paws-1.svg" alt="Paws"
                            class="mb-3" width="85">
                        <?php echo '<h1>Articles </h1>' ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4">
        <?php
        $paged = get_query_var('paged') ? get_query_var('paged') : 1;
        $selected_category = isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '';

        $args = array(
            'post_type' => 'post',
            'posts_per_page' => 9,
            'paged' => $paged,
            'orderby' => 'date',
            'order' => 'DESC',
        );

        if (!empty($selected_category)) {
            $args['category_name'] = $selected_category;
        }

        $blog_query = new WP_Query($args);
        ?>

        <div class="col-md-12">
            <div class="p-0">

                <?php
                $categories = get_categories();
                if ($categories):
                    ?>
                    <div class="text-start">
                        <ul class="category-list">
                            <li>
                                <a href="<?php echo esc_url(get_permalink()); ?>"
                                    class="cats <?php echo empty($selected_category) ? 'active' : ''; ?>">
                                    All
                                </a>
                            </li>
                            <?php foreach ($categories as $category):
                                $active_class = ($selected_category === $category->slug) ? 'active' : '';
                                ?>
                                <li>
                                    <a href="<?php echo esc_url(add_query_arg('category', $category->slug, get_permalink())); ?>"
                                        class="cats <?php echo esc_attr($active_class); ?>">
                                        <?php echo esc_html($category->name); ?>
                                        <span><?php // echo esc_html($category->count); ?></span>
                                    </a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="col-md-12">
            <?php if ($blog_query->have_posts()): ?>
                <div class="blog-page blog-main">
                    <div class="row g-md-5 g-3">
                        <?php while ($blog_query->have_posts()):
                            $blog_query->the_post(); ?>
                            <div class="col-md-4">
                                <div class="blog-post-card mb-4">
                                    <div class="blog-image-wrapper">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php if (has_post_thumbnail()) {
                                                the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                            } ?>
                                        </a>
                                        <span></span>
                                       
                                    </div>

                                    <div class="blog-content mt-3">
                                    <?php
                                        $terms = get_the_terms(get_the_ID(), 'category');
                                        if ($terms && !is_wp_error($terms)) {
                                            foreach ($terms as $term) { ?>
                                                <p class="blog-category"><?php echo esc_html(strtolower($term->name)); ?></p>
                                            <?php }
                                        } ?>
                                        <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                    </div>
                                </div>
                            </div>

                        <?php endwhile; ?>
                    </div>

                    <?php if ($blog_query->max_num_pages > 1): ?>
                        <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                            <div class="pagination-style-one">
                                <?php
                                echo paginate_links(array(
                                    'total' => $blog_query->max_num_pages,
                                    'current' => max(1, get_query_var('paged')),
                                    'format' => '?paged=%#%',
                                    'show_all' => false,
                                    'type' => 'plain',
                                    'prev_text' => '<i class="eicon-chevron-left"></i>',
                                    'next_text' => '<i class="eicon-chevron-right"></i>',
                                    'end_size' => 2,
                                    'mid_size' => 2
                                ));
                                ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            <?php else: ?>
                <p>No blog posts found.</p>
            <?php endif;

            wp_reset_postdata();
            ?>
        </div>
    </div>
</div>

<?php get_footer(); ?>