<?php

function hello_elementor_child_enqueue_styles()
{
    wp_enqueue_style('hello-elementor-parent-style', get_template_directory_uri() . '/../hello-elementor-child/style.css');
    wp_enqueue_style('hello-elementor-parent-ecommerce', get_template_directory_uri() . '/../hello-elementor-child/ecommerce.css');
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles');


// Enqueue Booststrap 
function enqueue_bootstrap()
{
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js', array('jquery'), null, true);

}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');


//  Slick carousel script and styles
function enqueue_slick_scripts()
{
    wp_enqueue_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js', array('jquery'), null, true);
    wp_enqueue_style('slick-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_slick_scripts');


function enqueue_custom_script()
{
    wp_enqueue_script(
        'custom-script',
        get_template_directory_uri() . '../../hello-elementor-child/custom-script.js',
        array('jquery'),
        null,
        true
    );
}
add_action('wp_enqueue_scripts', 'enqueue_custom_script');



// custom code



// blog related start --------------------

function get_related_articles($post_id, $number_of_posts = 5)
{

    $args = array(
        'post_type' => 'post',
        'post__not_in' => array($post_id),
        'posts_per_page' => $number_of_posts,
        'ignore_sticky_posts' => 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );

    return get_posts($args);

    $related_posts = get_related_articles(get_the_ID());

    // If not enough related posts by category, get related posts by tag
    if (count($related_posts) < $number_of_posts) {
        $tags = wp_get_post_tags($post_id);
        if ($tags) {
            $tag_ids = array();
            foreach ($tags as $tag) {
                $tag_ids[] = $tag->term_id;
            }
            $args = array(
                'tag__in' => $tag_ids,
                'post__not_in' => array_merge(array($post_id), wp_list_pluck($related_posts, 'ID')),
                'posts_per_page' => $number_of_posts - count($related_posts),
                'ignore_sticky_posts' => 1,
            );
            $more_related_posts = get_posts($args);
            $related_posts = array_merge($related_posts, $more_related_posts);
        }
    }

    return $related_posts;
}

// blog related end --------------------




// woocommerce code start here ---------------------


//  WooCommerce product  image wrap  ----------
add_action('woocommerce_before_shop_loop_item_title', 'wrap_product_image_in_div', 5);
function wrap_product_image_in_div()
{
    echo '<div class="product-image-wrapper">';
}
add_action('woocommerce_before_shop_loop_item_title', 'close_product_image_div', 15);
function close_product_image_div()
{
    echo '</div>';
}
//  WooCommerce product image wrap ----------



function change_related_products_heading($translated_text, $text, $domain)
{
    if ('Related products' === $text) {
        $translated_text = __('You May Like These, Too', 'your-text-domain');
    }
    return $translated_text;
}
add_filter('gettext', 'change_related_products_heading', 20, 3);



// Display brand before product title on single product page
function show_brand_before_product_title()
{
    global $post;

    $terms = get_the_terms($post->ID, 'product_brand');

    if (!empty($terms) && !is_wp_error($terms)) {
        $brand_names = wp_list_pluck($terms, 'name');
        echo '<div class="product-brand mb-2" style="color:#8BB1CC;font-size: 14px;">' . esc_html(implode(', ', $brand_names)) . '</div>';
    }
}
add_action('woocommerce_single_product_summary', 'show_brand_before_product_title', 4);






// product-categories start ----------------------------------------- 
function wpb_woocommerce_product_categories_accordion()
{
    // Get the current queried product category
    $queried_object = get_queried_object();
    $current_category_id = ($queried_object && isset($queried_object->term_id)) ? $queried_object->term_id : 0;

    // Get all parent categories of the current category
    $current_category_parents = [];
    if ($current_category_id) {
        $parent_categories = get_ancestors($current_category_id, 'product_cat');
        $current_category_parents = array_map('intval', $parent_categories);
    }

    // Recursive function to get subcategories with checkboxes
    function get_subcategories($parent_id, $level = 1, $current_category_id, $current_category_parents)
    {
        $args = array(
            'taxonomy' => 'product_cat',
            'orderby' => 'name',
            'order' => 'ASC',
            'parent' => $parent_id,
            'hide_empty' => true
        );
        $sub_categories = get_terms($args);

        if (!empty($sub_categories)) {
            echo '<ul class="list-unstyled ps-2">';
            foreach ($sub_categories as $sub_category) {
                $is_checked = ($sub_category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($sub_category->term_id == $current_category_id) ? 'current-category' : '';

                echo '<li class="' . $active_class . '">';
                echo '<div class="in-menu">';
                echo '<input type="checkbox" class="category-checkbox me-2" data-category-id="' . $sub_category->term_id . '" ' . $is_checked . '> ';

                echo '<a href="' . get_term_link($sub_category) . '">  <span class="customcheck"></span>' . $sub_category->name . '</a>';
                echo '</div>';
                get_subcategories($sub_category->term_id, $level + 1, $current_category_id, $current_category_parents);
                echo '</li>';
            }
            echo '</ul>';
        }
    }

    // Get main product categories (parent categories)
    $args = array(
        'taxonomy' => 'product_cat',
        'orderby' => 'name',
        'order' => 'ASC',
        'parent' => 0,
        'hide_empty' => true
    );
    $product_categories = get_terms($args);

    if ($product_categories) {
        ob_start();
        ?>
        <div class="accordion" id="productCategoriesAccordion">

            <?php
            $shop_page_url = wc_get_page_permalink('shop');
            $is_shop_page = is_shop();
            ?>

            <div class="accordion-item">
                <div class="accordion-header <?php echo $is_shop_page ? 'current-category' : ''; ?>">
                    <label>
                        <a href="<?php echo esc_url($shop_page_url); ?>" class="main-category">
                            All
                        </a>
                    </label>
                </div>
            </div>


            <?php
            $i = 0;
            foreach ($product_categories as $category) {
                $i++;

                // Check if the category has subcategories
                $sub_args = array(
                    'taxonomy' => 'product_cat',
                    'parent' => $category->term_id,
                    'hide_empty' => true
                );
                $sub_categories = get_terms($sub_args);
                $has_subcategories = !empty($sub_categories);

                // Determine if this category should be expanded
                $is_checked = ($category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'current-category' : '';
                $show_collapse = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'show' : '';
                ?>
                <div class="accordion-item <?php echo $active_class; ?>">
                    <div class="accordion-header d-flex align-items-center" id="heading<?php echo $i; ?>">
                        <label for="cat<?php echo $category->term_id; ?>">
                            <input type="checkbox" class="category-checkbox me-2" id="cat<?php echo $category->term_id; ?>"
                                data-category-id="<?php echo $category->term_id; ?>" <?php echo $is_checked; ?>>

                            <a href="<?php echo get_term_link($category); ?>" class="main-category">
                                <span class="customcheck"></span> <?php echo $category->name; ?>
                            </a>
                        </label>

                        <?php if ($has_subcategories) { ?>
                            <button class="accordion-button ms-auto <?php echo ($show_collapse == '') ? 'collapsed' : ''; ?>"
                                type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>"
                                aria-expanded="<?php echo ($show_collapse) ? 'true' : 'false'; ?>"
                                aria-controls="collapse<?php echo $i; ?>" data-category-id="<?php echo $category->term_id; ?>">
                                <i class="fa fa-angle-down"></i>
                            </button>
                        <?php } ?>
                    </div>
                    <?php if ($has_subcategories) { ?>
                        <div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse <?php echo $show_collapse; ?>"
                            aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#productCategoriesAccordion">
                            <div class="accordion-body ps-0 pe-0">
                                <?php get_subcategories($category->term_id, 1, $current_category_id, $current_category_parents); ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
                <?php
            }
            ?>
        </div>

        <script>
            document.addEventListener("DOMContentLoaded", function () {
                var savedCategories = JSON.parse(localStorage.getItem("checkedCategories")) || [];

                savedCategories.forEach(function (categoryId) {
                    var checkbox = document.querySelector('.category-checkbox[data-category-id="' + categoryId + '"]');
                    if (checkbox) {
                        checkbox.checked = true;
                    }
                });

                document.querySelectorAll(".category-checkbox").forEach(function (checkbox) {
                    checkbox.addEventListener("change", function () {
                        var categoryId = this.getAttribute("data-category-id");
                        if (this.checked) {
                            if (!savedCategories.includes(categoryId)) {
                                savedCategories.push(categoryId);
                            }
                        } else {
                            savedCategories = savedCategories.filter(id => id !== categoryId);
                        }
                        localStorage.setItem("checkedCategories", JSON.stringify(savedCategories));
                    });
                });

                var activeCategory = localStorage.getItem("activeCategory");
                if (activeCategory) {
                    var activeAccordion = document.querySelector('[data-category-id="' + activeCategory + '"]');
                    if (activeAccordion) {
                        var collapseElement = activeAccordion.getAttribute("data-bs-target");
                        document.querySelector(collapseElement).classList.add("show");
                        activeAccordion.classList.remove("collapsed");
                        activeAccordion.setAttribute("aria-expanded", "true");
                    }
                }

                document.querySelectorAll(".accordion-button").forEach(function (button) {
                    button.addEventListener("click", function () {
                        var categoryId = this.getAttribute("data-category-id");
                        if (document.querySelector(this.getAttribute("data-bs-target")).classList.contains("show")) {
                            localStorage.removeItem("activeCategory");
                        } else {
                            localStorage.setItem("activeCategory", categoryId);
                        }
                    });
                });
            });
        </script>

        <style>
            .current-category>a {
                font-weight: bold;
                color: #ff6600;
            }

            .category-checkbox {
                display: none;
            }

            span.customcheck {
                background: #FFFFFF 0% 0% no-repeat padding-box;
                border: 1px solid #DDDDDD;
                border-radius: 2px;
                width: 18px;
                height: 18px;
                position: relative;
                margin-right: 6px;
                margin-top: 0px;
                top: 2px;
                display: block;
                float: right;
            }

            .current-category [type=checkbox]:checked~a span.customcheck {
                background: #F68E3A;
                background-image: url('https://draftsite1.com/ace-vet-care/wp-content/uploads/2025/07/icon-paw-1.png');
                border: 0 !important;
                background-size: contain;
                background-position: center;
                background-repeat: no-repeat;
            }

            .current-category [type=checkbox]~a .customcheck:after {
                content: "";
                position: absolute;
            }

            .current-category a input:checked~.customcheck:after {
                display: block;
            }

            .current-category a .customcheck:after {
                /* left: 5px;
                                                        top: 2px;
                                                        width: 4px;
                                                        height: 8px;
                                                        border: solid white;
                                                        border-width: 0 2px 2px 0;
                                                        -webkit-transform: rotate(45deg);
                                                        -ms-transform: rotate(45deg);
                                                        transform: rotate(45deg); */
            }
        </style>
        <?php
        return ob_get_clean();
    }
}

add_shortcode('product_categories_accordion', 'wpb_woocommerce_product_categories_accordion');

// product category for sidebar end -------------------------------



// brand start --------
function apply_brand_checkbox_filter_to_products($query)
{
    if (is_admin() || !$query->is_main_query()) {
        return;
    }

    // Only apply on shop or product archive pages
    if (is_post_type_archive('product') || is_tax('product_cat')) {

        if (!empty($_GET['product_brand']) && is_array($_GET['product_brand'])) {
            $brands = array_map('sanitize_text_field', $_GET['product_brand']);

            // Fetch existing tax_query and merge
            $tax_query = (array) $query->get('tax_query');

            $tax_query[] = array(
                'taxonomy' => 'product_brand',
                'field' => 'slug',
                'terms' => $brands,
                'operator' => 'IN',
            );

            $query->set('tax_query', $tax_query);
        }
    }
}
add_action('pre_get_posts', 'apply_brand_checkbox_filter_to_products');



function brand_archive_checkbox_filter_shortcode()
{
    $terms = get_terms(array(
        'taxonomy' => 'product_brand',
        'hide_empty' => true,
    ));

    if (empty($terms) || is_wp_error($terms)) {
        return '<p>No brands available.</p>';
    }

    $current_term = is_tax('product_brand') ? get_queried_object() : null;

    ob_start(); ?>
    <form method="get" id="brand-archive-filter" class="brand-filter-form">
        <div class="brand-filter-checkboxes">
            <?php foreach ($terms as $term): ?>
                <?php
                $checked = ($current_term && $current_term->term_id === $term->term_id) ? 'checked' : '';
                ?>
                <label>
                    <p class="mb-0 d-inline"><?php echo esc_html($term->name); ?> </p>
                    <input type="checkbox" name="brand" value="<?php echo esc_url(get_term_link($term)); ?>"
                        onchange="window.location.href = this.value;" <?php echo $checked; ?>>

                    <span class="customcheckbox"> </span>
                </label>
            <?php endforeach; ?>
        </div>
    </form>
    <?php
    return ob_get_clean();
}
add_shortcode('brand_archive_filter', 'brand_archive_checkbox_filter_shortcode');

// brand end --------


// Add custom buttons  for product hover in WooCommerce
add_action('woocommerce_after_shop_loop_item', 'custom_product_hover_buttons', 20);

function custom_product_hover_buttons()
{
    global $product;
    $product_id = $product->get_id();
    $product_url = get_permalink($product_id);
    $add_to_cart_url = esc_url("?add-to-cart=" . $product_id);
    ?>
    <div class="custom-hover-buttons">
        <a href="<?php echo $product_url; ?>" class="view-product-btn" title="View Product">
            <img src="https://draftsite1.com/ace-vet-care/wp-content/uploads/2025/07/icon-view.svg" alt="" class="mb-0">
        </a>
        <a href="<?php echo $add_to_cart_url; ?>" class="add-to-cart-btn ajax_add_to_cart" title="Add to Cart">
            <img src="https://draftsite1.com/ace-vet-care/wp-content/uploads/2025/07/icon-addtocart.svg" alt=""
                class="mb-0">
        </a>
    </div>
    <?php
}
// End Add custom buttons  for product hover in WooCommerce 









// Add custom quantity buttons JS start -----------

add_action('wp_footer', 'custom_quantity_buttons_script');
function custom_quantity_buttons_script()
{
    if (!is_product())
        return;
    ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const qtyContainers = document.querySelectorAll('.quantity');
            qtyContainers.forEach(qty => {
                const input = qty.querySelector('input.qty');
                if (!input) return;

                // Remove existing buttons (if any)
                if (qty.querySelector('.custom-plus')) return;

                // Create buttons
                const minus = document.createElement('button');
                minus.type = 'button';
                minus.innerHTML = '−';
                minus.className = 'custom-minus';

                const plus = document.createElement('button');
                plus.type = 'button';
                plus.innerHTML = '+';
                plus.className = 'custom-plus';

                // Insert buttons
                qty.insertBefore(minus, input);
                qty.appendChild(plus);

                // Event listeners
                minus.addEventListener('click', () => {
                    if (input.value > 1) input.value = parseInt(input.value) - 1;
                });
                plus.addEventListener('click', () => {
                    input.value = parseInt(input.value) + 1;
                });
            });
        });
    </script>
    <?php
}

// Add custom quantity buttons JS end --------------




// single shop banner  start ---------------------------
// Remove default breadcrumb location
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);

// Add breadcrumb before product title
add_action('woocommerce_single_product_summary', 'woocommerce_breadcrumb', 4);


add_action('woocommerce_before_main_content', 'custom_shop_header', 5);
function custom_shop_header()
{
    if (is_product()) {
        ?>
        <div class="woocommerce-shop-details-banner py-4 ">
            <div class="container">
                <div class="row g-md-3 align-items-center">
                    <div class="col-md-12">
                        <div class="">
                            <?php
                            // Display product category name if applicable
                            // if (is_product_category()) {
                            //     $category = get_queried_object();
                            //     if ($category) {
                            //         echo '<h1>' . esc_html($category->name) . '</h1>';
                            //     }
                            // } else {
                            //     echo '<h1>Shop</h1>';
                            // }
                    
                            // Display WooCommerce breadcrumb
                            if (function_exists('woocommerce_breadcrumb')) {
                                woocommerce_breadcrumb(array(
                                    'delimiter' => ' / ',
                                    'wrap_before' => '<nav class="woocommerce-breadcrumb" itemprop="breadcrumb">',
                                    'wrap_after' => '</nav>',
                                ));
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}
// single shop banner end ---------------------------



// wpgis  product gallery ------------------
add_action('wp_footer', 'hide_gallery_thumbs_if_single_image');
function hide_gallery_thumbs_if_single_image()
{
    if (is_product()): ?>
        <script>
            jQuery(document).ready(function ($) {
                $(window).on('load', function () {
                    var thumbCount = $('.wpgis-slider-nav .slick-slide').length;

                    if (thumbCount <= 1) {
                        $('.wpgis-slider-nav').hide();
                        $('.wpgis-slider-for').addClass('full-width-slider');
                    } else {
                        $('.wpgis-slider-nav').show();
                        $('.wpgis-slider-for').removeClass('full-width-slider');
                    }
                });
            });
        </script>
    <?php endif;
}
// wpgis  product gallery end ------------------








// validation start -----------------------------------------------------------



// validation woocommerce start 


add_action('woocommerce_save_account_details_errors', 'validate_my_account_fields', 10, 1);

function validate_my_account_fields($errors)
{
    // Validate First Name
    if (isset($_POST['account_first_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_first_name'])) {
        $errors->add('validation', __('Allowed characters for First Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Last Name
    if (isset($_POST['account_last_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_last_name'])) {
        $errors->add('validation', __('Allowed characters for Last Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Display Name
    if (isset($_POST['account_display_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_display_name'])) {
        $errors->add('validation', __('Allowed characters for Display Name are alphabets and spaces only.', 'woocommerce'));
    }
}




add_action('woocommerce_after_save_address_validation', 'validate_billing_address_fields', 10, 2);

function validate_billing_address_fields($user_id, $address_type)
{
    if ('billing' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $billing_first_name = isset($_POST['billing_first_name']) ? sanitize_text_field($_POST['billing_first_name']) : '';
        $billing_last_name = isset($_POST['billing_last_name']) ? sanitize_text_field($_POST['billing_last_name']) : '';
        $billing_city = isset($_POST['billing_city']) ? sanitize_text_field($_POST['billing_city']) : '';
        $billing_address_1 = isset($_POST['billing_address_1']) ? sanitize_text_field($_POST['billing_address_1']) : '';

        $billing_postcode = isset($_POST['billing_postcode']) ? sanitize_text_field($_POST['billing_postcode']) : '';
        $billing_email = isset($_POST['billing_email']) ? sanitize_email($_POST['billing_email']) : '';

        // Validate Billing First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_first_name)) {
            $validation_errors[] = __('Allowed characters for Billing First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_last_name)) {
            $validation_errors[] = __('Allowed characters for Billing Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_city)) {
            $validation_errors[] = __('Allowed characters for Billing City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $billing_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $billing_postcode)) {
            $validation_errors[] = __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate Billing Email (Basic Email validation)
        if (!is_email($billing_email)) {
            $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}








add_action('woocommerce_after_save_address_validation', 'validate_shipping_address_fields', 10, 2);

function validate_shipping_address_fields($user_id, $address_type)
{
    if ('shipping' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $shipping_first_name = isset($_POST['shipping_first_name']) ? sanitize_text_field($_POST['shipping_first_name']) : '';
        $shipping_last_name = isset($_POST['shipping_last_name']) ? sanitize_text_field($_POST['shipping_last_name']) : '';
        $shipping_city = isset($_POST['shipping_city']) ? sanitize_text_field($_POST['shipping_city']) : '';
        $shipping_address_1 = isset($_POST['shipping_address_1']) ? sanitize_text_field($_POST['shipping_address_1']) : '';

        $shipping_postcode = isset($_POST['shipping_postcode']) ? sanitize_text_field($_POST['shipping_postcode']) : '';
        //  $shipping_email = isset($_POST['shipping_email']) ? sanitize_email($_POST['shipping_email']) : '';

        // Validate shipping First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_first_name)) {
            $validation_errors[] = __('Allowed characters for shipping First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_last_name)) {
            $validation_errors[] = __('Allowed characters for shipping Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_city)) {
            $validation_errors[] = __('Allowed characters for shipping City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $shipping_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $shipping_postcode)) {
            $validation_errors[] = __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate shipping Email (Basic Email validation)
        // if (!is_email($shipping_email)) {
        //     $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        // }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}




// validation woocommerce end --------------------







// contact form validation 

// Validate text fields (only alphabets allowed)
add_filter('wpcf7_validate_text', 'alpha_validation_filter_text', 20, 2);
add_filter('wpcf7_validate_text*', 'alpha_validation_filter_text', 20, 2);

function alpha_validation_filter_text($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('names' === $tag->name) {
        $name_of_the_input = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input)) {
            $result->invalidate($tag, "Allowed characters are Alphabets only.");
        }
    }

    if ('lname' === $tag->name) {
        $name_of_the_input = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input)) {
            $result->invalidate($tag, "Allowed characters are Alphabets only.");
        }
    }

    return $result;
}

// Validate phone number (must be exactly 10 digits)
add_filter('wpcf7_validate_tel', 'numeric_phone_validation_filter', 20, 2);
add_filter('wpcf7_validate_tel*', 'numeric_phone_validation_filter', 20, 2);

function numeric_phone_validation_filter($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('phone' === $tag->name) {
        $phone_number = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!preg_match('/^\d{8}$/', $phone_number)) {
            $result->invalidate($tag, "Phone number must contain exactly 8 digits.");
        }
    }

    return $result;
}



// Validate email (must be a valid email format)
add_filter('wpcf7_validate_email', 'validate_email_filter', 20, 2);
add_filter('wpcf7_validate_email*', 'validate_email_filter', 20, 2);

function validate_email_filter($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('email' === $tag->name) {
        $email = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $result->invalidate($tag, "Please enter a valid email address.");
        }
    }

    return $result;
}


// Validate textarea field (message)
add_filter('wpcf7_validate_textarea', 'validate_textarea_filter', 20, 2);
add_filter('wpcf7_validate_textarea*', 'validate_textarea_filter', 20, 2);

function validate_textarea_filter($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('message' === $tag->name) {
        $message = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        // Allowed characters: alphabets, spaces, common punctuation marks
        if (!preg_match('/^[a-zA-Z0-9\s.,!?()-]+$/', $message)) {
            $result->invalidate($tag, "Message contains invalid characters. Only letters, numbers, spaces, and punctuation are allowed.");
        }

        // Min 10 characters, Max 500 characters
        if (strlen($message) < 10 || strlen($message) > 500) {
            $result->invalidate($tag, "Message must be between 10 and 500 characters.");
        }
    }

    return $result;
}




// validation end -----------------------------------------------------------



// woocommerce end-----------


function custom_products_taxonomy_posts_per_page($query)
{
    if (
        !is_admin() &&
        $query->is_main_query() &&
        is_tax('controlled-products-category')
    ) {
        $query->set('posts_per_page', 9);
    }
}
add_action('pre_get_posts', 'custom_products_taxonomy_posts_per_page');


// testimonials slider Start --------------------------------------------
function display_testimonials($atts)
{
    $args = array(
        'post_type' => 'testimonials',
    );

    $mainslider_query = new WP_Query($args);

    ob_start();

    if ($mainslider_query->have_posts()):
        $total_slides = $mainslider_query->post_count;
        ?>
        <div id="demo" class="carousel slide hero-banner carousel-fade" data-bs-ride="carousel">
            <div class="carousel-inner">
                <?php
                $first = true;
                while ($mainslider_query->have_posts()):
                    $mainslider_query->the_post(); ?>

                    <div class="carousel-item <?php echo $first ? 'active' : ''; ?>">

                        <div class="row align-items-end justify-content-end">
                            <div class="col-lg-5 col-md-6">
                                <div class="testimonial-details">
                                    <h6 class="qoute">“</h6>
                                    <div class="description">

                                        <?php echo wp_trim_words(get_the_content(), 150, '...'); ?>
                                        <?php
                                        $content = get_the_content();
                                        $word_count = str_word_count(wp_strip_all_tags(strip_shortcodes($content)));
                                        if ($word_count > 150):
                                            ?>
                                            <span class="tmore"> [more] </span>

                                        <?php endif; ?>

                                        <div class="full-content"> <?php echo get_the_content(); ?> </div>
                                    </div>



                                    <h5 class="author-name"><?php the_title(); ?></h5>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 p-0">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                } ?>
                            </div>
                        </div>

                    </div>
                    <?php
                    $first = false;
                endwhile; ?>
            </div>

            <?php if ($total_slides > 1): ?>

                <div class="arrow-control-bottom">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="arrow-control-slider">
                                    <span class="control-prev" data-bs-target="#demo" data-bs-slide="prev">
                                        <i class="fa fa-arrow-left"></i>
                                    </span>
                                    <span class="control-next" data-bs-target="#demo" data-bs-slide="next">
                                        <i class="fa fa-arrow-right"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            <?php endif; ?>


        </div>

    <?php else: ?>
        <div>No Slider found.</div>
    <?php endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('testimonials', 'display_testimonials');


// Testimonials slider end --------------------------------------------





// services page start ------------------------------------------------------------


function display_services($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 8,
        ),
        $atts,
        'services'
    );

    // Get the current page


    $args = array(
        'post_type' => 'ourservice',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );



    $services_query = new WP_Query($args);

    ob_start();

    if ($services_query->have_posts()): ?>
        <div class="services-page">
            <div class="row g-md-5 g-3">
                <?php while ($services_query->have_posts()):
                    $services_query->the_post();
                    ?>

                    <div class="col-lg-6 col-md-6">
                        <div class="service-box mb-4">
                            <div class="img-box">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                } ?>
                               
                               <?php
                                    $icon_url = get_field('icon');

                                    if (!empty($icon_url)) {
                                        echo '<img src="' . esc_url($icon_url) . '" alt="Icon" class="icon"> ';
                                    }
                                    ?>
                                <h2><?php echo get_the_title(); ?></h2>
                            </div>
                            <div class="text-box">
                                <div>
                                    <h2 class="mb-lg-4 pb-lg-1 mb-3"><?php echo get_the_title(); ?></h2>
                                    <?php
                                    $bulleted_points = get_field('bulleted_point');

                                    if (!empty($bulleted_points)): ?>
                                        <ul class="mb-4">
                                            <?php foreach ($bulleted_points as $item): ?>
                                                <?php if (!empty($item['point'])): ?>
                                                    <li><?php echo esc_html($item['point']); ?></li>
                                                <?php endif; ?>
                                            <?php endforeach; ?>
                                        </ul>
                                    <?php endif; ?>

                                    <a href="<?php the_permalink(); ?>" class="elementor-button">View Details</a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>

            <?php if ($services_query->max_num_pages > 1): ?>
                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                    <div class="pagination-two">
                        <?php
                        echo paginate_links(array(
                            'total' => $services_query->max_num_pages,
                            'current' => max(1, get_query_var('paged')),
                            'format' => '?paged=%#%',
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => '<i class="eicon-chevron-left"></i>',
                            'next_text' => '<i class="eicon-chevron-right"></i>',
                            'end_size' => 2,
                            'mid_size' => 2
                        ));
                        ?>
                    </div>
                </div>
            <?php endif; ?>


        <?php else:
        echo 'No services found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('services', 'display_services');


// services list end------------



// services slider start------------------
function display_services_slider($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => -1,
        ),
        $atts,
        'services'
    );

    $args = array(
        'post_type' => 'ourservice',
        'posts_per_page' => $atts['posts_per_page'],
        'meta_query' => array(
            array(
                'key' => '_is_ns_featured_post',
                'value' => 'yes',
                'compare' => '='
            )
        )
    );

    $services_query = new WP_Query($args);


    ob_start();

    if ($services_query->have_posts()): ?>
            <div class="services-slider">
                <div class="slick-slider-services">
                    <?php while ($services_query->have_posts()):
                        $services_query->the_post();
                        ?>

                        <div class="item pt-4 ps-2 pe-2">
                            <div class="service-box service-box-slider mb-4">
                                <div class="img-box">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                    } ?>

                                    <?php
                                    $icon_url = get_field('icon');

                                    if (!empty($icon_url)) {
                                        echo '<img src="' . esc_url($icon_url) . '" alt="Icon" class="icon"> ';
                                    }
                                    ?>


                                    <h2><?php echo get_the_title(); ?></h2>
                                </div>
                                <div class="text-box">
                                    <div>
                                        <h2 class="mb-lg-4 pb-lg-1 mb-3"><?php echo get_the_title(); ?></h2>
                                        <?php
                                        $bulleted_points = get_field('bulleted_point');

                                        if (!empty($bulleted_points)): ?>
                                            <ul class="mb-4">
                                                <?php foreach ($bulleted_points as $item): ?>
                                                    <?php if (!empty($item['point'])): ?>
                                                        <li><?php echo esc_html($item['point']); ?></li>
                                                    <?php endif; ?>
                                                <?php endforeach; ?>
                                            </ul>
                                        <?php endif; ?>

                                        <a href="<?php the_permalink(); ?>" class="elementor-button">View Details</a>
                                    </div>
                                </div>
                            </div>

                        </div>
                    <?php endwhile; ?>
                </div>
            </div>


        <?php else:
        echo 'No services found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('services_slider', 'display_services_slider');
// services slider end ------------------------------




// enquiry product  title 


//produtcs title for enquiry start ---------------------------
function cf7_dynamic_product_title($atts)
{
    $atts = shortcode_atts(array('id' => ''), $atts);
    $post_id = !empty($atts['id']) ? intval($atts['id']) : get_the_ID();

    if (!$post_id) {
        return '';
    }

    return esc_attr(get_the_title($post_id));
}
add_shortcode('cf7_product_title', 'cf7_dynamic_product_title');

function cf7_dynamic_hidden_field($tag)
{
    if ($tag['name'] === 'product_title') {
        $post_id = get_the_ID();
        if ($post_id) {
            $tag['values'][] = get_the_title($post_id);
        }
    }
    return $tag;
}
add_filter('wpcf7_form_tag', 'cf7_dynamic_hidden_field', 10, 2);





function pets_filter_shortcode()
{
    $terms = get_terms(array(
        'taxonomy' => 'pets',
        'hide_empty' => true,
    ));

    if (empty($terms)) {
        return '<p>No pets found.</p>';
    }

    ob_start(); ?>
        <form id="pets-filter-form">
            <?php foreach ($terms as $term): ?>
                <label>
                    <input type="checkbox" name="pets[]" value="<?php echo esc_attr($term->slug); ?>">
                    <?php echo esc_html($term->name); ?>
                </label><br>
            <?php endforeach; ?>
        </form>

        <div id="pets-filter-results"></div>

        <script>
            jQuery(document).ready(function ($) {
                $('#pets-filter-form input').on('change', function () {
                    var selectedPets = [];
                    $('#pets-filter-form input:checked').each(function () {
                        selectedPets.push($(this).val());
                    });

                    $.ajax({
                        url: '<?php echo admin_url('admin-ajax.php'); ?>',
                        type: 'POST',
                        data: {
                            action: 'filter_by_pets',
                            pets: selectedPets
                        },
                        success: function (response) {
                            $('#pets-filter-results').html(response);
                        }
                    });
                });
            });
        </script>
        <?php
        return ob_get_clean();
}
add_shortcode('pets_filter', 'pets_filter_shortcode');

