<?php
/*
Template Name: Product Enquiry Template
*/

get_header(); ?>

<div id="primary" class="content-area">

    <main id="main" class="site-main custom-product-page pb-md-5 pb-4">



        <div class="woocommerce-shop-banner pt-md-5 pb-md-5 pt-4 pb-4">
            <div class="container">
                <div class="row g-md-3 align-items-center">
                    <div class="col-md-12">
                        <div class="banner-title text-center">
                            <img src="https://draftsite1.com/ace-vet-care/wp-content/uploads/2025/07/paws-1.svg"
                                alt="Paws" class="mb-3" width="85">

                            <?php echo '<h1>Controlled Products </h1>' ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="row">
            <div class="col-lg-3 col-md-3 pe-lg-5 sidebar order-md-1 order-2">
                <div class="fiter_shop mb-4">

                    <!-- Pets Filter -->
                    <div class="pb-4">
                        <h2 class="title">Filter by Pets</h2>


                        <form id="pets-filter-form" method="GET" action="">
                            <?php
                            $selected_pets = isset($_GET['pets']) ? (array) $_GET['pets'] : array();
                            $terms = get_terms(array(
                                'taxonomy' => 'pets',
                                'hide_empty' => false,
                            ));

                            if (!empty($terms)) {
                                echo '<div class="filter-by-pets">';
                                foreach ($terms as $term) {
                                    $checked = in_array($term->slug, $selected_pets) ? 'checked' : '';
                                    echo '<label style="display:block; margin-bottom:10px;">';
                                    echo '<input type="checkbox" class="d-none" name="pets[]" value="' . esc_attr($term->slug) . '" ' . $checked . ' onchange="document.getElementById(\'pets-filter-form\').submit();">';
                                    echo '<span class="customcheck"></span>';
                                    echo ' ' . esc_html($term->name);
                                    echo '</label>';
                                }
                                echo '</div>';
                            }
                            ?>
                        </form>


                    </div>

                    <div class="pb-4">
                        <h2 class="title"> CATEGORIES </h2>

                        <?php
                        $active_category = single_term_title('', false);

                        $taxonomy = 'controlled-products-category';
                        $terms = get_terms(array(
                            'taxonomy' => $taxonomy,
                            'hide_empty' => true,
                            'parent' => 0,
                        ));

                        if (!empty($terms) && !is_wp_error($terms)):
                            $i = 1;
                            ?>
                            <div class="taxonomy-list">

                                <div class="accordion" id="productCategoriesAccordion">
                                    <?php
                                    foreach ($terms as $term):
                                        $term_link = get_term_link($term);
                                        $active_class = ($active_category === $term->name) ? 'active' : '';


                                        $subcategories = get_terms(array(
                                            'taxonomy' => $taxonomy,
                                            'hide_empty' => true,
                                            'parent' => $term->term_id,
                                        ));
                                        ?>

                                        <div class="accordion-item">
                                            <div class="accordion-header" id="heading<?php echo $i; ?>">

                                                <a href="<?php echo esc_url($term_link); ?>" class="main-category">
                                                    <span class="customcheck"></span> <?php echo esc_html($term->name); ?>
                                                </a>

                                                <?php if ($subcategories) { ?>
                                                    <button class="accordion-button <?php echo ($i > 1) ? 'collapsed' : ''; ?>"
                                                        type="button" data-bs-toggle="collapse"
                                                        data-bs-target="#collapse<?php echo $i; ?>"
                                                        aria-expanded="<?php echo ($i === 1) ? 'true' : 'false'; ?>"
                                                        aria-controls="collapse<?php echo $i; ?>"></button>
                                                <?php } ?>
                                            </div>
                                            <?php if ($subcategories) { ?>
                                                <div id="collapse<?php echo $i; ?>"
                                                    class="accordion-collapse collapse <?php echo ($i === 1) ? 'show' : ''; ?>"
                                                    aria-labelledby="heading<?php echo $i; ?>"
                                                    data-bs-parent="#productCategoriesAccordion">
                                                    <div class="accordion-body">
                                                        <?php if (!empty($subcategories) && !is_wp_error($subcategories)): ?>
                                                            <ul class="list-unstyled">
                                                                <?php foreach ($subcategories as $subcategory):
                                                                    $subcat_link = get_term_link($subcategory);
                                                                    $subcat_active_class = ($active_category === $subcategory->name) ? 'active' : '';
                                                                    ?>
                                                                    <li>
                                                                        <a href="<?php echo esc_url($subcat_link); ?>"
                                                                            class="<?php echo esc_attr($subcat_active_class); ?>">
                                                                            <?php echo esc_html($subcategory->name); ?>
                                                                        </a>
                                                                    </li>
                                                                <?php endforeach; ?>
                                                            </ul>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            <?php } ?>
                                        </div>
                                        <?php
                                        $i++;
                                    endforeach; ?>
                                </div>
                            </div>
                            <?php
                        else:
                            ?>
                            <p><?php esc_html_e('No categories found', 'textdomain'); ?></p>
                            <?php
                        endif;
                        ?>
                    </div>
                </div>
            </div>


            <div class="col-lg-9 col-md-9 order-md-2 order-1">
                <div class="row" id="ajax-product-results">
                    <?php
                    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

                    $tax_query = array();
                    
                    if (!empty($_GET['pets'])) {
                        $tax_query[] = array(
                            'taxonomy' => 'pets',
                            'field'    => 'slug',
                            'terms'    => array_map('sanitize_text_field', $_GET['pets']),
                        );
                    }
                    
                    $args = array(
                        'post_type'      => 'controlled-products',
                        'posts_per_page' => 9,
                        'paged'          => $paged,
                        'tax_query'      => $tax_query,
                    );
                    
                    $query = new WP_Query($args);
                    


                    if ($query->have_posts()):
                        while ($query->have_posts()):
                            $query->the_post();
                            ?>

                            <div class="col-md-4 col-sm-6 mb-4" id="post-<?php the_ID(); ?>">
                                <div <?php post_class(); ?>>
                                    <div class="product-card">
                                        <div class="product-wrap">
                                            <div class="img-box">
                                                <?php if (has_post_thumbnail()): ?>
                                                    <?php the_post_thumbnail('full'); ?>
                                                <?php endif; ?>
                                            </div>
                                            <div class="custom-hover-buttons">
                                                <a href="<?php the_permalink(); ?>" class="view-product-btn"
                                                    title="View Product">
                                                    <img src="https://draftsite1.com/ace-vet-care/wp-content/uploads/2025/07/icon-view.svg"
                                                        alt="" class="mb-0">
                                                </a>
                                                <a href="javascript:void(0)" data-bs-toggle="modal"
                                                    data-bs-target="#exampleModal<?php echo get_the_ID(); ?>"
                                                    data-product-title="<?php echo esc_attr(get_the_title()); ?>">
                                                    <img src="https://draftsite1.com/ace-vet-care/wp-content/uploads/2025/08/info.png"
                                                        alt="" class="mb-0">
                                                </a>
                                            </div>
                                        </div>

                                        <h6 class="product-name"> <?php the_title(); ?></h6>

                                        <p class="price"> Price Upon Enquiry </p>
                                    </div>
                                </div>
                            </div>


                            <!-- Modal for this product -->
                            <div class="modal-product-enquiry modal" id="exampleModal<?php echo get_the_ID(); ?>" tabindex="-1"
                                aria-labelledby="exampleModalLabel<?php echo get_the_ID(); ?>" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered modal-lg">
                                    <div class="modal-content rounded-0 p-0">
                                        <div class="modal-header p-0 border-0">
                                            <!-- <h1 class="modal-title fs-5" id="exampleModalLabel<?php // echo get_the_ID(); ?>">
                                                    <?php // the_title(); ?>
                                                </h1> -->
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body p-0">
                                            <!-- <input type="hidden" id="cf7_product_title" name="product_title"> -->
                                            <?php echo do_shortcode('[hfe_template id="822"]'); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php
                        endwhile; ?>

                        <?php if ($query->max_num_pages > 1): ?>
                            <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                                <div class="pagination-style-one">
                                    <?php
                                    echo paginate_links(array(
                                        'total' => $query->max_num_pages,
                                        'current' => max(1, get_query_var('paged')),
                                        'format' => '?paged=%#%',
                                        'show_all' => false,
                                        'type' => 'plain',
                                        'prev_text' => '<i class="eicon-chevron-left"></i>',
                                        'next_text' => '<i class="eicon-chevron-right"></i>',
                                        'end_size' => 2,
                                        'mid_size' => 2
                                    ));
                                    ?>
                                </div>
                            </div>
                        <?php endif; ?>



                    <?php else:
                        echo '<p>' . esc_html__('No Products Found', 'textdomain') . '</p>';
                    endif;

                    wp_reset_postdata();
                    ?>

                </div>

            </div>

    </main>
</div>



<?php get_footer(); ?>