<?php get_header(); ?>


<div class="single-eproduct-detail pt-md-4 pt-4">

    <?php
    global $post;
    $post_id = get_the_ID();
    while (have_posts()):
        the_post(); ?>
        <div class="pb-md-5 pb-4">
            <div class="container">
                <div class="row">

                    <div class="col-12 pb-2 mb-2">
                        <?php function custom_breadcrumbs()
                        {
                            if (!is_single()) {
                                return;
                            }

                            global $post;

                            $breadcrumbs = '<nav aria-label="breadcrumb"><ol class="breadcrumb">';
                            $breadcrumbs .= '<li class="breadcrumb-item"><a href="' . home_url() . '">Home</a></li>';
                            $breadcrumbs .= '<li class="breadcrumb-item"><a href="' . get_permalink(get_page_by_path('Products')) . '">Products</a></li>';
                            $breadcrumbs .= '<li class="breadcrumb-item active" aria-current="page">' . get_the_title() . '</li>';
                            $breadcrumbs .= '</ol></nav>';

                            echo $breadcrumbs;
                        } ?>


                        <?php custom_breadcrumbs(); ?>
                    </div>
                    <!-- Product Images -->
                    <div class="col-lg-6">

                        <?php
                        // Collect thumbnails
                        $thumbnails = [];

                        if (has_post_thumbnail()) {
                            $thumbnail_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
                            $thumbnails[] = $thumbnail_url;
                        }

                        // Get gallery field (assuming SCF/ACF field name is 'gallery')
                        $gallery = get_field('gallery');

                        $gallery_images = [
                            $gallery['first'] ?? null,
                            $gallery['second'] ?? null,
                            $gallery['third'] ?? null,
                            $gallery['fourth'] ?? null
                        ];

                        foreach ($gallery_images as $image) {
                            if (!empty($image['url'])) {
                                $thumbnails[] = $image['url'];
                            }
                        }
                        ?>

                        <?php if (!empty($thumbnails)): ?>
                            <div class="product-details-gallery d-md-flex row">
                                <!-- Thumbnail Slider -->
                                <div class="thumbnail-slider col-12 order-md-1 order-2">
                                    <?php foreach ($thumbnails as $thumb): ?>
                                        <div>
                                            <img src="<?php echo esc_url($thumb); ?>" alt="Thumb" />
                                        </div>
                                    <?php endforeach; ?>
                                </div>

                                <!-- Main Slider -->
                                <div class="product-slider ps-lg-2 col-12 order-md-2 order-1">
                                    <?php foreach ($thumbnails as $main_img): ?>
                                        <div>
                                            <img src="<?php echo esc_url($main_img); ?>" alt="Product Image" />
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        <?php endif; ?>




                    </div>

                    <!-- Product Details -->
                    <div class="col-lg-6 ps-lg-4">
                        <div class="product_details ps-lg-4">

                            <?php
                            $pets = get_the_terms(get_the_ID(), 'pets');

                            if ($pets && !is_wp_error($pets)) {
                                echo '<div class="product-pets mb-2">';
                                $pets_list = wp_list_pluck($pets, 'name');
                                echo implode(', ', $pets_list);
                                echo '</div>';
                            }
                            ?>



                            <h4 class="title mt-0"> <?php the_title(); ?> </h4>

                            <p class="price"> Price Upon Enquiry </p>

                            <div class="mb-5">
                                <?php the_content(); ?>
                            </div>

                            <div class="prescription mb-4">
                                <label for="prescription">
                                    <h3> THIS ITEM REQUIRES A PRESCRIPTION </h3>
                                    <p class="para"> Orders will be cancelled if no prescription is attached. </p>
                                    <input type="file" name="prescription-file" id="prescription">
                                    <span class="upload"> Choose File/Image </span>
                                    <p class="sub"> Prescription Document and/or Previous Label</p>
                                </label>
                            </div>



                            <button class="elementor-button" href="javascript:void(0)" data-bs-toggle="modal"
                                data-bs-target="#exampleModal<?php echo get_the_ID(); ?>"
                                data-product-title="<?php echo esc_attr(get_the_title()); ?>" id="EnquireNow"
                                onclick="addToQuote(<?php echo $post_id; ?>)">
                                <span> Enquire Now
                                </span>
                            </button>
                        </div>
                    </div>

                    <!-- Modal for this product -->
                    <div class="modal-product-enquiry modal" id="exampleModal<?php echo get_the_ID(); ?>" tabindex="-1"
                        aria-labelledby="exampleModalLabel<?php echo get_the_ID(); ?>" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg">
                            <div class="modal-content rounded-0 p-0">
                                <div class="modal-header p-0 border-0">
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body p-0">
                                    <?php echo do_shortcode('[hfe_template id="822"]'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    endwhile;
    ?>



    <?php
    $products_details = get_field('products_details');
    $nutritional_information = get_field('nutritional_information');

    if (!empty($products_details) || !empty($nutritional_information)): ?>
        <div class="prodcut-more-info">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <ul class="nav nav-tabs" role="tablist">
                            <?php if (!empty($products_details)): ?>
                                <li class="nav-item">
                                    <a class="nav-link active" data-bs-toggle="tab" href="#home">PRODUCTS DETAILS</a>
                                </li>
                            <?php endif; ?>
                            <?php if (!empty($nutritional_information)): ?>
                                <li class="nav-item">
                                    <a class="nav-link <?php echo empty($products_details) ? 'active' : ''; ?>"
                                        data-bs-toggle="tab" href="#menu1">NUTRITIONAL INFORMATION</a>
                                </li>
                            <?php endif; ?>
                        </ul>

                        <div class="tab-content">
                            <?php if (!empty($products_details)): ?>
                                <div id="home" class="container tab-pane active">
                                    <?php echo wp_kses_post($products_details); ?>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($nutritional_information)): ?>
                                <div id="menu1"
                                    class="container tab-pane <?php echo empty($products_details) ? 'active' : 'fade'; ?>">
                                    <?php echo wp_kses_post($nutritional_information); ?>
                                </div>
                            <?php endif; ?>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>










    <div class="related-products">
        <div class="container">
            <?php
            $post_id = get_the_ID();
            $terms = get_the_terms($post_id, 'controlled-products-category');

            if ($terms && !is_wp_error($terms)) {
                $category_id = $terms[0]->term_id;

                $args = array(
                    'post_type' => 'controlled-products',
                    'posts_per_page' => 5,
                    'post__not_in' => array($post_id),
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'controlled-products-category',
                            'field' => 'term_id',
                            'terms' => $category_id,
                        ),
                    ),
                    'orderby' => 'rand',
                );

                $related_posts_query = new WP_Query($args);


                if ($related_posts_query->have_posts()) {
                    ?>
                    <h2 class="page-title mb-5 pb-0"> You May Like These, Too </h2>
                    <div class="related-product-slider ">
                        <?php

                        while ($related_posts_query->have_posts()) {
                            $related_posts_query->the_post();
                            ?>

                            <div class="p-2" id="post-<?php the_ID(); ?>">
                                <div <?php post_class(); ?>>
                                    <div class="product-card">
                                        <div class="product-wrap">
                                            <div class="img-box">
                                                <?php if (has_post_thumbnail()): ?>
                                                    <?php the_post_thumbnail('full'); ?>
                                                <?php endif; ?>
                                            </div>
                                            <div class="custom-hover-buttons">
                                                <a href="<?php the_permalink(); ?>" class="view-product-btn" title="View Product">
                                                    <img src="https://draftsite1.com/ace-vet-care/wp-content/uploads/2025/07/icon-view.svg"
                                                        alt="" class="mb-0">
                                                </a>
                                                <a href="javascript:void(0)" data-bs-toggle="modal"
                                                    data-bs-target="#exampleModal<?php echo get_the_ID(); ?>"
                                                    data-product-title="<?php echo esc_attr(get_the_title()); ?>">
                                                    <img src="https://draftsite1.com/ace-vet-care/wp-content/uploads/2025/08/info.png"
                                                        alt="" class="mb-0">
                                                </a>
                                            </div>
                                        </div>

                                        <h6 class="product-name"> <?php the_title(); ?></h6>

                                        <p class="price"> Price Upon Enquiry </p>
                                    </div>
                                </div>
                            </div>




                        <?php } ?>
                    </div>
                    <?php

                    while ($related_posts_query->have_posts()) {
                        $related_posts_query->the_post();
                        ?>
                        <div class="modal-product-enquiry modal" id="exampleModal<?php echo get_the_ID(); ?>" tabindex="-1"
                            aria-labelledby="exampleModalLabel<?php echo get_the_ID(); ?>" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered modal-lg">
                                <div class="modal-content rounded-0 p-0">
                                    <div class="modal-header p-0 border-0">
                                        <!-- <h1 class="modal-title fs-5" id="exampleModalLabel<?php // echo get_the_ID(); ?>">
                                                    <?php // the_title(); ?>
                                                </h1> -->
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body p-0">
                                        <!-- <input type="hidden" id="cf7_product_title" name="product_title"> -->
                                        <?php echo do_shortcode('[hfe_template id="822"]'); ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                    <?php } ?>
                    <?php


                    // Restore original post data
                    wp_reset_postdata();
                }
            }
            ?>
        </div>
    </div>

    <script>
        jQuery(document).ready(function ($) {
            $('.product-slider').slick({
                slidesToShow: 1,
                slidesToScroll: 1,
                arrows: false,
                fade: true,
                asNavFor: '.thumbnail-slider'
            });

            $('.thumbnail-slider').slick({
                slidesToShow: 5,
                slidesToScroll: 1,
                asNavFor: '.product-slider',
                dots: false,
                arrows: false,
                infinite: false,
                centerMode: false,
                focusOnSelect: true,
                vertical: true,
                verticalSwiping: true
            });
            $('.related-product-slider').slick({
                dots: true,
                arrows: false,
                infinite: true,
                autoplay: false,
                speed: 300,
                slidesToShow: 4,
                slidesToScroll: 1,
                adaptiveHeight: true,
                prevArrow: '<div class="left-btn arrowbtn"><i class="fa fa-angle-left"></i> </div>',
                nextArrow: '<div class="right-btn arrowbtn"><i class="fa fa-angle-right"></i></div>',
                responsive: [{
                    breakpoint: 1200,
                    settings: {
                        slidesToShow: 4,
                        slidesToScroll: 1,
                    },
                },
                {
                    breakpoint: 1008,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 1,
                    },
                },
                {
                    breakpoint: 800,
                    settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1,
                    },
                },
                ],
            });
        });
    </script>


    <script>
        function increaseQuantity() {
            var quantityInput = document.getElementById('quantity');
            var currentValue = parseInt(quantityInput.value);
            quantityInput.value = currentValue + 1;
        }

        function decreaseQuantity() {
            var quantityInput = document.getElementById('quantity');
            var currentValue = parseInt(quantityInput.value);
            if (currentValue > 1) { // Prevent decreasing below 1
                quantityInput.value = currentValue - 1;
            }
        }

        function addToQuote(postId) {
            var quantity = document.getElementById('quantity').value;

            // Use AJAX to send data to the server
            var xhr = new XMLHttpRequest();
            xhr.open('POST', '<?php echo admin_url('admin-ajax.php'); ?>', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    // Redirect to the quote page after adding the item to the quote
                    window.location.href = 'http://localhost:8888/wp/t2960/product-enquiry-cart/';
                }
            };
            xhr.send('action=add_to_quote&post_id=' + postId + '&quantity=' + quantity);
        }
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const fileInputOutside = document.getElementById('prescription');

            document.querySelectorAll('[data-bs-toggle="modal"]').forEach(button => {
                button.addEventListener('click', function () {
                    const modalID = this.getAttribute('data-bs-target');

                    setTimeout(() => {
                        const modal = document.querySelector(modalID);
                        if (!modal) return;

                        // Find the hidden real file input inside the drag-drop plugin
                        const dropzoneInput = modal.querySelector('.wpcf7 input[type="file"][name="prescription-file[]"]');

                        if (fileInputOutside && fileInputOutside.files.length > 0 && dropzoneInput) {
                            const file = fileInputOutside.files[0];
                            const dt = new DataTransfer();
                            dt.items.add(file);
                            dropzoneInput.files = dt.files;

                            // Optional: Show file name in drag-drop UI (if plugin supports it)
                            const dropzonePreview = modal.querySelector('.wpcf7 .cf7mls-upload-name');
                            if (dropzonePreview) {
                                dropzonePreview.innerText = file.name;
                            }
                        }
                    }, 500); // Delay allows modal content to render
                });
            });
        });
    </script>




</div>


<?php get_footer(); ?>