<?php get_header(); ?>


<div class="article-detail pb-0 pt-0">

    <div class="container-fluid p-0">
        <?php
        if (have_posts()):
            while (have_posts()):
                the_post();
                ?>

                <div class="row justify-content-start m-0">
                    <div class="col-lg-6 col-md-6 ps-0 pe-lg-5 service-image-outer">
                        <img src="https://draftsite1.com/ace-vet-care/wp-content/uploads/2025/07/service-1.jpg"
                            alt="service img" class="w-100">
                    </div>
                    <div class="col-lg-5 col-md-6">
                        <div class="service-details">
                            <div class="row align-items-center">
                                <div class="col-8">
                                    <h6><img src="https://draftsite1.com/ace-vet-care/wp-content/uploads/2025/07/icon-paw.svg"
                                            alt="" class="me-2"> SERVICES</h6>
                                    <h1><?php echo get_the_title(); ?></h1>
                                </div>
                                <div class="col-4 text-end">
                                    <img src="https://draftsite1.com/ace-vet-care/wp-content/uploads/2025/07/icon-consultation-circle.svg"
                                        alt="" width="60">
                                </div>
                                <div class="col-12 pt-4">
                                    <p> <?php the_content(); ?> </p>

                                    <?php
                                    $description_items = get_field('description_area');

                                    if (!empty($description_items)):
                                        ?>
                                        <div class="accordion mt-5" id="accordionExample">
                                            <?php foreach ($description_items as $index => $item): ?>
                                                <?php
                                                $unique_id = 'collapse' . $index;
                                                $title = isset($item['title']) ? $item['title'] : '';
                                                $description = isset($item['description']) ? $item['description'] : '';
                                                $is_first = ($index === 0);
                                                ?>
                                                <div class="accordion-item">
                                                    <h2 class="accordion-header m-0">
                                                        <button class="accordion-button <?php echo $is_first ? '' : 'collapsed'; ?>"
                                                            type="button" data-bs-toggle="collapse"
                                                            data-bs-target="#<?php echo esc_attr($unique_id); ?>"
                                                            aria-expanded="<?php echo $is_first ? 'true' : 'false'; ?>"
                                                            aria-controls="<?php echo esc_attr($unique_id); ?>">
                                                            <?php echo esc_html($title); ?>
                                                        </button>
                                                    </h2>
                                                    <div id="<?php echo esc_attr($unique_id); ?>"
                                                        class="accordion-collapse collapse <?php echo $is_first ? 'show' : ''; ?>"
                                                        data-bs-parent="#accordionExample">
                                                        <div class="accordion-body">
                                                            <?php echo wp_kses_post($description); ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    <?php endif; ?>


                                    <div class="d-flex align-items-center justify-content-between action-btn pt-5">
                                        <a href="<?php echo get_permalink(get_page_by_path('contact-us')); ?>"
                                            class="elementor-button">Book An Appointment</a>
                                        <a href="<?php echo get_permalink(get_page_by_path('services')); ?>"
                                            class="other-link">Other Services <i class="fa fa-arrow-right"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php
            endwhile;
        else:
            echo 'No post found.';
        endif;
        ?>




    </div>
</div>




<?php get_footer(); ?>