<?php get_header(); ?>


<div class="article-detail pt-0 ">

    <div class="container">

        <div class="row">
            <div class="col-md-12">
                <?php

                function custom_breadcrumbs()
                {
                    global $post;

                    $breadcrumbs = '<div class="breadcrumbs-article py-3 py-lg-5">';

                    $breadcrumbs .= '<a href="' . home_url() . '">Home /</a>  ';

                    $breadcrumbs .= '<a href="' . get_permalink(get_page_by_path('blog')) . '">blog /</a>  ';

                    if (is_single()) {
                        $breadcrumbs .= get_the_title();
                    }

                    $breadcrumbs .= '</div>';

                    echo $breadcrumbs;
                }

                ?>

                <?php custom_breadcrumbs(); ?>
            </div>
        </div>


        <div class="row g-md-5 g-3 justify-content-center">
            <div class="col-lg-9 col-md-9">
                <?php
                if (have_posts()):
                    while (have_posts()):
                        the_post();
                        ?>
                        <div class="content-area">
                            <div class="">
                                <div class="topwrap">
                                    <?php
                                    $terms = get_the_terms(get_the_ID(), 'category');
                                    if ($terms && !is_wp_error($terms)) { ?>
                                        <?php
                                        foreach ($terms as $term) {
                                            $category_name = strtolower($term->name); ?>
                                            <h6 class="blog-category text-uppercase pb-2" ><img src="https://draftsite1.com/ace-vet-care/wp-content/uploads/2025/07/icon-paw.svg" alt="" class="me-2"> <?php echo $category_name; ?></h6>

                                                <?php
                                        } ?>
                                        <?php }
                                    ?>
                                    <h1 class="pb-2 details-title"><?php echo get_the_title(); ?></h1>

                                    <div class="date mb-5"> Posted on <?php echo get_the_date('j F Y'); ?></div>

                                </div>
                                <div class="blog-image-wrapper mb-5">
                                    <a href="<?php the_permalink(); ?>">
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                        } ?>
                                    </a>

                                </div>
                                <div class="blog-content">
                                    <div>
                                        <?php the_content(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php
                    endwhile;
                else:
                    echo 'No post found.';
                endif;
                ?>
            </div>
            <div class="col-lg-12">
                <hr class="sidebar-divider" />
            </div>

        </div>

        <div class="row">
            <div class="col-lg-12">
                <?php
                $related_posts = get_related_articles(get_the_ID(), 5);

                if (!empty($related_posts)): ?>
                    <div class="related-articles">
                        <div class="text-center py-4">
                            <h1>Other Articles</h1>
                        </div>

                        <div class="related-blog-slider">
                            <?php foreach ($related_posts as $post):
                                setup_postdata($post); ?>
                                <div class="item ps-2 pe-2">
                                    <div class="blog-post-card mb-4">
                                        <div class="blog-image-wrapper">
                                            <a href="<?php the_permalink(); ?>">
                                                <?php if (has_post_thumbnail()) {
                                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                                } ?>
                                            </a>


                                        </div>

                                        <div class="blog-content mt-3">
                                            <?php
                                            $terms = get_the_terms(get_the_ID(), 'category');
                                            if ($terms && !is_wp_error($terms)) {
                                                foreach ($terms as $term) { ?>
                                                    <p class="blog-category"><?php echo esc_html(strtolower($term->name)); ?></p>
                                                <?php }
                                            } ?>
                                            <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>

                <?php
                wp_reset_postdata();
                endif;
                ?>
        </div>
    </div>
</div>




<?php get_footer(); ?>
