<?php
defined('ABSPATH') || exit;

get_header('shop');
?>
<div class="shop-page">


    <div class="custom-shop-header">
        <div class="container">
            <div class="row g-md-3 align-items-center">
                <div class="col-md-12">
                    <div class="banner-title">
                        <?php if (is_product_category()) {
                            $category = get_queried_object();
                            if ($category) { ?>
                                <?php echo '<h1>' . esc_html($category->name) . '</h1>'; ?>
                                <?php
                            }
                        } else { ?>
                            <?php echo '<h1>Shop </h1>' ?>
                        <?php }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <div class="shop-inner-section">

        <div class="container">


            <div class="row g-md-5 g-3">
                <div class="col-md-3">
                    <div class="fiter_shop">
                        <h2> Product Categories </h2>
                        <?php echo do_shortcode('[product_categories_accordion]'); ?>

                    </div>
                </div>
                <div class="col-md-9">
                    <div class="custom-product-grid" id="products">
                        <?php if (woocommerce_product_loop()): ?>
                            <?php
                            do_action('woocommerce_before_shop_loop');
                            woocommerce_product_loop_start();
                            if (wc_get_loop_prop('total')) {
                                while (have_posts()) {
                                    the_post();
                                    do_action('woocommerce_shop_loop');
                                    wc_get_template_part('content', 'product');
                                }
                            }
                            woocommerce_product_loop_end();
                            do_action('woocommerce_after_shop_loop');
                            ?>
                        <?php else: ?>
                            <?php do_action('woocommerce_no_products_found'); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
<div class="comman-section-shop">
    <?php echo do_shortcode('[hfe_template id="265"]'); ?>
</div>





<?php
do_action('woocommerce_after_main_content');

get_footer('shop'); ?>


<style>
    .woocommerce-page .content-area {
        display: none;
    }
</style>