<?php
// Enqueue the parent theme's stylesheet

function hello_elementor_child_enqueue_styles()
{
    wp_enqueue_style('hello-elementor-parent-style', get_template_directory_uri() . '/../hello-elementor-child/style.css');
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles');


// Enqueue Booststrap 
function enqueue_bootstrap()
{
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');

//  Slick carousel script and styles
function enqueue_slick_scripts()
{
    //  Slick carousel script
    wp_enqueue_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js', array('jquery'), null, true);
    //  Slick carousel CSS
    wp_enqueue_style('slick-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_slick_scripts');

// custom code






// Home slider Start --------------------------------------------
function display_banner_home($atts)
{
    $args = array(
        'post_type' => 'main-slider',
    );

    $mainslider_query = new WP_Query($args);

    ob_start();

    if ($mainslider_query->have_posts()):
        $total_slides = $mainslider_query->post_count;
        ?>
        <div id="demo" class="carousel slide hero-banner" data-bs-ride="carousel">
            <div class="carousel-inner">
                <?php
                $first = true;
                while ($mainslider_query->have_posts()):
                    $mainslider_query->the_post(); ?>

                    <div class="carousel-item <?php echo $first ? 'active' : ''; ?>">
                        <?php if (has_post_thumbnail()) {
                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                        } ?>
                        <div class="carousel-caption">
                            <h3><?php the_title(); ?></h3>
                            <div> <?php the_content(); ?> </div>
                            <div class="btnlight">
                                <?php
                                $links = get_field('button_link');
                                if ($links) {
                                    $link_url = $links['url'];
                                    $link_title = $links['title'];
                                    ?>
                                    <a href="<?php echo esc_url($link_url); ?>"
                                        class="elementor-button"><?php echo esc_html($link_title); ?></a>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <?php
                    $first = false;
                endwhile; ?>
            </div>

            <!-- Indicators/dots -->
            <?php if ($total_slides > 1): ?>
                <div class="carousel-indicators">
                    <?php for ($i = 0; $i < $total_slides; $i++): ?>
                        <button type="button" data-bs-target="#demo" data-bs-slide-to="<?php echo $i; ?>"
                            class="<?php echo $i === 0 ? 'active' : ''; ?>">
                            <?php //echo str_pad($i + 1, 2, '0', STR_PAD_LEFT); ?>
                        </button>
                    <?php endfor; ?>
                </div>
            <?php endif; ?>

            <?php /* if ($total_slides > 1): ?>
                                                             <span class="carousel-control-prev" data-bs-target="#demo" data-bs-slide="prev">
                                                                <
                                                             </span>
                                                             <span class="carousel-control-next" data-bs-target="#demo" data-bs-slide="next">
                                                               >
                                                             </span>
                                                         <?php endif; */ ?>


        </div>

    <?php else: ?>
        <div>No Slider found.</div>
    <?php endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('banner_home', 'display_banner_home');


// Home slider end --------------------------------------------




// article page start -----------------

function display_article($atts)
{

    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
        ),
        $atts,
        'article_list_view'
    );


    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    $selected_category = isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '';

    // Query arguments
    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => $paged,
        'orderby' => 'date',

    );


    if (!empty($selected_category)) {
        $args['category_name'] = $selected_category;
    }

    $article_query = new WP_Query($args);

    ob_start();


    if ($article_query->have_posts()):
        ?>
        <div class="our-article">
            <div class="row-article">

                <?php while ($article_query->have_posts()):
                    $article_query->the_post(); ?>
                    <div class="col-article">
                        <div class="project-box">
                            <div class="img-box mb-3">
                                <div class="item">
                                    <a href="<?php the_permalink(); ?>" class="d-block">
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                        } ?>
                                    </a>
                                </div>

                            </div>
                            <div class="text-box">
                                <h2 class="font2"><?php echo the_title(); ?></h2>
                                <p class="text-content"> <?php echo get_the_excerpt(); ?></p>

                                <a href="<?php the_permalink(); ?>" class="read-more">Read More </a>
                            </div>
                        </div>
                    </div>

                <?php endwhile; ?>
            </div>


            <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                <div class="pagination-two">
                    <?php
                    echo paginate_links(array(
                        'total' => $article_query->max_num_pages,
                        'current' => $paged,
                        'format' => '?paged=%#%',
                        'add_args' => array('category' => $selected_category), // Retain category filter in pagination
                        'show_all' => false,
                        'type' => 'plain',
                        'prev_text' => __(' « '),
                        'next_text' => __(' »'),
                        'end_size' => 2,
                        'mid_size' => 2
                    ));
                    ?>
                </div>
            </div>

        </div>
        </div>
    <?php else:
        echo 'No Article found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('article_list_view', 'display_article');

// article end ----------------------------------------



// Testimonial page start ------------------------------------------------------------

function display_testimonials($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
        ),
        $atts,
        'testimonials'
    );

    // Get the current page
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    $selected_category = isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '';



    $args = array(
        'post_type' => 'testimonials',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => $paged,
    );


    if (!empty($selected_category)) {
        $args['category_name'] = $selected_category;
    }

    $testimonials_query = new WP_Query($args);

    ob_start();

    if ($testimonials_query->have_posts()): ?>
        <div class="testimonial-page mt-3 testimonials-main">
            <div class="row g-md-5 g-3" id="testimonials-container">
                <?php while ($testimonials_query->have_posts()):
                    $testimonials_query->the_post();
                    ?>
                    <div class="col-md-6">
                        <div class="testimonials-list-wrap">

                            <div class="testimonial-body">
                                <div class="description mb-2">
                                    <?php echo the_content(); ?>
                                </div>
                            </div>
                            <div class="testimonial-head d-flex align-items-center mb-4">
                                <div class="client-img">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                    } ?>
                                </div>
                                <p class="mb-0 user-name"><?php echo get_the_title(); ?> </p>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>

            <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                <div class="pagination-two">
                    <?php
                    echo paginate_links(array(
                        'total' => $testimonials_query->max_num_pages,
                        'current' => $paged,
                        'format' => '?paged=%#%',
                        'add_args' => array('category' => $selected_category), // Retain category filter in pagination
                        'show_all' => false,
                        'type' => 'plain',
                        'prev_text' => __(' « '),
                        'next_text' => __(' »'),
                        'end_size' => 2,
                        'mid_size' => 2
                    ));
                    ?>
                </div>
            </div>


        </div>



    <?php else:
        echo 'No testimonials found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('testimonials', 'display_testimonials');


// Testimonial page end ------------------------------------------------------------






// promotion page start ------------------------------------------------------------

function display_promotions($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'promotions'
    );

    // Get the current page


    $args = array(
        'post_type' => 'promotions',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );


    // Filter by category if provided
    if (!empty($atts['category'])) {
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'promotion-category',
                'field' => 'slug',
                'terms' => $atts['category'],
            ),
        );
    }
    // Get categories
    $categories = get_terms(array(
        'taxonomy' => 'promotion-category',
        'hide_empty' => true,
    ));

    ob_start();

    if ($categories):
        ?>
        <ul id="category-filter-list" class="mb-5">
            <li><a href="<?php echo esc_url(add_query_arg('category', '', home_url('/promotions'))); ?>"
                    class="all-cat-head active"> All </a></li>
            <?php foreach ($categories as $category):
                $active_class = ($atts['category'] === $category->slug) ? 'active' : '';
                ?>
                <li>
                    <a href="<?php echo esc_url(add_query_arg('category', $category->slug, home_url('/promotions'))); ?>"
                        class="cats <?php echo esc_attr($active_class); ?>">
                        <?php echo esc_html($category->name); ?>
                    </a>
                </li>
            <?php endforeach; ?>
        </ul>
        <?php
    endif;




    $promotions_query = new WP_Query($args);



    if ($promotions_query->have_posts()): ?>
        <div class="promotion-page promotions-main">
            <div class="row g-md-4 g-3">
                <?php while ($promotions_query->have_posts()):
                    $promotions_query->the_post();
                    ?>
                    <div class="col-md-4">
                        <div class="promotion-box">
                            <a href="<?php the_permalink(); ?>" class="promotion-img">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                } ?>
                            </a>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
        </div>

        <script type="text/javascript">
            document.addEventListener('DOMContentLoaded', function () {
                var listItems = document.querySelectorAll('#category-filter-list a');
                listItems.forEach(function (item) {
                    item.addEventListener('click', function (event) {
                        // No need to prevent default here; the link's href handles the filtering
                    });
                });
            });
        </script>

        <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
            <div class="pagination-two d-inline-block">
                <?php
                echo paginate_links(
                    array(
                        'total' => $promotions_query->max_num_pages,
                        'current' => max(1, get_query_var('paged')),
                        'format' => '?paged=%#%',
                        'show_all' => false,
                        'type' => 'plain',
                        'prev_text' => __(' « '),
                        'next_text' => __(' »'),
                        'end_size' => 2,
                        'mid_size' => 2
                    )
                );
                ?>
            </div>
        </div>

    <?php else:
        echo 'No promotions found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('promotions_list', 'display_promotions');


// promotion page End ------------------------------------------------------------



// related promotion  start ------------------------------------------------------------
function display_related_promotions($post_id)
{
    $args = array(
        'post_type' => 'promotions',
        'posts_per_page' => 3,
        'post__not_in' => array($post_id),
        'orderby' => 'rand',
    );

    $related_query = new WP_Query($args);

    ob_start();

    if ($related_query->have_posts()): ?>
        <div class="row g-md-4 g-3">
            <?php while ($related_query->have_posts()):
                $related_query->the_post(); ?>
                <div class="col-md-4">
                    <div class="promotion-box">
                        <a href="<?php the_permalink(); ?>" class="promotion-img">
                            <?php if (has_post_thumbnail()) {
                                the_post_thumbnail('full', array('class' => 'd-block w-100'));
                            } ?>
                        </a>
                    </div>
                </div>
            <?php endwhile; ?>
        </div>

    <?php else:
        echo 'No related promotions found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}



// related promotion  end ------------------------------------------------------------







// product-categories start ----------------------------------------- 
function wpb_woocommerce_product_categories_accordion()
{
    // Get the current queried product category
    $queried_object = get_queried_object();
    $current_category_id = ($queried_object && isset($queried_object->term_id)) ? $queried_object->term_id : 0;

    // Get all parent categories of the current category
    $current_category_parents = [];
    if ($current_category_id) {
        $parent_categories = get_ancestors($current_category_id, 'product_cat');
        $current_category_parents = array_map('intval', $parent_categories);
    }

    // Recursive function to get subcategories with checkboxes
    function get_subcategories($parent_id, $level = 1, $current_category_id, $current_category_parents)
    {
        $args = array(
            'taxonomy' => 'product_cat',
            'orderby' => 'name',
            'order' => 'ASC',
            'parent' => $parent_id,
            'hide_empty' => true
        );
        $sub_categories = get_terms($args);

        if (!empty($sub_categories)) {
            echo '<ul class="list-unstyled ps-2">';
            foreach ($sub_categories as $sub_category) {
                $is_checked = ($sub_category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($sub_category->term_id == $current_category_id) ? 'current-category' : '';

                echo '<li class="' . $active_class . '">';
                echo '<div class="in-menu">';
                echo '<input type="checkbox" class="category-checkbox me-2" data-category-id="' . $sub_category->term_id . '" ' . $is_checked . '> ';

                echo '<a href="' . get_term_link($sub_category) . '">  <span class="customcheck"></span>' . $sub_category->name . '</a>';
                echo '</div>';
                get_subcategories($sub_category->term_id, $level + 1, $current_category_id, $current_category_parents);
                echo '</li>';
            }
            echo '</ul>';
        }
    }

    // Get main product categories (parent categories)
    $args = array(
        'taxonomy' => 'product_cat',
        'orderby' => 'name',
        'order' => 'ASC',
        'parent' => 0,
        'hide_empty' => true
    );
    $product_categories = get_terms($args);

    if ($product_categories) {
        ob_start();
        ?>
        <div class="accordion" id="productCategoriesAccordion">

            <?php
            $shop_page_url = wc_get_page_permalink('shop');
            $is_shop_page = is_shop();
            ?>

            <!-- <div class="accordion-item">
                    <div class="accordion-header <?php //echo $is_shop_page ? 'current-category' : ''; ?>">
                        <label>
                            <a href="<?php // echo esc_url($shop_page_url); ?>" class="main-category">
                                All Product
                            </a>
                        </label>
                    </div>
                </div> -->


            <?php
            $i = 0;
            foreach ($product_categories as $category) {
                $i++;

                // Check if the category has subcategories
                $sub_args = array(
                    'taxonomy' => 'product_cat',
                    'parent' => $category->term_id,
                    'hide_empty' => true
                );
                $sub_categories = get_terms($sub_args);
                $has_subcategories = !empty($sub_categories);

                // Determine if this category should be expanded
                $is_checked = ($category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'current-category' : '';
                $show_collapse = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'show' : '';
                ?>
                <div class="accordion-item <?php echo $active_class; ?>">
                    <div class="accordion-header d-flex align-items-center" id="heading<?php echo $i; ?>">
                        <label for="cat<?php echo $category->term_id; ?>">
                            <input type="checkbox" class="category-checkbox me-2" id="cat<?php echo $category->term_id; ?>"
                                data-category-id="<?php echo $category->term_id; ?>" <?php echo $is_checked; ?>>

                            <a href="<?php echo get_term_link($category); ?>" class="main-category">
                                <span class="customcheck"></span>
                                <?php echo $category->name . ' <span class="count">(' . $category->count . ')</span>'; ?>
                            </a>
                        </label>

                        <?php if ($has_subcategories) { ?>
                            <button class="accordion-button ms-auto <?php echo ($show_collapse == '') ? 'collapsed' : ''; ?>"
                                type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>"
                                aria-expanded="<?php echo ($show_collapse) ? 'true' : 'false'; ?>"
                                aria-controls="collapse<?php echo $i; ?>" data-category-id="<?php echo $category->term_id; ?>">
                                <i class="fa fa-angle-down"></i>
                            </button>
                        <?php } ?>
                    </div>
                    <?php if ($has_subcategories) { ?>
                        <div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse <?php echo $show_collapse; ?>"
                            aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#productCategoriesAccordion">
                            <div class="accordion-body ps-0 pe-0">
                                <?php get_subcategories($category->term_id, 1, $current_category_id, $current_category_parents); ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
                <?php
            }
            ?>
        </div>

        <script>
            document.addEventListener("DOMContentLoaded", function () {
                var savedCategories = JSON.parse(localStorage.getItem("checkedCategories")) || [];

                savedCategories.forEach(function (categoryId) {
                    var checkbox = document.querySelector('.category-checkbox[data-category-id="' + categoryId + '"]');
                    if (checkbox) {
                        checkbox.checked = true;
                    }
                });

                document.querySelectorAll(".category-checkbox").forEach(function (checkbox) {
                    checkbox.addEventListener("change", function () {
                        var categoryId = this.getAttribute("data-category-id");
                        if (this.checked) {
                            if (!savedCategories.includes(categoryId)) {
                                savedCategories.push(categoryId);
                            }
                        } else {
                            savedCategories = savedCategories.filter(id => id !== categoryId);
                        }
                        localStorage.setItem("checkedCategories", JSON.stringify(savedCategories));
                    });
                });

                var activeCategory = localStorage.getItem("activeCategory");
                if (activeCategory) {
                    var activeAccordion = document.querySelector('[data-category-id="' + activeCategory + '"]');
                    if (activeAccordion) {
                        var collapseElement = activeAccordion.getAttribute("data-bs-target");
                        document.querySelector(collapseElement).classList.add("show");
                        activeAccordion.classList.remove("collapsed");
                        activeAccordion.setAttribute("aria-expanded", "true");
                    }
                }

                document.querySelectorAll(".accordion-button").forEach(function (button) {
                    button.addEventListener("click", function () {
                        var categoryId = this.getAttribute("data-category-id");
                        if (document.querySelector(this.getAttribute("data-bs-target")).classList.contains("show")) {
                            localStorage.removeItem("activeCategory");
                        } else {
                            localStorage.setItem("activeCategory", categoryId);
                        }
                    });
                });
            });
        </script>

        <style>
            .current-category>a {
                font-weight: bold;
                color: #ff6600;
            }

            .category-checkbox {
                display: none;
            }

            span.customcheck {
                background: #FFFFFF 0% 0% no-repeat padding-box;
                border: 1px solid #B7DBEE;
                border-radius: 5px;
                width: 15px;
                height: 15px;
                position: relative;
                margin-right: 6px;
                margin-top: 0px;
                top: 2px;
                display: none;
            }

            .current-category [type=checkbox]:checked~a span.customcheck {
                background: #326783;
                border-color: #326783;
            }

            .current-category [type=checkbox]~a .customcheck:after {
                content: "";
                position: absolute;
            }

            .current-category a input:checked~.customcheck:after {
                display: block;
            }

            .current-category a .customcheck:after {
                left: 5px;
                top: 2px;
                width: 4px;
                height: 8px;
                border: solid white;
                border-width: 0 2px 2px 0;
                -webkit-transform: rotate(45deg);
                -ms-transform: rotate(45deg);
                transform: rotate(45deg);
            }
        </style>
        <?php
        return ob_get_clean();
    }
}

add_shortcode('product_categories_accordion', 'wpb_woocommerce_product_categories_accordion');

// product category for sidebar end -------------------------------


// wpgis  product gallery ------------------
add_action('wp_footer', 'hide_gallery_thumbs_if_single_image');
function hide_gallery_thumbs_if_single_image()
{
    if (is_product()): ?>
        <script>
            jQuery(document).ready(function ($) {
                $(window).on('load', function () {
                    var thumbCount = $('.wpgis-slider-nav .slick-slide').length;

                    if (thumbCount <= 1) {
                        $('.wpgis-slider-nav').hide();
                        $('.wpgis-slider-for').addClass('full-width-slider');
                    } else {
                        $('.wpgis-slider-nav').show();
                        $('.wpgis-slider-for').removeClass('full-width-slider');
                    }
                });
            });
        </script>
    <?php endif;
}
// wpgis  product gallery end ------------------


// comman template add start ---------

add_action('woocommerce_after_single_product', 'add_custom_template_after_product', 15);
function add_custom_template_after_product()
{
    echo '<div class="comman-section-shop">';
    echo do_shortcode('[hfe_template id="265"]');
    echo '</div>';
}

// comman template add end ---------


// shop header add start ---------------------------

add_action('woocommerce_before_main_content', 'custom_shop_header', 5);
function custom_shop_header()
{
    if (is_product()) {
        ?>
        <div class="custom-shop-header">
            <div class="container">
                <div class="row g-md-3 align-items-center">
                    <div class="col-md-12">
                        <div class="banner-title">
                            <h1><?php the_title(); ?></h1>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}
// shop header add end ---------------------------








?>