<?php
// Enqueue the parent theme's stylesheet

function hello_elementor_child_enqueue_styles()
{
    wp_enqueue_style('hello-elementor-parent-style', get_template_directory_uri() . '/../hello-elementor-child/style.css');
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles');



// custom code

// Enqueue Booststrap 
function enqueue_bootstrap()
{
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');


//  Slick carousel script and styles
function enqueue_slick_scripts()
{
    //  Slick carousel script
    wp_enqueue_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js', array('jquery'), null, true);
    //  Slick carousel CSS
    wp_enqueue_style('slick-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_slick_scripts');

// Wrap WooCommerce product image in a div start ----------
add_action('woocommerce_before_shop_loop_item_title', 'wrap_product_image_in_div', 5);

function wrap_product_image_in_div()
{
    echo '<div class="custom-image-wrapper">';
}

add_action('woocommerce_before_shop_loop_item_title', 'close_product_image_div', 15);
function close_product_image_div()
{
    echo '</div>';
}
// Wrap WooCommerce product image in a div end ----------



// banner slider start
 

// Home slider Start --------------------------------------------
function display_banner_home($atts)
{
    $args = array(
        'post_type' => 'main-slider',
    );

    $mainslider_query = new WP_Query($args);

    ob_start();

    if ($mainslider_query->have_posts()):
        $total_slides = $mainslider_query->post_count;
        ?>
        <div class="banner-slider">
            <div id="carouselExampleCaptions" class="carousel slide" data-bs-ride="carousel">

                <div class="carousel-inner">
                    <?php
                    $first = true;
                    while ($mainslider_query->have_posts()):
                        $mainslider_query->the_post(); ?>

                        <div class="carousel-item <?php echo $first ? 'active' : ''; ?>">

                            <div class="row align-items-center justify-content-center">
                                <div class="col-lg-7 col-md-6 col-sm-8">
                                    <?php the_post_thumbnail(); ?>
                                </div>
                                <div class="col-lg-5 col-md-6">
                                    <div class="carousel-caption">
                                        <p class="banner-sub-title"><?php the_title(); ?></p>
                                        <h2 class="banner-title"> <?php the_content(); ?></h2>
                                        <div class="mt-5">


                                            <?php
                                            $links = get_field('button_link');
                                            if ($links) {
                                                $link_url = $links['url'];
                                                $link_title = $links['title'];
                                                ?>
                                                <a href="<?php echo esc_url($link_url); ?>"
                                                    class="btn-primary"><?php echo esc_html($link_title); ?></a>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php
                        $first = false;
                    endwhile; ?>
                </div>
                <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleCaptions"
                    data-bs-slide="prev">
                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Previous</span>
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleCaptions"
                    data-bs-slide="next">
                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Next</span>
                </button>

            </div>
        </div>

    <?php else: ?>
        <!-- <div>No Slider found.</div> -->
    <?php endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('banner_home', 'display_banner_home');


// Home slider end --------------------------------------------



// promotion page start ------------------------------------------------------------

function display_promotions($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 4, 
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'promotions'
    );

    $paged = get_query_var('paged') ? get_query_var('paged') : 1;

    $args = array(
        'post_type' => 'promotions',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => $paged,
    );

    $promotions_query = new WP_Query($args);

    ob_start();

    if ($promotions_query->have_posts()): ?>
        <div class="promotion">
            <div class="row g-md-3 g-3">
                <div class="col-12">
                    <div class="row align-items-start">
                        <!-- Left Side Vertical Text -->
                        <div class="col-lg-2 col-12 d-none d-sm-block">
                            <div class="vertical-heading vertical-left">
                                Promotion
                            </div>
                        </div>

                        <!-- Right Side Images Grid -->
                        <div class="col-lg-10 col-12">
                            <div class="row g-4">
                                <?php while ($promotions_query->have_posts()):
                                    $promotions_query->the_post(); ?>
                                    <div class="col-md-6 col-sm-6">
                                        <div class="promotion-image-box">
                                            <?php
                                            if (has_post_thumbnail()) {
                                                the_post_thumbnail('full', array('class' => 'img-fluid w-100'));
                                            }
                                            ?>
                                        </div>
                                    </div>
                                <?php endwhile; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Pagination -->
        <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
            <div class="pagination-two d-inline-block">
                <?php
                echo paginate_links(
                    array(
                        'total' => $promotions_query->max_num_pages,
                        'current' => $paged,
                        'format' => '?paged=%#%',
                        'show_all' => false,
                        'type' => 'plain',
                        'prev_text' => __('<img src="https://artistryhairsalon.sg/wp-content/uploads/2024/09/left-arrow-1.png">'),
                        'next_text' => __('<img src="https://artistryhairsalon.sg/wp-content/uploads/2024/09/right-arrow-1.png">'),
                        'end_size' => 2,
                        'mid_size' => 2
                    )
                );
                ?>
            </div>
        </div>
    <?php else:
        echo 'No promotions found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('promotions_list', 'display_promotions');

// promotion page End ------------------------------------------------------------




// Testimonial page start ------------------------------------------------------------

function display_testimonials($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'testimonials'
    );

    // Get the current page


    $args = array(
        'post_type' => 'testimonials',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );


    $testimonials_query = new WP_Query($args);

    ob_start();

    if ($testimonials_query->have_posts()): ?>
        <div class="testimonial">
            <div class="row g-md-3 g-3">
                <?php while ($testimonials_query->have_posts()):
                    $testimonials_query->the_post();
                    ?>
                    <div class="col-md-4">
                        <div class="testimonial-box">
                            <div class="rating mb-3">
                                <?php
                                $rating = get_field('rating');
                                if ($rating):
                                    echo '<span class="rating">';
                                    echo str_repeat('★', $rating);
                                    echo '</span>';
                                endif;
                                ?>

                            </div>
                            <div class="testimonial-text">
                                <?php echo get_the_content(); ?>
                            </div>
                            <p class="author-name"> <?php echo get_the_title(); ?> </p>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
        </div>

        <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
            <div class="pagination-two d-inline-block">
                <?php
                echo paginate_links(
                    array(
                        'total' => $testimonials_query->max_num_pages,
                        'current' => max(1, get_query_var('paged')),
                        'format' => '?paged=%#%',
                        'show_all' => false,
                        'type' => 'plain',
                        'prev_text' => __('<img src="https://artistryhairsalon.sg/wp-content/uploads/2024/09/left-arrow-1.png">'),
                        'next_text' => __('<img src="https://artistryhairsalon.sg/wp-content/uploads/2024/09/right-arrow-1.png">'),
                        'end_size' => 2,
                        'mid_size' => 2
                    )
                );
                ?>
            </div>
        </div>

    <?php else:
        echo 'No testimonials found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('testimonials', 'display_testimonials');


// Testimonial page End ------------------------------------------------------------







// woocommerce start --------------------------------


function add_shortcode_after_footer() {
    if ( is_product() ) {
        echo do_shortcode('[hfe_template id="5289"]');
    }
}
add_action('woocommerce_after_main_content', 'add_shortcode_after_footer', 10);


// user dashboard start ----------------------------------------------------------
// Remove Wishlist and Downloads from My Account menu
function remove_my_account_links($menu_links)
{
    unset($menu_links['wishlist']); // remove wishlist
    unset($menu_links['downloads']); // remove downloads
    return $menu_links;
}
add_filter('woocommerce_account_menu_items', 'remove_my_account_links');
// user dashboard end ------------------------------------------------------------

// woocommerce end --------------------------------






// promotion old design page start ------------------------------------------------------------

/*function display_promotions($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 3,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'promotions'
    );

    // Get the current page


    $args = array(
        'post_type' => 'promotions',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );



    $promotions_query = new WP_Query($args);

    ob_start();

    if ($promotions_query->have_posts()): ?>
        <div class="promotion">
            <div class="row g-md-3 g-3">
                <div class="col-12">
                    <?php while ($promotions_query->have_posts()):
                        $promotions_query->the_post();
                        ?>

                        <div class="promotion-box">
                            <div class="row justify-content-center g-3">
                                <div class="col-lg-2 col-3 d-none d-sm-block">
                                    <div class="vertical-heading vertical-left">
                                        Promotion
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-6 col-sm-9">
                                    <div class="">
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                        } ?>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="promotion-text ps-lg-5">
                                        <p class="promotion-date mb-lg-4 mb-3"> 
                                            <?php
                                        $datec = get_field('date_custom');
                                            if ($datec) {
                                                ?>
                                                <?php echo esc_html($datec); ?>
                                            <?php } ?>
                                        </p>
                                        <h2 class="promotion-heading mb-4"> <?php echo get_the_title(); ?> </h2>
                                        <div class="content">
                                            <?php echo get_the_content(); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    <?php endwhile; ?>
                </div>
            </div>
        </div>


        <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
            <div class="pagination-two d-inline-block">
                <?php
                echo paginate_links(
                    array(
                        'total' => $promotions_query->max_num_pages,
                        'current' => max(1, get_query_var('paged')),
                        'format' => '?paged=%#%',
                        'show_all' => false,
                        'type' => 'plain',
                        'prev_text' => __('<img src="https://artistryhairsalon.sg/wp-content/uploads/2024/09/left-arrow-1.png">'),
                        'next_text' => __('<img src="https://artistryhairsalon.sg/wp-content/uploads/2024/09/right-arrow-1.png">'),
                        'end_size' => 2,
                        'mid_size' => 2
                    )
                );
                ?>
            </div>
        </div>

    <?php else:
        echo 'No promotions found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('promotions_list', 'display_promotions');*/


// promotion old design page End ------------------------------------------------------------
 