<?php
// Enqueue the parent theme's stylesheet

function hello_elementor_child_enqueue_styles()
{
    wp_enqueue_style('hello-elementor-parent-style', get_template_directory_uri() . '/../hello-elementor-child/style.css');
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles');




// Enqueue Booststrap 
function enqueue_bootstrap()
{
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');

//  Slick carousel script and styles
function enqueue_slick_scripts()
{
    //  Slick carousel script
    wp_enqueue_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js', array('jquery'), null, true);
    //  Slick carousel CSS
    wp_enqueue_style('slick-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_slick_scripts');

// custom code


// custom code








// Home slider Start --------------------------------------------
function display_banner_home($atts)
{
    $args = array(
        'post_type' => 'main-slider',
    );

    $mainslider_query = new WP_Query($args);

    ob_start();

    if ($mainslider_query->have_posts()):
        $total_slides = $mainslider_query->post_count;
        $slide_num = 1;
?>
        <div id="demo" class="carousel slide carousel-fade hero-banner" data-bs-ride="carousel">
            <div class="carousel-inner">
                <?php
                $first = true;
                $slide_index = 0;
                while ($mainslider_query->have_posts()):
                    $mainslider_query->the_post(); ?>

                    <div class="carousel-item <?php echo $first ? 'active' : ''; ?>">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="carousel-captions">
                                    <?php
                                    $sub_title = get_field('sub_title');
                                    if ($sub_title):
                                        echo '<p class="subtitle">';
                                        echo $sub_title;
                                        echo '</p>';
                                    endif; ?>

                                    <h1><?php the_title(); ?></h1>
                                    <div class="desription"> <?php the_content(); ?> </div>

                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="ps-md-5">
                                    <div class="position-relative">
                                        <?php
                                        $featured_video = get_field('featured_video');
                                        ?>
                                        <?php
                                        if ($featured_video) {
                                            $file_url = is_array($featured_video) ? $featured_video['url'] : $featured_video;
                                            echo ' <video controls autoplay width="100%">
                                            <source src="' . esc_url($file_url) . '" type="video/mp4" class="video-box">
                                        </video>
                                        <img src="https://draftsite1.com/aspire-lightings/wp-content/uploads/2025/05/Lumiere-5H_bedroom@2x.png" class="d-block w-100 visiblity">
                            ';
                                        } elseif (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                <?php
                    $first = false;
                    $slide_index++;
                endwhile; ?>
            </div>


            <?php
            // Re-run the same query again for the indicators
            $indicator_query = new WP_Query($args);
            $indicator_index = 0; ?>
            <div class="slider_indegator">
                <?php if ($indicator_query->have_posts()):
                    while ($indicator_query->have_posts()):
                        $indicator_query->the_post();
                ?>
                        <button type="button" data-bs-target="#demo" data-bs-slide-to="<?php echo $indicator_index; ?>"
                            class="<?php echo $indicator_index === 0 ? 'active' : ''; ?>">
                            <?php if (has_post_thumbnail()): ?>
                                <div class="indicator-thumbnail">
                                    <?php the_post_thumbnail('full'); ?>
                                </div>
                            <?php endif; ?>
                            <div class="indicator-title">
                                <?php
                                $thumb_title_title = get_field('thumb_title_title');
                                if ($thumb_title_title):
                                    echo '<p class="tumbtitle">';
                                    echo $thumb_title_title;
                                    echo '</p>';
                                endif; ?>
                            </div>
                        </button>
                <?php
                        $indicator_index++;
                    endwhile;
                    wp_reset_postdata();
                endif;
                ?>
            </div>


            <script>
                document.addEventListener("DOMContentLoaded", function() {
                    var myCarousel = document.querySelector("#demo");
                    var currentSlideElement = document.querySelector("#current-slide");

                    myCarousel.addEventListener("slid.bs.carousel", function(event) {
                        var activeIndex = event.to + 1; // Carousel index starts from 0, so add 1
                        currentSlideElement.textContent = activeIndex;
                    });
                });
            </script>

        </div>

    <?php else: ?>
        <div>No Slider found.</div>
    <?php endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('banner_home', 'display_banner_home');


// Home slider end --------------------------------------------






// blog page start ------------------------------------------------------------


function display_articles($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'blog'
    );

    // Get the current page

    $selected_category = isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '';

    // Query arguments
    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );

    // Add category filter to query arguments if a category is selected
    if (!empty($selected_category)) {
        $args['category_name'] = $selected_category;
    }


    $categories = get_categories();
    if ($categories):
    ?>
        <div class="text-start">
            <div id="category-filter-list" class="mb-5">
                <a href="<?php echo esc_url(add_query_arg('category', '', home_url('/blog'))); ?>"
                    class="filter-btn <?php echo empty($atts['category']) ? 'active' : ''; ?>">
                    All
                </a>

                <?php foreach ($categories as $category):
                    $active_class = ($atts['category'] === $category->slug) ? 'active' : '';
                ?>

                    <a href="<?php echo esc_url(add_query_arg('category', $category->slug, home_url('/blog'))); ?>"
                        class="filter-btn <?php echo esc_attr($active_class); ?>">
                        <?php echo esc_html($category->name); ?>
                    </a>

                <?php endforeach; ?>
            </div>
        </div>
    <?php
    endif;




    $articles_query = new WP_Query($args);

    ob_start();

    if ($articles_query->have_posts()): ?>
        <div class="articles-page articles-main">
            <div class="row g-md-5 g-3">
                <?php while ($articles_query->have_posts()):
                    $articles_query->the_post();
                ?>
                    <div class="col-md-6 mb-md-5 mb-3">
                        <div class="articles-box" data-post-id="<?php echo get_the_ID(); ?>">

                            <div class="articles-img">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                } ?>

                                <?php
                                $terms = get_the_terms(get_the_ID(), 'category');
                                if ($terms && !is_wp_error($terms)) { ?>
                                    <div class="category-wrap">
                                        <?php
                                        foreach ($terms as $term) {
                                            $category_name = strtolower($term->name); ?>

                                            <span class="category-name"><?php echo $category_name; ?></span>

                                        <?php
                                        } ?>
                                    </div>
                                <?php }
                                ?>
                            </div>

                            <div class="content-box">


                                <h1 class="name"> <?php echo get_the_title(); ?> </h1>
                                <div class="read-now btn-custom-animation">
                                    <a href="<?php the_permalink(); ?>" class="btn-read-now elementor-button"> Read More</a>
                                </div>
                            </div>


                        </div>
                    </div>
                <?php endwhile; ?>
            </div>


            <script type="text/javascript">
                document.addEventListener('DOMContentLoaded', function() {
                    var listItems = document.querySelectorAll('#category-filter-list a');
                    listItems.forEach(function(item) {
                        item.addEventListener('click', function(event) {
                            // No need to prevent default here; the link's href handles the filtering
                        });
                    });
                });
            </script>


            <?php if ($articles_query->max_num_pages > 1): ?>
                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                    <div class="pagination-two">
                        <?php
                        echo paginate_links(array(
                            'total' => $articles_query->max_num_pages,
                            'current' => max(1, get_query_var('paged')),
                            'format' => '?paged=%#%',
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => '<img src="https://draftsite1.com/aspire-lightings/wp-content/uploads/2025/05/arrow-left.png" alt="Previous">',
                            'next_text' => '<img src="https://draftsite1.com/aspire-lightings/wp-content/uploads/2025/05/arrow-right.png" alt="Next">',
                            'end_size' => 2,
                            'mid_size' => 2
                        ));
                        ?>
                    </div>
                </div>
            <?php endif; ?>



        <?php else:
        echo 'No articles found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('articles', 'display_articles');


// list end------------


function get_related_articles($post_id, $number_of_posts = 5)
{

    $args = array(
        'post_type' => 'post',
        'post__not_in' => array($post_id),
        'posts_per_page' => $number_of_posts,
        'ignore_sticky_posts' => 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );

    return get_posts($args);

    $related_posts = get_related_articles(get_the_ID());

    // If not enough related posts by category, get related posts by tag
    if (count($related_posts) < $number_of_posts) {
        $tags = wp_get_post_tags($post_id);
        if ($tags) {
            $tag_ids = array();
            foreach ($tags as $tag) {
                $tag_ids[] = $tag->term_id;
            }
            $args = array(
                'tag__in' => $tag_ids,
                'post__not_in' => array_merge(array($post_id), wp_list_pluck($related_posts, 'ID')),
                'posts_per_page' => $number_of_posts - count($related_posts),
                'ignore_sticky_posts' => 1,
            );
            $more_related_posts = get_posts($args);
            $related_posts = array_merge($related_posts, $more_related_posts);
        }
    }

    return $related_posts;
}


// blog page End ------------------------------------------------------------






// projects page start ------------------------------------------------------------

function display_projects($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'projects'
    );

    // Get the current page


    $args = array(
        'post_type' => 'projects',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );


    // Filter by category if provided
    if (!empty($atts['category'])) {
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'projects-category',
                'field' => 'slug',
                'terms' => $atts['category'],
            ),
        );
    }
    // Get categories
    $categories = get_terms(array(
        'taxonomy' => 'projects-category',
        'hide_empty' => true,
    ));

    if ($categories):
        ?>
            <div class="text-center">
                <ul id="project-filter-list" class="mb-5">



                    <li><a href="<?php echo esc_url(add_query_arg('category', '', home_url('/projects'))); ?>"
                            class="cats <?php echo empty($atts['category']) ? 'active' : ''; ?>"> All </a></li>
                    <?php foreach ($categories as $category):
                        $active_class = ($atts['category'] === $category->slug) ? 'active' : '';
                    ?>
                        <li>
                            <a href="<?php echo esc_url(add_query_arg('category', $category->slug, home_url('/projects'))); ?>"
                                class="cats <?php echo esc_attr($active_class); ?>">
                                <?php echo esc_html($category->name); ?>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        <?php
    endif;




    $projects_query = new WP_Query($args);

    ob_start();

    if ($projects_query->have_posts()): ?>
            <div class="projects-page projects-main">
                <div class="row g-md-5 g-3">
                    <?php while ($projects_query->have_posts()):
                        $projects_query->the_post();
                    ?>
                        <div class="col-md-6 pb-4 pb-md-0">
                            <div class="projects-box show-more-content-btn" id="<?php echo get_the_ID(); ?>">
                                <a href="<?php the_permalink(); ?>" class="d-block">
                                    <div class="projects-img mb-2 mb-md-4">
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                        } ?>
                                    </div>
                                    <div class="content-box">
                                        <h1 class="name mb-0"> <?php echo get_the_title(); ?> </h1>
                                    </div>
                                </a>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>

                <script type="text/javascript">
                    document.addEventListener('DOMContentLoaded', function() {
                        var listItems = document.querySelectorAll('#category-filter-list a');
                        listItems.forEach(function(item) {
                            item.addEventListener('click', function(event) {
                                // No need to prevent default here; the link's href handles the filtering
                            });
                        });
                    });
                </script>




                <?php if ($projects_query->max_num_pages > 1): ?>
                    <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                        <div class="pagination-two">
                            <?php
                            echo paginate_links(array(
                                'total' => $projects_query->max_num_pages,
                                'current' => max(1, get_query_var('paged')),
                                'format' => '?paged=%#%',
                                'show_all' => false,
                                'type' => 'plain',
                                'prev_text' => '<img src="https://draftsite1.com/aspire-lightings/wp-content/uploads/2025/05/arrow-left.png" alt="Previous">',
                                'next_text' => '<img src="https://draftsite1.com/aspire-lightings/wp-content/uploads/2025/05/arrow-right.png" alt="Next">',
                                'end_size' => 2,
                                'mid_size' => 2
                            ));
                            ?>
                        </div>
                    </div>
                <?php endif; ?>


            <?php else:
            echo 'No projects found.';
        endif;

        wp_reset_postdata();

        return ob_get_clean();
    }
    add_shortcode('projects', 'display_projects');


    // projects page End ------------------------------------------------------------












    // woocommerce start





    // Wrap WooCommerce product image in a div start ----------
    add_action('woocommerce_before_shop_loop_item_title', 'wrap_product_image_in_div', 5);
    function wrap_product_image_in_div()
    {
        echo '<div class="custom-image-wrapper">';
    }
    add_action('woocommerce_before_shop_loop_item_title', 'close_product_image_div', 15);
    function close_product_image_div()
    {
        echo '</div>';
    }
    // Wrap WooCommerce product image in a div end ----------


    // shop header add start ---------------------------

    add_action('woocommerce_before_main_content', 'custom_shop_header', 5);
    function custom_shop_header()
    {
        if (is_product()) {
            ?>
                <div class="custom-shop-header">
                    <div class="container">
                        <div class="row g-md-3 align-items-center">
                            <div class="col-md-12">
                                <div class="banner-title">
                                    <div class="read-now btn-custom-animation">
                                        <a href="<?php echo esc_url(home_url('shop')); ?>"
                                            class="btn-read-now elementor-button"> Back To Shop Page
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php
        }
    }
    // shop header add end ---------------------------


    // product-categories start ----------------------------------------- 
    function wpb_woocommerce_product_categories_accordion()
    {
        // Get the current queried product category
        $queried_object = get_queried_object();
        $current_category_id = ($queried_object && isset($queried_object->term_id)) ? $queried_object->term_id : 0;

        // Get all parent categories of the current category
        $current_category_parents = [];
        if ($current_category_id) {
            $parent_categories = get_ancestors($current_category_id, 'product_cat');
            $current_category_parents = array_map('intval', $parent_categories);
        }

        // Recursive function to get subcategories with checkboxes
        function get_subcategories($parent_id, $level = 1, $current_category_id, $current_category_parents)
        {
            $args = array(
                'taxonomy' => 'product_cat',
                'orderby' => 'name',
                'order' => 'ASC',
                'parent' => $parent_id,
                'hide_empty' => true
            );
            $sub_categories = get_terms($args);

            if (!empty($sub_categories)) {
                echo '<ul class="list-unstyled ps-2">';
                foreach ($sub_categories as $sub_category) {
                    $is_checked = ($sub_category->term_id == $current_category_id) ? 'checked' : '';
                    $active_class = ($sub_category->term_id == $current_category_id) ? 'current-category' : '';

                    echo '<li class="' . $active_class . '">';
                    echo '<div class="in-menu">';
                    echo '<input type="checkbox" class="category-checkbox me-2" data-category-id="' . $sub_category->term_id . '" ' . $is_checked . '> ';

                    echo '<a href="' . get_term_link($sub_category) . '">  <span class="customcheck"></span>' . $sub_category->name . '</a>';
                    echo '</div>';
                    get_subcategories($sub_category->term_id, $level + 1, $current_category_id, $current_category_parents);
                    echo '</li>';
                }
                echo '</ul>';
            }
        }

        // Get main product categories (parent categories)
        $args = array(
            'taxonomy' => 'product_cat',
            'orderby' => 'name',
            'order' => 'ASC',
            'parent' => 0,
            'hide_empty' => true
        );
        $product_categories = get_terms($args);

        if ($product_categories) {
            ob_start();
            ?>
                <div class="accordion" id="productCategoriesAccordion">

                    <?php
                    $shop_page_url = wc_get_page_permalink('shop');
                    $is_shop_page = is_shop();
                    ?>

                    <div class="accordion-item">
                        <div class="accordion-header <?php echo $is_shop_page ? 'current-category' : ''; ?>">
                            <label for="all">
                                <input type="checkbox" class="category-checkbox me-2" id="all" data-category-id="all" <?php echo $is_checked; ?>>
                                <a href="<?php echo esc_url($shop_page_url); ?>" class="main-category">
                                    <span class="customcheck"></span>
                                    All Product
                                </a>
                            </label>
                        </div>
                    </div>


                    <?php
                    $i = 0;
                    foreach ($product_categories as $category) {
                        $i++;

                        // Check if the category has subcategories
                        $sub_args = array(
                            'taxonomy' => 'product_cat',
                            'parent' => $category->term_id,
                            'hide_empty' => true
                        );
                        $sub_categories = get_terms($sub_args);
                        $has_subcategories = !empty($sub_categories);

                        // Determine if this category should be expanded
                        $is_checked = ($category->term_id == $current_category_id) ? 'checked' : '';
                        $active_class = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'current-category' : '';
                        $show_collapse = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'show' : '';
                    ?>
                        <div class="accordion-item <?php echo $active_class; ?>">
                            <div class="accordion-header d-flex align-items-center" id="heading<?php echo $i; ?>">
                                <label for="cat<?php echo $category->term_id; ?>">
                                    <input type="checkbox" class="category-checkbox me-2" id="cat<?php echo $category->term_id; ?>"
                                        data-category-id="<?php echo $category->term_id; ?>" <?php echo $is_checked; ?>>

                                    <a href="<?php echo get_term_link($category); ?>" class="main-category">
                                        <span class="customcheck"></span>
                                        <?php echo $category->name; ?>
                                    </a>
                                </label>

                                <?php if ($has_subcategories) { ?>
                                    <button class="accordion-button ms-auto <?php echo ($show_collapse == '') ? 'collapsed' : ''; ?>"
                                        type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>"
                                        aria-expanded="<?php echo ($show_collapse) ? 'true' : 'false'; ?>"
                                        aria-controls="collapse<?php echo $i; ?>" data-category-id="<?php echo $category->term_id; ?>">
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                <?php } ?>
                            </div>
                            <?php if ($has_subcategories) { ?>
                                <div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse <?php echo $show_collapse; ?>"
                                    aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#productCategoriesAccordion">
                                    <div class="accordion-body ps-0 pe-0">
                                        <?php get_subcategories($category->term_id, 1, $current_category_id, $current_category_parents); ?>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    <?php
                    }
                    ?>
                </div>

                <script>
                    document.addEventListener("DOMContentLoaded", function() {
                        var savedCategories = JSON.parse(localStorage.getItem("checkedCategories")) || [];

                        savedCategories.forEach(function(categoryId) {
                            var checkbox = document.querySelector('.category-checkbox[data-category-id="' + categoryId + '"]');
                            if (checkbox) {
                                checkbox.checked = true;
                            }
                        });

                        document.querySelectorAll(".category-checkbox").forEach(function(checkbox) {
                            checkbox.addEventListener("change", function() {
                                var categoryId = this.getAttribute("data-category-id");
                                if (this.checked) {
                                    if (!savedCategories.includes(categoryId)) {
                                        savedCategories.push(categoryId);
                                    }
                                } else {
                                    savedCategories = savedCategories.filter(id => id !== categoryId);
                                }
                                localStorage.setItem("checkedCategories", JSON.stringify(savedCategories));
                            });
                        });

                        var activeCategory = localStorage.getItem("activeCategory");
                        if (activeCategory) {
                            var activeAccordion = document.querySelector('[data-category-id="' + activeCategory + '"]');
                            if (activeAccordion) {
                                var collapseElement = activeAccordion.getAttribute("data-bs-target");
                                document.querySelector(collapseElement).classList.add("show");
                                activeAccordion.classList.remove("collapsed");
                                activeAccordion.setAttribute("aria-expanded", "true");
                            }
                        }

                        document.querySelectorAll(".accordion-button").forEach(function(button) {
                            button.addEventListener("click", function() {
                                var categoryId = this.getAttribute("data-category-id");
                                if (document.querySelector(this.getAttribute("data-bs-target")).classList.contains("show")) {
                                    localStorage.removeItem("activeCategory");
                                } else {
                                    localStorage.setItem("activeCategory", categoryId);
                                }
                            });
                        });
                    });
                </script>

                <style>
                    .current-category>a {
                        font-weight: bold;
                        color: #ff6600;
                    }

                    .category-checkbox {
                        display: none;
                    }

                    span.customcheck {
                        background: #FFFFFF 0% 0% no-repeat padding-box;
                        border: 1px solid #BEBEBE;
                        border-radius: 2px;
                        width: 15px;
                        height: 15px;
                        position: relative;
                        margin-right: 3px;
                        margin-top: 0px;
                        top: 2px;
                        display: none;
                    }

                    .current-category [type=checkbox]:checked~a span.customcheck {
                        background: #fff;
                        border-color: #4D804F;
                    }

                    .current-category [type=checkbox]~a .customcheck:after {
                        content: "";
                        position: absolute;
                    }

                    .current-category a input:checked~.customcheck:after {
                        display: block;
                    }

                    .current-category a .customcheck:after {
                        left: 5px;
                        top: 2px;
                        width: 4px;
                        height: 8px;
                        border: solid #4D804F;
                        border-width: 0 2px 2px 0;
                        -webkit-transform: rotate(45deg);
                        -ms-transform: rotate(45deg);
                        transform: rotate(45deg);
                    }
                </style>
            <?php
            return ob_get_clean();
        }
    }

    add_shortcode('product_categories_accordion', 'wpb_woocommerce_product_categories_accordion');

    // product category for sidebar end -------------------------------




    function wc_brand_filter_links_shortcode()
    {
        $terms = get_terms(array(
            'taxonomy' => 'product_brand',
            'hide_empty' => true,
        ));

        if (empty($terms) || is_wp_error($terms)) {
            return '<p>No brands found.</p>';
        }

        $current_brand = get_queried_object();
        $current_term_slug = ($current_brand && isset($current_brand->slug)) ? $current_brand->slug : '';

        $output = '<ul class="brand-filter-list">';

        // "All" link
        $output .= '<li>';
        $output .= '<a href="' . esc_url(get_permalink(wc_get_page_id('shop'))) . '" class="' . ($current_term_slug === '' ? 'active' : '') . '">';
        $output .= '<input type="checkbox" class="d-none" disabled ' . checked($current_term_slug === '', true, false) . '> All';
        $output .= '<span class="customcheckbox"> </span>';
        $output .= '</a>';
        $output .= '</li>';

        foreach ($terms as $term) {
            $url = get_term_link($term, 'product_brand');
            $is_active = ($current_term_slug === $term->slug);
            $output .= '<li>';
            $output .= '<a href="' . esc_url($url) . '" class="' . ($is_active ? 'active' : '') . '">';
            $output .= '<input type="checkbox" class="d-none" disabled ' . checked($is_active, true, false) . '> ' . esc_html($term->name);
            $output .= '<span class="customcheckbox"> </span>';
            $output .= '</a>';
            $output .= '</li>';
        }

        $output .= '</ul>';

        return $output;
    }
    add_shortcode('brand_filter_links', 'wc_brand_filter_links_shortcode');







    // Shortcode list for filtering by end -------------------












    function custom_scroll_script()
    {
            ?>
            <script type="text/javascript">
                (function($) {
                    $(document).ready(function() {
                        $(window).scroll(function() {
                            if ($(this).scrollTop() > 20) {
                                $('body').addClass('scrolled');
                            } else {
                                $('body').removeClass('scrolled');
                            }
                        });
                    });
                })(jQuery);
            </script>


        <?php
    }
    add_action('wp_footer', 'custom_scroll_script');





    // validation woocommerce start 


    add_action('woocommerce_save_account_details_errors', 'validate_my_account_fields', 10, 1);

    function validate_my_account_fields($errors)
    {
        // Validate First Name
        if (isset($_POST['account_first_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_first_name'])) {
            $errors->add('validation', __('Allowed characters for First Name are alphabets and spaces only.', 'woocommerce'));
        }

        // Validate Last Name
        if (isset($_POST['account_last_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_last_name'])) {
            $errors->add('validation', __('Allowed characters for Last Name are alphabets and spaces only.', 'woocommerce'));
        }

        // Validate Display Name
        if (isset($_POST['account_display_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_display_name'])) {
            $errors->add('validation', __('Allowed characters for Display Name are alphabets and spaces only.', 'woocommerce'));
        }
    }




    add_action('woocommerce_after_save_address_validation', 'validate_billing_address_fields', 10, 2);

    function validate_billing_address_fields($user_id, $address_type)
    {
        if ('billing' === $address_type) {
            // Initialize an array to store error messages
            $validation_errors = [];

            // Get the values of the fields from the form
            $billing_first_name = isset($_POST['billing_first_name']) ? sanitize_text_field($_POST['billing_first_name']) : '';
            $billing_last_name = isset($_POST['billing_last_name']) ? sanitize_text_field($_POST['billing_last_name']) : '';
            $billing_city = isset($_POST['billing_city']) ? sanitize_text_field($_POST['billing_city']) : '';
            $billing_address_1 = isset($_POST['billing_address_1']) ? sanitize_text_field($_POST['billing_address_1']) : '';

            $billing_postcode = isset($_POST['billing_postcode']) ? sanitize_text_field($_POST['billing_postcode']) : '';
            $billing_email = isset($_POST['billing_email']) ? sanitize_email($_POST['billing_email']) : '';

            // Validate Billing First Name (Only alphabets and spaces allowed)
            if (!preg_match('/^[a-zA-Z\s]+$/', $billing_first_name)) {
                $validation_errors[] = __('Allowed characters for Billing First Name are alphabets and spaces only.', 'woocommerce');
            }

            // Validate Billing Last Name (Only alphabets and spaces allowed)
            if (!preg_match('/^[a-zA-Z\s]+$/', $billing_last_name)) {
                $validation_errors[] = __('Allowed characters for Billing Last Name are alphabets and spaces only.', 'woocommerce');
            }

            // Validate Billing Last Name (Only alphabets and spaces allowed)
            if (!preg_match('/^[a-zA-Z\s]+$/', $billing_city)) {
                $validation_errors[] = __('Allowed characters for Billing City Name are alphabets and spaces only.', 'woocommerce');
            }

            // Validate Address (Only letters, numbers, and spaces)
            if (!preg_match('/^[a-zA-Z0-9\s]+$/', $billing_address_1)) {
                $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
            }

            // Validate Postcode (Only numbers, 4-10 digits)
            if (!preg_match('/^\d{4,6}$/', $billing_postcode)) {
                $validation_errors[] = __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
            }



            // Validate Billing Email (Basic Email validation)
            if (!is_email($billing_email)) {
                $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
            }

            // If there are validation errors, stop the form submission and display the errors
            if (!empty($validation_errors)) {
                // Add all validation errors as WooCommerce notices
                foreach ($validation_errors as $error_message) {
                    wc_add_notice($error_message, 'error');  // Add error messages
                }

                // Stop the form submission by returning early
                return; // This will prevent the address from being saved
            }
        }
    }








    add_action('woocommerce_after_save_address_validation', 'validate_shipping_address_fields', 10, 2);

    function validate_shipping_address_fields($user_id, $address_type)
    {
        if ('shipping' === $address_type) {
            // Initialize an array to store error messages
            $validation_errors = [];

            // Get the values of the fields from the form
            $shipping_first_name = isset($_POST['shipping_first_name']) ? sanitize_text_field($_POST['shipping_first_name']) : '';
            $shipping_last_name = isset($_POST['shipping_last_name']) ? sanitize_text_field($_POST['shipping_last_name']) : '';
            $shipping_city = isset($_POST['shipping_city']) ? sanitize_text_field($_POST['shipping_city']) : '';
            $shipping_address_1 = isset($_POST['shipping_address_1']) ? sanitize_text_field($_POST['shipping_address_1']) : '';

            $shipping_postcode = isset($_POST['shipping_postcode']) ? sanitize_text_field($_POST['shipping_postcode']) : '';
            //  $shipping_email = isset($_POST['shipping_email']) ? sanitize_email($_POST['shipping_email']) : '';

            // Validate shipping First Name (Only alphabets and spaces allowed)
            if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_first_name)) {
                $validation_errors[] = __('Allowed characters for shipping First Name are alphabets and spaces only.', 'woocommerce');
            }

            // Validate shipping Last Name (Only alphabets and spaces allowed)
            if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_last_name)) {
                $validation_errors[] = __('Allowed characters for shipping Last Name are alphabets and spaces only.', 'woocommerce');
            }

            // Validate shipping Last Name (Only alphabets and spaces allowed)
            if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_city)) {
                $validation_errors[] = __('Allowed characters for shipping City Name are alphabets and spaces only.', 'woocommerce');
            }

            // Validate Address (Only letters, numbers, and spaces)
            if (!preg_match('/^[a-zA-Z0-9\s]+$/', $shipping_address_1)) {
                $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
            }

            // Validate Postcode (Only numbers, 4-10 digits)
            if (!preg_match('/^\d{4,6}$/', $shipping_postcode)) {
                $validation_errors[] = __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
            }



            // Validate shipping Email (Basic Email validation)
            // if (!is_email($shipping_email)) {
            //     $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
            // }

            // If there are validation errors, stop the form submission and display the errors
            if (!empty($validation_errors)) {
                // Add all validation errors as WooCommerce notices
                foreach ($validation_errors as $error_message) {
                    wc_add_notice($error_message, 'error');  // Add error messages
                }

                // Stop the form submission by returning early
                return; // This will prevent the address from being saved
            }
        }
    }




    // validation woocommerce end --------------------

    // contact form validation 




    // Validate text fields (only alphabets allowed)
    add_filter('wpcf7_validate_text', 'alpha_validation_filter_text', 20, 2);
    add_filter('wpcf7_validate_text*', 'alpha_validation_filter_text', 20, 2);

    function alpha_validation_filter_text($result, $tag)
    {
        if (class_exists('WPCF7_FormTag')) {
            $tag = new WPCF7_FormTag($tag); // Corrected class
        }

        if ('names' === $tag->name) {
            $name_of_the_input = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

            if (!preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input)) {
                $result->invalidate($tag, "Allowed characters are Alphabets only.");
            }
        }

        if ('lname' === $tag->name) {
            $name_of_the_input = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

            if (!preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input)) {
                $result->invalidate($tag, "Allowed characters are Alphabets only.");
            }
        }

        return $result;
    }

    // Validate phone number (must be exactly 10 digits)
    add_filter('wpcf7_validate_tel', 'numeric_phone_validation_filter', 20, 2);
    add_filter('wpcf7_validate_tel*', 'numeric_phone_validation_filter', 20, 2);

    function numeric_phone_validation_filter($result, $tag)
    {
        if (class_exists('WPCF7_FormTag')) {
            $tag = new WPCF7_FormTag($tag); // Corrected class
        }

        if ('phone' === $tag->name) {
            $phone_number = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

            if (!preg_match('/^\d{8}$/', $phone_number)) {
                $result->invalidate($tag, "Phone number must contain exactly 8 digits.");
            }
        }

        return $result;
    }



    // Validate email (must be a valid email format)
    add_filter('wpcf7_validate_email', 'validate_email_filter', 20, 2);
    add_filter('wpcf7_validate_email*', 'validate_email_filter', 20, 2);

    function validate_email_filter($result, $tag)
    {
        if (class_exists('WPCF7_FormTag')) {
            $tag = new WPCF7_FormTag($tag); // Corrected class
        }

        if ('email' === $tag->name) {
            $email = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

            if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                $result->invalidate($tag, "Please enter a valid email address.");
            }
        }

        return $result;
    }


    // Validate textarea field (message)
    add_filter('wpcf7_validate_textarea', 'validate_textarea_filter', 20, 2);
    add_filter('wpcf7_validate_textarea*', 'validate_textarea_filter', 20, 2);

    function validate_textarea_filter($result, $tag)
    {
        if (class_exists('WPCF7_FormTag')) {
            $tag = new WPCF7_FormTag($tag); // Corrected class
        }

        if ('message' === $tag->name) {
            $message = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

            // Allowed characters: alphabets, spaces, common punctuation marks
            if (!preg_match('/^[a-zA-Z0-9\s.,!?()-]+$/', $message)) {
                $result->invalidate($tag, "Message contains invalid characters. Only letters, numbers, spaces, and punctuation are allowed.");
            }

            // Min 10 characters, Max 500 characters
            if (strlen($message) < 10 || strlen($message) > 500) {
                $result->invalidate($tag, "Message must be between 10 and 500 characters.");
            }
        }

        return $result;
    }

    // Remove short description from the default position
    remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20);

    // Re-add it after the Add to Cart button (default priority for Add to Cart is 30)
    add_action('woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 35);
    // Remove product meta (categories, SKU, tags) from right column


    // remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
    // add_action( 'woocommerce_after_single_product_summary', 'woocommerce_template_single_meta', 5 );




        ?>