<?php get_header(); ?>


<div class="project-detail">

    <div class="container pt-4">

        <div class="row g-md-3 g-3 justify-content-between">
            <div class="col-lg-12 mb-5">
                <div class="read-now btn-custom-animation">
                    <a href="<?php echo esc_url(home_url('blog')); ?>" class="btn-read-now elementor-button"> Back To
                        Project
                    </a>
                </div>
            </div>
        </div>


        <?php
        if (have_posts()):
            while (have_posts()):
                the_post();
                ?>
                <div class="row g-md-5 g-3 justify-content-between pb-4">

                    <div class="col-md-6">
                        <div class="img-wrap">
                            <?php if (has_post_thumbnail()) {
                                the_post_thumbnail('full', array('class' => 'd-block w-100'));
                            } ?>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <h2 class="title"><?php echo the_title(); ?></h2>

                        <div class="content-other mb-2 pt-2">
                            <div class="wrap mb-3">

                                <?php
                                $year = get_field('year');
                                if ($year):
                                    echo '  <p class="other-title"> YEAR</p>';
                                    echo '<p class="other-text mb-0">';
                                    echo $year;
                                    echo '</p>';
                                endif; ?>
                            </div>
                            <div class="wrap mb-3">
                                <?php
                                $product_type = get_field('product_type');
                                if ($product_type):
                                    echo '  <p class="other-title"> PRODUCT TYPE</p>';
                                    echo '<p class="other-text mb-0">';
                                    echo $product_type;
                                    echo '</p>';
                                endif; ?>
                            </div>

                        </div>

                        <div class="content-area">
                            <?php the_content(); ?>
                        </div>
                    </div>


                </div>

                <div class="row justify-content-center">
                    <div class="col-md-12 col-sm-12 col-10 mt-md-5 mt-4">

                        <?php
                        $slider_images = get_field('slider_images', get_the_ID());

                        if (!empty($slider_images)): ?>
                            <div class="project-slider">
                                <div class="slick-slider-project">
                                    <?php foreach ($slider_images as $row):
                                        $image_url = $row['project_image']; // Direct image URL if return format is 'URL'
                                        if (!empty($image_url)): ?>
                                            <div class="item">
                                                <div class="img-wraps">
                                                    <img src="<?php echo esc_url($image_url); ?>" alt="" class="w-100">
                                                </div>
                                            </div>
                                        <?php endif;
                                    endforeach; ?>
                                </div>
                            </div>
                        <?php endif; ?>


                    </div>
                </div>

                <?php
            endwhile;
        else:
            echo 'No post found.';
        endif;
        ?>
    </div>

</div>

<script>
    jQuery(document).ready(function ($) {
        $(".slick-slider-project").slick({
            dots: false,
            infinite: true,
            speed: 300,
            slidesToShow: 2,
            slidesToScroll: 1,
            adaptiveHeight: true,
            prevArrow: '<div class="left-btn arrowbtn"><i class="eicon-chevron-left"></i></div>',
            nextArrow: '<div class="right-btn arrowbtn"><i class="eicon-chevron-right"></i></div>',
            responsive: [{
                breakpoint: 1200,
                settings: {
                    slidesToShow: 2,
                    slidesToScroll: 1,
                },
            },
            {
                breakpoint: 1008,
                settings: {
                    slidesToShow: 3,
                    slidesToScroll: 1,
                },
            },
            {
                breakpoint: 800,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                },
            },
            ],
        });

    });
</script>

<?php echo do_shortcode('[hfe_template id="199"]'); ?>


<?php get_footer(); ?>