<?php
/**
 * Single Product Meta
 *
 * This template displays Categories, Tags, and Brand for the product.
 *
 * Override this template by copying it to yourtheme/woocommerce/single-product/meta.php
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.0.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Categories
$categories_list = wc_get_product_category_list(
    $product->get_id(),
    ', ',
    '<span class="posted_in">' . _n( 'Category:', 'Categories:', count( $product->get_category_ids() ), 'woocommerce' ) . ' ',
    '</span>'
);

// Tags
$tags_list = wc_get_product_tag_list(
    $product->get_id(),
    ', ',
    '<span class="tagged_as">' . _n( 'Tag:', 'Tags:', count( $product->get_tag_ids() ), 'woocommerce' ) . ' ',
    '</span>'
);

// Brand (custom taxonomy)
$brands = wp_get_post_terms( $product->get_id(), 'brand', array( 'fields' => 'all' ) );
$brand_list = '';
if ( ! empty( $brands ) && ! is_wp_error( $brands ) ) {
    $brand_names = wp_list_pluck( $brands, 'name' );
    $brand_list = '<span class="posted_in">Brand: ' . esc_html( implode( ', ', $brand_names ) ) . '</span>';
}

?>

<div class="product_meta">

    <?php
    if ( $categories_list ) {
        echo wp_kses_post( $categories_list );
    }

    if ( $tags_list ) {
        echo wp_kses_post( $tags_list );
    }

    if ( $brand_list ) {
        echo wp_kses_post( $brand_list );
    }
    ?>

</div>
