<?php
// Enqueue the parent theme's stylesheet

function hello_elementor_child_enqueue_styles()
{
    wp_enqueue_style('hello-elementor-parent-style', get_template_directory_uri() . '/../hello-elementor-child/style.css');
    wp_enqueue_style('hello-elementor-parent-ecommerce', get_template_directory_uri() . '/../hello-elementor-child/ecommerce.css');
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles');



// Enqueue Booststrap 
function enqueue_bootstrap()
{
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');

//  Slick carousel script and styles
function enqueue_slick_scripts()
{
    //  Slick carousel script
    wp_enqueue_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js', array('jquery'), null, true);
    //  Slick carousel CSS
    wp_enqueue_style('slick-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_slick_scripts');
// custom code










// Home slider Start --------------------------------------------
function display_banner_home($atts)
{
    $args = array(
        'post_type' => 'main-slider',
    );

    $mainslider_query = new WP_Query($args);

    ob_start();

    if ($mainslider_query->have_posts()):
        $total_slides = $mainslider_query->post_count;
        ?>
        <div id="demo" class="carousel slide carousel-fade hero-banner" data-bs-ride="carousel">
            <div class="carousel-inner">
                <?php
                $first = true;
                $slide_index = 0;
                while ($mainslider_query->have_posts()):
                    $mainslider_query->the_post(); ?>

                    <div class="carousel-item <?php echo $first ? 'active' : ''; ?>">

                        <div class="img-wrap">
                            <?php
                            if (has_post_thumbnail()) {
                                the_post_thumbnail('full', array('class' => 'd-block w-100'));
                            }
                            ?>
                        </div>

                        <div class="carousel-caption-main ">

                            <h1 class="animated zoomIn"><?php the_title(); ?></h1>

                            <div class="btn-slider">
                                <?php
                                $links = get_field('button_link');
                                if ($links) {
                                    $link_url = $links['url'];
                                    $link_title = $links['title'];
                                    ?>
                                    <a href="<?php echo esc_url($link_url); ?>"
                                        class="elementor-button"><?php echo esc_html($link_title); ?> <i
                                            class="icon icon-arrow-right"></i></a>
                                <?php } ?>
                            </div>


                        </div>


                    </div>
                    <?php
                    $first = false;
                    $slide_index++;
                endwhile; ?>
            </div>


            <?php if ($total_slides > 1): ?>
                <div class="carousel-indicator">
                    <?php for ($i = 0; $i < $total_slides; $i++): ?>
                        <button type="button" data-bs-target="#demo" data-bs-slide-to="<?php echo $i; ?>"
                            class="<?php echo $i === 0 ? 'active' : ''; ?>" aria-current="<?php echo $i === 0 ? 'true' : 'false'; ?>"
                            aria-label="Slide <?php echo $i + 1; ?>">
                        </button>
                    <?php endfor; ?>
                </div>
            <?php endif; ?>


            <script>
                document.addEventListener("DOMContentLoaded", function () {
                    var myCarousel = document.querySelector("#demo");
                    var indicators = document.querySelectorAll(".carousel-indicator button");

                    myCarousel.addEventListener("slid.bs.carousel", function (event) {
                        // Remove 'active' class from all indicators
                        indicators.forEach(function (indicator) {
                            indicator.classList.remove("active");
                        });

                        // Add 'active' class to the current indicator
                        if (indicators[event.to]) {
                            indicators[event.to].classList.add("active");
                        }
                    });
                });
            </script>


        </div>

    <?php else: ?>
        <div>No Slider found.</div>
    <?php endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('banner_home', 'display_banner_home');


// Home slider end --------------------------------------------






// testimonials slider start 
function display_testimonials_slider($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
        ),
        $atts,
        'testimonials'
    );

    $args = array(
        'post_type' => 'testimonials',
        'posts_per_page' => $atts['posts_per_page'],
    );

    $testimonials_query = new WP_Query($args);

    ob_start();

    if ($testimonials_query->have_posts()): ?>
        <div class="testimonial-slider">
            <div class="slick-slider-testimonial pb-2">
                <?php while ($testimonials_query->have_posts()):
                    $testimonials_query->the_post();
                    ?>

                    <div class="item ps-2 pt-4 pe-2">
                        <div class="testimonial-box testimonial-box-height">
                            <div class="testimonial-heading">
                                <p class="title mb-1"><?php echo get_the_title(); ?> </p>
                                <?php
                                $rating = get_field('rating');
                                if ($rating):
                                    echo '<div class="rating">';
                                    echo str_repeat('★', $rating);
                                    echo '</div>';
                                endif;
                                ?>
                                <div class="testimonial-text pt-2 mb-4">
                                    <?php echo get_the_content(); ?>
                                </div>
                                <div class="testimonial-image">
                                    <?php
                                    $image_group = get_field('images');

                                    $first_image_url = !empty($image_group['first_image']) ? esc_url($image_group['first_image']) : '';
                                    $second_image_url = !empty($image_group['second_image']) ? esc_url($image_group['second_image']) : '';
                                    $third_image_url = !empty($image_group['third_image']) ? esc_url($image_group['third_image']) : '';
                                    ?>
                                    <div class="row g-2"> <?php
                                    if ($first_image_url) {
                                        echo '<div class="col-md-4 col-4">';
                                        echo '<img src="' . $first_image_url . '" alt="First Image">';
                                        echo '</div>';
                                    }
                                    if ($second_image_url) {
                                        echo '<div class="col-md-4 col-4">';
                                        echo '<img src="' . $second_image_url . '" alt="Second Image">';
                                        echo '</div>';
                                    }
                                    if ($third_image_url) {
                                        echo '<div class="col-md-4 col-4">';
                                        echo '<img src="' . $third_image_url . '" alt="Third Image">';
                                        echo '</div>';
                                    }
                                    ?>
                                    </div>
                                </div>



                            </div>

                        </div>

                    </div>
                <?php endwhile; ?>
            </div>
        </div>

        <script>
            jQuery(document).ready(function ($) {
                $(".slick-slider-testimonial").slick({
                    dots: false,
                    infinite: true,
                    speed: 300,
                    slidesToShow: 3,
                    slidesToScroll: 1,
                    adaptiveHeight: true,
                    prevArrow: '<div class="left-btn arrowbtn"> <img src="https://draftsite1.com/chwee-song/wp-content/uploads/2025/06/left-arrow.png"> </div>',
                    nextArrow: '<div class="right-btn arrowbtn"><img src="https://draftsite1.com/chwee-song/wp-content/uploads/2025/06/right-arrow.png"></div>',
                    responsive: [{
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 3,
                            slidesToScroll: 1,
                        },
                    },
                    {
                        breakpoint: 1008,
                        settings: {
                            slidesToShow: 3,
                            slidesToScroll: 1,
                        },
                    },
                    {
                        breakpoint: 800,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                        },
                    },
                    ],
                });

            });
        </script>

    <?php else:
        echo 'No testimonials found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('testimonials_slider', 'display_testimonials_slider');
// testimonials slider end ------------------------------





// Testimonial page start ------------------------------------------------------------

function display_testimonials($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
        ),
        $atts,
        'testimonials'
    );

    // Get the current page


    $args = array(
        'post_type' => 'testimonials',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );


    $testimonials_query = new WP_Query($args);

    ob_start();

    if ($testimonials_query->have_posts()): ?>
        <div class="testimonial-page testimonials-main">
            <div class="row g-md-3 g-3">
                <?php while ($testimonials_query->have_posts()):
                    $testimonials_query->the_post();
                    ?>
                    <div class="col-md-4">
                        <div class="testimonial-box h-100">
                            <div class="testimonial-heading">
                                <p class="title mb-1"><?php echo get_the_title(); ?> </p>
                                <?php
                                $rating = get_field('rating');
                                if ($rating):
                                    echo '<div class="rating">';
                                    echo str_repeat('★', $rating);
                                    echo '</div>';
                                endif;
                                ?>

                                <div class="pt-2 mb-4">
                                    <div class="testimonial-text">
                                        <?php echo get_the_content(); ?>
                                    </div>
                                 

                                                   <?php
                                $content = get_the_content();
                                $word_count = str_word_count(wp_strip_all_tags(strip_shortcodes($content)));
                                if ($word_count > 30) :
                                ?>
                                      <a data-bs-toggle="modal" data-bs-target="#exampleModal<?php echo get_the_ID(); ?>"
                                        class="read-more-testimonial"> Read More</a> 
                                <?php endif; ?>
                                </div>

                                <div class="testimonial-image">
                                    <?php
                                    $image_group = get_field('images');

                                    $first_image_url = !empty($image_group['first_image']) ? esc_url($image_group['first_image']) : '';
                                    $second_image_url = !empty($image_group['second_image']) ? esc_url($image_group['second_image']) : '';
                                    $third_image_url = !empty($image_group['third_image']) ? esc_url($image_group['third_image']) : '';
                                    ?>
                                    <div class="row g-2"> <?php
                                    if ($first_image_url) {
                                        echo '<div class="col-md-4 col-4">';
                                        echo '<img src="' . $first_image_url . '" alt="First Image">';
                                        echo '</div>';
                                    }
                                    if ($second_image_url) {
                                        echo '<div class="col-md-4 col-4">';
                                        echo '<img src="' . $second_image_url . '" alt="Second Image">';
                                        echo '</div>';
                                    }
                                    if ($third_image_url) {
                                        echo '<div class="col-md-4 col-4">';
                                        echo '<img src="' . $third_image_url . '" alt="Third Image">';
                                        echo '</div>';
                                    }
                                    ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>

            <?php while ($testimonials_query->have_posts()):
                $testimonials_query->the_post(); ?>
                <div class="model-testimonial modal " id="exampleModal<?php echo get_the_ID(); ?>" tabindex="-1"
                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            <div class="modal-body p-0">


                                <div class="testimonial-model">
                                    <div class="testimonial-heading">
                                        <p class="title mb-1"><?php echo get_the_title(); ?> </p>
                                        <?php
                                        $rating = get_field('rating');
                                        if ($rating):
                                            echo '<div class="rating">';
                                            echo str_repeat('★', $rating);
                                            echo '</div>';
                                        endif;
                                        ?>
                                        <div class="testimonial-text-full pt-2 mb-4">
                                            <?php echo get_the_content(); ?>
                                        </div>
                                        <div class="testimonial-image">
                                            <?php
                                            $image_group = get_field('images');

                                            $first_image_url = !empty($image_group['first_image']) ? esc_url($image_group['first_image']) : '';
                                            $second_image_url = !empty($image_group['second_image']) ? esc_url($image_group['second_image']) : '';
                                            $third_image_url = !empty($image_group['third_image']) ? esc_url($image_group['third_image']) : '';
                                            ?>
                                            <div class="row g-2"> <?php
                                            if ($first_image_url) {
                                                echo '<div class="col-md-4">';
                                                echo '<img src="' . $first_image_url . '" alt="First Image">';
                                                echo '</div>';
                                            }
                                            if ($second_image_url) {
                                                echo '<div class="col-md-4">';
                                                echo '<img src="' . $second_image_url . '" alt="Second Image">';
                                                echo '</div>';
                                            }
                                            if ($third_image_url) {
                                                echo '<div class="col-md-4">';
                                                echo '<img src="' . $third_image_url . '" alt="Third Image">';
                                                echo '</div>';
                                            }
                                            ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>

            <?php endwhile; ?>


            <?php if ($testimonials_query->max_num_pages > 1): ?>
                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                    <div class="pagination-two">
                        <?php
                        echo paginate_links(array(
                            'total' => $testimonials_query->max_num_pages,
                            'current' => max(1, get_query_var('paged')),
                            'format' => '?paged=%#%',
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => '<img src="https://draftsite1.com/chwee-song/wp-content/uploads/2025/06/left-arrow.png" alt="Previous">',
                            'next_text' => '<img src="https://draftsite1.com/chwee-song/wp-content/uploads/2025/06/right-arrow.png" alt="Next">',
                            'end_size' => 2,
                            'mid_size' => 2
                        ));
                        ?>
                    </div>
                </div>
            <?php endif; ?>

        </div>

    <?php else:
        echo 'No testimonials found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('testimonials', 'display_testimonials');


// Testimonial page End ------------------------------------------------------------





// blog page start ------------------------------------------------------------


function display_articles($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 1,
        ),
        $atts,
        'blog'
    );



    // Query arguments
    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );


    $articles_query = new WP_Query($args);

    ob_start();

    if ($articles_query->have_posts()): ?>
        <div class="articles-page articles-main">
            <div class="row g-md-5 g-3">
                <?php while ($articles_query->have_posts()):
                    $articles_query->the_post();
                    ?>
                    <div class="col-lg-6 col-md-6">
                        <a href="<?php the_permalink(); ?>" class="articles-box d-block" data-post-id="<?php echo get_the_ID(); ?>">

                            <div class="articles-img">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                } ?>

                                <div class="date">
                                    <div>
                                        <span> <?php echo get_the_date('d'); ?> </span>
                                        <small> <?php echo get_the_date('M'); ?> </small>
                                    </div>
                                </div>

                            </div>

                            <div class="content-box">
                                <h1 class="name"> <?php echo get_the_title(); ?> </h1>
                                <div class="description">
                                    <?php echo get_the_excerpt(); ?>
                                </div>
                                <div class="read-now btn-custom-animation">
                                    <span href="<?php the_permalink(); ?>" class="btn-read-now elementor-button"> Read More</span>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endwhile; ?>
            </div>

            <?php if ($articles_query->max_num_pages > 1): ?>
                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                    <div class="pagination-two">
                        <?php
                        echo paginate_links(array(
                            'total' => $articles_query->max_num_pages,
                            'current' => max(1, get_query_var('paged')),
                            'format' => '?paged=%#%',
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => '<img src="https://draftsite1.com/chwee-song/wp-content/uploads/2025/06/left-arrow.png" alt="Previous">',
                            'next_text' => '<img src="https://draftsite1.com/chwee-song/wp-content/uploads/2025/06/right-arrow.png" alt="Next">',
                            'end_size' => 2,
                            'mid_size' => 2
                        ));
                        ?>
                    </div>
                </div>
            <?php endif; ?>



        <?php else:
        echo 'No articles found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('articles', 'display_articles');


// list end------------





// on click add remove class -------------------
add_action('wp_footer', 'custom_searchpanel_script');
function custom_searchpanel_script()
{
    ?>
        <script>
            document.addEventListener("DOMContentLoaded", function () {
                // When search button is clicked
                document.querySelectorAll('.seachproduct').forEach(function (btn) {
                    btn.addEventListener('click', function () {
                        const panel = document.querySelector('.searchpanel');
                        if (panel) {
                            panel.classList.add('open');
                        }
                    });
                });

                // When close button is clicked
                document.querySelectorAll('.closepanel').forEach(function (btn) {
                    btn.addEventListener('click', function () {
                        const panel = document.querySelector('.searchpanel');
                        if (panel) {
                            panel.classList.remove('open');
                        }
                    });
                });
            });
        </script>
        <?php
}


// on click add remove class -------------------





// woocommerce start -------------


// Wrap WooCommerce product image in a div start ----------
add_action('woocommerce_before_shop_loop_item_title', 'wrap_product_image_in_div', 5);
function wrap_product_image_in_div()
{
    echo '<div class="custom-image-wrapper">';
}
add_action('woocommerce_before_shop_loop_item_title', 'close_product_image_div', 15);
function close_product_image_div()
{
    echo '</div>';
}
// Wrap WooCommerce product image in a div end ----------



// home page featured category ------
function display_featured_product_categories()
{
    $terms = get_terms(array(
        'taxonomy' => 'product_cat',
        'hide_empty' => false,
    ));

    if (empty($terms) || is_wp_error($terms)) {
        return '<p>No categories found.</p>';
    }

    ob_start();

    echo '<div class="featured-categories">';
    echo '<div class="row g-md-5 g-3">';

    foreach ($terms as $term) {
        $is_featured = get_field('is_featured', 'product_cat_' . $term->term_id);

        if ($is_featured) {
            $thumbnail_id = get_term_meta($term->term_id, 'thumbnail_id', true);
            $image_url = wp_get_attachment_url($thumbnail_id);
            ?>
                <div class="col-lg-3 col-md-3 col-6">
                    <div class="category-box">
                        <a href="<?php echo get_term_link($term); ?>" class="shop-now">
                            <?php if ($image_url): ?>
                                <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($term->name); ?>">
                            <?php endif; ?>
                            <h3><?php echo esc_html($term->name); ?></h3>
                        </a>
                    </div>
                </div>
                <?php
        }
    }

    echo '</div>';
    echo '</div>';

    return ob_get_clean();
}
add_shortcode('featured_categories', 'display_featured_product_categories');

// home page featured category ------


// product-categories start -----------------------------------------

function wpb_woocommerce_product_categories_accordion()
{
    // Get the current queried product category
    $queried_object = get_queried_object();
    $current_category_id = ($queried_object && isset($queried_object->term_id)) ? $queried_object->term_id : 0;

    // Get all parent categories of the current category
    $current_category_parents = [];
    if ($current_category_id) {
        $parent_categories = get_ancestors($current_category_id, 'product_cat');
        $current_category_parents = array_map('intval', $parent_categories);
    }

    // Recursive function to get subcategories with checkboxes
    function get_subcategories($parent_id, $level = 1, $current_category_id, $current_category_parents)
    {
        $args = array(
            'taxonomy' => 'product_cat',
            'orderby' => 'name',
            'order' => 'ASC',
            'parent' => $parent_id,
            'hide_empty' => false
        );
        $sub_categories = get_terms($args);

        if (!empty($sub_categories)) {
            echo '<ul class="list-unstyled ps-2">';
            foreach ($sub_categories as $sub_category) {
                $is_checked = ($sub_category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($sub_category->term_id == $current_category_id) ? 'current-category' : '';

                echo '<li class="' . $active_class . '">';
                echo '<div class="in-menu">';
                echo '<input type="checkbox" class="category-checkbox me-2" data-category-id="' . $sub_category->term_id . '" ' . $is_checked . '> ';

                echo '<a href="' . get_term_link($sub_category) . '">  <span class="customcheck"></span>' . $sub_category->name . '</a>';
                echo '</div>';
                get_subcategories($sub_category->term_id, $level + 1, $current_category_id, $current_category_parents);
                echo '</li>';
            }
            echo '</ul>';
        }
    }

    // Get main product categories (parent categories)
    $args = array(
        'taxonomy' => 'product_cat',
        'orderby' => 'name',
        'order' => 'ASC',
        'parent' => 0,
        'hide_empty' => false
    );
    $product_categories = get_terms($args);

    if ($product_categories) {
        ob_start();
        ?>
            <div class="accordion" id="productCategoriesAccordion">

                <?php
                $shop_page_url = wc_get_page_permalink('shop');
                $is_shop_page = is_shop();
                ?>

                <!-- <div class="accordion-item">
                    <div class="accordion-header <?php //echo $is_shop_page ? 'current-category' : ''; 
                            ?>">
                        <label>
                            <a href="<?php // echo esc_url($shop_page_url); 
                                    ?>" class="main-category">
                                All Product
                            </a>
                        </label>
                    </div>
                </div> -->


                <?php
                $i = 0;
                foreach ($product_categories as $category) {
                    $i++;

                    // Check if the category has subcategories
                    $sub_args = array(
                        'taxonomy' => 'product_cat',
                        'parent' => $category->term_id,
                        'hide_empty' => true
                    );
                    $sub_categories = get_terms($sub_args);
                    $has_subcategories = !empty($sub_categories);

                    // Determine if this category should be expanded
                    $is_checked = ($category->term_id == $current_category_id) ? 'checked' : '';
                    $active_class = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'current-category' : '';
                    $show_collapse = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'show' : '';
                    ?>
                    <div class="accordion-item <?php echo $active_class; ?>">
                        <div class="accordion-header d-flex align-items-center" id="heading<?php echo $i; ?>">
                            <label for="cat<?php echo $category->term_id; ?>">
                                <input type="checkbox" class="category-checkbox me-2" id="cat<?php echo $category->term_id; ?>"
                                    data-category-id="<?php echo $category->term_id; ?>" <?php echo $is_checked; ?>>

                                <a href="<?php echo get_term_link($category); ?>" class="main-category">
                                    <?php echo $category->name . ' <span class="count">(' . $category->count . ')</span>'; ?>
                                    <span class="customcheck"></span>
                                </a>
                            </label>

                            <?php if ($has_subcategories) { ?>
                                <button class="accordion-button ms-auto <?php echo ($show_collapse == '') ? 'collapsed' : ''; ?>"
                                    type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>"
                                    aria-expanded="<?php echo ($show_collapse) ? 'true' : 'false'; ?>"
                                    aria-controls="collapse<?php echo $i; ?>" data-category-id="<?php echo $category->term_id; ?>">
                                    <i class="fa fa-angle-down"></i>
                                </button>
                            <?php } ?>
                        </div>
                        <?php if ($has_subcategories) { ?>
                            <div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse <?php echo $show_collapse; ?>"
                                aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#productCategoriesAccordion">
                                <div class="accordion-body ps-0 pe-0">
                                    <?php get_subcategories($category->term_id, 1, $current_category_id, $current_category_parents); ?>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                    <?php
                }
                ?>
            </div>

            <script>
                document.addEventListener("DOMContentLoaded", function () {
                    var savedCategories = JSON.parse(localStorage.getItem("checkedCategories")) || [];

                    savedCategories.forEach(function (categoryId) {
                        var checkbox = document.querySelector('.category-checkbox[data-category-id="' + categoryId + '"]');
                        if (checkbox) {
                            checkbox.checked = true;
                        }
                    });

                    document.querySelectorAll(".category-checkbox").forEach(function (checkbox) {
                        checkbox.addEventListener("change", function () {
                            var categoryId = this.getAttribute("data-category-id");
                            if (this.checked) {
                                if (!savedCategories.includes(categoryId)) {
                                    savedCategories.push(categoryId);
                                }
                            } else {
                                savedCategories = savedCategories.filter(id => id !== categoryId);
                            }
                            localStorage.setItem("checkedCategories", JSON.stringify(savedCategories));
                        });
                    });

                    var activeCategory = localStorage.getItem("activeCategory");
                    if (activeCategory) {
                        var activeAccordion = document.querySelector('[data-category-id="' + activeCategory + '"]');
                        if (activeAccordion) {
                            var collapseElement = activeAccordion.getAttribute("data-bs-target");
                            document.querySelector(collapseElement).classList.add("show");
                            activeAccordion.classList.remove("collapsed");
                            activeAccordion.setAttribute("aria-expanded", "true");
                        }
                    }

                    document.querySelectorAll(".accordion-button").forEach(function (button) {
                        button.addEventListener("click", function () {
                            var categoryId = this.getAttribute("data-category-id");
                            if (document.querySelector(this.getAttribute("data-bs-target")).classList.contains("show")) {
                                localStorage.removeItem("activeCategory");
                            } else {
                                localStorage.setItem("activeCategory", categoryId);
                            }
                        });
                    });
                });
            </script>

            <style>
                .current-category>a {
                    font-weight: bold;
                    color: #ff6600;
                }

                .category-checkbox {
                    display: none;
                }

                span.customcheck {
                    background: #FFFFFF 0% 0% no-repeat padding-box;
                    border: 1px solid #BEC0C5;
                    border-radius: 0px;
                    width: 15px;
                    height: 15px;
                    position: relative;
                    margin-right: 2px;
                    margin-top: 0px;
                    top: 2px;
                    display: none;
                }

                .current-category [type=checkbox]:checked~a span.customcheck {
                    background: #000;
                    border-color: #000;
                }

                .current-category [type=checkbox]~a .customcheck:after {
                    content: "";
                    position: absolute;
                }

                .current-category a input:checked~.customcheck:after {
                    display: block;
                }

                .current-category a .customcheck:after {
                    left: 5px;
                    top: 2px;
                    width: 4px;
                    height: 8px;
                    border: solid white;
                    border-width: 0 2px 2px 0;
                    -webkit-transform: rotate(45deg);
                    -ms-transform: rotate(45deg);
                    transform: rotate(45deg);
                }
            </style>
            <?php
            return ob_get_clean();
    }
}

add_shortcode('product_categories_accordion', 'wpb_woocommerce_product_categories_accordion');

// product category for sidebar end -------------------------------



// product quantity button ----------------
add_action('wp_footer', 'custom_quantity_buttons_script');
function custom_quantity_buttons_script()
{
    if (!is_product())
        return;
    ?>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                const qtyContainers = document.querySelectorAll('.quantity');
                qtyContainers.forEach(qty => {
                    const input = qty.querySelector('input.qty');
                    if (!input) return;

                    // Remove existing buttons (if any)
                    if (qty.querySelector('.custom-plus')) return;

                    // Create buttons
                    const minus = document.createElement('button');
                    minus.type = 'button';
                    minus.innerHTML = '−';
                    minus.className = 'custom-minus';

                    const plus = document.createElement('button');
                    plus.type = 'button';
                    plus.innerHTML = '+';
                    plus.className = 'custom-plus';

                    // Insert buttons
                    qty.insertBefore(minus, input);
                    qty.appendChild(plus);

                    // Event listeners
                    minus.addEventListener('click', () => {
                        if (input.value > 1) input.value = parseInt(input.value) - 1;
                    });
                    plus.addEventListener('click', () => {
                        input.value = parseInt(input.value) + 1;
                    });
                });
            });
        </script>
        <?php
}
// product quantity button ----------------

// single related title change -------

add_filter('woocommerce_product_related_products_heading', 'custom_related_products_title');
function custom_related_products_title($title)
{
    return 'Similar Products';
}
// single related title change-------



// comman template added ---------
add_action('get_footer', 'insert_after_main_for_product_page');
function insert_after_main_for_product_page()
{
    if (is_product()) {
        echo '<div class="comman-section-shop">';
        echo do_shortcode('[hfe_template id="202"]');
        echo '</div>';
    }
}
// comman template added ---------


// add tag single page before title--------

add_action('woocommerce_single_product_summary', 'force_show_product_tags', 1);
function force_show_product_tags()
{
    $tags = wc_get_product_tag_list(get_the_ID(), ' ', '<div class="product-tags">', '</div>');
    if ($tags) {
        echo $tags;
    }
}
// add tag single page before title--------


// add section single page ----------





// add section single page ----------

add_action('woocommerce_after_single_product_summary', 'add_custom_description_video_section', 15);

function add_custom_description_video_section() {
    global $post;

    $description = apply_filters('the_content', get_the_content());

 
    $video_file = get_field('product_video'); 
    $video_url = get_field('video_url'); 

    if ($description || $video_file || $video_url): ?>
        <div class="custom-product-section">
            <div class="container">
                <div class="row g-md-5 g-3">

                    <?php if ($description): ?>
                        <div class="col-md-6">
                            <div class="product-description">
                                <?php echo $description; ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if ($video_file): ?>
                        <div class="col-md-6">
                            <div class="product-video">
                                <div class="video-wrapper">
                                    <video width="100%" height="auto" controls>
                                        <source src="<?php echo esc_url($video_file); ?>" type="video/mp4">
                                    </video>
                                </div>
                            </div>
                        </div>
                    <?php elseif ($video_url): ?>
                        <div class="col-md-6">
                            <div class="product-video">
                                <div class="video-wrapper">
                                    <?php
                                    if (preg_match('/youtu\.be\/([^\?]+)/', $video_url, $matches)) {
                                        $video_id = $matches[1];
                                    } elseif (preg_match('/youtube\.com.*[?&]v=([^&]+)/', $video_url, $matches)) {
                                        $video_id = $matches[1];
                                    }

                                    if (!empty($video_id)) {
                                        $embed_url = 'https://www.youtube.com/embed/' . $video_id;
                                        echo '<iframe width="100%" height="315" src="' . esc_url($embed_url) . '" frameborder="0" allowfullscreen></iframe>';
                                    } else {
                                        echo '<p>Invalid video URL.</p>';
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    <?php endif;
}


// add section single page ----------

// add section single page ----------



// recent woo product -------

function recent_products_title_list_shortcode($atts)
{
    $atts = shortcode_atts(array(
        'limit' => 5,
    ), $atts, 'recent_products_list');

    $args = array(
        'post_type' => 'product',
        'posts_per_page' => intval($atts['limit']),
        'orderby' => 'date',
        'order' => 'DESC',
        'post_status' => 'publish',
    );

    $products = new WP_Query($args);

    ob_start();

    if ($products->have_posts()) {
        echo '<ul class="recent-product-title-list">';
        while ($products->have_posts()) {
            $products->the_post();
            echo '<li><a href="' . get_permalink() . '">' . get_the_title() . '</a></li>';
        }
        echo '</ul>';
    } else {
        echo '<p>No recent products found.</p>';
    }

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('recent_products_list', 'recent_products_title_list_shortcode');

// recent woo product -------

// woccommerce end -----------------


















// validation woocommerce start --------------------

add_action('woocommerce_save_account_details_errors', 'validate_my_account_fields', 10, 1);

function validate_my_account_fields($errors)
{
    // Validate First Name
    if (isset($_POST['account_first_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_first_name'])) {
        $errors->add('validation', __('Allowed characters for First Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Last Name
    if (isset($_POST['account_last_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_last_name'])) {
        $errors->add('validation', __('Allowed characters for Last Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Display Name
    if (isset($_POST['account_display_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_display_name'])) {
        $errors->add('validation', __('Allowed characters for Display Name are alphabets and spaces only.', 'woocommerce'));
    }
}




add_action('woocommerce_after_save_address_validation', 'validate_billing_address_fields', 10, 2);

function validate_billing_address_fields($user_id, $address_type)
{
    if ('billing' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $billing_first_name = isset($_POST['billing_first_name']) ? sanitize_text_field($_POST['billing_first_name']) : '';
        $billing_last_name = isset($_POST['billing_last_name']) ? sanitize_text_field($_POST['billing_last_name']) : '';
        $billing_city = isset($_POST['billing_city']) ? sanitize_text_field($_POST['billing_city']) : '';
        $billing_address_1 = isset($_POST['billing_address_1']) ? sanitize_text_field($_POST['billing_address_1']) : '';

        $billing_postcode = isset($_POST['billing_postcode']) ? sanitize_text_field($_POST['billing_postcode']) : '';
        $billing_email = isset($_POST['billing_email']) ? sanitize_email($_POST['billing_email']) : '';

        // Validate Billing First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_first_name)) {
            $validation_errors[] = __('Allowed characters for Billing First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_last_name)) {
            $validation_errors[] = __('Allowed characters for Billing Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_city)) {
            $validation_errors[] = __('Allowed characters for Billing City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $billing_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $billing_postcode)) {
            $validation_errors[] = __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate Billing Email (Basic Email validation)
        if (!is_email($billing_email)) {
            $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}








add_action('woocommerce_after_save_address_validation', 'validate_shipping_address_fields', 10, 2);

function validate_shipping_address_fields($user_id, $address_type)
{
    if ('shipping' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $shipping_first_name = isset($_POST['shipping_first_name']) ? sanitize_text_field($_POST['shipping_first_name']) : '';
        $shipping_last_name = isset($_POST['shipping_last_name']) ? sanitize_text_field($_POST['shipping_last_name']) : '';
        $shipping_city = isset($_POST['shipping_city']) ? sanitize_text_field($_POST['shipping_city']) : '';
        $shipping_address_1 = isset($_POST['shipping_address_1']) ? sanitize_text_field($_POST['shipping_address_1']) : '';

        $shipping_postcode = isset($_POST['shipping_postcode']) ? sanitize_text_field($_POST['shipping_postcode']) : '';
        //  $shipping_email = isset($_POST['shipping_email']) ? sanitize_email($_POST['shipping_email']) : '';

        // Validate shipping First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_first_name)) {
            $validation_errors[] = __('Allowed characters for shipping First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_last_name)) {
            $validation_errors[] = __('Allowed characters for shipping Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_city)) {
            $validation_errors[] = __('Allowed characters for shipping City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $shipping_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $shipping_postcode)) {
            $validation_errors[] = __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate shipping Email (Basic Email validation)
        // if (!is_email($shipping_email)) {
        //     $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        // }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}




// validation woocommerce end --------------------




//  form validation start ---------------------

// Validate text fields (only alphabets allowed)
add_filter('wpcf7_validate_text', 'alpha_validation_filter_text', 20, 2);
add_filter('wpcf7_validate_text*', 'alpha_validation_filter_text', 20, 2);

function alpha_validation_filter_text($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('names' === $tag->name) {
        $name_of_the_input = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input)) {
            $result->invalidate($tag, "Allowed characters are Alphabets only.");
        }
    }

    if ('address' === $tag->name) {
        $name_of_the_input = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        // Allowed characters: alphabets, spaces, common punctuation marks
        if (!preg_match('/^[a-zA-Z0-9\s.,!?()-]+$/', $name_of_the_input)) {
            $result->invalidate($tag, "Address contains invalid characters. Only letters, numbers, spaces, and punctuation are allowed.");
        }
    }

    if ('subject' === $tag->name) {
        $name_of_the_input = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        // Allowed characters: alphabets, spaces, common punctuation marks
        if (!preg_match('/^[a-zA-Z0-9\s.,!?()-]+$/', $name_of_the_input)) {
            $result->invalidate($tag, "subject contains invalid characters. Only letters, numbers, spaces, and punctuation are allowed.");
        }
    }

    return $result;
}

// Validate phone number (must be exactly 10 digits)
add_filter('wpcf7_validate_tel', 'numeric_phone_validation_filter', 20, 2);
add_filter('wpcf7_validate_tel*', 'numeric_phone_validation_filter', 20, 2);

function numeric_phone_validation_filter($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('phone' === $tag->name) {
        $phone_number = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!preg_match('/^\d{8}$/', $phone_number)) {
            $result->invalidate($tag, "Phone number must contain exactly 8 digits.");
        }
    }

    return $result;
}



// Validate email (must be a valid email format)
add_filter('wpcf7_validate_email', 'validate_email_filter', 20, 2);
add_filter('wpcf7_validate_email*', 'validate_email_filter', 20, 2);

function validate_email_filter($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('email' === $tag->name) {
        $email = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $result->invalidate($tag, "Please enter a valid email address.");
        }
    }

    return $result;
}


// Validate textarea field (message)
add_filter('wpcf7_validate_textarea', 'validate_textarea_filter', 20, 2);
add_filter('wpcf7_validate_textarea*', 'validate_textarea_filter', 20, 2);

function validate_textarea_filter($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('message' === $tag->name) {
        $message = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        // Allowed characters: alphabets, spaces, common punctuation marks
        if (!preg_match('/^[a-zA-Z0-9\s.,!?()-]+$/', $message)) {
            $result->invalidate($tag, "Message contains invalid characters. Only letters, numbers, spaces, and punctuation are allowed.");
        }

        // Min 10 characters, Max 500 characters
        if (strlen($message) < 10 || strlen($message) > 500) {
            $result->invalidate($tag, "Message must be between 10 and 500 characters.");
        }
    }

    return $result;
}


//  form validation end ------------------------





?>