<?php
defined('ABSPATH') || exit;

get_header('shop');
?>
<div class="shop-page">






    <?php
    $category_id = get_queried_object_id(); // Get current WooCommerce category ID
    $slider_items = get_field('slider_item', 'product_cat_' . $category_id);

    if (!empty($slider_items)):
        ?>
        <div class="container">
            <div id="demo2" class="carousel slide product-slider" data-bs-ride="carousel">
                <div class="carousel-inner">
                    <?php foreach ($slider_items as $index => $item):
                        $slide_image = esc_url($item['slide_image']);
                        $title_offer = esc_html($item['title_offer']);
                        $description = esc_html($item['desription']);
                        $code = esc_html($item['code']);
                        ?>
                        <div class="carousel-item <?php echo $index === 0 ? 'active' : ''; ?>">
                            <div class="row align-items-center">
                                <div class="col-lg-6 col-md-6">
                                    <img fetchpriority="high" width="820" height="400" src="<?php echo $slide_image; ?>"
                                        class="d-block w-100 wp-post-image" alt="<?php echo $title_offer; ?>"
                                        decoding="async" />
                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <div class="product-caption">
                                        <h3><?php echo $title_offer; ?></h3>
                                        <p><?php echo $description; ?></p>
                                        <a href="javascript:void(0);" class="elementor-button" onclick="copyToClipboard(this)">
                                            Code: <span><?php echo $code; ?></span>
                                        </a>

                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

                <!-- Indicators -->
                <?php if ($index > 1): ?>
                    <div class="carousel-indicators">
                        <?php foreach ($slider_items as $index => $item): ?>
                            <button type="button" data-bs-target="#demo2" data-bs-slide-to="<?php echo $index; ?>"
                                class="<?php echo $index === 0 ? 'active' : ''; ?>"></button>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>


    <script>
        function copyToClipboard(element) {
    var codeText = element.querySelector("span").innerText; // Get the text inside the span
    navigator.clipboard.writeText(codeText).then(function() {
        alert("Code copied: " + codeText); // Optional: Show confirmation
    }).catch(function(err) {
        console.error("Failed to copy text: ", err);
    });
}

    </script>




    <div class="shop-inner-section">

        <div class="container">
            <div class="fiter_shop">
                <div class="row g-md-3 g-3">
                    <div class="col-md-4">
                        <?php
                        if (function_exists('woocommerce_result_count')) {
                            woocommerce_result_count();
                        }
                        ?>
                    </div>
                    <div class="col-md-3">
                        <?php
                        if (function_exists('woocommerce_catalog_ordering')) {
                            woocommerce_catalog_ordering();
                        }
                        ?>

                    </div>
                    <div class="col-md-3">

                        <div class="dropdown dropdown-price-filter">
                            <a class="btn  dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown"
                                aria-expanded="false">
                                Price
                            </a>

                            <ul class="dropdown-menu">
                                <li>
                                    <?php echo do_shortcode("[woof  sid='generator_67e2560627111' autohide='0' autosubmit='-1' is_ajax='0' ajax_redraw='0' start_filtering_btn='0' btn_position='b' dynamic_recount='-1' hide_terms_count_txt='0' mobile_mode='0' ]"); ?>
                                </li>
                            </ul>
                        </div>


                    </div>
                    <div class="col-md-2">
                        <form method="GET" action="<?php echo esc_url(wc_get_page_permalink('shop')); ?>">
                            <select name="filter" class="onsalefilter" onchange="this.form.submit()">
                                <option value="">All</option>
                                <option value="on-sale" <?php selected(isset($_GET['filter']) && $_GET['filter'] === 'on-sale'); ?>>On Sale</option>
                            </select>
                        </form>
                    </div>
                </div>
            </div>

            <div class="row g-md-3">
                <div class="col-md-12">
                    <div class="custom-product-grid" id="products">
                        <?php if (woocommerce_product_loop()): ?>
                            <?php
                            do_action('woocommerce_before_shop_loop');
                            woocommerce_product_loop_start();
                            if (wc_get_loop_prop('total')) {
                                while (have_posts()) {
                                    the_post();
                                    do_action('woocommerce_shop_loop');
                                    wc_get_template_part('content', 'product');
                                }
                            }
                            woocommerce_product_loop_end();
                            do_action('woocommerce_after_shop_loop');
                            ?>
                        <?php else: ?>
                            <?php do_action('woocommerce_no_products_found'); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<?php
do_action('woocommerce_after_main_content');

get_footer('shop'); ?>


<style>
    .woocommerce-page .content-area {
        display: none;
    }
</style>