<?php
// Enqueue the parent theme's stylesheet

function hello_elementor_child_enqueue_styles()
{
    wp_enqueue_style('hello-elementor-parent-style', get_template_directory_uri() . '/../hello-elementor-child/style.css');
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles');


// Enqueue Booststrap 
function enqueue_bootstrap()
{
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js', array('jquery'), null, true);
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');

// custom code






// Home slider Start --------------------------------------------
function display_banner_home($atts)
{
    $args = array(
        'post_type' => 'main-slider',
    );

    $mainslider_query = new WP_Query($args);

    ob_start();

    if ($mainslider_query->have_posts()):
        $total_slides = $mainslider_query->post_count;
        ?>
        <div id="demo" class="carousel slide hero-banner" data-bs-ride="carousel">
            <div class="carousel-inner">
                <?php
                $first = true;
                while ($mainslider_query->have_posts()):
                    $mainslider_query->the_post(); ?>

                    <div class="carousel-item <?php echo $first ? 'active' : ''; ?>">
                        <?php if (has_post_thumbnail()) {
                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                        } ?>
                        <div class="carousel-caption">
                            <h3><?php the_title(); ?></h3>
                            <div> <?php the_content(); ?> </div>
                            <div class="btnlight">
                                <?php
                                $links = get_field('button_link');
                                if ($links) {
                                    $link_url = $links['url'];
                                    $link_title = $links['title'];
                                    ?>
                                    <a href="<?php echo esc_url($link_url); ?>"
                                        class="elementor-button"><?php echo esc_html($link_title); ?></a>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <?php
                    $first = false;
                endwhile; ?>
            </div>

            <!-- Indicators/dots -->
            <?php if ($total_slides > 1): ?>
                <div class="carousel-indicators">
                    <?php for ($i = 0; $i < $total_slides; $i++): ?>
                        <button type="button" data-bs-target="#demo" data-bs-slide-to="<?php echo $i; ?>"
                            class="<?php echo $i === 0 ? 'active' : ''; ?>">
                            <?php //echo str_pad($i + 1, 2, '0', STR_PAD_LEFT); ?>
                        </button>
                    <?php endfor; ?>
                </div>
            <?php endif; ?>

            <?php if ($total_slides > 1): ?>
                <!-- Left and right controls/icons -->
                <span class="carousel-control-prev" data-bs-target="#demo" data-bs-slide="prev">
                    <img src="https://draftsite1.com/crius-bake/wp-content/uploads/2025/03/Brown-Arrow-1.png" alt="">
                </span>
                <span class="carousel-control-next" data-bs-target="#demo" data-bs-slide="next">
                    <img src="https://draftsite1.com/crius-bake/wp-content/uploads/2025/03/Brown-Arrow.png" alt="">
                </span>
            <?php endif; ?>


        </div>

    <?php else: ?>
        <div>No Slider found.</div>
    <?php endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('banner_home', 'display_banner_home');


// Home slider end --------------------------------------------







// Product Offer slider Start --------------------------------------------
function display_prodcuct_offer($atts)
{
    $args = array(
        'post_type' => 'product-offer',
    );

    $mainslider_query = new WP_Query($args);

    ob_start();

    if ($mainslider_query->have_posts()):
        $total_slides = $mainslider_query->post_count;
        ?>
        <div class="container">
            <div id="demo2" class="carousel slide product-slider" data-bs-ride="carousel">
                <div class="carousel-inner">
                    <?php
                    $first = true;
                    while ($mainslider_query->have_posts()):
                        $mainslider_query->the_post(); ?>

                        <div class="carousel-item <?php echo $first ? 'active' : ''; ?>">

                            <div class="row align-items-center">
                                <div class="col-lg-6 col-md-6">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                    } ?>

                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <div class="product-caption">
                                        <h3><?php the_title(); ?></h3>
                                        <p><?php the_content(); ?> </p>

                                        <?php
                                        $code = get_field('code');
                                        if ($code):
                                            echo '<a href="#" class="elementor-button">';
                                            echo 'Code: ' . $code;
                                            echo '</a>';
                                        endif;
                                        ?>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <?php
                        $first = false;
                    endwhile; ?>
                </div>

                <!-- Indicators/dots -->
                <?php if ($total_slides > 1): ?>
                    <div class="carousel-indicators">
                        <?php for ($i = 0; $i < $total_slides; $i++): ?>
                            <button type="button" data-bs-target="#demo2" data-bs-slide-to="<?php echo $i; ?>"
                                class="<?php echo $i === 0 ? 'active' : ''; ?>">
                                <?php //echo str_pad($i + 1, 2, '0', STR_PAD_LEFT); ?>
                            </button>
                        <?php endfor; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>

    <?php else: ?>
        <div>No Slider found.</div>
    <?php endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('prodcuct_offer', 'display_prodcuct_offer');


// Product Offer  slider end --------------------------------------------




function change_related_products_heading($translated_text, $text, $domain)
{
    if ('Related products' === $text) {
        $translated_text = __('You May Also Like', 'your-text-domain');
    }
    return $translated_text;
}
add_filter('gettext', 'change_related_products_heading', 20, 3);






// Modify WooCommerce query to show only sale products start ------
function filter_woocommerce_query( $query ) {
    if ( !is_admin() && $query->is_main_query() && (is_shop() || is_product_category()) && isset($_GET['filter']) && $_GET['filter'] === 'on-sale' ) {
        $query->set('meta_query', array(
            array(
                'key'     => '_sale_price',
                'value'   => '',
                'compare' => '!=',
            )
        ));
    }
}
add_action('pre_get_posts', 'filter_woocommerce_query');
// Modify WooCommerce query to show only sale products end -------


remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );

add_action( 'woocommerce_single_product_summary', function() {
    woocommerce_breadcrumb();
}, 1 );




add_filter('woocommerce_single_product_image_thumbnail_html', function($html, $attachment_id) {
    global $product;
    
    $attachment_ids = $product->get_gallery_image_ids();

    if (empty($attachment_ids)) {
        return ''; // Hide the thumbnail gallery if no images are found
    }

    return $html;
}, 10, 2);




function custom_woocommerce_product_faq_section() {
    global $post;
    $faqs = get_field('product_faqs', $post->ID);

    if (!empty($faqs)) {
        echo '<div class="woocommerce-product-faq">';
        echo '<div class="accordion" id="faqAccordion">';

        $count = 1;
        foreach ($faqs as $faq) {
            $is_first = ($count === 1) ? 'show' : '';
            $is_expanded = ($count === 1) ? 'true' : 'false';
            $collapsed = ($count === 1) ? '' : 'collapsed';

            echo '<div class="accordion-item">';
            echo '<h2 class="accordion-header">';
            echo '<button class="accordion-button ' . $collapsed . '" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse' . $count . '" aria-expanded="' . $is_expanded . '" aria-controls="faqCollapse' . $count . '">';
            echo esc_html($faq['question']);
            echo '</button>';
            echo '</h2>';
            echo '<div id="faqCollapse' . $count . '" class="accordion-collapse collapse ' . $is_first . '" data-bs-parent="#faqAccordion">';
            echo '<div class="accordion-body">';
            echo esc_html($faq['answer']);
            echo '</div>';
            echo '</div>';
            echo '</div>';

            $count++;
        }

        echo '</div>'; // Close accordion
        echo '</div>'; // Close FAQ section
    }
}
add_action('woocommerce_after_add_to_cart_form', 'custom_woocommerce_product_faq_section', 15);







// cf7 validations---------------------------start ------------------



// Validate text fields (only alphabets allowed)
add_filter( 'wpcf7_validate_text', 'alpha_validation_filter_text', 20, 2 );
add_filter( 'wpcf7_validate_text*', 'alpha_validation_filter_text', 20, 2 );

function alpha_validation_filter_text( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'names' === $tag->name ) {
        $name_of_the_input = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input) ) {
            $result->invalidate( $tag, "Allowed characters are Alphabets only." );
        }
    }

    return $result;
}

// Validate phone number (must be exactly 10 digits)
add_filter( 'wpcf7_validate_tel', 'numeric_phone_validation_filter', 20, 2 );
add_filter( 'wpcf7_validate_tel*', 'numeric_phone_validation_filter', 20, 2 );

function numeric_phone_validation_filter( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'phone' === $tag->name ) {
        $phone_number = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! preg_match( '/^\d{10}$/', $phone_number ) ) {
            $result->invalidate( $tag, "Phone number must contain exactly 10 digits." );
        }
    }

    return $result;
}




// Validate text fields (only alphabets allowed)
add_filter( 'wpcf7_validate_text', 'alpha_validation_filter_subject', 20, 2 );
add_filter( 'wpcf7_validate_text*', 'alpha_validation_filter_subject', 20, 2 );

function alpha_validation_filter_subject( $result, $tag ) {
    if ( ! is_object( $tag ) || empty( $tag->name ) ) {
        return $result;
    }

    if ( 'subject' === $tag->name ) {
        $name_of_the_input = isset( $_POST[$tag->name] ) ? sanitize_text_field( $_POST[$tag->name] ) : '';

        if ( ! preg_match( '/^[a-zA-Z\s]+$/', $name_of_the_input ) ) {
            $result->invalidate( $tag, "Allowed characters are alphabets only." );
        }
    }

    return $result;
}




// Validate email (must be a valid email format)
add_filter( 'wpcf7_validate_email', 'validate_email_filter', 20, 2 );
add_filter( 'wpcf7_validate_email*', 'validate_email_filter', 20, 2 );

function validate_email_filter( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'email' === $tag->name ) {
        $email = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! filter_var( $email, FILTER_VALIDATE_EMAIL ) ) {
            $result->invalidate( $tag, "Please enter a valid email address." );
        }
    }

    return $result;
}


// Validate textarea field (message)
add_filter( 'wpcf7_validate_textarea', 'validate_textarea_filter', 20, 2 );
add_filter( 'wpcf7_validate_textarea*', 'validate_textarea_filter', 20, 2 );

function validate_textarea_filter( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'message' === $tag->name ) {
        $message = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        // Allowed characters: alphabets, spaces, common punctuation marks
        if ( ! preg_match( '/^[a-zA-Z0-9\s.,!?()-]+$/', $message ) ) {
            $result->invalidate( $tag, "Message contains invalid characters. Only letters, numbers, spaces, and punctuation are allowed." );
        }

        // Min 10 characters, Max 500 characters
        if ( strlen( $message ) < 10 || strlen( $message ) > 500 ) {
            $result->invalidate( $tag, "Message must be between 10 and 500 characters." );
        }
    }

    return $result;
}








// validation woocommerce start --------------------

add_action('woocommerce_save_account_details_errors', 'validate_my_account_fields', 10, 1);

function validate_my_account_fields($errors)
{
    // Validate First Name
    if (isset($_POST['account_first_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_first_name'])) {
        $errors->add('validation', __('Allowed characters for First Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Last Name
    if (isset($_POST['account_last_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_last_name'])) {
        $errors->add('validation', __('Allowed characters for Last Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Display Name
    if (isset($_POST['account_display_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_display_name'])) {
        $errors->add('validation', __('Allowed characters for Display Name are alphabets and spaces only.', 'woocommerce'));
    }
}




add_action('woocommerce_after_save_address_validation', 'validate_billing_address_fields', 10, 2);

function validate_billing_address_fields($user_id, $address_type)
{
    if ('billing' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $billing_first_name = isset($_POST['billing_first_name']) ? sanitize_text_field($_POST['billing_first_name']) : '';
        $billing_last_name = isset($_POST['billing_last_name']) ? sanitize_text_field($_POST['billing_last_name']) : '';
        $billing_city = isset($_POST['billing_city']) ? sanitize_text_field($_POST['billing_city']) : '';
        $billing_address_1 = isset($_POST['billing_address_1']) ? sanitize_text_field($_POST['billing_address_1']) : '';

        $billing_postcode = isset($_POST['billing_postcode']) ? sanitize_text_field($_POST['billing_postcode']) : '';
        $billing_email = isset($_POST['billing_email']) ? sanitize_email($_POST['billing_email']) : '';

        // Validate Billing First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_first_name)) {
            $validation_errors[] = __('Allowed characters for Billing First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_last_name)) {
            $validation_errors[] = __('Allowed characters for Billing Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_city)) {
            $validation_errors[] = __('Allowed characters for Billing City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $billing_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $billing_postcode)) {
            $validation_errors[] =  __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate Billing Email (Basic Email validation)
        if (!is_email($billing_email)) {
            $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}








add_action('woocommerce_after_save_address_validation', 'validate_shipping_address_fields', 10, 2);

function validate_shipping_address_fields($user_id, $address_type)
{
    if ('shipping' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $shipping_first_name = isset($_POST['shipping_first_name']) ? sanitize_text_field($_POST['shipping_first_name']) : '';
        $shipping_last_name = isset($_POST['shipping_last_name']) ? sanitize_text_field($_POST['shipping_last_name']) : '';
        $shipping_city = isset($_POST['shipping_city']) ? sanitize_text_field($_POST['shipping_city']) : '';
        $shipping_address_1 = isset($_POST['shipping_address_1']) ? sanitize_text_field($_POST['shipping_address_1']) : '';

        $shipping_postcode = isset($_POST['shipping_postcode']) ? sanitize_text_field($_POST['shipping_postcode']) : '';
      //  $shipping_email = isset($_POST['shipping_email']) ? sanitize_email($_POST['shipping_email']) : '';

        // Validate shipping First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_first_name)) {
            $validation_errors[] = __('Allowed characters for shipping First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_last_name)) {
            $validation_errors[] = __('Allowed characters for shipping Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_city)) {
            $validation_errors[] = __('Allowed characters for shipping City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $shipping_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $shipping_postcode)) {
            $validation_errors[] =  __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate shipping Email (Basic Email validation)
        // if (!is_email($shipping_email)) {
        //     $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        // }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}




// validation woocommerce end --------------------









add_filter( 'woocommerce_package_rates', 'custom_hide_standard_delivery_when_free_shipping', 10, 2 );

function custom_hide_standard_delivery_when_free_shipping( $rates, $package ) {
    $free = false;

    // Loop through the available rates
    foreach ( $rates as $rate_id => $rate ) {
        if ( 'free_shipping' === $rate->method_id ) {
            $free = true;
            break;
        }
    }

    // If free shipping is available, remove other methods like 'flat_rate'
    if ( $free ) {
        foreach ( $rates as $rate_id => $rate ) {
            if ( 'flat_rate' === $rate->method_id ) {
                unset( $rates[ $rate_id ] );
            }
        }
    }

    return $rates;
}





