jQuery(document).ready(function($){
    $(document).on('click', '#gallery-pagination a', function(e){
        e.preventDefault();

        let page = 1;
        let href = $(this).attr('href');
        let match = href.match(/page=(\d+)/);
        if(match) page = match[1];

        $.ajax({
            url: gallery_ajax.ajaxurl,
            type: 'POST',
            data: {
                action: 'load_event_gallery',
                post_id: gallery_ajax.post_id,
                paged: page
            },
            beforeSend: function(){
                $('#gallery-wrapper').css('opacity','0.5');
            },
            success: function(response){
                $('#gallery-wrapper').html(response.html);
                $('#gallery-pagination').html(response.pagination);
                $('#gallery-wrapper').css('opacity','1');

                // ✅ Re-init glightbox after replacing HTML
                if(typeof GLightbox !== 'undefined'){
                    const lightbox = GLightbox({
                        selector: '.glightbox'
                    });
                }
            }
        });
    });
});
