<?php get_header(); ?>

<div class="single-detail">

    <div class="container">
        <?php
        if (have_posts()):
            while (have_posts()):
                the_post();
                ?>
                <div class="row py-5 mb-5 justify-content-between">
                    <div class="col-12">

                        <?php

                        function custom_breadcrumbs()
                        {
                            // Get the post object
                            global $post;

                            // Start the breadcrumb HTML
                            $breadcrumbs = '<div class="breadcrumbs-article mb-5">';

                            // Home link
                            $breadcrumbs .= '<a href="' . home_url() . '">Home</a> / ';

                            // Articles link
                            $breadcrumbs .= '<a href="' . get_permalink(get_page_by_path('prepaid')) . '">  Prepaid  </a> / ';

                            $breadcrumbs .= '<a href="' . get_permalink(get_page_by_path('prepaid')) . '">  Past Events  </a> / ';

                            // Post title
                            if (is_single()) {
                                $breadcrumbs .= get_the_title();
                            }

                            // Close the breadcrumb HTML
                            $breadcrumbs .= '</div>';

                            echo $breadcrumbs;
                        }

                        ?>
                        <?php custom_breadcrumbs(); ?>


                    </div>

                    <div class="col-12">
                        <h2 class="event-title mb-4"><?php echo the_title(); ?></h2>
                    </div>

                    <div class="row g-3 content-area" id="gallery-wrapper">
                        <?php
                        $images = get_field('gallery_images');
                        if (!empty($images)) {
                            $per_page = 9;
                            $paged = 1;
                            $total_images = count($images);
                            $total_pages = ceil($total_images / $per_page);

                            $paged_images = array_slice($images, 0, $per_page);

                            foreach ($paged_images as $image): ?>
                                <div class="col-md-4">
                                    <div class="event-box">
                                        <div class="event-img">
                                            <a href="<?php echo esc_url($image['url']); ?>" class="glightbox" data-gallery="acf-gallery"
                                                data-title="<?php echo esc_attr($image['title']); ?>">
                                                <img src="<?php echo esc_url($image['url']); ?>"
                                                    alt="<?php echo esc_attr($image['alt']); ?>" class="w-100">
                                                <div class="overlay">
                                                    <img src="https://draftsite1.com/goldcard/wp-content/uploads/2025/08/icon-plus-circle.svg"
                                                        alt="" width="60">
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php } ?>
                    </div>

                    <?php if ($total_pages > 1): ?>
                        <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                            <div class="pagination-style-one" id="gallery-pagination">
                                <?php
                                echo paginate_links(array(
                                    'base' => '%_%',
                                    'format' => '#page=%#%', // anchor format (AJAX use karega)
                                    'current' => $paged,
                                    'total' => $total_pages,
                                    'prev_text' => '<i class="eicon-caret-left"></i>',
                                    'next_text' => '<i class="eicon-caret-right"></i>',
                                    'end_size' => 2,
                                    'mid_size' => 2,
                                ));
                                ?>
                            </div>
                        </div>
                    <?php endif; ?>








                </div>

                <?php
            endwhile;
        else:
            echo 'No post found.';
        endif;
        ?>

    </div>

</div>




<?php get_footer(); ?>