<?php

function hello_elementor_child_enqueue_styles()
{
    wp_enqueue_style('hello-elementor-parent-style', get_template_directory_uri() . '/../hello-elementor-child/style.css');
    wp_enqueue_style('hello-elementor-parent-ecommerce', get_template_directory_uri() . '/../hello-elementor-child/ecommerce.css');
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles');


// Enqueue Booststrap 
function enqueue_bootstrap()
{
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js', array('jquery'), null, true);

}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');


//  Slick carousel script and styles
function enqueue_slick_scripts()
{
    wp_enqueue_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js', array('jquery'), null, true);
    wp_enqueue_style('slick-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_slick_scripts');


function enqueue_custom_script()
{
    wp_enqueue_script(
        'custom-script',
        get_template_directory_uri() . '../../hello-elementor-child/custom-script.js',
        array('jquery'),
        null,
        true
    );
}
add_action('wp_enqueue_scripts', 'enqueue_custom_script');



// custom code



// blog related start --------------------

function get_related_articles($post_id, $number_of_posts = 5)
{

    $args = array(
        'post_type' => 'post',
        'post__not_in' => array($post_id),
        'posts_per_page' => $number_of_posts,
        'ignore_sticky_posts' => 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );

    return get_posts($args);

    $related_posts = get_related_articles(get_the_ID());

    // If not enough related posts by category, get related posts by tag
    if (count($related_posts) < $number_of_posts) {
        $tags = wp_get_post_tags($post_id);
        if ($tags) {
            $tag_ids = array();
            foreach ($tags as $tag) {
                $tag_ids[] = $tag->term_id;
            }
            $args = array(
                'tag__in' => $tag_ids,
                'post__not_in' => array_merge(array($post_id), wp_list_pluck($related_posts, 'ID')),
                'posts_per_page' => $number_of_posts - count($related_posts),
                'ignore_sticky_posts' => 1,
            );
            $more_related_posts = get_posts($args);
            $related_posts = array_merge($related_posts, $more_related_posts);
        }
    }

    return $related_posts;
}

// blog related end --------------------




// woocommerce code start here ---------------------


//  WooCommerce product  image wrap  ----------
add_action('woocommerce_before_shop_loop_item_title', 'wrap_product_image_in_div', 5);
function wrap_product_image_in_div()
{
    echo '<div class="product-image-wrapper">';
}
add_action('woocommerce_before_shop_loop_item_title', 'close_product_image_div', 15);
function close_product_image_div()
{
    echo '</div>';
}
//  WooCommerce product image wrap ----------



function change_related_products_heading($translated_text, $text, $domain)
{
    if ('Related products' === $text) {
        $translated_text = __('Similar Products', 'your-text-domain');
    }
    return $translated_text;
}
add_filter('gettext', 'change_related_products_heading', 20, 3);






// product-categories start ----------------------------------------- 
function wpb_woocommerce_product_categories_accordion()
{
    // Get the current queried product category
    $queried_object = get_queried_object();
    $current_category_id = ($queried_object && isset($queried_object->term_id)) ? $queried_object->term_id : 0;

    // Get all parent categories of the current category
    $current_category_parents = [];
    if ($current_category_id) {
        $parent_categories = get_ancestors($current_category_id, 'product_cat');
        $current_category_parents = array_map('intval', $parent_categories);
    }

    // Recursive function to get subcategories with checkboxes
    function get_subcategories($parent_id, $level = 1, $current_category_id, $current_category_parents)
    {
        $args = array(
            'taxonomy' => 'product_cat',
            'orderby' => 'name',
            'order' => 'ASC',
            'parent' => $parent_id,
            'hide_empty' => true
        );
        $sub_categories = get_terms($args);

        if (!empty($sub_categories)) {
            echo '<ul class="list-unstyled ps-2">';
            foreach ($sub_categories as $sub_category) {
                $is_checked = ($sub_category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($sub_category->term_id == $current_category_id) ? 'current-category' : '';

                echo '<li class="' . $active_class . '">';
                echo '<div class="in-menu">';
                echo '<input type="checkbox" class="category-checkbox me-2" data-category-id="' . $sub_category->term_id . '" ' . $is_checked . '> ';
                echo '<a href="' . get_term_link($sub_category) . '">  
                    <span class="customcheck"></span>' . $sub_category->name . ' 
                    
                </a>';

                echo '</div>';
                get_subcategories($sub_category->term_id, $level + 1, $current_category_id, $current_category_parents);
                echo '</li>';
            }
            echo '</ul>';
        }
    }

    // Get main product categories (parent categories)
    $args = array(
        'taxonomy' => 'product_cat',
        'orderby' => 'name',
        'order' => 'ASC',
        'parent' => 0,
        'hide_empty' => true
    );
    $product_categories = get_terms($args);

    if ($product_categories) {
        ob_start();
        ?>
        <div class="accordion" id="productCategoriesAccordion">
            <?php
            $i = 0;
            foreach ($product_categories as $category) {
                $i++;
                // Check if the category has subcategories
                $sub_args = array(
                    'taxonomy' => 'product_cat',
                    'parent' => $category->term_id,
                    'hide_empty' => true
                );
                $sub_categories = get_terms($sub_args);
                $has_subcategories = !empty($sub_categories);

                // Determine if this category should be expanded
                $is_checked = ($category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'current-category' : '';
                $show_collapse = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'show' : '';
                ?>
                <div class="accordion-item <?php echo $active_class; ?>">
                    <div class="accordion-header d-flex align-items-center" id="heading<?php echo $i; ?>">
                        <label for="cat<?php echo $category->term_id; ?>">
                            <input type="checkbox" class="category-checkbox me-2"
                                   id="cat<?php echo $category->term_id; ?>"
                                   data-category-id="<?php echo $category->term_id; ?>" <?php echo $is_checked; ?>>

                            <a href="<?php echo get_term_link($category); ?>" class="main-category">
                                        <?php echo $category->name; ?>
                                        <span class="cat-count">(<?php echo $category->count; ?>)</span>
                                    </a>

                        </label>

                        <?php if ($has_subcategories) { ?>
                            <button
                                class="accordion-button ms-auto <?php echo ($show_collapse == '') ? 'collapsed' : ''; ?>"
                                type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>"
                                aria-expanded="<?php echo ($show_collapse) ? 'true' : 'false'; ?>"
                                aria-controls="collapse<?php echo $i; ?>"
                                data-category-id="<?php echo $category->term_id; ?>">
                                <i class="fa fa-angle-down"></i>
                            </button>
                        <?php } ?>
                    </div>
                    <?php if ($has_subcategories) { ?>
                        <div id="collapse<?php echo $i; ?>"
                             class="accordion-collapse collapse <?php echo $show_collapse; ?>"
                             aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#productCategoriesAccordion">
                            <div class="accordion-body ps-0 pe-0">
                                <?php get_subcategories($category->term_id, 1, $current_category_id, $current_category_parents); ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
                <?php
            }
            ?>
        </div>

        <script>
            document.addEventListener("DOMContentLoaded", function () {
                var savedCategories = JSON.parse(localStorage.getItem("checkedCategories")) || [];

                savedCategories.forEach(function (categoryId) {
                    var checkbox = document.querySelector('.category-checkbox[data-category-id="' + categoryId + '"]');
                    if (checkbox) {
                        checkbox.checked = true;
                    }
                });

                document.querySelectorAll(".category-checkbox").forEach(function (checkbox) {
                    checkbox.addEventListener("change", function () {
                        var categoryId = this.getAttribute("data-category-id");
                        if (this.checked) {
                            if (!savedCategories.includes(categoryId)) {
                                savedCategories.push(categoryId);
                            }
                        } else {
                            savedCategories = savedCategories.filter(id => id !== categoryId);
                        }
                        localStorage.setItem("checkedCategories", JSON.stringify(savedCategories));
                    });
                });
            });
        </script>

        <style>
            .current-category > a {
                font-weight: bold;
                color: #ff6600;
            }

            .category-checkbox {
                display: none;
            }

            span.customcheck {
                background: #FFFFFF 0% 0% no-repeat padding-box;
                border: 1px solid #B7DBEE;
                border-radius: 5px;
                width: 15px;
                height: 15px;
                position: relative;
                margin-right: 6px;
                margin-top: 0px;
                top: 2px;
                display: none;
            }

            .current-category [type=checkbox]:checked ~ a span.customcheck {
                background: #326783;
                border-color: #326783;
            }

            .current-category [type=checkbox] ~ a .customcheck:after {
                content: "";
                position: absolute;
            }

            .current-category a input:checked ~ .customcheck:after {
                display: block;
            }

            .current-category a .customcheck:after {
                left: 5px;
                top: 2px;
                width: 4px;
                height: 8px;
                border: solid white;
                border-width: 0 2px 2px 0;
                transform: rotate(45deg);
            }
        </style>
        <?php
        return ob_get_clean();
    }
}

add_shortcode('product_categories_accordion', 'wpb_woocommerce_product_categories_accordion');


// product category for sidebar end -------------------------------

// Show second product image on hover
add_action('woocommerce_before_shop_loop_item_title', 'custom_product_second_image', 20);

function custom_product_second_image() {
    global $product;

    $attachment_ids = $product->get_gallery_image_ids();

    if ($attachment_ids && isset($attachment_ids[0])) {
        $second_image_id = $attachment_ids[0];
        $second_image = wp_get_attachment_image($second_image_id, 'woocommerce_thumbnail', false, array(
            'class' => 'secondary-image',
        ));
        echo $second_image;
    }
}




// brand filter -------------------
function brand_checkbox_filter_shortcode() {
    $terms = get_terms(array(
        'taxonomy' => 'product_brand',
        'hide_empty' => true,
    ));

    if (empty($terms) || is_wp_error($terms)) {
        return '<p>No brands available.</p>';
    }

    $selected = isset($_GET['product_brand']) ? (array) $_GET['product_brand'] : [];

    ob_start();
    ?>
    <form method="GET" id="brand-filter-form" class="brand-filter-form">
        <div class="brand-filter-checkboxes">
            <?php foreach ($terms as $term): ?>
                <label>
                    
                   <p class="mb-0 d-inline">  <?php echo esc_html($term->name); ?> </p> 
                    <input type="checkbox" name="product_brand[]" value="<?php echo esc_attr($term->slug); ?>"
                        <?php checked(in_array($term->slug, $selected)); ?>
                        onchange="this.form.submit()">
                        <span class="customcheckbox"> </span>
                </label>
            <?php endforeach; ?>
        </div>
    </form>
    <?php
    return ob_get_clean();
}
add_shortcode('brand_checkbox_filter', 'brand_checkbox_filter_shortcode');

function apply_brand_checkbox_filter_to_products($query) {
    if (!is_admin() && $query->is_main_query() && is_post_type_archive('product')) {
        if (!empty($_GET['product_brand']) && is_array($_GET['product_brand'])) {
            $brands = array_map('sanitize_text_field', $_GET['product_brand']);

            $query->set('tax_query', array(array(
                'taxonomy' => 'product_brand',
                'field'    => 'slug',
                'terms'    => $brands,
                'operator' => 'IN',
            )));
        }
    }
}
add_action('pre_get_posts', 'apply_brand_checkbox_filter_to_products');
// brand filter end -------------------







// Add custom quantity buttons JS start -----------

add_action('wp_footer', 'custom_quantity_buttons_script');
function custom_quantity_buttons_script()
{
    if (!is_product())
        return;
    ?>
                <script>
                    document.addEventListener('DOMContentLoaded', function () {
                        const qtyContainers = document.querySelectorAll('.quantity');
                        qtyContainers.forEach(qty => {
                            const input = qty.querySelector('input.qty');
                            if (!input) return;

                            // Remove existing buttons (if any)
                            if (qty.querySelector('.custom-plus')) return;

                            // Create buttons
                            const minus = document.createElement('button');
                            minus.type = 'button';
                            minus.innerHTML = '−';
                            minus.className = 'custom-minus';

                            const plus = document.createElement('button');
                            plus.type = 'button';
                            plus.innerHTML = '+';
                            plus.className = 'custom-plus';

                            // Insert buttons
                            qty.insertBefore(minus, input);
                            qty.appendChild(plus);

                            // Event listeners
                            minus.addEventListener('click', () => {
                                if (input.value > 1) input.value = parseInt(input.value) - 1;
                            });
                            plus.addEventListener('click', () => {
                                input.value = parseInt(input.value) + 1;
                            });
                        });
                    });
                </script>
                <?php
}

// Add custom quantity buttons JS end --------------




// single shop banner  start ---------------------------
// Remove default breadcrumb location
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);

// Add breadcrumb before product title
add_action('woocommerce_single_product_summary', 'woocommerce_breadcrumb', 4);


add_action('woocommerce_before_main_content', 'custom_shop_header', 5);
function custom_shop_header() {
    if (is_product()) {
        ?>
        <div class="woocommerce-shop-banner pt-md-5 pb-md-5 pt-4 pb-4 bg-light">
            <div class="container">
                <div class="row g-md-3 align-items-center">
                    <div class="col-md-12">
                        <div class="banner-title text-start">
                            <?php
                            if (function_exists('woocommerce_breadcrumb')) {
                                woocommerce_breadcrumb(array(
                                    'delimiter'   => ' / ',
                                    'wrap_before' => '<nav class="woocommerce-breadcrumb" itemprop="breadcrumb">',
                                    'wrap_after'  => '</nav>',
                                ));
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}
// single shop banner end ---------------------------



// wpgis  product gallery ------------------
add_action('wp_footer', 'hide_gallery_thumbs_if_single_image');
function hide_gallery_thumbs_if_single_image()
{
    if (is_product()): ?>
                    <script>
                        jQuery(document).ready(function ($) {
                            $(window).on('load', function () {
                                var thumbCount = $('.wpgis-slider-nav .slick-slide').length;

                                if (thumbCount <= 1) {
                                    $('.wpgis-slider-nav').hide();
                                    $('.wpgis-slider-for').addClass('full-width-slider');
                                } else {
                                    $('.wpgis-slider-nav').show();
                                    $('.wpgis-slider-for').removeClass('full-width-slider');
                                }
                            });
                        });
                    </script>
                <?php endif;
}
// wpgis  product gallery end ------------------








// validation start -----------------------------------------------------------



// validation woocommerce start 


add_action('woocommerce_save_account_details_errors', 'validate_my_account_fields', 10, 1);

function validate_my_account_fields($errors)
{
    // Validate First Name
    if (isset($_POST['account_first_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_first_name'])) {
        $errors->add('validation', __('Allowed characters for First Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Last Name
    if (isset($_POST['account_last_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_last_name'])) {
        $errors->add('validation', __('Allowed characters for Last Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Display Name
    if (isset($_POST['account_display_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_display_name'])) {
        $errors->add('validation', __('Allowed characters for Display Name are alphabets and spaces only.', 'woocommerce'));
    }
}




add_action('woocommerce_after_save_address_validation', 'validate_billing_address_fields', 10, 2);

function validate_billing_address_fields($user_id, $address_type)
{
    if ('billing' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $billing_first_name = isset($_POST['billing_first_name']) ? sanitize_text_field($_POST['billing_first_name']) : '';
        $billing_last_name = isset($_POST['billing_last_name']) ? sanitize_text_field($_POST['billing_last_name']) : '';
        $billing_city = isset($_POST['billing_city']) ? sanitize_text_field($_POST['billing_city']) : '';
        $billing_address_1 = isset($_POST['billing_address_1']) ? sanitize_text_field($_POST['billing_address_1']) : '';

        $billing_postcode = isset($_POST['billing_postcode']) ? sanitize_text_field($_POST['billing_postcode']) : '';
        $billing_email = isset($_POST['billing_email']) ? sanitize_email($_POST['billing_email']) : '';

        // Validate Billing First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_first_name)) {
            $validation_errors[] = __('Allowed characters for Billing First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_last_name)) {
            $validation_errors[] = __('Allowed characters for Billing Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_city)) {
            $validation_errors[] = __('Allowed characters for Billing City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $billing_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $billing_postcode)) {
            $validation_errors[] =  __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate Billing Email (Basic Email validation)
        if (!is_email($billing_email)) {
            $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}








add_action('woocommerce_after_save_address_validation', 'validate_shipping_address_fields', 10, 2);

function validate_shipping_address_fields($user_id, $address_type)
{
    if ('shipping' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $shipping_first_name = isset($_POST['shipping_first_name']) ? sanitize_text_field($_POST['shipping_first_name']) : '';
        $shipping_last_name = isset($_POST['shipping_last_name']) ? sanitize_text_field($_POST['shipping_last_name']) : '';
        $shipping_city = isset($_POST['shipping_city']) ? sanitize_text_field($_POST['shipping_city']) : '';
        $shipping_address_1 = isset($_POST['shipping_address_1']) ? sanitize_text_field($_POST['shipping_address_1']) : '';

        $shipping_postcode = isset($_POST['shipping_postcode']) ? sanitize_text_field($_POST['shipping_postcode']) : '';
      //  $shipping_email = isset($_POST['shipping_email']) ? sanitize_email($_POST['shipping_email']) : '';

        // Validate shipping First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_first_name)) {
            $validation_errors[] = __('Allowed characters for shipping First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_last_name)) {
            $validation_errors[] = __('Allowed characters for shipping Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_city)) {
            $validation_errors[] = __('Allowed characters for shipping City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $shipping_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $shipping_postcode)) {
            $validation_errors[] =  __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate shipping Email (Basic Email validation)
        // if (!is_email($shipping_email)) {
        //     $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        // }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}




// validation woocommerce end --------------------







// contact form validation 

// Validate text fields (only alphabets allowed)
add_filter( 'wpcf7_validate_text', 'alpha_validation_filter_text', 20, 2 );
add_filter( 'wpcf7_validate_text*', 'alpha_validation_filter_text', 20, 2 );

function alpha_validation_filter_text( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'names' === $tag->name ) {
        $name_of_the_input = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input) ) {
            $result->invalidate( $tag, "Allowed characters are Alphabets only." );
        }
    }

    if ( 'lname' === $tag->name ) {
        $name_of_the_input = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input) ) {
            $result->invalidate( $tag, "Allowed characters are Alphabets only." );
        }
    }

    return $result;
}

// Validate phone number (must be exactly 10 digits)
add_filter( 'wpcf7_validate_tel', 'numeric_phone_validation_filter', 20, 2 );
add_filter( 'wpcf7_validate_tel*', 'numeric_phone_validation_filter', 20, 2 );

function numeric_phone_validation_filter( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'phone' === $tag->name ) {
        $phone_number = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! preg_match( '/^\d{8}$/', $phone_number ) ) {
            $result->invalidate( $tag, "Phone number must contain exactly 8 digits." );
        }
    }

    return $result;
}



// Validate email (must be a valid email format)
add_filter( 'wpcf7_validate_email', 'validate_email_filter', 20, 2 );
add_filter( 'wpcf7_validate_email*', 'validate_email_filter', 20, 2 );

function validate_email_filter( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'email' === $tag->name ) {
        $email = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! filter_var( $email, FILTER_VALIDATE_EMAIL ) ) {
            $result->invalidate( $tag, "Please enter a valid email address." );
        }
    }

    return $result;
}


// Validate textarea field (message)
add_filter( 'wpcf7_validate_textarea', 'validate_textarea_filter', 20, 2 );
add_filter( 'wpcf7_validate_textarea*', 'validate_textarea_filter', 20, 2 );

function validate_textarea_filter( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'message' === $tag->name ) {
        $message = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        // Allowed characters: alphabets, spaces, common punctuation marks
        if ( ! preg_match( '/^[a-zA-Z0-9\s.,!?()-]+$/', $message ) ) {
            $result->invalidate( $tag, "Message contains invalid characters. Only letters, numbers, spaces, and punctuation are allowed." );
        }

        // Min 10 characters, Max 500 characters
        if ( strlen( $message ) < 10 || strlen( $message ) > 500 ) {
            $result->invalidate( $tag, "Message must be between 10 and 500 characters." );
        }
    }

    return $result;
}




// validation end -----------------------------------------------------------






// Specifications start single product page


add_action('add_meta_boxes', 'add_specifications_metabox');
function add_specifications_metabox() {
    add_meta_box(
        'specifications_box',
        __('Specifications', 'woocommerce'), 
        'render_specifications_metabox', 
        'product', 
        'normal', 
        'default' 
    );
}


function render_specifications_metabox($post) {
    $value = get_post_meta($post->ID, '_specifications', true);
    
   
    wp_editor(
        $value,
        '_specifications',
        array(
            'textarea_name' => '_specifications',
            'textarea_rows' => 8,
            'media_buttons' => true
        )
    );
}


add_action('save_post', 'save_specifications_metabox');
function save_specifications_metabox($post_id) {
    if (isset($_POST['_specifications'])) {
        update_post_meta(
            $post_id,
            '_specifications',
            wp_kses_post($_POST['_specifications'])
        );
    }
}


add_filter('woocommerce_product_tabs', 'add_specifications_tab');
function add_specifications_tab($tabs) {
    global $post;
    $specifications = get_post_meta($post->ID, '_specifications', true);

    if (!empty($specifications)) {
        $tabs['specifications'] = array(
            'title'    => __('Specifications', 'woocommerce'),
            'priority' => 20, 
            'callback' => 'specifications_tab_content'
        );
    }
    return $tabs;
}


function specifications_tab_content() {
    global $post;
    $specifications = get_post_meta($post->ID, '_specifications', true);

    if (!empty($specifications)) {
        echo '<h2>' . __('Specifications', 'woocommerce') . '</h2>';
        echo wpautop(wp_kses_post($specifications));
    }
}

// Specifications end single product page






// Remove "Additional information" tab start
add_filter( 'woocommerce_product_tabs', 'remove_additional_information_tab', 20 );
function remove_additional_information_tab( $tabs ) {
    unset( $tabs['additional_information'] ); 
    return $tabs;
}

// Remove "Additional information" tab end



// add sku in single product page start
add_action('wp_footer', 'move_sku_above_title_js');
function move_sku_above_title_js() {
    if ( is_product() ) { 
        ?>
        <script>
        document.addEventListener("DOMContentLoaded", function() {
            let sku = document.querySelector(".product_meta .sku_wrapper");
            let title = document.querySelector(".product_title.entry-title");

            if (sku && title) {
                title.parentNode.insertBefore(sku, title);
            }
        });
        </script>
        <?php
    }
}
// add sku in single product page end



// add image in single product page color attribute start 
add_action('wp_footer', 'variation_swatches_with_main_image_for_color');
function variation_swatches_with_main_image_for_color() {
    if ( is_product() ) {
        global $product;

        if ( $product && has_post_thumbnail( $product->get_id() ) ) {
            $main_image_url = wp_get_attachment_image_url( $product->get_image_id(), 'medium' ); 
            ?>
            <script>
            document.addEventListener("DOMContentLoaded", function() {
                let imgUrl = "<?php echo esc_url($main_image_url); ?>";

      
                document.querySelectorAll(".variable-items-wrapper[data-attribute_name='attribute_pa_colour'] li .variable-item-span")
                .forEach(function(span) {
                    if(imgUrl && !span.querySelector("img")){
                        span.insertAdjacentHTML("afterbegin",
                            "<img src='"+imgUrl+"' style='width:30px;height:30px;object-fit:cover;margin-right:8px;border-radius:0;'> "
                        );
                    }
                });
            });
            </script>
            <?php
        }
    }
}

// add image in single product page color attribute end


// add size text in single product page size attribute start 
add_action('wp_footer', 'add_size_prefix_script');
function add_size_prefix_script() {
    if ( is_product() ) { ?>
        <script>
        document.addEventListener("DOMContentLoaded", function () {
            // Size ke liye variation labels target karo
            document.querySelectorAll(".variable-items-wrapper[data-attribute_name='attribute_pa_size'] .variable-item-span").forEach(function(el){
                let txt = el.textContent.trim();
                if (!txt.startsWith("Size")) {
                    el.textContent = "Size " + txt;
                }
            });
        });
        </script>
    <?php }
}

// add size text in single product page size attribute end






add_action('wp_footer', function () {
    if (is_product()) { ?>
        <script>
        document.addEventListener("DOMContentLoaded", function () {
            document.querySelectorAll(".quantity").forEach(function (el) {
                if (!el.previousElementSibling || !el.previousElementSibling.classList.contains("qty-label")) {
                    let label = document.createElement("div");
                    label.className = "qty-label";
                    label.innerText = "Quantity";
                    el.parentNode.insertBefore(label, el);
                }
            });
        });
        </script>
        <style>
            .qty-label {
                font-size: 16px;
                font-weight: 500;
                color: #A7A7A7;
                margin-bottom: 10px;
            }
        </style>
    <?php }
});




// add wishlist single product page gallery slider start
add_action( 'woocommerce_before_single_product_summary', 'custom_wishlist_inside_gallery', 5 );
function custom_wishlist_inside_gallery() {
    if ( function_exists( 'YITH_WCWL' ) ) {
        echo '<div class="wishlist-inside-gallery">';
        echo do_shortcode('[yith_wcwl_add_to_wishlist]');
        echo '</div>';
    }
}

// add wishlist single product page gallery slider start








// About page animation section start

function custom_about_animation_script() {
    ?>
    <script>
    document.addEventListener("DOMContentLoaded", function () {
      const elements = document.querySelectorAll(".about-left, .about-right");

      const observer = new IntersectionObserver((entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) {
            entry.target.classList.add("animate");
          } else {
            entry.target.classList.remove("animate"); // remove to replay animation
          }
        });
      }, { threshold: 0.2 });

      elements.forEach((el) => observer.observe(el));
    });
    </script>
    <?php
}
add_action('wp_footer', 'custom_about_animation_script');

// About page animation section end


// Shortcode for YITH Wishlist Count
function shortcode_yith_wishlist_count() {
    if ( function_exists( 'yith_wcwl_count_all_products' ) ) {
        $count = yith_wcwl_count_all_products();
        $wishlist_url = YITH_WCWL()->get_wishlist_url();

        return '<a href="' . esc_url( $wishlist_url ) . '" class="wishlist-link">
                    <img src="https://draftsite1.com/homezone-household/wp-content/uploads/2025/09/icon-fav.svg"> 
                     <span id="wishlist-count">' . esc_html( $count ) . '</span>
                </a>';
    }
    return '';
}
add_shortcode( 'wishlist_count', 'shortcode_yith_wishlist_count' );

// AJAX handler for updating wishlist count
add_action( 'wp_ajax_yith_wcwl_update_wishlist_count', 'yith_wcwl_update_wishlist_count' );
add_action( 'wp_ajax_nopriv_yith_wcwl_update_wishlist_count', 'yith_wcwl_update_wishlist_count' );

function yith_wcwl_update_wishlist_count() {
    if ( function_exists( 'yith_wcwl_count_all_products' ) ) {
        echo yith_wcwl_count_all_products();
    } else {
        echo 0;
    }
    wp_die();
}
