<?php
// Enqueue the parent theme's stylesheet

function hello_elementor_child_enqueue_styles()
{
    wp_enqueue_style('hello-elementor-parent-style', get_template_directory_uri() . '/../hello-elementor-child/style.css');
    wp_enqueue_style('hello-elementor-parent-ecommerce', get_template_directory_uri() . '/../hello-elementor-child/ecommerce.css');
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles');


// Enqueue Booststrap 
function enqueue_bootstrap()
{
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');

//  Slick carousel script and styles
function enqueue_slick_scripts()
{
    //  Slick carousel script
    wp_enqueue_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js', array('jquery'), null, true);
    //  Slick carousel CSS
    wp_enqueue_style('slick-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_slick_scripts');


function load_proxima_nova_font()
{
    wp_enqueue_style('adobe-fonts', 'https://use.typekit.net/cec5ldw.css');
}
add_action('wp_enqueue_scripts', 'load_proxima_nova_font');


// custom code





// blog page start ------------------------------------------------------------


function display_blog($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
        ),
        $atts,
        'blog'
    );


    // Query arguments
    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );


    $blog_query = new WP_Query($args);

    ob_start();

    if ($blog_query->have_posts()): ?>
        <div class="news-slider">
            <div class="row g-lg-4 g-3">
                <?php while ($blog_query->have_posts()):
                    $blog_query->the_post();
                    ?>
                    <div class="col-lg-4 col-md-6 col-sm-6">
                        <div class="news-box" data-post-id="<?php echo get_the_ID(); ?>">
                            <a href="<?php the_permalink(); ?>">
                                <div class="img-box">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                    } ?>

                                    <?php
                                    $day = get_the_date('d');
                                    $month = get_the_date('M');
                                    $year = get_the_date('y');
                                    ?>

                                    <span class="date"><span><?php echo $day; ?></span> <?php echo $month . ' ' . $year; ?></span>

                                </div>
                                <div class="news-text">
                                    <h5 class="title"> <?php echo get_the_title(); ?> </h5>
                                    <div class="description">
                                        <?php echo get_the_excerpt(); ?>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>

                <?php endwhile; ?>
            </div>


            <script type="text/javascript">
                document.addEventListener('DOMContentLoaded', function () {
                    var listItems = document.querySelectorAll('#category-filter-list a');
                    listItems.forEach(function (item) {
                        item.addEventListener('click', function (event) {
                            // No need to prevent default here; the link's href handles the filtering
                        });
                    });
                });
            </script>


            <?php if ($blog_query->max_num_pages > 1): ?>
                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                    <div class="pagination-two">
                        <?php
                        echo paginate_links(array(
                            'total' => $blog_query->max_num_pages,
                            'current' => max(1, get_query_var('paged')),
                            'format' => '?paged=%#%',
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => '<img src="https://draftsite1.com/i-concept-studio/wp-content/uploads/2025/06/right-arrow.png" alt="Previous"  style="transform: rotate(180deg);">',
                            'next_text' => '<img src="https://draftsite1.com/i-concept-studio/wp-content/uploads/2025/06/right-arrow.png" alt="Next">',
                            'end_size' => 2,
                            'mid_size' => 2
                        ));
                        ?>
                    </div>
                </div>
            <?php endif; ?>



        <?php else:
        echo 'No blog found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('blog', 'display_blog');



function get_related_articles($post_id, $number_of_posts = 5)
{

    $args = array(
        'post_type' => 'post',
        'post__not_in' => array($post_id),
        'posts_per_page' => $number_of_posts,
        'ignore_sticky_posts' => 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );

    return get_posts($args);

    $related_posts = get_related_articles(get_the_ID());

    // If not enough related posts by category, get related posts by tag
    if (count($related_posts) < $number_of_posts) {
        $tags = wp_get_post_tags($post_id);
        if ($tags) {
            $tag_ids = array();
            foreach ($tags as $tag) {
                $tag_ids[] = $tag->term_id;
            }
            $args = array(
                'tag__in' => $tag_ids,
                'post__not_in' => array_merge(array($post_id), wp_list_pluck($related_posts, 'ID')),
                'posts_per_page' => $number_of_posts - count($related_posts),
                'ignore_sticky_posts' => 1,
            );
            $more_related_posts = get_posts($args);
            $related_posts = array_merge($related_posts, $more_related_posts);
        }
    }

    return $related_posts;
}

// blog list end------------


// e-product start ---------

function display_eproducts($atts) {
    global $wp;

    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 12,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'eproducts'
    );

    if (!empty($_GET['category'])) {
        $selected_term = get_term_by('slug', sanitize_text_field($_GET['category']), 'products-category');
    } elseif (!empty($atts['category'])) {
        $selected_term = get_term_by('slug', $atts['category'], 'products-category');
    }
    
    $args = array(
        'post_type'      => 'e-products',
        'posts_per_page' => $atts['posts_per_page'],
        'paged'          => max(1, get_query_var('paged')),
        'orderby'        => 'date',
        'order'          => 'DESC',
    );
    
    if ($selected_term && !is_wp_error($selected_term)) {
        $args['tax_query'] = array(
            array(
                'taxonomy'         => 'products-category',
                'field'            => 'slug',
                'terms'            => array($selected_term->slug),
                'include_children' => false, // Child ke products include nahi
            ),
        );
    } else {
        $args['post__in'] = array(0);
    }
    


    // Prepare subcategories list
    $filter_categories = array();
    if ($selected_term && !is_wp_error($selected_term)) {
        // If child → get siblings, if parent → get its children
        $parent_id = $selected_term->parent ? $selected_term->parent : $selected_term->term_id;

        $filter_categories = get_terms(array(
            'taxonomy' => 'products-category',
            'parent' => $parent_id,
            'hide_empty' => true,
        ));
    }

    // Start output
    $eproducts_query = new WP_Query($args);
    ob_start();
    ?>
    <div class="row justify-content-center">
        <?php if (!empty($filter_categories)): ?>
            <div class="col-md-4">
                <div class="text-start">
                    <ul id="project-filter-list" class="mb-5">
                        <?php 
                        $current_cat = isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '';
                        $current_url = home_url(add_query_arg(array(), $wp->request));
                        foreach ($filter_categories as $category):
                            $filter_url = esc_url(add_query_arg('category', $category->slug, $current_url));
                            $active_class = ($current_cat === $category->slug) ? 'active' : '';
                        ?>
                            <li>
                                <a href="<?php echo $filter_url; ?>" class="cats <?php echo esc_attr($active_class); ?>">
                                    <?php echo esc_html($category->name); ?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        <?php endif; ?>

        <div class="col-md-8">
            <?php if ($eproducts_query->have_posts()): ?>
                <div class="eproducts-container">
                    <div class="row g-3 align-items-center mb-5">
                        <?php while ($eproducts_query->have_posts()):
                            $eproducts_query->the_post(); ?>
                            <div class="col-md-4">
                                <a href="<?php the_permalink(); ?>" class="e-products">
                                    <div class="img-box">
                                        <?php the_post_thumbnail('full', ['class' => 'd-block w-100']); ?>
                                    </div>
                                    <div class="product-wrap">
                                        <div class="product-info">
                                            <h5 class="title mt-0 mb-3"><?php the_title(); ?></h5>
                                            <div class="more-info">
                                                <p class="description"><?php echo get_the_excerpt(); ?></p>
                                                <div class="animated-btn">
                                                    <div class="e-button">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="30.731" height="12.946"
                                                            viewBox="0 0 30.731 12.946">
                                                            <path id="Arrow_Black"
                                                                d="M7.77,4.51V29.091c0,.1,0,.2,0,.3a1.246,1.246,0,0,1-1.324,1.336,1.236,1.236,0,0,1-1.268-1.356c0-4.854,0-19.708,0-24.562v-.38c-.115.105-.188.168-.256.236-.9.9-1.8,1.806-2.7,2.7A1.246,1.246,0,0,1,.357,7.356,1.242,1.242,0,0,1,.322,5.651c.06-.069.125-.133.189-.2q2.5-2.5,5-5A1.241,1.241,0,0,1,7.424.447q2.533,2.53,5.062,5.062a1.253,1.253,0,0,1,.3,1.568,1.27,1.27,0,0,1-2.075.281C9.834,6.493,8.967,5.616,8.1,4.741a3.073,3.073,0,0,1-.225-.286l-.1.054"
                                                                transform="translate(30.731 0) rotate(90)" fill="#23262c">
                                                            </path>
                                                        </svg>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        <?php endwhile; ?>
                    </div>

                    <?php if ($eproducts_query->max_num_pages > 1): ?>
                        <div class="pagination-center text-center mt-3">
                            <?php
                            echo paginate_links(array(
                                'total' => $eproducts_query->max_num_pages,
                                'current' => max(1, get_query_var('paged')),
                                'format' => '?paged=%#%',
                                'add_args' => array(
                                    'category' => $current_cat
                                ),
                                'type' => 'plain',
                                'prev_text' => '«',
                                'next_text' => '»',
                            ));
                            ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php else: ?>
                <p>No e-products found.</p>
            <?php endif; ?>
        </div>
    </div>
    <?php
    wp_reset_postdata();
    return ob_get_clean();
}
add_shortcode('eproducts', 'display_eproducts');





// e-product end---------

// news slider start-------------
function display_news_slider($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
        ),
        $atts,
        'post'
    );

    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['posts_per_page'],
        'meta_query' => array(
            array(
                'key' => '_is_ns_featured_post',
                'value' => 'yes',
                'compare' => '='
            )
        )
    );

    $news_query = new WP_Query($args);


    ob_start();

    if ($news_query->have_posts()): ?>
            <div class="news-slider">
                <div class="slick-slider-news pb-2">
                    <?php while ($news_query->have_posts()):
                        $news_query->the_post();
                        ?>
                        <div class="item p-sm-2" id="<?php echo get_the_ID(); ?>">
                            <div class="news-box">
                                <a href="<?php the_permalink(); ?>">
                                    <div class="img-box">
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                        } ?>
                                        <?php
                                        $day = get_the_date('d');
                                        $month = get_the_date('M');
                                        $year = get_the_date('y');
                                        ?>

                                        <span class="date"><span><?php echo $day; ?></span>
                                            <?php echo $month . ' ' . $year; ?></span>
                                    </div>

                                    <div class="news-text">
                                        <h5 class="title"><?php echo get_the_title(); ?></h5>
                                        <p class="description">
                                            <?php echo get_the_excerpt(); ?>
                                        </p>
                                    </div>
                                </a>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>
            </div>

            <script>
                jQuery(document).ready(function ($) {
                    $(".slick-slider-news").slick({
                        dots: false,
                        infinite: true,
                        speed: 300,
                        slidesToShow: 3,
                        slidesToScroll: 1,
                        adaptiveHeight: true,
                        prevArrow: '<div class="left-btn arrowbtn"><i class="icon icon-left-arrows"></i></div>',
                        nextArrow: '<div class="right-btn arrowbtn"><i class="icon icon-right-arrow1"></i></div>',
                        responsive: [{
                            breakpoint: 1200,
                            settings: {
                                slidesToShow: 3,
                                slidesToScroll: 1,
                            },
                        },
                        {
                            breakpoint: 1008,
                            settings: {
                                slidesToShow: 3,
                                slidesToScroll: 1,
                            },
                        },
                        {
                            breakpoint: 800,
                            settings: {
                                slidesToShow: 2,
                                slidesToScroll: 1,
                            },
                        },
                        {
                            breakpoint: 576,
                            settings: {
                                slidesToShow: 1,
                                slidesToScroll: 1,
                            },
                        },
                        ],
                    });

                });
            </script>

        <?php else:
        echo 'No news found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('news_slider', 'display_news_slider');
// news slider end -----------------



function display_promotion_slider($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
        ),
        $atts,
        'promotion'
    );

    $args = array(
        'post_type' => 'promotion',
        'posts_per_page' => $atts['posts_per_page'],
        'meta_query' => array(
            array(
                'key' => '_is_ns_featured_post',
                'value' => 'yes',
                'compare' => '='
            )
        )
    );


    $promotion_query = new WP_Query($args);


    ob_start();

    if ($promotion_query->have_posts()): ?>
            <div class="promotions-container mb-5">
                <div id="demo" class="carousel slide" data-bs-ride="carousel">
                    <div class="carousel-inner">
                        <?php
                        $first = true;
                        while ($promotion_query->have_posts()):
                            $promotion_query->the_post();
                            ?>

                            <div class="carousel-item <?php echo $first ? 'active' : ''; ?>">
                                <div class="promotion-box">
                                    <div class="row g-3 align-items-center">
                                        <div class="col-md-6 pe-lg-5">
                                            <div class="img-box">
                                                <?php if (has_post_thumbnail()) {
                                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                                } ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6 ps-lg-5">
                                            <div class="promo-text h-100">
                                                <h5 class="title mt-0 mb-3"><?php echo get_the_title(); ?></h5>
                                                <p class="description mb-5"><?php echo get_the_excerpt(); ?></p>
                                                <div class="animated-btn"><a href="<?php the_permalink(); ?>"
                                                        class="elementor-button">Discover More <svg
                                                            xmlns="http://www.w3.org/2000/svg" width="30.731" height="12.946"
                                                            viewBox="0 0 30.731 12.946">
                                                            <path id="Arrow_Black"
                                                                d="M7.77,4.51V29.091c0,.1,0,.2,0,.3a1.246,1.246,0,0,1-1.324,1.336,1.236,1.236,0,0,1-1.268-1.356c0-4.854,0-19.708,0-24.562v-.38c-.115.105-.188.168-.256.236-.9.9-1.8,1.806-2.7,2.7A1.246,1.246,0,0,1,.357,7.356,1.242,1.242,0,0,1,.322,5.651c.06-.069.125-.133.189-.2q2.5-2.5,5-5A1.241,1.241,0,0,1,7.424.447q2.533,2.53,5.062,5.062a1.253,1.253,0,0,1,.3,1.568,1.27,1.27,0,0,1-2.075.281C9.834,6.493,8.967,5.616,8.1,4.741a3.073,3.073,0,0,1-.225-.286l-.1.054"
                                                                transform="translate(30.731 0) rotate(90)" fill="#23262c">
                                                            </path>
                                                        </svg></a></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php $first = false;
                        endwhile; ?>
                    </div>
                    <div class="promo-nav">
                        <!-- Left and right controls/icons -->
                        <button class="carousel-control-prev" type="button" data-bs-target="#demo" data-bs-slide="prev">
                            <img src="https://draftsite1.com/i-concept-studio/wp-content/uploads/2025/06/Arrow_Black.svg"
                                alt="">
                        </button>
                        <button class="carousel-control-next ms-3" type="button" data-bs-target="#demo" data-bs-slide="next">
                            <img src="https://draftsite1.com/i-concept-studio/wp-content/uploads/2025/06/Arrow_Black.svg"
                                alt="">
                        </button>
                    </div>
                </div>
            </div>


        <?php else:
        echo 'No promotion found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('promotion_slider', 'display_promotion_slider');
// promotion slider end -----------------









// promotion start ---------


function display_promotions($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 2,
        ),
        $atts,
        'promotions'
    );
    // Get the current page
    $args = array(
        'post_type' => 'promotion',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );



    $promotions_query = new WP_Query($args);

    ob_start();

    if ($promotions_query->have_posts()): ?>
            <div class="promotions-container">
                <div class="promotion-box">

                    <?php while ($promotions_query->have_posts()):
                        $promotions_query->the_post();
                        ?>

                        <div class="row g-3 align-items-center mb-5" id="<?php echo get_the_ID(); ?>">
                            <div class="col-md-6 pe-lg-5">
                                <div class="img-box">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                    } ?>
                                </div>
                            </div>
                            <div class="col-md-6 ps-lg-5">
                                <div class="promo-text h-100">
                                    <h5 class="title mt-0 mb-3"> <?php echo get_the_title(); ?> </h5>
                                    <p class="description mb-5">
                                        <?php echo get_the_excerpt(); ?>
                                    </p>
                                    <div class="animated-btn"><a href="<?php the_permalink(); ?>" class="elementor-button">Discover
                                            More <svg xmlns="http://www.w3.org/2000/svg" width="30.731" height="12.946"
                                                viewBox="0 0 30.731 12.946">
                                                <path id="Arrow_Black"
                                                    d="M7.77,4.51V29.091c0,.1,0,.2,0,.3a1.246,1.246,0,0,1-1.324,1.336,1.236,1.236,0,0,1-1.268-1.356c0-4.854,0-19.708,0-24.562v-.38c-.115.105-.188.168-.256.236-.9.9-1.8,1.806-2.7,2.7A1.246,1.246,0,0,1,.357,7.356,1.242,1.242,0,0,1,.322,5.651c.06-.069.125-.133.189-.2q2.5-2.5,5-5A1.241,1.241,0,0,1,7.424.447q2.533,2.53,5.062,5.062a1.253,1.253,0,0,1,.3,1.568,1.27,1.27,0,0,1-2.075.281C9.834,6.493,8.967,5.616,8.1,4.741a3.073,3.073,0,0,1-.225-.286l-.1.054"
                                                    transform="translate(30.731 0) rotate(90)" fill="#23262c"></path>
                                            </svg></a></div>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>
            </div>


            <?php if ($promotions_query->max_num_pages > 1): ?>
                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                    <div class="pagination-two">
                        <?php
                        echo paginate_links(array(
                            'total' => $promotions_query->max_num_pages,
                            'current' => max(1, get_query_var('paged')),
                            'format' => '?paged=%#%',
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => '<img src="https://draftsite1.com/i-concept-studio/wp-content/uploads/2025/06/right-arrow.png" alt="Previous"  style="transform: rotate(180deg);">',
                            'next_text' => '<img src="https://draftsite1.com/i-concept-studio/wp-content/uploads/2025/06/right-arrow.png" alt="Next">',
                            'end_size' => 2,
                            'mid_size' => 2
                        ));
                        ?>
                    </div>
                </div>
            <?php endif; ?>


        <?php else:
        echo 'No promotions found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('promotions', 'display_promotions');


// promotion end---------






// product-categories start -----------------------------------------



// Wrap WooCommerce product image in a div start ----------
add_action('woocommerce_before_shop_loop_item_title', 'wrap_product_image_in_div', 5);
function wrap_product_image_in_div()
{
    echo '<div class="custom-image-wrapper">';
}
add_action('woocommerce_before_shop_loop_item_title', 'close_product_image_div', 15);
function close_product_image_div()
{
    echo '</div>';
}
// Wrap WooCommerce product image in a div end ----------

// Remove default breadcrumb location
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);

// Add breadcrumb before product title
add_action('woocommerce_single_product_summary', 'woocommerce_breadcrumb', 4);




function wpb_woocommerce_product_categories_accordion()
{
    // Get the current queried product category
    $queried_object = get_queried_object();
    $current_category_id = ($queried_object && isset($queried_object->term_id)) ? $queried_object->term_id : 0;

    // Get all parent categories of the current category
    $current_category_parents = [];
    if ($current_category_id) {
        $parent_categories = get_ancestors($current_category_id, 'product_cat');
        $current_category_parents = array_map('intval', $parent_categories);
    }

    // Recursive function to get subcategories with checkboxes
    function get_subcategories($parent_id, $level = 1, $current_category_id, $current_category_parents)
    {
        $args = array(
            'taxonomy' => 'product_cat',
            'orderby' => 'name',
            'order' => 'ASC',
            'parent' => $parent_id,
            'hide_empty' => false
        );
        $sub_categories = get_terms($args);

        if (!empty($sub_categories)) {
            echo '<ul class="list-unstyled ps-2">';
            foreach ($sub_categories as $sub_category) {
                $is_checked = ($sub_category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($sub_category->term_id == $current_category_id) ? 'current-category' : '';

                echo '<li class="' . $active_class . '">';
                echo '<div class="in-menu">';
                echo '<input type="checkbox" class="category-checkbox me-2" data-category-id="' . $sub_category->term_id . '" ' . $is_checked . '> ';

                echo '<a href="' . get_term_link($sub_category) . '">  <span class="customcheck"></span>' . $sub_category->name . '</a>';
                echo '</div>';
                get_subcategories($sub_category->term_id, $level + 1, $current_category_id, $current_category_parents);
                echo '</li>';
            }
            echo '</ul>';
        }
    }

    // Get main product categories (parent categories)
    $args = array(
        'taxonomy' => 'product_cat',
        'orderby' => 'name',
        'order' => 'ASC',
        'parent' => 0,
        'hide_empty' => false
    );
    $product_categories = get_terms($args);

    if ($product_categories) {
        ob_start();
        ?>
            <div class="accordion" id="productCategoriesAccordion">

                <?php
                $shop_page_url = wc_get_page_permalink('shop');
                $is_shop_page = is_shop();
                ?>

                <!-- <div class="accordion-item">
                    <div class="accordion-header <?php //echo $is_shop_page ? 'current-category' : ''; 
                            ?>">
                        <label>
                            <a href="<?php // echo esc_url($shop_page_url); 
                                    ?>" class="main-category">
                                All Product
                            </a>
                        </label>
                    </div>
                </div> -->


                <?php
                $i = 0;
                foreach ($product_categories as $category) {
                    $i++;

                    // Check if the category has subcategories
                    $sub_args = array(
                        'taxonomy' => 'product_cat',
                        'parent' => $category->term_id,
                        'hide_empty' => true
                    );
                    $sub_categories = get_terms($sub_args);
                    $has_subcategories = !empty($sub_categories);

                    // Determine if this category should be expanded
                    $is_checked = ($category->term_id == $current_category_id) ? 'checked' : '';
                    $active_class = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'current-category' : '';
                    $show_collapse = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'show' : '';
                    ?>
                    <div class="accordion-item <?php echo $active_class; ?>">
                        <div class="accordion-header d-flex align-items-center" id="heading<?php echo $i; ?>">
                            <label for="cat<?php echo $category->term_id; ?>">
                                <input type="checkbox" class="category-checkbox me-2" id="cat<?php echo $category->term_id; ?>"
                                    data-category-id="<?php echo $category->term_id; ?>" <?php echo $is_checked; ?>>

                                <a href="<?php echo get_term_link($category); ?>" class="main-category">
                                    <span class="customdot"></span>
                                    <?php echo $category->name . ' <span class="count">(' . $category->count . ')</span>'; ?>
                                </a>
                            </label>

                            <?php if ($has_subcategories) { ?>
                                <button class="accordion-button ms-auto <?php echo ($show_collapse == '') ? 'collapsed' : ''; ?>"
                                    type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>"
                                    aria-expanded="<?php echo ($show_collapse) ? 'true' : 'false'; ?>"
                                    aria-controls="collapse<?php echo $i; ?>" data-category-id="<?php echo $category->term_id; ?>">
                                    <i class="fa fa-angle-down"></i>
                                </button>
                            <?php } ?>
                        </div>
                        <?php if ($has_subcategories) { ?>
                            <div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse <?php echo $show_collapse; ?>"
                                aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#productCategoriesAccordion">
                                <div class="accordion-body ps-0 pe-0">
                                    <?php get_subcategories($category->term_id, 1, $current_category_id, $current_category_parents); ?>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                    <?php
                }
                ?>
            </div>

            <script>
                document.addEventListener("DOMContentLoaded", function () {
                    var savedCategories = JSON.parse(localStorage.getItem("checkedCategories")) || [];

                    savedCategories.forEach(function (categoryId) {
                        var checkbox = document.querySelector('.category-checkbox[data-category-id="' + categoryId + '"]');
                        if (checkbox) {
                            checkbox.checked = true;
                        }
                    });

                    document.querySelectorAll(".category-checkbox").forEach(function (checkbox) {
                        checkbox.addEventListener("change", function () {
                            var categoryId = this.getAttribute("data-category-id");
                            if (this.checked) {
                                if (!savedCategories.includes(categoryId)) {
                                    savedCategories.push(categoryId);
                                }
                            } else {
                                savedCategories = savedCategories.filter(id => id !== categoryId);
                            }
                            localStorage.setItem("checkedCategories", JSON.stringify(savedCategories));
                        });
                    });

                    var activeCategory = localStorage.getItem("activeCategory");
                    if (activeCategory) {
                        var activeAccordion = document.querySelector('[data-category-id="' + activeCategory + '"]');
                        if (activeAccordion) {
                            var collapseElement = activeAccordion.getAttribute("data-bs-target");
                            document.querySelector(collapseElement).classList.add("show");
                            activeAccordion.classList.remove("collapsed");
                            activeAccordion.setAttribute("aria-expanded", "true");
                        }
                    }

                    document.querySelectorAll(".accordion-button").forEach(function (button) {
                        button.addEventListener("click", function () {
                            var categoryId = this.getAttribute("data-category-id");
                            if (document.querySelector(this.getAttribute("data-bs-target")).classList.contains("show")) {
                                localStorage.removeItem("activeCategory");
                            } else {
                                localStorage.setItem("activeCategory", categoryId);
                            }
                        });
                    });
                });
            </script>

            <style>
                .current-category>a {
                    font-weight: bold;
                    color: #ff6600;
                }

                .category-checkbox {
                    display: none;
                }

                span.customcheck {
                    background: #FFFFFF 0% 0% no-repeat padding-box;
                    border: 1px solid #BEC0C5;
                    border-radius: 0px;
                    width: 15px;
                    height: 15px;
                    position: relative;
                    margin-right: 2px;
                    margin-top: 0px;
                    top: 2px;
                    display: inline-block;
                }

                .current-category [type=checkbox]:checked~a span.customcheck {
                    background: #BEC0C5;
                    border-color: #BEC0C5;
                }

                .current-category [type=checkbox]~a .customcheck:after {
                    content: "";
                    position: absolute;
                }

                .current-category a input:checked~.customcheck:after {
                    display: block;
                }

                .current-category a .customcheck:after {
                    left: 5px;
                    top: 2px;
                    width: 4px;
                    height: 8px;
                    border: solid white;
                    border-width: 0 2px 2px 0;
                    -webkit-transform: rotate(45deg);
                    -ms-transform: rotate(45deg);
                    transform: rotate(45deg);
                }
            </style>
            <?php
            return ob_get_clean();
    }
}

add_shortcode('product_categories_accordion', 'wpb_woocommerce_product_categories_accordion');

// product category for sidebar end -------------------------------

// add short descrition 
// add_action('woocommerce_after_shop_loop_item_title', 'custom_show_short_description', 6);
// function custom_show_short_description()
// {
//     global $post;
//     echo '<p class="custom-snippet">' . wp_trim_words(get_the_excerpt(), 8) . '</p>';
// }

// add view product button 
add_action('woocommerce_before_shop_loop_item_title', 'custom_view_product_button', 20);
function custom_view_product_button()
{
    global $product;
    echo '<div class="custom-view-button">
             <div class="animated-btn">
                <a href="' . get_permalink($product->get_id()) . '" class="view-product-link">
                <img src="https://draftsite1.com/i-concept-studio/wp-content/uploads/2025/06/Add-to-Cart.png">
                </a>
           </div>
            <div class="animated-btn">
                <a href="' . get_permalink($product->get_id()) . '" class="view-product-link">
                <img src="https://draftsite1.com/i-concept-studio/wp-content/uploads/2025/06/Component-230-–-2.png">
                </a>
           </div>

    </div>';
}


add_action('wp_footer', 'hide_gallery_thumbs_if_single_image');
function hide_gallery_thumbs_if_single_image()
{
    if (is_product()): ?>
            <script>
                jQuery(document).ready(function ($) {
                    $(window).on('load', function () {
                        var thumbCount = $('.wpgis-slider-nav .slick-slide').length;

                        if (thumbCount <= 1) {
                            $('.wpgis-slider-nav').hide();
                        } else {
                            $('.wpgis-slider-nav').show();
                        }
                    });
                });
            </script>

        <?php endif;
}


?>