<?php get_header(); ?>


<div class="article-detail">

    <div class="container pt-4">


        <div class="row g-md-5 g-3 justify-content-between">

            <div class="col-lg-12 col-md-12">
                <div class="top-bar-single">
                    <h1 class="title"><?php echo the_title(); ?></h1>
                    <div class="d-md-flex align-items-center">
                        <div class="wrap">
                            <img src="https://draftsite1.com/i-concept-studio/wp-content/uploads/2025/06/Author-min.png"
                                alt="auther">
                            <span> <?php the_author(); ?> </span>
                        </div>
                        <div class="wrap">
                            <img src="https://draftsite1.com/i-concept-studio/wp-content/uploads/2025/06/Date-min.png"
                                alt="calendor">
                            <span><?php echo strtoupper(get_the_date('F j, Y')); ?> </span>
                        </div>
                    </div>
                </div>

            </div>

            <div class="col-lg-8 col-md-8">
                <?php
                if (have_posts()):
                    while (have_posts()):
                        the_post();
                ?>
                        <div class="content-area">
                            <?php the_content(); ?>
                        </div>


                        <?php
                        $faqs = get_field('faq'); ?>
                        <?php if (!empty($faqs)): ?>
                            <div class="faqs-wrap pt-3">
                                <h4>Faqs</h4>

                                <div class="accordion" id="accordionExample">
                                    <?php foreach ($faqs as $index => $faq_item):
                                        $question = esc_html($faq_item['question']);
                                        $answer = wp_kses_post($faq_item['answer']);
                                        $collapse_id = 'collapse' . $index;
                                        $heading_id = 'heading' . $index;
                                        $is_first = $index === 0;
                                    ?>
                                        <div class="accordion-item">
                                            <div class="accordion-header" id="<?php echo $heading_id; ?>">
                                                <button class="accordion-button <?php echo !$is_first ? 'collapsed' : ''; ?>"
                                                    type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#<?php echo $collapse_id; ?>"
                                                    aria-expanded="<?php echo $is_first ? 'true' : 'false'; ?>"
                                                    aria-controls="<?php echo $collapse_id; ?>">
                                                    <?php echo $question; ?>
                                                </button>
                                            </div>
                                            <div id="<?php echo $collapse_id; ?>"
                                                class="accordion-collapse collapse <?php echo $is_first ? 'show' : ''; ?>"
                                                aria-labelledby="<?php echo $heading_id; ?>" data-bs-parent="#accordionExample">
                                                <div class="accordion-body">
                                                    <?php echo $answer; ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                <?php
                    endwhile;
                else:
                    echo 'No post found.';
                endif;
                ?>
            </div>

            <div class="col-lg-3 col-md-3">
                <?php
                $related_posts = get_related_articles(get_the_ID(), 5);

                if (!empty($related_posts)): ?>
                    <div class="sidebar-articles">
                        <h1 class="title-latest">
                            Recent Posts
                        </h1>
                        <?php foreach ($related_posts as $post):
                            setup_postdata($post); ?>
                            <div class="our-article-wrap">
                                <a href="<?php the_permalink(); ?>" class="d-block text-decoration-none">
                                    <div class="article-info">
                                        <h4><?php the_title(); ?></h4>
                                        <p class="date"> <span> <img
                                                    src="https://draftsite1.com/i-concept-studio/wp-content/uploads/2025/06/calendar-silhouette.png"
                                                    alt="calendar"> </span> <?php echo get_the_date(); ?></p>
                                    </div>
                                </a>
                            </div>
                        <?php endforeach; ?>
                    </div>
            </div>

        <?php
                    wp_reset_postdata();
                endif;
        ?>
        </div>
    </div>
</div>




<?php get_footer(); ?>