<?php
/**
 * Template Name: Custom Blog Page
 */

get_header();
?>

<?php echo do_shortcode('[hfe_template id="992"]'); ?>

<div class="container my-5">
    <div class="row g-4">
        <?php
        $paged = get_query_var('paged') ? get_query_var('paged') : 1;
        $selected_category = isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '';

        $args = array(
            'post_type' => 'post',
            'posts_per_page' => 9,
            'paged' => $paged,
            'orderby' => 'date',
            'order' => 'DESC',
        );

        if (!empty($selected_category)) {
            $args['category_name'] = $selected_category;
        }

        $blog_query = new WP_Query($args);
        ?>

        <div class="col-md-12">
            <?php if ($blog_query->have_posts()): ?>
                <div class="blog-page blog-main">
                    <div class="row g-md-5 g-3">
                        <?php while ($blog_query->have_posts()):
                            $blog_query->the_post(); ?>

                            <div class="col-md-4">
                                <div class="blog-post-card mb-4">
                                    <div class="blog-image-wrapper">
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                        } ?>
                                    </div>
                                    <div class="blog-content">
                                        <span class="date"><?php echo get_the_date('d F, Y'); ?> </span>
                                        <h2> <?php the_title(); ?> </h2>
                                        <p><?php echo get_the_excerpt(); ?></p>
                                        <a href="<?php the_permalink(); ?>" class="read-more-btn elementor-button">READ MORE</a>
                                    </div>
                                </div>
                            </div>

                        <?php endwhile; ?>
                    </div>

                    <?php if ($blog_query->max_num_pages > 1): ?>
                        <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                            <div class="pagination-style-one">
                                <?php
                                echo paginate_links(array(
                                    'total' => $blog_query->max_num_pages,
                                    'current' => max(1, get_query_var('paged')),
                                    'format' => '?paged=%#%',
                                    'show_all' => false,
                                    'type' => 'plain',
                                    'prev_text' => '<i class="eicon-chevron-left"></i>',
                                    'next_text' => '<i class="eicon-chevron-right"></i>',
                                    'end_size' => 2,
                                    'mid_size' => 2
                                ));
                                ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            <?php else: ?>
                <p>No blog posts found.</p>
            <?php endif;

            wp_reset_postdata();
            ?>
        </div>
    </div>
</div>


<?php get_footer(); ?>