jQuery(document).ready(function ($) {
    const button = $('#load-more');
    if (!button.length) return;

    let page = 1;
    const maxPage = parseInt(button.data('max'), 10);
    const productList = $('.product-list');

    button.on('click', function (e) {
        e.preventDefault();

        if (page >= maxPage) {
            button.text('No More Products').prop('disabled', true);
            return;
        }

        button.text('Loading...');

        $.ajax({
            url: loadmore_params.ajaxurl,
            type: 'POST',
            data: {
                action: 'loadmore_product_enquiry',
                page: page,
                material: $('input[name="material"]:checked').val() || ''
            },
            success: function (response) {
                if (response.trim() !== '') {
                    productList.append(response);
                    page++;
                    if (page >= maxPage) {
                        button.text('No More Products').prop('disabled', true);
                    } else {
                        button.text('Load More');
                    }
                } else {
                    button.text('No More Products').prop('disabled', true);
                }
            },
            error: function () {
                button.text('Error');
            },
        });
    });
});
