<?php get_header(); ?>


<div class="single-eproduct-detail">
    <?php
    global $post;
    $post_id = get_the_ID();
    while (have_posts()):
        the_post(); ?>
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <?php
                    $thumbnails = [];

                    if (has_post_thumbnail()) {
                        $thumbnail_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
                        $thumbnails[] = $thumbnail_url;
                    }

                    $gallery = get_field('gallery');

                    $gallery_images = [
                        $gallery['first'] ?? null,
                        $gallery['second'] ?? null,
                        $gallery['third'] ?? null,
                        $gallery['fourth'] ?? null
                    ];

                    foreach ($gallery_images as $image) {
                        if (!empty($image['url'])) {
                            $thumbnails[] = $image['url'];
                        }
                    }
                    ?>

                    <?php if (!empty($thumbnails)): ?>
                        <div class="product-details-gallery d-lg-flex">

                            <?php if (count($thumbnails) > 1): // Thumbnail slider sirf tab dikhaye jab ek se zyada images ho ?>
                                <!-- Thumbnail Slider -->
                                <div class="thumbnail-slider">
                                    <?php foreach ($thumbnails as $thumb): ?>
                                        <div>
                                            <img src="<?php echo esc_url($thumb); ?>" alt="Thumb" />
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>

                            <!-- Main Slider -->
                            <div class="product-slider ps-lg-2">
                                <?php foreach ($thumbnails as $main_img): ?>
                                    <div>
                                        <img src="<?php echo esc_url($main_img); ?>" alt="Product Image" />
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    <?php endif; ?>




                </div>

                <!-- Product Details -->
                <div class="col-lg-6 ps-lg-5">
                    <div class="product_details ps-lg-4">
                        <div class="col-12 pb-4 mb-2">
                            <?php function custom_breadcrumbs()
                            {
                                if (!is_single()) {
                                    return;
                                }

                                global $post;

                                $breadcrumbs = '<nav aria-label="breadcrumb"><ol class="breadcrumb">';
                                $breadcrumbs .= '<li class="breadcrumb-item"><a href="' . home_url() . '">Home</a></li>';
                                $breadcrumbs .= '<li class="breadcrumb-item"><a href="' . get_permalink(get_page_by_path('jewellery')) . '">Jewellery</a></li>';
                                $breadcrumbs .= '<li class="breadcrumb-item active" aria-current="page">' . get_the_title() . '</li>';
                                $breadcrumbs .= '</ol></nav>';

                                echo $breadcrumbs;
                            } ?>


                            <?php custom_breadcrumbs(); ?>

                        </div>
                        <h4 class="title mt-0"> <?php the_title(); ?> </h4>

                        <div class="mb-5">
                            <?php the_content(); ?>
                        </div>

                        <?php
                        $terms = get_the_terms(get_the_ID(), 'eproducts-category');
                        if ($terms && !is_wp_error($terms)) { ?>

                            <h3 class="information"> PRODUCT INFORMATION </h3>
                            <div class="pro-info mb-2">
                                <h5 class="d-inline-block m-0"> Categories: </h5>
                                <?php
                                foreach ($terms as $term) {
                                    $category_name = strtolower($term->name); ?>

                                    <span class="category-badge"><?php echo $category_name; ?></span>

                                    <?php
                                } ?>
                            </div>
                        <?php }
                        ?>

                        <?php $terms = get_the_terms(get_the_ID(), 'materials');
                        if ($terms && !is_wp_error($terms)) { ?>
                            <div class="pro-info mb-2">
                                <h5 class="d-inline-block m-0"> Material: </h5>
                                <?php
                                foreach ($terms as $term) {
                                    $category_name = strtolower($term->name); ?>

                                    <span class="category-badge"><?php echo $category_name; ?></span>

                                    <?php
                                } ?>
                            </div>
                        <?php }
                        ?>

                        <?php
                        $post_id = get_the_ID();
                        $terms = get_the_terms($post_id, 'products-tags');

                        if ($terms && !is_wp_error($terms)) {
                            $term_names = wp_list_pluck($terms, 'name');
                            if (!empty($term_names)) { ?>
                                <div class="pro-info mb-2">
                                    <h5 class="d-inline-block m-0">Tags: </h5>
                                    <?php echo esc_html(implode(', ', $term_names)); ?>
                                </div>
                            <?php }
                        }
                        ?>




                        <button class="elementor-button mt-md-4 popmake-1252" id="EnquireNow"
                            onclick="addToQuote(<?php echo $post_id; ?>)">
                            <span> ENQUIRY PRODUCT
                            </span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <?php
    endwhile;
    ?>
</div>







<div class="related-products">
    <div class="container">
        <?php
        $post_id = get_the_ID();
        $terms = get_the_terms($post_id, 'eproducts-category');

        if ($terms && !is_wp_error($terms)) {
            $category_id = $terms[0]->term_id;

            $args = array(
                'post_type' => 'product-enquiry',
                'posts_per_page' => 4,
                'post__not_in' => array($post_id),
                'tax_query' => array(
                    array(
                        'taxonomy' => 'eproducts-category',
                        'field' => 'term_id',
                        'terms' => $category_id,
                    ),
                ),
                'orderby' => 'rand',
            );

            $related_posts_query = new WP_Query($args);


            if ($related_posts_query->have_posts()) {
                ?>
                <h2 class="page-title mb-5 pb-3">Related Products</h2>
                <p> Here’s some of our most popular products people are in love with. </p>
                <div class="related-product-slider ">
                    <?php

                    while ($related_posts_query->have_posts()) {
                        $related_posts_query->the_post();
                        ?>

                        <div class="p-0" id="post-<?php the_ID(); ?>">
                            <a href="<?php the_permalink(); ?>" <?php post_class(); ?>>
                                <div class="product-card">
                                    <div class="img-box">
                                        <div class="product-img">
                                            <?php if (has_post_thumbnail()): ?>
                                                <?php the_post_thumbnail('full'); ?>
                                            <?php endif; ?>
                                        </div>
                                        <div class="hover-overlay">
                                            <!-- <div class="view-product">
                                                <img src="https://draftsite1.com/ishtara-jewellery/wp-content/uploads/2025/08/Wishlist.png"
                                                    width="30">
                                            </div> -->

                                            <div class="view-product">
                                                <img src="https://draftsite1.com/ishtara-jewellery/wp-content/uploads/2025/08/Preview.svg"
                                                    width="30">
                                            </div>
                                        </div>
                                    </div>
                                    <h6 class="mt-2 product-name"> <?php the_title(); ?></h6>
                                    <p class="mb-0 view-more-btn"> View More </p>
                                </div>
                            </a>
                        </div>

                    <?php } ?>
                </div>
                <?php


                // Restore original post data
                wp_reset_postdata();
            }
        }
        ?>

        <div class="row">
            <div class="col-md-12 text-center pt-md-5">
                <a href="<?php echo site_url('jewellery') ?>" class="elementor-button"> BACK TO JEWELLERY </a>
            </div>
        </div>
    </div>
</div>

<script>
    jQuery(document).ready(function ($) {
        $('.product-slider').slick({
            slidesToShow: 1,
            slidesToScroll: 1,
            arrows: false,
            fade: true,
            asNavFor: '.thumbnail-slider'
        });

        $('.thumbnail-slider').slick({
            slidesToShow: 5,
            slidesToScroll: 1,
            asNavFor: '.product-slider',
            dots: false,
            arrows: false,
            infinite: false,
            centerMode: false,
            focusOnSelect: true,
            vertical: true,
            verticalSwiping: true
        });
        $('.related-product-slider').slick({
            slidesToShow: 4,
            slidesToScroll: 1,
            arrows: true,
            dots: false,
            centerMode: false,
            infinite: false,
            prevArrow: '<button class="left-btn arrowbtn"><i class="icon icon-arrow-left"></i></button>',
            nextArrow: '<button class="right-btn arrowbtn"><i class="icon icon-arrow-right"></i></button>',

        });
    });
</script>



<?php get_footer(); ?>