<?php

function hello_elementor_child_enqueue_styles()
{
    wp_enqueue_style('hello-elementor-parent-style', get_template_directory_uri() . '/../hello-elementor-child/style.css');
    wp_enqueue_style('hello-elementor-parent-ecommerce', get_template_directory_uri() . '/../hello-elementor-child/ecommerce.css');
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles');


// Enqueue Booststrap 
function enqueue_bootstrap()
{
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js', array('jquery'), null, true);

}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');


//  Slick carousel script and styles
function enqueue_slick_scripts()
{
    wp_enqueue_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js', array('jquery'), null, true);
    wp_enqueue_style('slick-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_slick_scripts');


function enqueue_custom_script()
{
    wp_enqueue_script(
        'custom-script',
        get_template_directory_uri() . '../../hello-elementor-child/custom-script.js',
        array('jquery'),
        null,
        true
    );
}
add_action('wp_enqueue_scripts', 'enqueue_custom_script');



// custom code



// blog related start --------------------

function get_related_articles($post_id, $number_of_posts = 5)
{

    $args = array(
        'post_type' => 'post',
        'post__not_in' => array($post_id),
        'posts_per_page' => $number_of_posts,
        'ignore_sticky_posts' => 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );

    return get_posts($args);

    $related_posts = get_related_articles(get_the_ID());

    // If not enough related posts by category, get related posts by tag
    if (count($related_posts) < $number_of_posts) {
        $tags = wp_get_post_tags($post_id);
        if ($tags) {
            $tag_ids = array();
            foreach ($tags as $tag) {
                $tag_ids[] = $tag->term_id;
            }
            $args = array(
                'tag__in' => $tag_ids,
                'post__not_in' => array_merge(array($post_id), wp_list_pluck($related_posts, 'ID')),
                'posts_per_page' => $number_of_posts - count($related_posts),
                'ignore_sticky_posts' => 1,
            );
            $more_related_posts = get_posts($args);
            $related_posts = array_merge($related_posts, $more_related_posts);
        }
    }

    return $related_posts;
}

// blog related end --------------------




// woocommerce code start here ---------------------




//  WooCommerce product  image wrap  ----------
add_action('woocommerce_before_shop_loop_item_title', 'wrap_product_image_in_div', 5);
function wrap_product_image_in_div()
{
    echo '<div class="product-image-wrapper">';
}
add_action('woocommerce_before_shop_loop_item_title', 'close_product_image_div', 15);
function close_product_image_div()
{
    echo '</div>';
}
//  WooCommerce product image wrap ----------



function change_related_products_heading($translated_text, $text, $domain)
{
    if ('Related products' === $text) {
        $translated_text = __('Similar Products', 'your-text-domain');
    }
    return $translated_text;
}
add_filter('gettext', 'change_related_products_heading', 20, 3);






// product-categories start ----------------------------------------- 
function wpb_woocommerce_product_categories_accordion()
{
    // Get the current queried product category
    $queried_object = get_queried_object();
    $current_category_id = ($queried_object && isset($queried_object->term_id)) ? $queried_object->term_id : 0;

    // Get all parent categories of the current category
    $current_category_parents = [];
    if ($current_category_id) {
        $parent_categories = get_ancestors($current_category_id, 'product_cat');
        $current_category_parents = array_map('intval', $parent_categories);
    }

    // Recursive function to get subcategories with checkboxes
    function get_subcategories($parent_id, $level = 1, $current_category_id, $current_category_parents)
    {
        $args = array(
            'taxonomy' => 'product_cat',
            'orderby' => 'name',
            'order' => 'ASC',
            'parent' => $parent_id,
            'hide_empty' => true
        );
        $sub_categories = get_terms($args);

        if (!empty($sub_categories)) {
            echo '<ul class="list-unstyled ps-2">';
            foreach ($sub_categories as $sub_category) {
                $is_checked = ($sub_category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($sub_category->term_id == $current_category_id) ? 'current-category' : '';

                echo '<li class="' . $active_class . '">';
                echo '<div class="in-menu">';
                echo '<input type="checkbox" class="category-checkbox me-2" data-category-id="' . $sub_category->term_id . '" ' . $is_checked . '> ';

                echo '<a href="' . get_term_link($sub_category) . '">  <span class="customcheck"></span>' . $sub_category->name . '</a>';
                echo '</div>';
                get_subcategories($sub_category->term_id, $level + 1, $current_category_id, $current_category_parents);
                echo '</li>';
            }
            echo '</ul>';
        }
    }

    // Get main product categories (parent categories)
    $args = array(
        'taxonomy' => 'product_cat',
        'orderby' => 'name',
        'order' => 'ASC',
        'parent' => 0,
        'hide_empty' => true
    );
    $product_categories = get_terms($args);

    if ($product_categories) {
        ob_start();
        ?>
                    <div class="accordion" id="productCategoriesAccordion">

                        <?php
                        $shop_page_url = wc_get_page_permalink('shop');
                        $is_shop_page = is_shop();
                        ?>

                        <div class="accordion-item">
                            <div class="accordion-header <?php echo $is_shop_page ? 'current-category' : ''; ?>">
                                <label>
                                    <a href="<?php echo esc_url($shop_page_url); ?>" class="main-category">
                                        All
                                    </a>
                                </label>
                            </div>
                        </div>


                        <?php
                        $i = 0;
                        foreach ($product_categories as $category) {
                            $i++;

                            // Check if the category has subcategories
                            $sub_args = array(
                                'taxonomy' => 'product_cat',
                                'parent' => $category->term_id,
                                'hide_empty' => true
                            );
                            $sub_categories = get_terms($sub_args);
                            $has_subcategories = !empty($sub_categories);

                            // Determine if this category should be expanded
                            $is_checked = ($category->term_id == $current_category_id) ? 'checked' : '';
                            $active_class = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'current-category' : '';
                            $show_collapse = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'show' : '';
                            ?>
                            <div class="accordion-item <?php echo $active_class; ?>">
                                <div class="accordion-header d-flex align-items-center" id="heading<?php echo $i; ?>">
                                    <label for="cat<?php echo $category->term_id; ?>">
                                        <input type="checkbox" class="category-checkbox me-2"
                                            id="cat<?php echo $category->term_id; ?>"
                                            data-category-id="<?php echo $category->term_id; ?>" <?php echo $is_checked; ?>>

                                        <a href="<?php echo get_term_link($category); ?>" class="main-category">
                                            <span class="customcheck"></span> <?php echo $category->name; ?>
                                        </a>
                                    </label>

                                    <?php if ($has_subcategories) { ?>
                                        <button
                                            class="accordion-button ms-auto <?php echo ($show_collapse == '') ? 'collapsed' : ''; ?>"
                                            type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>"
                                            aria-expanded="<?php echo ($show_collapse) ? 'true' : 'false'; ?>"
                                            aria-controls="collapse<?php echo $i; ?>"
                                            data-category-id="<?php echo $category->term_id; ?>">
                                            <i class="fa fa-angle-down"></i>
                                        </button>
                                    <?php } ?>
                                </div>
                                <?php if ($has_subcategories) { ?>
                                    <div id="collapse<?php echo $i; ?>"
                                        class="accordion-collapse collapse <?php echo $show_collapse; ?>"
                                        aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#productCategoriesAccordion">
                                        <div class="accordion-body ps-0 pe-0">
                                            <?php get_subcategories($category->term_id, 1, $current_category_id, $current_category_parents); ?>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                            <?php
                        }
                        ?>
                    </div>

                    <script>
                        document.addEventListener("DOMContentLoaded", function () {
                            var savedCategories = JSON.parse(localStorage.getItem("checkedCategories")) || [];

                            savedCategories.forEach(function (categoryId) {
                                var checkbox = document.querySelector('.category-checkbox[data-category-id="' + categoryId + '"]');
                                if (checkbox) {
                                    checkbox.checked = true;
                                }
                            });

                            document.querySelectorAll(".category-checkbox").forEach(function (checkbox) {
                                checkbox.addEventListener("change", function () {
                                    var categoryId = this.getAttribute("data-category-id");
                                    if (this.checked) {
                                        if (!savedCategories.includes(categoryId)) {
                                            savedCategories.push(categoryId);
                                        }
                                    } else {
                                        savedCategories = savedCategories.filter(id => id !== categoryId);
                                    }
                                    localStorage.setItem("checkedCategories", JSON.stringify(savedCategories));
                                });
                            });

                            var activeCategory = localStorage.getItem("activeCategory");
                            if (activeCategory) {
                                var activeAccordion = document.querySelector('[data-category-id="' + activeCategory + '"]');
                                if (activeAccordion) {
                                    var collapseElement = activeAccordion.getAttribute("data-bs-target");
                                    document.querySelector(collapseElement).classList.add("show");
                                    activeAccordion.classList.remove("collapsed");
                                    activeAccordion.setAttribute("aria-expanded", "true");
                                }
                            }

                            document.querySelectorAll(".accordion-button").forEach(function (button) {
                                button.addEventListener("click", function () {
                                    var categoryId = this.getAttribute("data-category-id");
                                    if (document.querySelector(this.getAttribute("data-bs-target")).classList.contains("show")) {
                                        localStorage.removeItem("activeCategory");
                                    } else {
                                        localStorage.setItem("activeCategory", categoryId);
                                    }
                                });
                            });
                        });
                    </script>

                    <style>
                        .current-category>a {
                            font-weight: bold;
                            color: #ff6600;
                        }

                        .category-checkbox {
                            display: none;
                        }

                        span.customcheck {
                            background: #FFFFFF 0% 0% no-repeat padding-box;
                            border: 1px solid #B7DBEE;
                            border-radius: 5px;
                            width: 15px;
                            height: 15px;
                            position: relative;
                            margin-right: 6px;
                            margin-top: 0px;
                            top: 2px;
                            display: none;
                        }

                        .current-category [type=checkbox]:checked~a span.customcheck {
                            background: #326783;
                            border-color: #326783;
                        }

                        .current-category [type=checkbox]~a .customcheck:after {
                            content: "";
                            position: absolute;
                        }

                        .current-category a input:checked~.customcheck:after {
                            display: block;
                        }

                        .current-category a .customcheck:after {
                            left: 5px;
                            top: 2px;
                            width: 4px;
                            height: 8px;
                            border: solid white;
                            border-width: 0 2px 2px 0;
                            -webkit-transform: rotate(45deg);
                            -ms-transform: rotate(45deg);
                            transform: rotate(45deg);
                        }
                    </style>
                    <?php
                    return ob_get_clean();
    }
}

add_shortcode('product_categories_accordion', 'wpb_woocommerce_product_categories_accordion');

// product category for sidebar end -------------------------------





// brand start --------
function apply_brand_checkbox_filter_to_products($query)
{
    if (is_admin() || !$query->is_main_query()) {
        return;
    }

    // Only apply on shop or product archive pages
    if (is_post_type_archive('product') || is_tax('product_cat')) {

        if (!empty($_GET['product_brand']) && is_array($_GET['product_brand'])) {
            $brands = array_map('sanitize_text_field', $_GET['product_brand']);

            // Fetch existing tax_query and merge
            $tax_query = (array) $query->get('tax_query');

            $tax_query[] = array(
                'taxonomy' => 'product_brand',
                'field' => 'slug',
                'terms' => $brands,
                'operator' => 'IN',
            );

            $query->set('tax_query', $tax_query);
        }
    }
}
add_action('pre_get_posts', 'apply_brand_checkbox_filter_to_products');



function brand_archive_checkbox_filter_shortcode()
{
    $terms = get_terms(array(
        'taxonomy' => 'product_brand',
        'hide_empty' => true,
    ));

    if (empty($terms) || is_wp_error($terms)) {
        return '<p>No brands available.</p>';
    }

    $current_term = is_tax('product_brand') ? get_queried_object() : null;

    ob_start(); ?>
    <form method="get" id="brand-archive-filter" class="brand-filter-form">
        <div class="brand-filter-checkboxes">
            <?php foreach ($terms as $term): ?>
                <?php
                $checked = ($current_term && $current_term->term_id === $term->term_id) ? 'checked' : '';
                ?>
                <label>
                    <p class="mb-0 d-inline"><?php echo esc_html($term->name); ?> </p>
                    <input type="checkbox" name="brand" value="<?php echo esc_url(get_term_link($term)); ?>"
                        onchange="window.location.href = this.value;" <?php echo $checked; ?>>

                    <span class="customcheckbox"> </span>
                </label>
            <?php endforeach; ?>
        </div>
    </form>
    <?php
    return ob_get_clean();
}
add_shortcode('brand_checkbox_filter', 'brand_archive_checkbox_filter_shortcode');

// brand end --------




// Add custom quantity buttons JS start -----------

add_action('wp_footer', 'custom_quantity_buttons_script_everywhere');
function custom_quantity_buttons_script_everywhere()
{
    ?>
    <script>
        function initQtyButtons(context = document) {
            const qtyContainers = context.querySelectorAll('.quantity');
            qtyContainers.forEach(qty => {
                const input = qty.querySelector('input.qty');
                if (!input) return;

                // Avoid duplicate buttons
                if (qty.querySelector('.custom-plus')) return;

                // Create minus button
                const minus = document.createElement('button');
                minus.type = 'button';
                minus.innerHTML = '−';
                minus.className = 'custom-minus';

                // Create plus button
                const plus = document.createElement('button');
                plus.type = 'button';
                plus.innerHTML = '+';
                plus.className = 'custom-plus';

                // Insert buttons
                qty.insertBefore(minus, input);
                qty.appendChild(plus);

                // Event listeners
                minus.addEventListener('click', () => {
                    let val = parseInt(input.value) || 0;
                    let min = parseInt(input.min) || 1;
                    if (val > min) {
                        input.value = val - 1;
                        input.dispatchEvent(new Event('change', { bubbles: true }));
                    }
                });

                plus.addEventListener('click', () => {
                    let val = parseInt(input.value) || 0;
                    let max = parseInt(input.max) || 9999;
                    if (val < max) {
                        input.value = val + 1;
                        input.dispatchEvent(new Event('change', { bubbles: true }));
                    }
                });
            });
        }

        document.addEventListener('DOMContentLoaded', function () {
            // Run on page load
            initQtyButtons();

            // Watch for dynamically added content (e.g., Quick View)
            const observer = new MutationObserver(mutations => {
                mutations.forEach(mutation => {
                    mutation.addedNodes.forEach(node => {
                        if (node.nodeType === 1) {
                            if (node.matches('.quantity, .quick-view-content, .woocommerce')) {
                                initQtyButtons(node);
                            } else if (node.querySelectorAll) {
                                initQtyButtons(node);
                            }
                        }
                    });
                });
            });

            observer.observe(document.body, { childList: true, subtree: true });
        });
    </script>
    <?php
}


// Add custom quantity buttons JS end --------------




// single shop banner  start ---------------------------
// Remove default breadcrumb location
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);

// Add breadcrumb before product title
add_action('woocommerce_single_product_summary', 'woocommerce_breadcrumb', 4);


add_action('woocommerce_before_main_content', 'custom_shop_header', 5);
function custom_shop_header() {
    if (is_product()) {
        ?>
        <div class="woocommerce-shop-banner pt-md-5 pb-md-5 pt-4 pb-4 bg-light">
            <div class="container">
                <div class="row g-md-3 align-items-center">
                    <div class="col-md-12">
                        <div class="banner-title text-center">
                            <?php
                            // Display product category name if applicable
                            if (is_product_category()) {
                                $category = get_queried_object();
                                if ($category) {
                                    echo '<h1>' . esc_html($category->name) . '</h1>';
                                }
                            } else {
                                echo '<h1>Shop</h1>';
                            }

                            // Display WooCommerce breadcrumb
                            if (function_exists('woocommerce_breadcrumb')) {
                                woocommerce_breadcrumb(array(
                                    'delimiter'   => ' / ',
                                    'wrap_before' => '<nav class="woocommerce-breadcrumb" itemprop="breadcrumb">',
                                    'wrap_after'  => '</nav>',
                                ));
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}
// single shop banner end ---------------------------



// wpgis  product gallery ------------------
add_action('wp_footer', 'hide_gallery_thumbs_if_single_image');
function hide_gallery_thumbs_if_single_image()
{
    if (is_product()): ?>
                    <script>
                        jQuery(document).ready(function ($) {
                            $(window).on('load', function () {
                                var thumbCount = $('.wpgis-slider-nav .slick-slide').length;

                                if (thumbCount <= 1) {
                                    $('.wpgis-slider-nav').hide();
                                    $('.wpgis-slider-for').addClass('full-width-slider');
                                } else {
                                    $('.wpgis-slider-nav').show();
                                    $('.wpgis-slider-for').removeClass('full-width-slider');
                                }
                            });
                        });
                    </script>
                <?php endif;
}
// wpgis  product gallery end ------------------




// validation start -----------------------------------------------------------



// validation woocommerce start 


add_action('woocommerce_save_account_details_errors', 'validate_my_account_fields', 10, 1);

function validate_my_account_fields($errors)
{
    // Validate First Name
    if (isset($_POST['account_first_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_first_name'])) {
        $errors->add('validation', __('Allowed characters for First Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Last Name
    if (isset($_POST['account_last_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_last_name'])) {
        $errors->add('validation', __('Allowed characters for Last Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Display Name
    if (isset($_POST['account_display_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_display_name'])) {
        $errors->add('validation', __('Allowed characters for Display Name are alphabets and spaces only.', 'woocommerce'));
    }
}




add_action('woocommerce_after_save_address_validation', 'validate_billing_address_fields', 10, 2);

function validate_billing_address_fields($user_id, $address_type)
{
    if ('billing' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $billing_first_name = isset($_POST['billing_first_name']) ? sanitize_text_field($_POST['billing_first_name']) : '';
        $billing_last_name = isset($_POST['billing_last_name']) ? sanitize_text_field($_POST['billing_last_name']) : '';
        $billing_city = isset($_POST['billing_city']) ? sanitize_text_field($_POST['billing_city']) : '';
        $billing_address_1 = isset($_POST['billing_address_1']) ? sanitize_text_field($_POST['billing_address_1']) : '';

        $billing_postcode = isset($_POST['billing_postcode']) ? sanitize_text_field($_POST['billing_postcode']) : '';
        $billing_email = isset($_POST['billing_email']) ? sanitize_email($_POST['billing_email']) : '';

        // Validate Billing First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_first_name)) {
            $validation_errors[] = __('Allowed characters for Billing First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_last_name)) {
            $validation_errors[] = __('Allowed characters for Billing Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_city)) {
            $validation_errors[] = __('Allowed characters for Billing City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $billing_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $billing_postcode)) {
            $validation_errors[] =  __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate Billing Email (Basic Email validation)
        if (!is_email($billing_email)) {
            $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}








add_action('woocommerce_after_save_address_validation', 'validate_shipping_address_fields', 10, 2);

function validate_shipping_address_fields($user_id, $address_type)
{
    if ('shipping' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $shipping_first_name = isset($_POST['shipping_first_name']) ? sanitize_text_field($_POST['shipping_first_name']) : '';
        $shipping_last_name = isset($_POST['shipping_last_name']) ? sanitize_text_field($_POST['shipping_last_name']) : '';
        $shipping_city = isset($_POST['shipping_city']) ? sanitize_text_field($_POST['shipping_city']) : '';
        $shipping_address_1 = isset($_POST['shipping_address_1']) ? sanitize_text_field($_POST['shipping_address_1']) : '';

        $shipping_postcode = isset($_POST['shipping_postcode']) ? sanitize_text_field($_POST['shipping_postcode']) : '';
      //  $shipping_email = isset($_POST['shipping_email']) ? sanitize_email($_POST['shipping_email']) : '';

        // Validate shipping First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_first_name)) {
            $validation_errors[] = __('Allowed characters for shipping First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_last_name)) {
            $validation_errors[] = __('Allowed characters for shipping Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_city)) {
            $validation_errors[] = __('Allowed characters for shipping City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $shipping_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $shipping_postcode)) {
            $validation_errors[] =  __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate shipping Email (Basic Email validation)
        // if (!is_email($shipping_email)) {
        //     $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        // }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}




// validation woocommerce end --------------------







// contact form validation 

// Validate text fields (only alphabets allowed)
add_filter( 'wpcf7_validate_text', 'alpha_validation_filter_text', 20, 2 );
add_filter( 'wpcf7_validate_text*', 'alpha_validation_filter_text', 20, 2 );

function alpha_validation_filter_text( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'names' === $tag->name ) {
        $name_of_the_input = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input) ) {
            $result->invalidate( $tag, "Allowed characters are Alphabets only." );
        }
    }

    if ( 'lname' === $tag->name ) {
        $name_of_the_input = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input) ) {
            $result->invalidate( $tag, "Allowed characters are Alphabets only." );
        }
    }

    return $result;
}

// Validate phone number (must be exactly 10 digits)
add_filter( 'wpcf7_validate_tel', 'numeric_phone_validation_filter', 20, 2 );
add_filter( 'wpcf7_validate_tel*', 'numeric_phone_validation_filter', 20, 2 );

function numeric_phone_validation_filter( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'phone' === $tag->name ) {
        $phone_number = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! preg_match( '/^\d{8}$/', $phone_number ) ) {
            $result->invalidate( $tag, "Phone number must contain exactly 8 digits." );
        }
    }

    return $result;
}



// Validate email (must be a valid email format)
add_filter( 'wpcf7_validate_email', 'validate_email_filter', 20, 2 );
add_filter( 'wpcf7_validate_email*', 'validate_email_filter', 20, 2 );

function validate_email_filter( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'email' === $tag->name ) {
        $email = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! filter_var( $email, FILTER_VALIDATE_EMAIL ) ) {
            $result->invalidate( $tag, "Please enter a valid email address." );
        }
    }

    return $result;
}


// Validate textarea field (message)
add_filter( 'wpcf7_validate_textarea', 'validate_textarea_filter', 20, 2 );
add_filter( 'wpcf7_validate_textarea*', 'validate_textarea_filter', 20, 2 );

function validate_textarea_filter( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'message' === $tag->name ) {
        $message = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        // Allowed characters: alphabets, spaces, common punctuation marks
        if ( ! preg_match( '/^[a-zA-Z0-9\s.,!?()-]+$/', $message ) ) {
            $result->invalidate( $tag, "Message contains invalid characters. Only letters, numbers, spaces, and punctuation are allowed." );
        }

        // Min 10 characters, Max 500 characters
        if ( strlen( $message ) < 10 || strlen( $message ) > 500 ) {
            $result->invalidate( $tag, "Message must be between 10 and 500 characters." );
        }
    }

    return $result;
}




// validation end -----------------------------------------------------------


// Add Eye Icon (Quick View style but goes to product page)
// add_action('woocommerce_after_shop_loop_item', 'custom_eye_icon_link', 15);
// function custom_eye_icon_link() {
//     global $product;
//     $product_link = get_permalink($product->get_id());
    
//     echo '<a href="' . esc_url($product_link) . '" class="custom-eye-icon" title="View Product">
//            <img src="https://draftsite1.com/ishtara-jewellery/wp-content/uploads/2025/08/Preview.svg" width="30">
//           </a>';
// }
// Add Eye Icon that triggers YITH Quick View
add_action('woocommerce_after_shop_loop_item', 'custom_eye_icon_link', 15);
function custom_eye_icon_link() {
    global $product;
    $product_id = $product->get_id();
    
    echo '<a href="#" 
              class="custom-eye-icon yith-wcqv-button" 
              data-product_id="' . esc_attr($product_id) . '" 
              title="Quick View">
              <img src="https://draftsite1.com/ishtara-jewellery/wp-content/uploads/2025/08/Preview.svg" width="30">
          </a>';
}





// Change Related Products Heading
add_filter( 'woocommerce_product_related_products_heading', 'custom_related_products_title' );

function custom_related_products_title( $heading ) {
    return 'Related Products'; 
}

// Add Back to Shop button under Related Products
add_action( 'woocommerce_after_related_products', 'custom_back_to_shop_button' );

function custom_back_to_shop_button() {
    ?>
    <div class="back-to-shop text-center" style="margin-top:20px; text-align:center;">
        <a class="button wc-backward elementor-button" href="<?php echo get_permalink( wc_get_page_id( 'shop' ) ); ?>">
           Back to Shop
        </a>
    </div>
    <?php
}












// E-Product  taxonomy pagination start -----------------

function custom_products_taxonomy_posts_per_page($query)
{
    if (
        !is_admin() &&
        $query->is_main_query() &&
        is_tax('eproducts-category')
    ) {
        $query->set('posts_per_page', 12);
    }
}
add_action('pre_get_posts', 'custom_products_taxonomy_posts_per_page');


// E-Product  taxonomy pagination end







// featuredeproducts slider start------------------
function display_featuredeproducts_slider($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => -1,
        ),
        $atts,
        'featuredeproducts'
    );

    $args = array(
        'post_type' => 'product-enquiry',
        'posts_per_page' => $atts['posts_per_page'],
        'meta_query' => array(
            array(
                'key' => '_is_ns_featured_post',
                'value' => 'yes',
                'compare' => '='
            )
        )
    );

    $featuredeproducts_query = new WP_Query($args);


    ob_start();

    if ($featuredeproducts_query->have_posts()): ?>
        <div class="featured-slider">
            <div class="efeaturedproduct-slider">
                <?php while ($featuredeproducts_query->have_posts()):
                    $featuredeproducts_query->the_post();
                    ?>

                   <div class="item">
                   <a href="<?php the_permalink(); ?>" <?php // post_class(); ?>>
                      <div class="product-card">
                        <div class="img-box">
                            <div class="product-img">
                                <?php if (has_post_thumbnail()): ?>
                                    <?php the_post_thumbnail('full'); ?>
                                <?php endif; ?>
                            </div>
                            <div class="hover-overlay">
                                <!-- <div class="view-product">
                                    <img src="https://draftsite1.com/ishtara-jewellery/wp-content/uploads/2025/08/Wishlist.png"
                                        width="30">
                                </div> -->

                                <div class="view-product">
                                    <img src="https://draftsite1.com/ishtara-jewellery/wp-content/uploads/2025/08/Preview.svg"
                                        width="30">
                                </div>
                            </div>
                        </div>
                        <h6 class="mt-2 product-name"> <?php the_title(); ?></h6>
                        <p class="mb-0 view-more-btn"> View More </p>
                    </div>
                    </a>
                    </div>

                <?php endwhile; ?>
            </div>
        </div>


    <?php else:
        echo 'No featuredeproducts found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('featuredeproducts_slider', 'display_featuredeproducts_slider');
// featuredeproducts slider end ------------------------------



function woocommerce_product_carousel_shortcode($atts)
{
	$atts = shortcode_atts(
		array(
			'limit' => 10,
			'category' => '', // Optional category
			'featured' => true, // Add featured flag
		),
		$atts,
		'product_carousel'
	);

	// Base query args
	$args = array(
		'post_type' => 'product',
		'posts_per_page' => $atts['limit'],
	);

	// Filter by category if provided
	if (!empty($atts['category'])) {
		$args['product_cat'] = $atts['category'];
	}

	// Filter for featured products
	if (!empty($atts['featured'])) {
		$args['tax_query'][] = array(
			'taxonomy' => 'product_visibility',
			'field' => 'name',
			'terms' => 'featured',
			'operator' => 'IN',
		);
	}

	$query = new WP_Query($args);
	ob_start();

	if ($query->have_posts()) { ?>
		<div class="featured-product-slider archive woocommerce">
          
			<?php while ($query->have_posts()):
				$query->the_post();
				global $product; ?>
                  
				<div class="item">
                <ul class="products"> 
                <?php wc_get_template_part( 'content', 'product' ); ?>
                </ul>
				</div>
				<?php
			endwhile;
			?>
            
		</div>
	<?php }
	?>

	<?php
	wp_reset_postdata();

	$output = ob_get_clean();
	return $output;
}
add_shortcode('featured_product_carousel', 'woocommerce_product_carousel_shortcode');



function woocommerce_product_categories_shortcode($atts) {
    $atts = shortcode_atts(
        array(
            'hide_empty' => true,
            'parent'     => 0,
        ),
        $atts,
        'product_categories'
    );

    $args = array(
        'taxonomy'   => 'product_cat',
        'hide_empty' => filter_var($atts['hide_empty'], FILTER_VALIDATE_BOOLEAN),
        'parent'     => intval($atts['parent']),
    );

    $terms = get_terms($args);

    if ( empty($terms) || is_wp_error($terms) ) {
        return '<p>No product categories found.</p>';
    }

    // Filter only featured categories
    $featured_terms = array();
    foreach ($terms as $term) {
        $is_featured = get_term_meta($term->term_id, 'is_featured', true); // true flag returns single value
        if ($is_featured) { // check if checkbox is checked
            $featured_terms[] = $term;
        }
    }

    if ( empty($featured_terms) ) {
        return '<p>No featured categories found.</p>';
    }

    ob_start();
    ?>
    <div class="woocommerce categories-list">
        <div class="product-categories-slider">
            <?php foreach ( $featured_terms as $term ) : 
                $thumbnail_id = get_term_meta( $term->term_id, 'thumbnail_id', true );
                $image = wp_get_attachment_url( $thumbnail_id );
                ?>
                <div class="items category-item">
                    <a href="<?php echo esc_url( get_term_link( $term ) ); ?>">
                        <div class="category-img"> 
                        <?php if ( $image ) : ?>
                            <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $term->name ); ?>" />
                        <?php endif; ?>
                        </div>
                        <h4><?php echo esc_html( $term->name ); ?></h4>
                    </a>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode('product_categories_list', 'woocommerce_product_categories_shortcode');







// for pagination shop  start
// Set default products per page to 24
function custom_woocommerce_products_per_page($cols)
{
	return 12; // Display 9 products on the first page
}
add_filter('loop_shop_per_page', 'custom_woocommerce_products_per_page', 20);

// Enqueue the AJAX load more script
function load_more_scripts()
{
	global $wp_query;

	// Register the script
	wp_register_script('load-more', get_stylesheet_directory_uri() . '../../hello-elementor-child/load-more.js', array('jquery'), null, true);

	// Localize the script with data for AJAX
	wp_localize_script('load-more', 'load_more_params', array(
		'ajaxurl' => admin_url('admin-ajax.php'), // WordPress AJAX URL
		'current_page' => max(1, get_query_var('paged')), // Current page
		'max_page' => $wp_query->max_num_pages // Max number of pages
	));

	// Enqueue the script
	wp_enqueue_script('load-more');
}
add_action('wp_enqueue_scripts', 'load_more_scripts');

// AJAX handler for loading more products inside an unordered list
function load_more_products()
{
	$paged = $_POST['page']; // Get the next page number from the AJAX request

	$args = array(
		'post_type' => 'product',
		'posts_per_page' => 3, // Load 3 products per request
		'paged' => $paged,
	);

	$loop = new WP_Query($args);

	if ($loop->have_posts()):
		while ($loop->have_posts()):
			$loop->the_post();
			echo '<li>';
			wc_get_template_part('content', 'product'); // Load product template part
			echo '</li>';
		endwhile;
	endif;

	wp_die(); // Required to terminate the script properly
}
add_action('wp_ajax_load_more', 'load_more_products'); // For logged-in users
add_action('wp_ajax_nopriv_load_more', 'load_more_products'); // For non-logged-in users

// Remove default WooCommerce pagination
remove_action('woocommerce_after_shop_loop', 'woocommerce_pagination', 10);

// Add custom "Load More" button on the shop page
function custom_load_more_button()
{
	global $wp_query;
	if ($wp_query->max_num_pages > 1) {
		echo '<div id="load-more-container" class="text-center mt-md-5">';
		echo '<button id="load-more-btn" class="btn btn-primary">Load More</button>';
		echo '</div>';
	}
}
add_action('woocommerce_after_shop_loop', 'custom_load_more_button', 10);


// for pagination shop end










function product_enquiry_loadmore_scripts() {
    wp_enqueue_script('jquery');

    wp_enqueue_script(
        'loadmore-script',
        get_stylesheet_directory_uri() . '../../hello-elementor-child/loadmore.js',
        array('jquery'),
        '1.0',
        true
    );

    wp_localize_script('loadmore-script', 'loadmore_params', array(
        'ajaxurl' => admin_url('admin-ajax.php'),
    ));
}
add_action('wp_enqueue_scripts', 'product_enquiry_loadmore_scripts');


function loadmore_product_enquiry_ajax() {
    $paged = (isset($_POST['page'])) ? intval($_POST['page']) + 1 : 1;

    $args = array(
        'post_type' => 'product-enquiry',
        'posts_per_page' => 6,
        'paged' => $paged,
    );

    $query = new WP_Query($args);

    if($query->have_posts()) :
        while($query->have_posts()): $query->the_post(); ?>
            <div class="col-md-4 col-sm-6 product-item" id="post-<?php the_ID(); ?>">
                <a href="<?php the_permalink(); ?>" <?php post_class(); ?>>
                    <div class="product-card">
                        <div class="img-box">
                            <div class="product-img">
                                <?php if (has_post_thumbnail()) the_post_thumbnail('full'); ?>
                            </div>
                            <div class="hover-overlay">
                                <div class="view-product">
                                    <img src="https://draftsite1.com/ishtara-jewellery/wp-content/uploads/2025/08/Preview.svg" width="30">
                                </div>
                            </div>
                        </div>
                        <h6 class="mt-2 product-name"><?php the_title(); ?></h6>
                        <p class="mb-0 view-more-btn">View More</p>
                    </div>
                </a>
            </div>
        <?php endwhile;
    endif;

    wp_die();
}
add_action('wp_ajax_loadmore_product_enquiry', 'loadmore_product_enquiry_ajax');
add_action('wp_ajax_nopriv_loadmore_product_enquiry', 'loadmore_product_enquiry_ajax');



















// Home slider Start --------------------------------------------
function display_banner_home($atts)
{
    $args = array(
        'post_type' => 'main-slider',
    );

    $mainslider_query = new WP_Query($args);

    ob_start();

    if ($mainslider_query->have_posts()):
        $total_slides = $mainslider_query->post_count;
        ?>
        <div id="homebanner" class="carousel slide hero-banner carousel-slide" data-bs-ride="carousel">
            <div class="carousel-inner">
                <?php
                $first = true;
                while ($mainslider_query->have_posts()):
                    $mainslider_query->the_post(); ?>

                    <div class="carousel-item <?php echo $first ? 'active' : ''; ?>">
                        <?php if (has_post_thumbnail()) {
                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                        } ?>
                        <div class="carousel-caption">
                            <div class="container">
                                <div class="row">
                                    <div class="col-md-5 animated slideInLeft"
                                        data-settings="{&quot;_animation&quot;:&quot;slideInLeft&quot;}">
                                        <p class="subtitle"><?php the_title(); ?></p>

                                        <h3 class="title"><?php the_content(); ?></h3>
                                        <div class="btnlight pt-3">
                                            <?php
                                            $links = get_field('button_link');
                                            if ($links) {
                                                $link_url = $links['url'];
                                                $link_title = $links['title'];
                                                ?>
                                                <a href="<?php echo esc_url($link_url); ?>" class="elementor-button theme-btn-custom btn-light">
                                                    <?php echo esc_html($link_title); ?>
                                                </a>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    $first = false;
                endwhile; ?>
            </div>


            <?php if ($total_slides > 1): ?>
                <div class="carousel-indicator">
                    <?php for ($i = 0; $i < $total_slides; $i++): ?>
                        <button type="button" data-bs-target="#homebanner" data-bs-slide-to="<?php echo $i; ?>"
                            class="<?php echo $i === 0 ? 'active' : ''; ?>">
                            <span></span>
                        </button>
                    <?php endfor; ?>
                </div>
            <?php endif; ?>

            <script>
                document.addEventListener("DOMContentLoaded", function () {
                    var myCarousel = document.querySelector("#homebanner");
                    var indicators = document.querySelectorAll(".carousel-indicator button");

                    myCarousel.addEventListener("slid.bs.carousel", function (event) {
                        // Remove 'active' class from all indicators
                        indicators.forEach(function (indicator) {
                            indicator.classList.remove("active");
                        });

                        // Add 'active' class to the current indicator
                        if (indicators[event.to]) {
                            indicators[event.to].classList.add("active");
                        }
                    });
                });
            </script>


        </div>

    <?php else: ?>
        <div>No Slider found.</div>
    <?php endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('banner_home', 'display_banner_home');


// Home slider end --------------------------------------------


// reviews slider start------------------
function display_reviews_slider($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => -1,
        ),
        $atts,
        'reviews'
    );

    $args = array(
        'post_type' => 'reviews',
        'posts_per_page' => $atts['posts_per_page'],
        'meta_query' => array(
            array(
                'key' => '_is_ns_featured_post',
                'value' => 'yes',
                'compare' => '='
            )
        )
    );

    $reviews_query = new WP_Query($args);


    ob_start();

    if ($reviews_query->have_posts()): ?>
        <div class="testimonials-slider">
            <div class="testimonials-slider-one">
                <?php while ($reviews_query->have_posts()):
                    $reviews_query->the_post();
                    ?>

                   <div class="item ps-2 pe-2">
                        <div class="testimonials-box-one">
                            <div class="img-wrap">
                            <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                } ?>
                            </div>                                                       
                            <div class="rating-area">
                                <?php
                                $rating = get_field('rating');
                                if ($rating):
                                    echo '<div class="rating">';
                                    echo str_repeat('★', $rating);
                                    echo '</div>';
                                endif;
                                ?>
                            </div>
                            <div class="content-box">
                                <div class="description"> <?php echo get_the_content(); ?>
                                </div>
                                <?php /*
                                $content = get_the_content();
                                $word_count = str_word_count(wp_strip_all_tags(strip_shortcodes($content)));
                                if ($word_count > 35):
                                    ?>
                                    <a data-bs-toggle="modal" data-bs-target="#exampleModal<?php echo get_the_ID(); ?>"
                                        class="read-more-testimonial"> Read More</a>
                                <?php endif; */ ?>
                            </div>
                            <div class="testimonials-wrap">
                                <h1 class="title"> -  <?php echo get_the_title(); ?> </h1>                                
                            </div>

                        </div>
                    </div>

                <?php endwhile; ?>
            </div>
        </div>

        <?php while ($reviews_query->have_posts()):
            $reviews_query->the_post(); ?>
            <div class="model-testimonial modal modal-md" id="exampleModal<?php echo get_the_ID(); ?>" tabindex="-1"
                aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg modal-dialog-centered">
                    <div class="modal-content">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        <div class="modal-body p-0">


                            <div class="testimonial-model">
                                <div class="testimonials-box-popup" id="<?php echo get_the_ID(); ?>">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="img-wrap">
                                                <?php if (has_post_thumbnail()) {
                                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                                } ?>
                                            </div>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="testimonials-wrap">
                                                <h1 class="title mt-0"> <?php echo get_the_title(); ?> </h1>
                                                <?php
                                                $position = get_field('position');
                                                if ($position):
                                                    echo '<p class="position mb-0">';
                                                    echo $position;
                                                    echo '</p>';
                                                endif; ?>
                                            </div>

                                            <div class="rating-area">
                                                <?php
                                                $rating = get_field('rating');
                                                if ($rating):
                                                    echo '<div class="rating">';
                                                    echo str_repeat('★', $rating);
                                                    echo '</div>';
                                                endif;
                                                ?>
                                            </div>

                                            <div class="content-box">
                                                <div class="description">
                                                    <?php echo get_the_content(); ?>
                                                </div>
                                            </div>

                                        </div>
                                    </div>

                                </div>
                            </div>


                        </div>
                    </div>
                </div>
            </div>

        <?php endwhile; ?>


    <?php else:
        echo 'No reviews found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('reviews_slider', 'display_reviews_slider');
// reviews slider end ------------------------------


// reviews page start ------------------------------------------------------------


function display_reviews($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
        ),
        $atts,
        'reviews'
    );

    // Get the current page


    $args = array(
        'post_type' => 'reviews',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );


    $reviews_query = new WP_Query($args);

    ob_start();

    if ($reviews_query->have_posts()): ?>
        <div class="reviews-page reviews-main">
            <div class="row g-md-5 g-3">
                <?php while ($reviews_query->have_posts()):
                    $reviews_query->the_post();
                    ?>

                <div class="col-md-4">
                <div class="testimonials-box-one">
                            <div class="img-wrap">
                            <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                } ?>
                            </div>                                                       
                            <div class="rating-area">
                                <?php
                                $rating = get_field('rating');
                                if ($rating):
                                    echo '<div class="rating">';
                                    echo str_repeat('★', $rating);
                                    echo '</div>';
                                endif;
                                ?>
                            </div>
                            <div class="content-box">
                                <div class="description"> <?php echo get_the_content(); ?>
                                </div>
                               
                            </div>
                            <div class="testimonials-wrap">
                                <h1 class="title"> -  <?php echo get_the_title(); ?> </h1>                                
                            </div>

                        </div>                 
                    </div>

                <?php endwhile; ?>
            </div>


            <?php if ($reviews_query->max_num_pages > 1): ?>
                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                    <div class="pagination-style-one">
                        <?php
                        echo paginate_links(array(
                            'total' => $reviews_query->max_num_pages,
                            'current' => max(1, get_query_var('paged')),
                            'format' => '?paged=%#%',
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => '<i class="eicon-chevron-left"></i>',
                            'next_text' => '<i class="eicon-chevron-right"></i>',
                            'end_size' => 2,
                            'mid_size' => 2
                        ));
                        ?>
                    </div>
                </div>
            <?php endif; ?>


        <?php else:
        echo 'No reviews found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('reviews', 'display_reviews');


// reviews list end------------




// career page start ------------------------------------------------------------


function display_career($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
        ),
        $atts,
        'career'
    );

    // Get the current page


    $args = array(
        'post_type' => 'careers',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );


    $career_query = new WP_Query($args);

    ob_start();

    if ($career_query->have_posts()): ?>
        <div class="career-page career-main">
            <div class="career">
                <?php while ($career_query->have_posts()):
                    $career_query->the_post();
                    ?>

                <div class="career-box py-4" data-bs-toggle="modal" data-bs-target="#careerModal<?php echo get_the_ID(); ?>">
                    <div class="row m-0">
                        <div class="col-lg-10 p-0">
                            <h5 class="mt-0 mb-2"><?php echo get_the_title(); ?></h5>
                            <p class="pb-2"> <?php echo get_the_excerpt(); ?> </p>
        
                            <?php
                                $job_type = get_field('job_type');
                                if ($job_type):
                                    echo '<span>';
                                    echo $job_type;
                                    echo '</span>';
                                endif; ?>

                        </div>
                        <div class="col-lg-2 p-0 text-end">
                            <a href="javascript:void(0)">VIEW MORE <i class="fa fa-angle-right"></i></a>
                        </div>
                    </div>
                </div>

                <?php endwhile; ?>

                </div>

                <?php while ($career_query->have_posts()):
            $career_query->the_post(); ?>

            
                <div class="modal careerModal" id="careerModal<?php echo get_the_ID(); ?>">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content rounded-0">
                            <!-- Modal body -->
                            <div class="modal-body">
                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                <div class="row">
                                    <div class="col-md-8 pe-lg-5">
                                        <span class="date d-block">Home / Careers / Sales Consultant</span>
                                        <h2><?php echo get_the_title(); ?></h2>
                                        <hr>

                                         <?php
                                            $role_overview = get_field( 'role_overview' );
                                            if ( ! empty( $role_overview ) ) { ?>
                                            <div class="mb-4 pt-4">
                                                <h6>ROLE OVERVIEW</h6>
                                                <div> 
                                                    <?php echo wp_kses_post( $role_overview ); ?>
                                                </div>
                                            </div>
                                            <?php  }  ?>

                                            <?php
                                            $key_responsibilities = get_field( 'key_responsibilities' );
                                            if ( ! empty( $key_responsibilities ) ) { ?>
                                            <div class="mb-4">
                                                <h6>KEY RESPONSIBILITIES</h6>
                                                <div> 
                                                    <?php echo wp_kses_post( $key_responsibilities ); ?>
                                                </div>
                                            </div>
                                            <?php  }  ?>

                                            <?php
                                            $requirements = get_field( 'requirements' );
                                            if ( ! empty( $requirements ) ) { ?>
                                            <div class="mb-4">
                                                <h6>Requirements</h6>
                                                <div> 
                                                    <?php echo wp_kses_post( $requirements ); ?>
                                                </div>
                                            </div>
                                            <?php  }  ?>

                                            <?php
                                            $what_we_offer = get_field( 'what_we_offer' );
                                            if ( ! empty( $what_we_offer ) ) { ?>
                                            <div class="mb-4">
                                                <h6>What We Offer</h6>
                                                <div> 
                                                    <?php echo wp_kses_post( $what_we_offer ); ?>
                                                </div>
                                            </div>
                                            <?php  }  ?>

                                    </div>
                                    <div class="col-md-4">
                                        <div class="div">
                                          
                                            <?php
                                            $job_type = get_field('job_type');
                                            if ($job_type): ?>
                                                <div class="pb-1">
                                                    <h6 class="mt-0">TYPE</h6>
                                                    <p> <?php echo $job_type; ?> </p>                                        
                                                </div>
                                            <?php endif; ?>
                                           

                                            <?php
                                            $location = get_field('location');
                                            if ($location): ?>
                                             <hr>
                                                <div class="pt-3 pb-1">
                                                    <h6 class="mt-0">LOCATION</h6>
                                                    <p> <?php echo $location; ?> </p>                                        
                                                </div>
                                            <?php endif; ?>

                                            <?php
                                            $experience_level = get_field('experience_level');
                                            if ($experience_level): ?>
                                             <hr>
                                                <div class="pt-3 pb-1">
                                                    <h6 class="mt-0">EXPERIENCE LEVEL</h6>
                                                    <p> <?php echo $experience_level; ?> </p>                                        
                                                </div>
                                            <?php endif; ?>

                                            <?php
                                            $salary = get_field('salary');
                                            if ($salary): ?>
                                             <hr>
                                                <div class="mb-4 pt-3 pb-1">
                                                    <h6 class="mt-0">SALARY</h6>
                                                    <p> <?php echo $salary; ?> </p>                                        
                                                </div>
                                            <?php endif; ?>
                                           
                                            
                                            <a href="<?php echo site_url('apply-now') ?>" class="elementor-button w-100">
                                                APPLY NOW
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        <?php endwhile; ?>




            <?php if ($career_query->max_num_pages > 1): ?>
                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                    <div class="pagination-style-one">
                        <?php
                        echo paginate_links(array(
                            'total' => $career_query->max_num_pages,
                            'current' => max(1, get_query_var('paged')),
                            'format' => '?paged=%#%',
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => '<i class="eicon-chevron-left"></i>',
                            'next_text' => '<i class="eicon-chevron-right"></i>',
                            'end_size' => 2,
                            'mid_size' => 2
                        ));
                        ?>
                    </div>
                </div>
            <?php endif; ?>


        <?php else:
        echo 'No career found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('career', 'display_career');


// career list end------------


// ourteam slider start------------------
function display_ourteam_slider($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => -1,
        ),
        $atts,
        'ourteam'
    );

    $args = array(
        'post_type' => 'our-team',
        'posts_per_page' => $atts['posts_per_page'],
    );

    $ourteam_query = new WP_Query($args);


    ob_start();

    if ($ourteam_query->have_posts()): ?>
        <div class="team-message-slider">
            <div class="team-slider">
                <?php while ($ourteam_query->have_posts()):
                    $ourteam_query->the_post();
                    ?>

                    <div class="item ps-2 pe-2">
                        <div class="team-message-box">
                            <div class="row align-items-center m-0">
                                <div class="col-md-6 px-lg-4 order-2 order-md-1">
                                    <h4><?php echo get_the_title(); ?> </h4>

                                    <?php
                                $position = get_field('position');
                                if ($position):
                                    echo '<span class="position mb-0">';
                                    echo $position;
                                    echo '</span>';
                                endif; ?>

                                    <hr class="my-4">
                                    <p class="mb-0">
                                    <?php echo get_the_content(); ?>
                                    </p>
                                </div>
                                <div class="col-md-6 p-0 order-1 order-md-2">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                    } ?>
                                </div>
                            </div>                           
                        </div>
                    </div>

                <?php endwhile; ?>
            </div>
        </div>


    <?php else:
        echo 'No ourteam found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('ourteam_slider', 'display_ourteam_slider');
// ourteam slider end ------------------------------





// newsevents page start ------------------------------------------------------------


function display_newsevents($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 3,
        ),
        $atts,
        'newsevents'
    );

    // Get the current page


    $args = array(
        'post_type' => 'news-events',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );


    $newsevents_query = new WP_Query($args);

    ob_start();

    if ($newsevents_query->have_posts()): ?>
            <div class="event-accordion">
            <div class="accordion" id="accordionExample">
                <?php $i=1;  while ($newsevents_query->have_posts()) : $newsevents_query->the_post(); 
                    ?>

                        <div class="accordion-item pb-2">
                            <div class="accordion-header" id="heading<?php echo $i; ?>">
                                <div class="accordion-button p-0 pt-4" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>" aria-expanded="<?php echo ($i==1)?'true':'false'; ?>" aria-controls="collapse<?php echo $i; ?>">
                                    <span class="years"><?php echo get_the_date('Y'); ?></span>
                                    <div class="accordion-header-content">
                                        <p class="m-0 date"><?php echo strtoupper( get_the_date('d F, Y') ); ?>                                        </p>
                                        <h5 class="mb-2 mt-1"><?php the_title(); ?></h5>
                                        <p><?php the_content(); ?></p>
                                    </div>
                                </div>
                            </div>
                            <div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse <?php echo ($i==1)?'show':''; ?>" aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#accordionExample">
                                <div class="accordion-body p-0 pb-3 border-0">
                                    <div class="events-image">
                                        <div class="row m-0">
                                          
                                        <?php
                                            $event_images = get_field('event_images'); 

                                            if (!empty($event_images)) {
                                                $image1 = $event_images['image1'];
                                                $image2 = $event_images['image2'];
                                                ?>

                                                <div class="event-images row g-3">
                                                    <?php if (!empty($image1)) : ?>
                                                        <div class="col-md-6">
                                                            <img src="<?php echo esc_url($image1); ?>" alt="Event Image 1" class="img-fluid">
                                                        </div>
                                                    <?php endif; ?>

                                                    <?php if (!empty($image2)) : ?>
                                                        <div class="col-md-6">
                                                            <img src="<?php echo esc_url($image2); ?>" alt="Event Image 2" class="img-fluid">
                                                        </div>
                                                    <?php endif; ?>
                                                </div>

                                            <?php } ?>


                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                <?php  $i++; endwhile; ?>
            </div>
            </div>


            <?php if ($newsevents_query->max_num_pages > 1): ?>
                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                    <div class="pagination-style-one">
                        <?php
                        echo paginate_links(array(
                            'total' => $newsevents_query->max_num_pages,
                            'current' => max(1, get_query_var('paged')),
                            'format' => '?paged=%#%',
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => '<i class="eicon-chevron-left"></i>',
                            'next_text' => '<i class="eicon-chevron-right"></i>',
                            'end_size' => 2,
                            'mid_size' => 2
                        ));
                        ?>
                    </div>
                </div>
            <?php endif; ?>


        <?php else:
        echo 'No newsevents found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('newsevents', 'display_newsevents');


// newsevents list end------------















