jQuery(function($) {
    var canBeLoaded = true, // State to prevent multiple AJAX requests
        button = $('#load-more-btn'), // Button selector
        page = load_more_params.current_page, // Current page number
        maxPage = load_more_params.max_page; // Max number of pages

    button.on('click', function() {
        if (canBeLoaded && page < maxPage) {
            canBeLoaded = false; // Disable further requests

            $.ajax({
                url: load_more_params.ajaxurl,
                type: 'POST',
                data: {
                    action: 'load_more', // Action for the AJAX call
                    page: page + 1 // Increment page number
                },
                beforeSend: function() {
                    button.text('Loading...'); // Change button text while loading
                },
                success: function(data) {
                    if (data) {
                        $('#products ul').append(data); // Append the new products to the <ul> element
                        page++; // Increment the current page number
                        canBeLoaded = true; // Re-enable loading

                        // If the current page is the last, hide the button
                        if (page >= maxPage) {
                            button.text('No More Products').attr('disabled', 'disabled').fadeOut();
                        } else {
                            button.text('Load More'); // Reset button text
                        }
                    }
                }
            });
        }
    });
});