

jQuery(function($){
    $('#load-more').on('click', function(){
        var button = $(this),
            page = button.data('page'),
            max = button.data('max');

        $.ajax({
            url: loadmore_params.ajaxurl,
            type: 'POST',
            data: {
                action: 'loadmore_product_enquiry',
                page: page
            },
            beforeSend: function(){
                button.text('Loading...');
            },
            success: function(res){
                if(res){
                    $('.product-list').append(res);
                    page++;
                    button.data('page', page);
                    button.text('Load More');

                    if(page >= max){
                        button.remove();
                    }
                } else {
                    button.remove();
                }
            }
        });
    });
});
