<?php
/*
Template Name: Product Enquiry Page Template
*/

get_header(); ?>


<?php echo do_shortcode('[hfe_template id="1201"]'); ?>
<div id="primary" class="content-area">

    <main id="main" class="site-main custom-product-page pt-md-5 pt-4 pb-md-5 pb-4">

        <div class="row">
            <div class="col-lg-3 col-md-3 pe-lg-5 sidebar">
                <h5 class="m-0 sidebar-title">Categories</h5>

                <?php
                $active_category = single_term_title('', false);

                $taxonomy = 'eproducts-category';
                $terms = get_terms(array(
                    'taxonomy' => $taxonomy,
                    'hide_empty' => true,
                    'parent' => 0,
                ));

                if (!empty($terms) && !is_wp_error($terms)):
                    $i = 1;
                    ?>
                    <div class="taxonomy-list">

                        <div class="accordion" id="productCategoriesAccordion">
                            <?php
                            foreach ($terms as $term):
                                $term_link = get_term_link($term);
                                $active_class = ($active_category === $term->name) ? 'active' : '';


                                $subcategories = get_terms(array(
                                    'taxonomy' => $taxonomy,
                                    'hide_empty' => true,
                                    'parent' => $term->term_id,
                                ));
                                ?>

                                <div class="accordion-item">
                                    <div class="accordion-header" id="heading<?php echo $i; ?>">

                                        <a href="<?php echo esc_url($term_link); ?>" class="main-category">
                                            <?php echo esc_html($term->name); ?>
                                        </a>

                                        <?php if ($subcategories) { ?>
                                            <button class="accordion-button <?php echo ($i > 1) ? 'collapsed' : ''; ?>"
                                                type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>"
                                                aria-expanded="<?php echo ($i === 1) ? 'true' : 'false'; ?>"
                                                aria-controls="collapse<?php echo $i; ?>"></button>
                                        <?php } ?>
                                    </div>
                                    <?php if ($subcategories) { ?>
                                        <div id="collapse<?php echo $i; ?>"
                                            class="accordion-collapse collapse <?php echo ($i === 1) ? 'show' : ''; ?>"
                                            aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#productCategoriesAccordion">
                                            <div class="accordion-body">
                                                <?php if (!empty($subcategories) && !is_wp_error($subcategories)): ?>
                                                    <ul class="list-unstyled">
                                                        <?php foreach ($subcategories as $subcategory):
                                                            $subcat_link = get_term_link($subcategory);
                                                            $subcat_active_class = ($active_category === $subcategory->name) ? 'active' : '';
                                                            ?>
                                                            <li>
                                                                <a href="<?php echo esc_url($subcat_link); ?>"
                                                                    class="<?php echo esc_attr($subcat_active_class); ?>">
                                                                    <?php echo esc_html($subcategory->name); ?>
                                                                </a>
                                                            </li>
                                                        <?php endforeach; ?>
                                                    </ul>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php } ?>
                                </div>
                                <?php
                                $i++;
                            endforeach; ?>
                        </div>
                    </div>
                    <?php
                else:
                    ?>
                    <p><?php esc_html_e('No categories found', 'textdomain'); ?></p>
                    <?php
                endif;
                ?>






<div class="filter-box mt-4">
    <h5 class="m-0 sidebar-title"> Materials</h5>

    <?php
    $taxonomy = 'materials';
    $terms = get_terms(array(
        'taxonomy'   => $taxonomy,
        'hide_empty' => true,
    ));

    // Current selected material
    $current_term_slug = isset($_GET['material']) ? sanitize_text_field($_GET['material']) : '';
    ?>

    <?php if (!empty($terms) && !is_wp_error($terms)): ?>
        <form method="get" id="materials-archive-filter" class="brand-filter-form">
            <div class="brand-filter-checkboxes">
                <?php foreach ($terms as $term): ?>
                    <?php
                    $checked = ($current_term_slug === $term->slug) ? 'checked' : '';
                    $filter_url = add_query_arg('material', $term->slug, get_permalink()); 
                    ?>
                    <label>
                        <p class="mb-0 d-inline"><?php echo esc_html($term->name); ?></p>
                        <input type="checkbox" 
                               name="material" 
                               value="<?php echo esc_attr($term->slug); ?>"
                               onchange="window.location.href='?material=<?php echo esc_attr($term->slug); ?>';"
                               <?php echo $checked; ?>>
                        <span class="customcheckbox"></span>
                    </label>
                <?php endforeach; ?>
            </div>
        </form>
    <?php endif; ?>
</div>









            </div>


            <div class="col-lg-9 col-md-9">

                <?php
                $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

                $args = array(
                    'post_type' => 'product-enquiry',
                    'posts_per_page' => 12,
                    'paged' => $paged,
                );

                // Check if materials filter is applied
if (!empty($_GET['material'])) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => 'materials',
            'field'    => 'slug',
            'terms'    => sanitize_text_field($_GET['material']),
        ),
    );
}
                $query = new WP_Query($args);

                if ($query->have_posts()): ?>
                    <div class="row g-0 product-list">
                        <?php while ($query->have_posts()):
                            $query->the_post();
                            ?>

                            <div class="col-md-4 col-sm-6" id="post-<?php the_ID(); ?>">
                                <a href="<?php the_permalink(); ?>" <?php post_class(); ?>>
                                    <div class="product-card">
                                        <div class="img-box">
                                            <div class="product-img">
                                                <?php if (has_post_thumbnail()): ?>
                                                    <?php the_post_thumbnail('full'); ?>
                                                <?php endif; ?>
                                            </div>
                                            <div class="hover-overlay">
                                                <!-- <div class="view-product">
                                                    <img src="https://draftsite1.com/ishtara-jewellery/wp-content/uploads/2025/08/Wishlist.png"
                                                        width="30">
                                                </div> -->
                                                <div class="view-product">
                                                    <img src="https://draftsite1.com/ishtara-jewellery/wp-content/uploads/2025/08/Preview.svg"
                                                        width="30">
                                                </div>
                                            </div>
                                        </div>
                                        <h6 class="mt-2 product-name"> <?php the_title(); ?></h6>

                                        <p class="mb-0 view-more-btn"> View More </p>

                                    </div>
                                </a>
                            </div>
                            <?php
                        endwhile; ?>
                    </div>

                    <?php /* if ($query->max_num_pages > 1): ?>
                          <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                              <div class="pagination-style-one">
                                  <?php
                                  echo paginate_links(array(
                                      'total' => $query->max_num_pages,
                                      'current' => max(1, get_query_var('paged')),
                                      'format' => '?paged=%#%',
                                      'show_all' => false,
                                      'type' => 'plain',
                                      'prev_text' => '<i class="eicon-chevron-left"></i>',
                                      'next_text' => '<i class="eicon-chevron-right"></i>',
                                      'end_size' => 2,
                                      'mid_size' => 2
                                  ));
                                  ?>
                              </div>
                          </div>
                      <?php endif; */ ?>


                    <?php if ($query->max_num_pages > 1): ?>
                        <div class="load-more-wrap text-center mt-md-5">
                            <button id="load-more" class="btn btn-primary" data-page="1"
                                data-max="<?php echo $query->max_num_pages; ?>">
                                Load More
                            </button>
                        </div>
                    <?php endif; ?>



                <?php else:
                    echo '<p>' . esc_html__('No Products Found', 'textdomain') . '</p>';
                endif;

                wp_reset_postdata();
                ?>


            </div>

    </main>
</div>

<?php get_footer(); ?>