<?php

function hello_elementor_child_enqueue_styles()
{
    wp_enqueue_style('hello-elementor-parent-style', get_template_directory_uri() . '/../hello-elementor-child/style.css');
    wp_enqueue_style('hello-elementor-parent-ecommerce', get_template_directory_uri() . '/../hello-elementor-child/ecommerce.css');
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles');


// Enqueue Booststrap 
function enqueue_bootstrap()
{
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js', array('jquery'), null, true);

}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');


//  Slick carousel script and styles
function enqueue_slick_scripts()
{
    wp_enqueue_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js', array('jquery'), null, true);
    wp_enqueue_style('slick-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_slick_scripts');


function enqueue_custom_script()
{
    wp_enqueue_script(
        'custom-script',
        get_template_directory_uri() . '../../hello-elementor-child/custom-script.js',
        array('jquery'),
        null,
        true
    );
}
add_action('wp_enqueue_scripts', 'enqueue_custom_script');



// custom code


// blog related start --------------------

function get_related_articles($post_id, $number_of_posts = 5)
{

    $args = array(
        'post_type' => 'post',
        'post__not_in' => array($post_id),
        'posts_per_page' => $number_of_posts,
        'ignore_sticky_posts' => 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );

    return get_posts($args);

    $related_posts = get_related_articles(get_the_ID());

    // If not enough related posts by category, get related posts by tag
    if (count($related_posts) < $number_of_posts) {
        $tags = wp_get_post_tags($post_id);
        if ($tags) {
            $tag_ids = array();
            foreach ($tags as $tag) {
                $tag_ids[] = $tag->term_id;
            }
            $args = array(
                'tag__in' => $tag_ids,
                'post__not_in' => array_merge(array($post_id), wp_list_pluck($related_posts, 'ID')),
                'posts_per_page' => $number_of_posts - count($related_posts),
                'ignore_sticky_posts' => 1,
            );
            $more_related_posts = get_posts($args);
            $related_posts = array_merge($related_posts, $more_related_posts);
        }
    }

    return $related_posts;
}

// blog related end --------------------




// woocommerce code start here ---------------------




//  WooCommerce product  image wrap  ----------
add_action('woocommerce_before_shop_loop_item_title', 'wrap_product_image_in_div', 5);
function wrap_product_image_in_div()
{
    echo '<div class="product-image-wrapper">';
}
add_action('woocommerce_before_shop_loop_item_title', 'close_product_image_div', 15);
function close_product_image_div()
{
    echo '</div>';
}
//  WooCommerce product image wrap ----------



function change_related_products_heading($translated_text, $text, $domain)
{
    if ('Related products' === $text) {
        $translated_text = __('Other Related Products', 'your-text-domain');
    }
    return $translated_text;
}
add_filter('gettext', 'change_related_products_heading', 20, 3);






// product-categories start ----------------------------------------- 
function wpb_woocommerce_product_categories_accordion()
{
    // Get the current queried product category
    $queried_object = get_queried_object();
    $current_category_id = ($queried_object && isset($queried_object->term_id)) ? $queried_object->term_id : 0;

    // Get all parent categories of the current category
    $current_category_parents = [];
    if ($current_category_id) {
        $parent_categories = get_ancestors($current_category_id, 'product_cat');
        $current_category_parents = array_map('intval', $parent_categories);
    }

    // Recursive function to get subcategories with checkboxes
    function get_subcategories($parent_id, $level = 1, $current_category_id, $current_category_parents)
    {
        $args = array(
            'taxonomy' => 'product_cat',
            'orderby' => 'name',
            'order' => 'ASC',
            'parent' => $parent_id,
            'hide_empty' => true
        );
        $sub_categories = get_terms($args);

        if (!empty($sub_categories)) {
            echo '<ul class="list-unstyled ps-2">';
            foreach ($sub_categories as $sub_category) {
                $is_checked = ($sub_category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($sub_category->term_id == $current_category_id) ? 'current-category' : '';

                echo '<li class="' . $active_class . '">';
                echo '<div class="in-menu">';
                echo '<input type="checkbox" class="category-checkbox me-2" data-category-id="' . $sub_category->term_id . '" ' . $is_checked . '> ';

                echo '<a href="' . get_term_link($sub_category) . '">  <span class="customcheck"></span>' . $sub_category->name . '</a>';
                echo '</div>';
                get_subcategories($sub_category->term_id, $level + 1, $current_category_id, $current_category_parents);
                echo '</li>';
            }
            echo '</ul>';
        }
    }

    // Get main product categories (parent categories)
    $args = array(
        'taxonomy' => 'product_cat',
        'orderby' => 'name',
        'order' => 'ASC',
        'parent' => 0,
        'hide_empty' => true
    );
    $product_categories = get_terms($args);

    if ($product_categories) {
        ob_start();
        ?>
        <div class="accordion" id="productCategoriesAccordion">

            <?php
            $shop_page_url = wc_get_page_permalink('shop');
            $is_shop_page = is_shop();
            ?>

            <div class="accordion-item">
                <div class="accordion-header <?php echo $is_shop_page ? 'current-category' : ''; ?>">
                    <label>
                        <a href="<?php echo esc_url($shop_page_url); ?>" class="main-category">
                            ALL PRODUCTS
                        </a>
                    </label>
                </div>
            </div>


            <?php
            $i = 0;
            foreach ($product_categories as $category) {
                $i++;

                // Check if the category has subcategories
                $sub_args = array(
                    'taxonomy' => 'product_cat',
                    'parent' => $category->term_id,
                    'hide_empty' => true
                );
                $sub_categories = get_terms($sub_args);
                $has_subcategories = !empty($sub_categories);

                // Determine if this category should be expanded
                $is_checked = ($category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'current-category' : '';
                $show_collapse = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'show' : '';
                ?>
                <div class="accordion-item <?php echo $active_class; ?>">
                    <div class="accordion-header d-flex align-items-center" id="heading<?php echo $i; ?>">
                        <label for="cat<?php echo $category->term_id; ?>">
                            <input type="checkbox" class="category-checkbox me-2" id="cat<?php echo $category->term_id; ?>"
                                data-category-id="<?php echo $category->term_id; ?>" <?php echo $is_checked; ?>>

                            <a href="<?php echo get_term_link($category); ?>" class="main-category">
                                <span class="customcheck"></span> <?php echo $category->name; ?>
                                <!-- <span class="product-count">(<?php // echo $category->count; ?>)</span> -->
                            </a>
                        </label>

                        <?php if ($has_subcategories) { ?>
                            <button class="accordion-button ms-auto <?php echo ($show_collapse == '') ? 'collapsed' : ''; ?>"
                                type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>"
                                aria-expanded="<?php echo ($show_collapse) ? 'true' : 'false'; ?>"
                                aria-controls="collapse<?php echo $i; ?>" data-category-id="<?php echo $category->term_id; ?>">
                                <i class="fa fa-angle-down"></i>
                            </button>
                        <?php } ?>
                    </div>
                    <?php if ($has_subcategories) { ?>
                        <div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse <?php echo $show_collapse; ?>"
                            aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#productCategoriesAccordion">
                            <div class="accordion-body ps-0 pe-0">
                                <?php get_subcategories($category->term_id, 1, $current_category_id, $current_category_parents); ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
                <?php
            }
            ?>
        </div>

        <script>
            document.addEventListener("DOMContentLoaded", function () {
                var savedCategories = JSON.parse(localStorage.getItem("checkedCategories")) || [];

                savedCategories.forEach(function (categoryId) {
                    var checkbox = document.querySelector('.category-checkbox[data-category-id="' + categoryId + '"]');
                    if (checkbox) {
                        checkbox.checked = true;
                    }
                });

                document.querySelectorAll(".category-checkbox").forEach(function (checkbox) {
                    checkbox.addEventListener("change", function () {
                        var categoryId = this.getAttribute("data-category-id");
                        if (this.checked) {
                            if (!savedCategories.includes(categoryId)) {
                                savedCategories.push(categoryId);
                            }
                        } else {
                            savedCategories = savedCategories.filter(id => id !== categoryId);
                        }
                        localStorage.setItem("checkedCategories", JSON.stringify(savedCategories));
                    });
                });

                var activeCategory = localStorage.getItem("activeCategory");
                if (activeCategory) {
                    var activeAccordion = document.querySelector('[data-category-id="' + activeCategory + '"]');
                    if (activeAccordion) {
                        var collapseElement = activeAccordion.getAttribute("data-bs-target");
                        document.querySelector(collapseElement).classList.add("show");
                        activeAccordion.classList.remove("collapsed");
                        activeAccordion.setAttribute("aria-expanded", "true");
                    }
                }

                document.querySelectorAll(".accordion-button").forEach(function (button) {
                    button.addEventListener("click", function () {
                        var categoryId = this.getAttribute("data-category-id");
                        if (document.querySelector(this.getAttribute("data-bs-target")).classList.contains("show")) {
                            localStorage.removeItem("activeCategory");
                        } else {
                            localStorage.setItem("activeCategory", categoryId);
                        }
                    });
                });
            });
        </script>

        <style>
            .current-category>a {
                font-weight: bold;
                color: #ff6600;
            }

            .category-checkbox {
                display: none;
            }

            span.customcheck {
                background: #FFFFFF 0% 0% no-repeat padding-box;
                border: 1px solid #B7DBEE;
                border-radius: 5px;
                width: 15px;
                height: 15px;
                position: relative;
                margin-right: 6px;
                margin-top: 0px;
                top: 2px;
                display: none;
            }

            .current-category [type=checkbox]:checked~a span.customcheck {
                background: #326783;
                border-color: #326783;
            }

            .current-category [type=checkbox]~a .customcheck:after {
                content: "";
                position: absolute;
            }

            .current-category a input:checked~.customcheck:after {
                display: block;
            }

            .current-category a .customcheck:after {
                left: 5px;
                top: 2px;
                width: 4px;
                height: 8px;
                border: solid white;
                border-width: 0 2px 2px 0;
                -webkit-transform: rotate(45deg);
                -ms-transform: rotate(45deg);
                transform: rotate(45deg);
            }
        </style>
        <?php
        return ob_get_clean();
    }
}

add_shortcode('product_categories_accordion', 'wpb_woocommerce_product_categories_accordion');

// product category for sidebar end -------------------------------





// brand filter -------------------

// brand start --------
function apply_brand_checkbox_filter_to_products($query)
{
    if (is_admin() || !$query->is_main_query()) {
        return;
    }

    // Only apply on shop or product archive pages
    if (is_post_type_archive('product') || is_tax('product_cat')) {

        if (!empty($_GET['product_brand']) && is_array($_GET['product_brand'])) {
            $brands = array_map('sanitize_text_field', $_GET['product_brand']);

            // Fetch existing tax_query and merge
            $tax_query = (array) $query->get('tax_query');

            $tax_query[] = array(
                'taxonomy' => 'product_brand',
                'field' => 'slug',
                'terms' => $brands,
                'operator' => 'IN',
            );

            $query->set('tax_query', $tax_query);
        }
    }
}
add_action('pre_get_posts', 'apply_brand_checkbox_filter_to_products');



function brand_archive_checkbox_filter_shortcode()
{
    $terms = get_terms(array(
        'taxonomy' => 'product_brand',
        'hide_empty' => true,
    ));

    if (empty($terms) || is_wp_error($terms)) {
        return '<p>No brands available.</p>';
    }

    $current_term = is_tax('product_brand') ? get_queried_object() : null;

    ob_start(); ?>
    <form method="get" id="brand-archive-filter" class="brand-filter-form">
        <div class="brand-filter-checkboxes">
            <?php foreach ($terms as $term): ?>
                <?php
                $checked = ($current_term && $current_term->term_id === $term->term_id) ? 'checked' : '';
                ?>
                <label>
                    <p class="mb-0 d-inline"><?php echo esc_html($term->name); ?> </p>
                    <input type="checkbox" name="brand" value="<?php echo esc_url(get_term_link($term)); ?>"
                        onchange="window.location.href = this.value;" <?php echo $checked; ?>>

                    <span class="customcheckbox"> </span>
                </label>
            <?php endforeach; ?>
        </div>
    </form>
    <?php
    return ob_get_clean();
}
add_shortcode('brand_checkbox_filter', 'brand_archive_checkbox_filter_shortcode');



// short description title start -----------
add_action('woocommerce_single_product_summary', 'ws_add_product_description_title', 19);
function ws_add_product_description_title()
{
    global $post;

    // Get short description
    $short_description = apply_filters('woocommerce_short_description', $post->post_excerpt);

    // Only show title if short description exists
    if (!empty($short_description)) {
        echo '<h2 class="product-description-title">PRODUCT DESCRIPTION</h2>';
    }
}


// short description title end -----------------

// single shop banner  start ---------------------------
// Remove default breadcrumb location
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);

// Add breadcrumb before product title
add_action('woocommerce_single_product_summary', 'woocommerce_breadcrumb', 4);


add_action('woocommerce_before_main_content', 'custom_shop_header', 5);
function custom_shop_header()
{
    if (is_product()) {
        ?>
        <div class="woocommerce-shop-banner d-none">
            <div class="container">
                <div class="row g-md-3 align-items-center">
                    <div class="col-md-12">
                        <div class="banner-title text-center">
                            <?php
                            // Display product category name if applicable
                            if (is_product_category()) {
                                $category = get_queried_object();
                                if ($category) {
                                    echo '<h1>' . esc_html($category->name) . '</h1>';
                                }
                            } else {
                                echo '<h1>Shop</h1>';
                            }

                            // Display WooCommerce breadcrumb
                            if (function_exists('woocommerce_breadcrumb')) {
                                woocommerce_breadcrumb(array(
                                    'delimiter' => ' / ',
                                    'wrap_before' => '<nav class="woocommerce-breadcrumb" itemprop="breadcrumb">',
                                    'wrap_after' => '</nav>',
                                ));
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}
// single shop banner end ---------------------------



// wpgis  product gallery ------------------
add_action('wp_footer', 'hide_gallery_thumbs_if_single_image');
function hide_gallery_thumbs_if_single_image()
{
    if (is_product()): ?>
        <script>
            jQuery(document).ready(function ($) {
                $(window).on('load', function () {
                    var thumbCount = $('.wpgis-slider-nav .slick-slide').length;

                    if (thumbCount <= 1) {
                        $('.wpgis-slider-nav').hide();
                        $('.wpgis-slider-for').addClass('full-width-slider');
                    } else {
                        $('.wpgis-slider-nav').show();
                        $('.wpgis-slider-for').removeClass('full-width-slider');
                    }
                });
            });
        </script>
    <?php endif;
}
// wpgis  product gallery end ------------------


// View Product Button ------------ 
add_action('woocommerce_before_shop_loop_item_title', 'custom_view_product_button', 20);
function custom_view_product_button()
{
    global $product;
    echo '<div class="custom-view-button">
            <div class="animated-btn">
                <a href="' . get_permalink($product->get_id()) . '" class="view-product-link elementor-button theme-btn-custom">
                VIEW PRODUCT
                </a>
            </div>
          </div>';
}
// View Product Button end------------ 






// validation start -----------------------------------------------------------



// validation woocommerce start 


add_action('woocommerce_save_account_details_errors', 'validate_my_account_fields', 10, 1);

function validate_my_account_fields($errors)
{
    // Validate First Name
    if (isset($_POST['account_first_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_first_name'])) {
        $errors->add('validation', __('Allowed characters for First Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Last Name
    if (isset($_POST['account_last_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_last_name'])) {
        $errors->add('validation', __('Allowed characters for Last Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Display Name
    if (isset($_POST['account_display_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_display_name'])) {
        $errors->add('validation', __('Allowed characters for Display Name are alphabets and spaces only.', 'woocommerce'));
    }
}




add_action('woocommerce_after_save_address_validation', 'validate_billing_address_fields', 10, 2);

function validate_billing_address_fields($user_id, $address_type)
{
    if ('billing' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $billing_first_name = isset($_POST['billing_first_name']) ? sanitize_text_field($_POST['billing_first_name']) : '';
        $billing_last_name = isset($_POST['billing_last_name']) ? sanitize_text_field($_POST['billing_last_name']) : '';
        $billing_city = isset($_POST['billing_city']) ? sanitize_text_field($_POST['billing_city']) : '';
        $billing_address_1 = isset($_POST['billing_address_1']) ? sanitize_text_field($_POST['billing_address_1']) : '';

        $billing_postcode = isset($_POST['billing_postcode']) ? sanitize_text_field($_POST['billing_postcode']) : '';
        $billing_email = isset($_POST['billing_email']) ? sanitize_email($_POST['billing_email']) : '';

        // Validate Billing First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_first_name)) {
            $validation_errors[] = __('Allowed characters for Billing First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_last_name)) {
            $validation_errors[] = __('Allowed characters for Billing Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_city)) {
            $validation_errors[] = __('Allowed characters for Billing City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $billing_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $billing_postcode)) {
            $validation_errors[] = __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate Billing Email (Basic Email validation)
        if (!is_email($billing_email)) {
            $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}








add_action('woocommerce_after_save_address_validation', 'validate_shipping_address_fields', 10, 2);

function validate_shipping_address_fields($user_id, $address_type)
{
    if ('shipping' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $shipping_first_name = isset($_POST['shipping_first_name']) ? sanitize_text_field($_POST['shipping_first_name']) : '';
        $shipping_last_name = isset($_POST['shipping_last_name']) ? sanitize_text_field($_POST['shipping_last_name']) : '';
        $shipping_city = isset($_POST['shipping_city']) ? sanitize_text_field($_POST['shipping_city']) : '';
        $shipping_address_1 = isset($_POST['shipping_address_1']) ? sanitize_text_field($_POST['shipping_address_1']) : '';

        $shipping_postcode = isset($_POST['shipping_postcode']) ? sanitize_text_field($_POST['shipping_postcode']) : '';
        //  $shipping_email = isset($_POST['shipping_email']) ? sanitize_email($_POST['shipping_email']) : '';

        // Validate shipping First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_first_name)) {
            $validation_errors[] = __('Allowed characters for shipping First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_last_name)) {
            $validation_errors[] = __('Allowed characters for shipping Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_city)) {
            $validation_errors[] = __('Allowed characters for shipping City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $shipping_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $shipping_postcode)) {
            $validation_errors[] = __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate shipping Email (Basic Email validation)
        // if (!is_email($shipping_email)) {
        //     $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        // }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}




// validation woocommerce end --------------------







// contact form validation 

// Validate text fields (only alphabets allowed)
add_filter('wpcf7_validate_text', 'alpha_validation_filter_text', 20, 2);
add_filter('wpcf7_validate_text*', 'alpha_validation_filter_text', 20, 2);

function alpha_validation_filter_text($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('names' === $tag->name) {
        $name_of_the_input = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input)) {
            $result->invalidate($tag, "Allowed characters are Alphabets only.");
        }
    }

    if ('lname' === $tag->name) {
        $name_of_the_input = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input)) {
            $result->invalidate($tag, "Allowed characters are Alphabets only.");
        }
    }

    return $result;
}

// Validate phone number (must be exactly 10 digits)
add_filter('wpcf7_validate_tel', 'numeric_phone_validation_filter', 20, 2);
add_filter('wpcf7_validate_tel*', 'numeric_phone_validation_filter', 20, 2);

function numeric_phone_validation_filter($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('phone' === $tag->name) {
        $phone_number = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!preg_match('/^\d{8}$/', $phone_number)) {
            $result->invalidate($tag, "Phone number must contain exactly 8 digits.");
        }
    }

    return $result;
}



// Validate email (must be a valid email format)
add_filter('wpcf7_validate_email', 'validate_email_filter', 20, 2);
add_filter('wpcf7_validate_email*', 'validate_email_filter', 20, 2);

function validate_email_filter($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('email' === $tag->name) {
        $email = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $result->invalidate($tag, "Please enter a valid email address.");
        }
    }

    return $result;
}


// Validate textarea field (message)
add_filter('wpcf7_validate_textarea', 'validate_textarea_filter', 20, 2);
add_filter('wpcf7_validate_textarea*', 'validate_textarea_filter', 20, 2);

function validate_textarea_filter($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('message' === $tag->name) {
        $message = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        // Allowed characters: alphabets, spaces, common punctuation marks
        if (!preg_match('/^[a-zA-Z0-9\s.,!?()-]+$/', $message)) {
            $result->invalidate($tag, "Message contains invalid characters. Only letters, numbers, spaces, and punctuation are allowed.");
        }

        // Min 10 characters, Max 500 characters
        if (strlen($message) < 10 || strlen($message) > 500) {
            $result->invalidate($tag, "Message must be between 10 and 500 characters.");
        }
    }

    return $result;
}




// validation end -----------------------------------------------------------







// Home slider Start --------------------------------------------
function display_banner_home($atts)
{
    $args = array(
        'post_type' => 'main-slider',
    );

    $mainslider_query = new WP_Query($args);

    ob_start();

    if ($mainslider_query->have_posts()):
        $total_slides = $mainslider_query->post_count;
        ?>
        <div id="demo" class="carousel slide hero-banner carousel-slide" data-bs-ride="carousel">
            <div class="carousel-inner">
                <?php
                $first = true;
                while ($mainslider_query->have_posts()):
                    $mainslider_query->the_post(); ?>

                    <div class="carousel-item <?php echo $first ? 'active' : ''; ?>">
                        <div class="row align-items-center">
                            <div class="col-md-6">
                                <div class="carousel-caption">

                                    <div class="text-center">
                                        <div class="ps-md-5 pe-md-5 ms-md-5 me-md-5 pt-3 pb-3 ps-3 pe-3">
                                            <?php
                                            $sub_title = get_field('sub_title');
                                            if ($sub_title):
                                                echo '<p class="sub-title">';
                                                echo $sub_title;
                                                echo '</p>';
                                            endif; ?>

                                            <h2><?php the_title(); ?></h2>

                                            <div class="description">
                                                <?php echo get_the_content(); ?>
                                            </div>

                                            <div class="btnlight pt-md-5 pt-3">
                                                <?php
                                                $links = get_field('button_link');
                                                if ($links) {
                                                    $link_url = $links['url'];
                                                    $link_title = $links['title'];
                                                    ?>
                                                    <a href="<?php echo esc_url($link_url); ?>"
                                                        class="elementor-button theme-btn-custom">
                                                        <?php echo esc_html($link_title); ?>
                                                    </a>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 p-0">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                } ?>
                            </div>
                        </div>


                    </div>
                    <?php
                    $first = false;
                endwhile; ?>
            </div>

            <?php if ($total_slides > 1): ?>
                <div class="carousel-indicators">
                    <?php for ($i = 0; $i < $total_slides; $i++): ?>
                        <button type="button" data-bs-target="#demo" data-bs-slide-to="<?php echo $i; ?>"
                            class="<?php echo $i === 0 ? 'active' : ''; ?>">
                            <span></span>
                        </button>
                    <?php endfor; ?>
                </div>
            <?php endif; ?>

            <?php if ($total_slides > 1): ?>
                <div class="arrow-control-bottom">
                    <div class="container-fluid position-relative">
                        <div class="row m-md-0">
                            <div class="col-md-12 p-md-0">
                                <div class="arrow-control-slider">
                                    <span class="control-prev" data-bs-target="#demo" data-bs-slide="prev">
                                        <i class="eicon-long-arrow-left"></i>
                                    </span>
                                    <span class="control-next" data-bs-target="#demo" data-bs-slide="next">
                                        <i class="eicon-long-arrow-right"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            <?php endif; ?>


        </div>

    <?php else: ?>
        <div>No Slider found.</div>
    <?php endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('banner_home', 'display_banner_home');


// Home slider end --------------------------------------------




// testimonial list  start -----------------
function display_testimonial($atts)
{
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
        ),
        $atts,
        'testimonials_list_view'
    );


    $selected_category = isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '';


    $args = array(
        'post_type' => 'testimonial',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => 1, // Initial load starts from page 1
    );

    if (!empty($selected_category)) {
        $args['category_name'] = $selected_category;
    }


    $testimonial_query = new WP_Query($args);

    ob_start();

    if ($testimonial_query->have_posts()):
        ?>
        <div class="testimonial">
            <div class="row g-4 gy-lg-5" id="testimonial-container">
                <?php while ($testimonial_query->have_posts()):
                    $testimonial_query->the_post(); ?>

                    <div class="col-lg-4 col-md-6 col-sm-6">
                        <div class="testimonial-box">
                            <div class="quote-logo mb-2">
                                <img src="https://draftsite1.com/ivory-dental/wp-content/uploads/2025/10/Quote.png" alt=""
                                    width="25">
                            </div>
                            <h2 class="author mb-3">
                                <?php the_title(); ?>
                            </h2>
                            <div class="description">
                                <?php
                                $content = get_the_content();
                                $clean_content = wp_strip_all_tags(strip_shortcodes($content));
                                $char_limit = 200;

                                if (strlen($clean_content) > $char_limit) {
                                    echo mb_substr($clean_content, 0, $char_limit) . '...';
                                } else {
                                    echo $clean_content;
                                }
                                ?>
                            </div>
                            <?php if (strlen($clean_content) > $char_limit): ?>
                                <a href="javascript:void(0)" data-bs-toggle="modal"
                                    data-bs-target="#testimonialpopup<?php echo get_the_ID(); ?>" class="link-view">Read More</a>
                            <?php endif; ?>

                            <?php
                            $customer_name = get_field('customer_name');
                            if ($customer_name):
                                echo '<p class="position mt-3 mb-4">';
                                echo $customer_name;
                                echo '</p>';
                            endif;
                            ?>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
        </div>


        <?php while ($testimonial_query->have_posts()):
            $testimonial_query->the_post(); ?>
            <div class="model-testimonial modal modal-lg fade" id="testimonialpopup<?php echo get_the_ID(); ?>" tabindex="-1"
                aria-labelledby="testimonialpopupLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        <div class="modal-body">
                            <div class="testimonial-box bg-transparent p-0 mb-0">
                                <h2 class="author mb-3">
                                    <?php the_title(); ?>
                                </h2>
                                <div class="description description-quote mb-4">
                                    <?php echo the_content(); ?>
                                </div>
                                <?php
                                $customer_name = get_field('customer_name');
                                if ($customer_name):
                                    echo '<p class="position mb-4">';
                                    echo $customer_name;
                                    echo '</p>';
                                endif;
                                ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        <?php endwhile; ?>

        <!-- Load More Button -->
        <?php if ($testimonial_query->max_num_pages > 1): ?>
            <div class="text-center mt-md-5 mt-3 mb-3">
                <button id="load-more-btn" class="load-more-btn btn-custom" data-page="1"
                    data-max-pages="<?php echo $testimonial_query->max_num_pages; ?>">Load More</button>
            </div>
        <?php endif; ?>

    <?php else:
        echo 'No testimonial found.';
    endif;


    wp_reset_postdata();
    return ob_get_clean();
}
add_shortcode('testimonials_list_view', 'display_testimonial');

// Handle AJAX request for loading more testimonials
function load_more_testimonials()
{
    $paged = isset($_POST['page']) ? intval($_POST['page']) : 1;
    $selected_category = isset($_POST['category']) ? sanitize_text_field($_POST['category']) : '';

    $args = array(
        'post_type' => 'testimonial',
        'posts_per_page' => 9,
        'paged' => $paged,
    );

    if (!empty($selected_category)) {
        $args['category_name'] = $selected_category;
    }

    $testimonial_query = new WP_Query($args);

    if ($testimonial_query->have_posts()) {
        while ($testimonial_query->have_posts()):
            $testimonial_query->the_post(); ?>
            <div class="col-lg-4 col-md-6 col-sm-6">
                <div class="testimonial-box">
                    <div class="quote-logo mb-2">
                        <img src="https://draftsite1.com/ivory-dental/wp-content/uploads/2025/10/Quote.png" alt="" width="25">
                    </div>

                    <h2 class="author mb-3">
                        <?php the_title(); ?>
                    </h2>

                    <div class="description">
                        <?php
                        $content = get_the_content();
                        $clean_content = wp_strip_all_tags(strip_shortcodes($content));
                        $char_limit = 200;

                        if (strlen($clean_content) > $char_limit) {
                            echo mb_substr($clean_content, 0, $char_limit) . '...';
                        } else {
                            echo $clean_content;
                        }
                        ?>
                    </div>
                    <?php if (strlen($clean_content) > $char_limit): ?>
                        <a href="javascript:void(0)" data-bs-toggle="modal"
                            data-bs-target="#testimonialpopup<?php echo get_the_ID(); ?>" class="link-view">Read More</a>
                    <?php endif; ?>


                    <?php
                    $customer_name = get_field('customer_name');
                    if ($customer_name):
                        echo '<p class="position mt-3 mb-4">';
                        echo $customer_name;
                        echo '</p>';
                    endif;
                    ?>
                </div>
            </div>
        <?php endwhile;
    } else {
        echo 'No more testimonials found.';
    }

    ?>
    <?php while ($testimonial_query->have_posts()):
        $testimonial_query->the_post(); ?>
        <div class="model-testimonial modal fade" id="testimonialpopup<?php echo get_the_ID(); ?>" tabindex="-1"
            aria-labelledby="testimonialpopupLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    <div class="modal-body">
                        <div class="testimonial-box bg-transparent p-0 mb-0">
                            <h2 class="author mb-3">
                                <?php the_title(); ?>
                            </h2>
                            <div class="description description-quote mb-4">
                                <?php echo the_content(); ?>
                            </div>
                            <?php
                            $customer_name = get_field('customer_name');
                            if ($customer_name):
                                echo '<p class="position mb-4">';
                                echo $customer_name;
                                echo '</p>';
                            endif;
                            ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>

    <?php endwhile; ?>
    <?php

    wp_reset_postdata();
    wp_die();
}
add_action('wp_ajax_load_more_testimonials', 'load_more_testimonials');
add_action('wp_ajax_nopriv_load_more_testimonials', 'load_more_testimonials');




// Enqueue jQuery and custom script for Load More functionality
function enqueue_load_more_scripts()
{
    wp_enqueue_script('jquery');
    wp_enqueue_script('load-more-script', get_template_directory_uri() . '/../hello-elementor-child/load-more-script.js', array('jquery'), null, true);
    wp_localize_script('load-more-script', 'ajax_params', array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
    ));
}
add_action('wp_enqueue_scripts', 'enqueue_load_more_scripts');


// testimonial list  end -----------------








// article list  start -----------------
function display_article($atts)
{
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
        ),
        $atts,
        'articles_list_view'
    );


    $selected_category = isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '';


    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => 1, // Initial load starts from page 1
    );

    if (!empty($selected_category)) {
        $args['category_name'] = $selected_category;
    }


    $article_query = new WP_Query($args);

    ob_start();

    if ($article_query->have_posts()):
        ?>
        <div class="article">
            <div class="row g-4 gy-lg-5" id="article-container">
                <?php while ($article_query->have_posts()):
                    $article_query->the_post(); ?>

                    <div class="col-lg-4 col-md-6 col-sm-6">
                        <div class="article-box">
                            <a href="<?php the_permalink(); ?>" class="d-block">
                                <div class="img-box">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                    } ?>
                                </div>
                                <div class="content-box">
                                    <h2 class="author mb-3">
                                        <?php the_title(); ?>
                                    </h2>

                                    <div class="description description-limit">
                                        <?php echo '' . mb_substr(get_the_excerpt(), 0, 180) . '...'; ?>
                                    </div>

                                    <div class="recent-date"><?php echo get_the_date(); ?></div>
                                </div>
                            </a>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
        </div>


        <!-- Load More Button -->
        <?php if ($article_query->max_num_pages > 1): ?>
            <div class="text-center mt-md-5 mt-3 mb-3">
                <button id="load-more-article" class="load-more-btn btn-custom" data-page="1"
                    data-max-pages="<?php echo $article_query->max_num_pages; ?>">Load More</button>
            </div>
        <?php endif; ?>

    <?php else:
        echo 'No article found.';
    endif;


    wp_reset_postdata();
    return ob_get_clean();
}
add_shortcode('articles_list_view', 'display_article');

// Handle AJAX request for loading more articles
function load_more_articles()
{
    $paged = isset($_POST['page']) ? intval($_POST['page']) : 1;
    $selected_category = isset($_POST['category']) ? sanitize_text_field($_POST['category']) : '';

    $args = array(
        'post_type' => 'post',
        'posts_per_page' => 9,
        'paged' => $paged,
    );

    if (!empty($selected_category)) {
        $args['category_name'] = $selected_category;
    }

    $article_query = new WP_Query($args);

    if ($article_query->have_posts()) {
        while ($article_query->have_posts()):
            $article_query->the_post(); ?>
            <div class="col-lg-4 col-md-6 col-sm-6">
                <div class="article-box">
                    <a href="<?php the_permalink(); ?>" class="d-block">
                        <div class="img-box">
                            <?php if (has_post_thumbnail()) {
                                the_post_thumbnail('full', array('class' => 'd-block w-100'));
                            } ?>
                        </div>

                        <div class="content-box">
                            <h2 class="author mb-3">
                                <?php the_title(); ?>
                            </h2>

                            <div class="description description-limit">
                                <?php echo '' . mb_substr(get_the_excerpt(), 0, 180) . '...'; ?>
                            </div>

                            <div class="recent-date"><?php echo get_the_date(); ?></div>
                        </div>
                    </a>
                </div>
            </div>
        <?php endwhile;
    } else {
        echo 'No more articles found.';
    }

    ?>
    <?php

    wp_reset_postdata();
    wp_die();
}
add_action('wp_ajax_load_more_articles', 'load_more_articles');
add_action('wp_ajax_nopriv_load_more_articles', 'load_more_articles');




// article list  end -----------------






// article slider start------------------
function display_article_slider($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => -1,
        ),
        $atts,
        'post'
    );

    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['posts_per_page'],
        'meta_query' => array(
            array(
                'key' => '_is_ns_featured_post',
                'value' => 'yes',
                'compare' => '='
            )
        )
    );

    $article_query = new WP_Query($args);


    ob_start();

    if ($article_query->have_posts()): ?>
        <div class="article-slider">
            <div class="article-slider-featured">
                <?php while ($article_query->have_posts()):
                    $article_query->the_post();
                    $post_id = get_the_ID();
                    ?>
                    <div class="item ps-md-3 pe-md-3 ps-1 pe-1">
                        <div class="article-box" id="<?php echo $post_id; ?>">
                            <a href="<?php the_permalink(); ?>" class="d-block">
                                <div class="img-box">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                    } ?>
                                </div>

                                <div class="content-box">
                                    <h2 class="author mb-3">
                                        <?php the_title(); ?>
                                    </h2>

                                    <div class="description description-limit">
                                        <?php echo '' . mb_substr(get_the_excerpt(), 0, 180) . '...'; ?>
                                    </div>

                                    <div class="recent-date"><?php echo get_the_date(); ?></div>
                                </div>
                            </a>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>

        </div>

    <?php else:
        echo 'No article found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('article_featured', 'display_article_slider');
// article slider end ------------------------------






// team list  start -----------------
function display_team($atts)
{
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
        ),
        $atts,
        'teams_list_view'
    );


    $selected_category = isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '';


    $args = array(
        'post_type' => 'team',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => 1, // Initial load starts from page 1
    );

    if (!empty($selected_category)) {
        $args['category_name'] = $selected_category;
    }


    $team_query = new WP_Query($args);

    ob_start();

    if ($team_query->have_posts()):
        ?>
        <div class="team">
            <div class="row g-md-5 g-3" id="team-container">
                <?php while ($team_query->have_posts()):
                    $team_query->the_post(); ?>

                    <div class="col-lg-4 col-md-6 col-sm-6 teambx">
                        <a href="<?php the_permalink(); ?>" class="team-box">
                            <div class="team-img">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                } ?>
                            </div>

                            <h2 class="author mt-3 mb-2">
                                <?php the_title(); ?>
                            </h2>

                            <?php
                            $qualification = get_field('qualification');
                            if ($qualification):
                                echo '<p class="position mb-0">';
                                echo $qualification;
                                echo '</p>';
                            endif;
                            ?>
                        </a>
                    </div>
                <?php endwhile; ?>
            </div>
        </div>


        <!-- Load More Button -->
        <?php if ($team_query->max_num_pages > 1): ?>
            <div class="text-center mt-md-5 mt-3 mb-3">
                <button id="load-more-team" class="load-more-btn btn-custom" data-page="1"
                    data-max-pages="<?php echo $team_query->max_num_pages; ?>">Load More</button>
            </div>
        <?php endif; ?>

    <?php else:
        echo 'No team found.';
    endif;


    wp_reset_postdata();
    return ob_get_clean();
}
add_shortcode('teams_list_view', 'display_team');

// Handle AJAX request for loading more teams
function load_more_teams()
{
    $paged = isset($_POST['page']) ? intval($_POST['page']) : 1;
    $selected_category = isset($_POST['category']) ? sanitize_text_field($_POST['category']) : '';

    $args = array(
        'post_type' => 'team',
        'posts_per_page' => 6,
        'paged' => $paged,
    );

    if (!empty($selected_category)) {
        $args['category_name'] = $selected_category;
    }

    $team_query = new WP_Query($args);

    if ($team_query->have_posts()) {
        while ($team_query->have_posts()):
            $team_query->the_post(); ?>

            <div class="col-lg-4 col-md-6 col-sm-6 teambx">
                <a href="<?php the_permalink(); ?>" class="team-box">
                    <div class="team-img">
                        <?php if (has_post_thumbnail()) {
                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                        } ?>
                    </div>

                    <h2 class="author mt-3 mb-2">
                        <?php the_title(); ?>
                    </h2>

                    <?php
                    $qualification = get_field('qualification');
                    if ($qualification):
                        echo '<p class="position mb-0">';
                        echo $qualification;
                        echo '</p>';
                    endif;
                    ?>
                </a>
            </div>
        <?php endwhile;
    } else {
        echo 'No more teams found.';
    }

    ?>
    <?php

    wp_reset_postdata();
    wp_die();
}
add_action('wp_ajax_load_more_teams', 'load_more_teams');
add_action('wp_ajax_nopriv_load_more_teams', 'load_more_teams');






// team slider start------------------
function display_team_slider($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 3,
        ),
        $atts,
        'team'
    );

    $args = array(
        'post_type' => 'team',
        'posts_per_page' => $atts['posts_per_page'],
        'meta_query' => array(
            array(
                'key' => '_is_ns_featured_post',
                'value' => 'yes',
                'compare' => '='
            )
        )
    );

    $team_query = new WP_Query($args);


    ob_start();

    if ($team_query->have_posts()): ?>
        <div class="team-slider">
            <div class="row g-md-5 g-3 team-slider-featured">
                <?php while ($team_query->have_posts()):
                    $team_query->the_post();
                    $post_id = get_the_ID();
                    ?>
                    <div class="col-lg-4 col-md-6 col-sm-6 teambx">
                        <a href="<?php the_permalink(); ?>" class="team-box">
                            <div class="team-img">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                } ?>
                            </div>

                            <h2 class="author mt-3 mb-2">
                                <?php the_title(); ?>
                            </h2>

                            <?php
                            $qualification = get_field('qualification');
                            if ($qualification):
                                echo '<p class="position mb-0">';
                                echo $qualification;
                                echo '</p>';
                            endif;
                            ?>
                        </a>
                    </div>
                <?php endwhile; ?>
            </div>

        </div>

    <?php else:
        echo 'No team found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('team_featured', 'display_team_slider');
// team slider end ------------------------------







// Gallery page start ------------------------------------------------------------

function display_showcase($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'events-showcase'
    );

    // Initial Query Args
    $args = array(
        'post_type' => 'showcase',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => 1,
    );

    // Filter by category if provided
    if (!empty($atts['category'])) {
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'gallery-category',
                'field' => 'slug',
                'terms' => $atts['category'],
            ),
        );
    }

    // Get categories
    $categories = get_terms(array(
        'taxonomy' => 'gallery-category',
        'hide_empty' => true,
    ));
    $total_posts = wp_count_posts('showcase')->publish;

    ob_start();

    if ($categories): ?>
        <div class="row">
            <div class="col-md-3 text-start">
                <h3 class="gallery-cat-title"> CATEGORIES </h3>
                <ul id="category-filter-list" class="gallery-filter">
                <?php
                        $post_count = $category->count;
                        ?>
                    <li>
                        <a href="<?php echo esc_url(add_query_arg('category', '', home_url('/gallery'))); ?>"
                            class="filter-btn <?php echo empty($atts['category']) ? 'active' : ''; ?>">
                            All (<?php echo intval($total_posts); ?>)
                        </a>
                    </li>
                    <?php foreach ($categories as $category): ?>
                        <?php $post_count = $category->count; ?>
                        <li>
                            <a href="<?php echo esc_url(add_query_arg('category', $category->slug, home_url('/gallery'))); ?>"
                                class="filter-btn <?php echo ($atts['category'] === $category->slug) ? 'active' : ''; ?>">
                                <?php echo esc_html($category->name); ?> (<?php echo intval($post_count); ?>)
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>

        <?php endif;

    $showcase_query = new WP_Query($args);

    if ($showcase_query->have_posts()): ?>
            <div id="showcase-container" class="showcase-page showcase-main col-md-9">
                <div class="row g-md-4 g-3">
                    <?php while ($showcase_query->have_posts()):
                        $showcase_query->the_post(); ?>
                        <div class="col-md-4 col-sm-6 col-6">
                            <div class="showcase-box">
                                <div class="img-box">
                                    <?php if (has_post_thumbnail()):
                                        $thumbnail_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
                                        $thumbnail_alt = get_post_meta(get_post_thumbnail_id(), '_wp_attachment_image_alt', true);
                                        ?>
                                        <a href="<?php echo esc_url($thumbnail_url); ?>" data-elementor-open-lightbox="yes"
                                            data-elementor-lightbox-slideshow="gallery-<?php echo esc_attr($atts['category']) ?: 'all'; ?>"
                                            data-elementor-lightbox-title="<?php echo esc_attr(get_the_title()); ?>">
                                            <img src="<?php echo esc_url($thumbnail_url); ?>"
                                                alt="<?php echo esc_attr($thumbnail_alt); ?>" class="d-block client-img mb-0 w-100" />
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>

                <!-- Load More Button -->
                <?php if ($showcase_query->max_num_pages > 1): ?>
                    <div class="text-center mt-md-5 mt-3 mb-3">
                        <button id="load-more" class="load-more-btn btn-custom" data-page="1"
                            data-category="<?php echo esc_attr($atts['category']); ?>"
                            data-max-pages="<?php echo $showcase_query->max_num_pages; ?>">Load More</button>
                    </div>
                <?php endif; ?>
            </div>



        <?php else:
        echo 'No showcase found.';
    endif; ?>
    </div>
    <?php

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('events_showcase_list', 'display_showcase');


// AJAX handler for loading more posts
function load_more_showcase_posts()
{
    $paged = isset($_POST['page']) ? intval($_POST['page']) : 1;
    $category = isset($_POST['category']) ? sanitize_text_field($_POST['category']) : '';

    $args = array(
        'post_type' => 'showcase',
        'posts_per_page' => 12,
        'paged' => $paged,
    );

    if (!empty($category)) {
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'gallery-category',
                'field' => 'slug',
                'terms' => $category,
            ),
        );
    }

    $showcase_query = new WP_Query($args);

    if ($showcase_query->have_posts()) {
        while ($showcase_query->have_posts()) {
            $showcase_query->the_post(); ?>
            <div class="col-md-4 col-sm-6 col-6">
                <div class="showcase-box">
                    <div class="img-box">
                        <div class="img-box">
                            <?php if (has_post_thumbnail()):
                                $thumbnail_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
                                $thumbnail_alt = get_post_meta(get_post_thumbnail_id(), '_wp_attachment_image_alt', true);
                                ?>
                                <a href="<?php echo esc_url($thumbnail_url); ?>" data-elementor-open-lightbox="yes"
                                    data-elementor-lightbox-slideshow="gallery-<?php echo esc_attr($atts['category']) ?: 'all'; ?>"
                                    data-elementor-lightbox-title="<?php echo esc_attr(get_the_title()); ?>">
                                    <img src="<?php echo esc_url($thumbnail_url); ?>" alt="<?php echo esc_attr($thumbnail_alt); ?>"
                                        class="d-block client-img mb-0 w-100" />
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php }
    } else {
        echo '';
    }

    wp_reset_postdata();
    wp_die();
}
add_action('wp_ajax_load_more_showcase', 'load_more_showcase_posts');
add_action('wp_ajax_nopriv_load_more_showcase', 'load_more_showcase_posts');

// Enqueue scripts


function enqueue_showcase_scripts()
{
    wp_enqueue_script('showcase-load-more', get_template_directory_uri() . '/../hello-elementor-child/showcase-load-more.js', array('jquery'), null, true);
    wp_localize_script('showcase-load-more', 'showcase_load_more', array(
        'ajax_url' => admin_url('admin-ajax.php'),
    ));
}
add_action('wp_enqueue_scripts', 'enqueue_showcase_scripts');


// showcase page End ------------------------------------------------------




// for pagination shop  start
function custom_woocommerce_products_per_page($cols)
{
    return 9; // Display 9 products on the first page
}
add_filter('loop_shop_per_page', 'custom_woocommerce_products_per_page', 20);

// Enqueue the AJAX load more script
function load_more_scripts()
{
    global $wp_query;

    // Register the script
    wp_register_script('product-load-more', get_stylesheet_directory_uri() . '../../hello-elementor-child/product-load-more.js', array('jquery'), null, true);

    // Localize the script with data for AJAX
    wp_localize_script('product-load-more', 'load_more_params', array(
        'ajaxurl' => admin_url('admin-ajax.php'), // WordPress AJAX URL
        'current_page' => max(1, get_query_var('paged')), // Current page
        'max_page' => $wp_query->max_num_pages // Max number of pages
    ));

    // Enqueue the script
    wp_enqueue_script('product-load-more');
}
add_action('wp_enqueue_scripts', 'load_more_scripts');

// AJAX handler for loading more products inside an unordered list
function load_more_products()
{
    $paged = (int) $_POST['page'];

    $args = array(
        'post_type' => 'product',
        'posts_per_page' => 9,
        'paged' => $paged,
    );

    if (isset($_POST['category']) && !empty($_POST['category'])) {
        $args['tax_query'] = array(array(
            'taxonomy' => 'product_cat',
            'field' => 'slug',
            'terms' => sanitize_text_field($_POST['category']),
        ));
    }

    $loop = new WP_Query($args);

    if ($loop->have_posts()) {
        while ($loop->have_posts()) {
            $loop->the_post();
            echo '<li>';
            wc_get_template_part('content', 'product');
            echo '</li>';
        }
    }
    wp_reset_postdata();
    wp_die();
}

add_action('wp_ajax_load_more', 'load_more_products'); // For logged-in users
add_action('wp_ajax_nopriv_load_more', 'load_more_products'); // For non-logged-in users

// Remove default WooCommerce pagination
remove_action('woocommerce_after_shop_loop', 'woocommerce_pagination', 10);

// Add custom "Load More" button on the shop page
function custom_load_more_button()
{
    global $wp_query;
    if ($wp_query->max_num_pages > 1) {
        echo '<div class="text-center mt-md-5">';
        echo '<button id="pload-more-btn" class="btn btn-primary">Load More</button>';
        echo '</div>';
    }
}
add_action('woocommerce_after_shop_loop', 'custom_load_more_button', 10);


// for pagination shop end