<?php
defined('ABSPATH') || exit;

get_header('shop');
?>
<div class="shop-page pb-md-5 pb-3">


    <div class="banner-main">
        <div class="container banner-resources">

            <div class="col-lg-12 text-md-start text-center">
                <p class="mb-0"><span class="btn-badge-light">HOME / E-SHOP</span></p>
            </div>
        </div>
    </div>




    <div class="shop-inner-section">

        <div class="container">


            <div class="row g-md-3 g-3">
                <div class="col-md-4 pe-md-5">
                    <div class="fiter_shop">
                        <?php if (is_product_category()) {
                            $category = get_queried_object();
                            if ($category) { ?>
                                <?php echo '<h1 class="elementor-heading-title elementor-size-default">' . esc_html($category->name) . '</h1>'; ?>
                                <?php
                            }
                        } else { ?>
                            <?php echo '<h1 class="elementor-heading-title elementor-size-default">Sacred <span> Essentials </span>  </h1>' ?>
                        <?php }
                        ?>
                        <?php echo do_shortcode('[product_categories_accordion]'); ?>

                    </div>
                </div>
                <div class="col-md-8 pt-3">
                    <div class="custom-product-grid" id="products">
                        <?php if (woocommerce_product_loop()): ?>
                            <?php
                            do_action('woocommerce_before_shop_loop');
                            woocommerce_product_loop_start();
                            if (wc_get_loop_prop('total')) {
                                while (have_posts()) {
                                    the_post();
                                    do_action('woocommerce_shop_loop');
                                    wc_get_template_part('content', 'product');
                                }
                            }
                            woocommerce_product_loop_end();
                            do_action('woocommerce_after_shop_loop');
                            ?>
                        <?php else: ?>
                            <?php do_action('woocommerce_no_products_found'); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>






<?php
do_action('woocommerce_after_main_content');

get_footer('shop'); ?>


<style>
    .woocommerce-page .content-area {
        display: none;
    }
</style>