<?php
// Enqueue the parent theme's stylesheet

function hello_elementor_child_enqueue_styles()
{
    wp_enqueue_style('hello-elementor-parent-style', get_template_directory_uri() . '/../hello-elementor-child/style.css');
    wp_enqueue_style('hello-elementor-parent-ecommerce', get_template_directory_uri() . '/../hello-elementor-child/ecommerce.css');
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles');




// Enqueue Booststrap 
function enqueue_bootstrap()
{
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');
    //  wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js', array('jquery'), null, true);

    // Load Bootstrap Bundle JS only when NOT on Portfolio page (or post)
    if (!is_page('gallery') && !is_singular('gallery')) {
        wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js', array('jquery'), null, true);
    }
}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');


//  Slick carousel script and styles
function enqueue_slick_scripts()
{
    //  Slick carousel script
    wp_enqueue_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js', array('jquery'), null, true);
    //  Slick carousel CSS
    wp_enqueue_style('slick-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_slick_scripts');

// custom code




// Home slider Start --------------------------------------------
function display_banner_home($atts)
{
    $args = array(
        'post_type' => 'main-slider',
    );

    $mainslider_query = new WP_Query($args);

    ob_start();

    if ($mainslider_query->have_posts()):
        $total_slides = $mainslider_query->post_count;
?>
        <div id="demo" class="carousel slide hero-banner" data-bs-ride="carousel">
            <div class="carousel-inner">
                <?php
                $first = true;
                while ($mainslider_query->have_posts()):
                    $mainslider_query->the_post(); ?>

                    <div class="carousel-item <?php echo $first ? 'active' : ''; ?>">
                        <?php if (has_post_thumbnail()) {
                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                        } ?>
                        <div class="carousel-caption">
                            <?php
                            $sub_title = get_field('sub_title');
                            if ($sub_title):
                                echo '<p class="sub-title">';
                                echo $sub_title;
                                echo '</p>';
                            endif; ?>

                            <h3><?php the_title(); ?></h3>
                            <div> <?php the_content(); ?> </div>
                            <div class="btnlight pt-3">
                                <?php
                                $links = get_field('button_link');
                                if ($links) {
                                    $link_url = $links['url'];
                                    $link_title = $links['title'];
                                ?>
                                    <a href="<?php echo esc_url($link_url); ?>" class="elementor-button theme-btn-custom"> <span
                                            class="elementor-button-icon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18">
                                                <path id="Arrow"
                                                    d="M1.336,18H.984a1.158,1.158,0,0,1-.667-.378A4.935,4.935,0,0,1,0,17.016v-.387a2.012,2.012,0,0,1,.607-.88Q7.246,9.115,13.88,2.476c.043-.043.083-.087.149-.156H4.039c-.281,0-.563.005-.844,0a1.162,1.162,0,0,1-1.083-.875A1.15,1.15,0,0,1,2.669.154,3.226,3.226,0,0,1,3.059,0H17.051a4.259,4.259,0,0,1,.52.267A1.219,1.219,0,0,1,18,.984V14.941c-.014.037-.03.073-.041.112a1.161,1.161,0,0,1-2.281-.357q0-5.245,0-10.491V4l-.063-.037a1.14,1.14,0,0,1-.119.172Q8.845,10.8,2.193,17.453A1.76,1.76,0,0,1,1.336,18"
                                                    fill="#6e1e24"></path>
                                            </svg> </span> <?php echo esc_html($link_title); ?></a>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                <?php
                    $first = false;
                endwhile; ?>
            </div>

            <!-- Indicators/dots -->
            <?php if ($total_slides > 1): ?>
                <div class="carousel-indicators">
                    <?php for ($i = 0; $i < $total_slides; $i++): ?>
                        <button type="button" data-bs-target="#demo" data-bs-slide-to="<?php echo $i; ?>"
                            class="<?php echo $i === 0 ? 'active' : ''; ?>">
                            <span></span>
                        </button>
                    <?php endfor; ?>
                </div>
            <?php endif; ?>

            <?php /* if ($total_slides > 1): ?>
                                                                    <span class="carousel-control-prev" data-bs-target="#demo" data-bs-slide="prev">
                                                                       <
                                                                    </span>
                                                                    <span class="carousel-control-next" data-bs-target="#demo" data-bs-slide="next">
                                                                      >
                                                                    </span>
                                                                <?php endif; */ ?>


        </div>

    <?php else: ?>
        <div>No Slider found.</div>
    <?php endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('banner_home', 'display_banner_home');


// Home slider end --------------------------------------------






















// events page start ------------------------------------------------------------


function display_events($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'events'
    );

    // Get the current page


    $args = array(
        'post_type' => 'events',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );


    // Filter by category if provided
    if (!empty($atts['category'])) {
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'events-category',
                'field' => 'slug',
                'terms' => $atts['category'],
            ),
        );
    }
    // Get categories
    $categories = get_terms(array(
        'taxonomy' => 'events-category',
        'hide_empty' => true,
        'orderby' => 'date',
        'order' => 'DESC',
    ));

    if ($categories):
    ?>
        <div class="text-center">
            <ul id="project-filter-list" class="mb-4">
                <li><a href="<?php echo esc_url(add_query_arg('category', '', home_url('/events'))); ?>"
                        class="cats <?php echo empty($atts['category']) ? 'active' : ''; ?>"> All </a></li>
                <?php foreach ($categories as $category):
                    $active_class = ($atts['category'] === $category->slug) ? 'active' : '';
                ?>
                    <li>
                        <a href="<?php echo esc_url(add_query_arg('category', $category->slug, home_url('/events'))); ?>"
                            class="cats <?php echo esc_attr($active_class); ?>">
                            <?php echo esc_html($category->name); ?>
                        </a>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php
    endif;




    $events_query = new WP_Query($args);

    ob_start();

    if ($events_query->have_posts()): ?>
        <div class="events-page events-main">
            <div class="row g-md-4 g-3">
                <?php while ($events_query->have_posts()):
                    $events_query->the_post();
                ?>
                    <div class="col-md-4">
                        <div class="events-box show-more-content-btn" id="<?php echo get_the_ID(); ?>">
                            <div class="events-img">
                                <a href="<?php the_permalink(); ?>" class="d-block">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                    } ?>
                                </a>

                                <div class="btn-center">
                                    <a href="<?php the_permalink(); ?>" class="elementor-button theme-btn-custom"> <span
                                            class="elementor-button-icon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18">
                                                <path id="Arrow"
                                                    d="M1.336,18H.984a1.158,1.158,0,0,1-.667-.378A4.935,4.935,0,0,1,0,17.016v-.387a2.012,2.012,0,0,1,.607-.88Q7.246,9.115,13.88,2.476c.043-.043.083-.087.149-.156H4.039c-.281,0-.563.005-.844,0a1.162,1.162,0,0,1-1.083-.875A1.15,1.15,0,0,1,2.669.154,3.226,3.226,0,0,1,3.059,0H17.051a4.259,4.259,0,0,1,.52.267A1.219,1.219,0,0,1,18,.984V14.941c-.014.037-.03.073-.041.112a1.161,1.161,0,0,1-2.281-.357q0-5.245,0-10.491V4l-.063-.037a1.14,1.14,0,0,1-.119.172Q8.845,10.8,2.193,17.453A1.76,1.76,0,0,1,1.336,18"
                                                    fill="#6e1e24"></path>
                                            </svg> </span> View More</a>
                                </div>

                            </div>
                            <div class="content-box mt-4">
                                <p class="date"> <?php echo strtoupper(get_the_date('F j, Y')); ?> </p>
                                <h1 class="title"> <?php echo get_the_title(); ?> </h1>
                                <p class="excerpt"> <?php echo get_the_excerpt(); ?> </p>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>

            <script type="text/javascript">
                document.addEventListener('DOMContentLoaded', function() {
                    var listItems = document.querySelectorAll('#category-filter-list a');
                    listItems.forEach(function(item) {
                        item.addEventListener('click', function(event) {
                            // No need to prevent default here; the link's href handles the filtering
                        });
                    });
                });
            </script>




            <?php if ($events_query->max_num_pages > 1): ?>
                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                    <div class="pagination-two">
                        <?php
                        echo paginate_links(array(
                            'total' => $events_query->max_num_pages,
                            'current' => max(1, get_query_var('paged')),
                            'format' => '?paged=%#%',
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => '<img src="https://draftsite1.com/jin-yin-memorial/wp-content/uploads/2025/06/back.png" alt="Previous">',
                            'next_text' => '<img src="https://draftsite1.com/jin-yin-memorial/wp-content/uploads/2025/06/back.png" alt="Next" style="transform: rotate(180deg);">',
                            'end_size' => 2,
                            'mid_size' => 2
                        ));
                        ?>
                    </div>
                </div>
            <?php endif; ?>


        <?php else:
        echo 'No events found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('events', 'display_events');


// events list end------------


// testimonials page start ------------------------------------------------------------


function display_testimonials($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 8,
        ),
        $atts,
        'testimonials'
    );

    // Get the current page

    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

    $args = array(
        'post_type' => 'testimonials',
        'posts_per_page' => $atts['posts_per_page'],
        // 'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
        'paged' => $paged,
        'orderby' => 'date',
        'order' => 'DESC',
    );


    $testimonials_query = new WP_Query($args);

    ob_start();

    if ($testimonials_query->have_posts()): ?>
            <div class="testimonials-page testimonials-main">
                <div class="row g-md-4 g-3">
                    <?php while ($testimonials_query->have_posts()):
                        $testimonials_query->the_post();
                    ?>
                        <div class="col-md-6">
                            <div class="testimonials-box" id="<?php echo get_the_ID(); ?>">
                                <div class="content-box">
                                    <?php echo get_the_content(); ?>
                                </div>
                                <div class="testimonials-wrap">
                                    <div class="info-bar">
                                        <div class="img-wrap">
                                            <?php if (has_post_thumbnail()) {
                                                the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                            } ?>
                                        </div>
                                        <h1 class="title"> <?php echo get_the_title(); ?> </h1>
                                    </div>

                                    <div class="btnlight">
                                        <?php
                                        $video_url = get_field('video_url');
                                        if ($video_url) {
                                        ?>
                                            <a href="<?php echo $video_url; ?>" class="elementor-button theme-btn-custom"
                                                target="_blank"> <span class="elementor-button-icon">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18">
                                                        <path id="Arrow"
                                                            d="M1.336,18H.984a1.158,1.158,0,0,1-.667-.378A4.935,4.935,0,0,1,0,17.016v-.387a2.012,2.012,0,0,1,.607-.88Q7.246,9.115,13.88,2.476c.043-.043.083-.087.149-.156H4.039c-.281,0-.563.005-.844,0a1.162,1.162,0,0,1-1.083-.875A1.15,1.15,0,0,1,2.669.154,3.226,3.226,0,0,1,3.059,0H17.051a4.259,4.259,0,0,1,.52.267A1.219,1.219,0,0,1,18,.984V14.941c-.014.037-.03.073-.041.112a1.161,1.161,0,0,1-2.281-.357q0-5.245,0-10.491V4l-.063-.037a1.14,1.14,0,0,1-.119.172Q8.845,10.8,2.193,17.453A1.76,1.76,0,0,1,1.336,18"
                                                            fill="#6e1e24"></path>
                                                    </svg> </span> View Video </a>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>
            </div>


            <?php if ($testimonials_query->max_num_pages > 1): ?>
                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                    <div class="pagination-two">
                        <?php
                        echo paginate_links(array(
                            'base' => get_pagenum_link(1) . '%_%',
                            'total' => $testimonials_query->max_num_pages,
                            'current' => max(1, get_query_var('paged')),
                            //  'format' => '?paged=%#%',
                            'format' => '/page/%#%',
                            'show_all' => false,
                            // 'type' => 'plain',
                            'prev_text' => '<img src="https://draftsite1.com/jin-yin-memorial/wp-content/uploads/2025/06/back.png" alt="Previous">',
                            'next_text' => '<img src="https://draftsite1.com/jin-yin-memorial/wp-content/uploads/2025/06/back.png" alt="Next" style="transform: rotate(180deg);">',
                            'end_size' => 2,
                            'mid_size' => 2
                        ));
                        ?>
                    </div>
                </div>
            <?php endif; ?>




        <?php else:
        echo 'No testimonials found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('testimonials', 'display_testimonials');



// testimonials list end------------

// testimonials slider start------------------
function display_testimonials_slider($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => -1,
        ),
        $atts,
        'testimonials'
    );

    $args = array(
        'post_type' => 'testimonials',
        'posts_per_page' => $atts['posts_per_page'],
        'meta_query' => array(
            array(
                'key' => '_is_ns_featured_post',
                'value' => 'yes',
                'compare' => '='
            )
        )
    );

    $testimonials_query = new WP_Query($args);


    ob_start();

    if ($testimonials_query->have_posts()): ?>
            <div class="testimonials-slider">
                <div class="slick-slider-testimonials">
                    <?php while ($testimonials_query->have_posts()):
                        $testimonials_query->the_post();
                    ?>

                        <div class="item">
                            <div class="testimonials-box-slider" id="<?php echo get_the_ID(); ?>">
                                <div class="content-box">
                                    <?php echo get_the_content(); ?>
                                </div>
                                <div class="testimonials-wrap">
                                    <div class="img-wrap">
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                        } ?>
                                    </div>
                                    <h1 class="title"> <?php echo get_the_title(); ?> </h1>
                                </div>
                            </div>

                        </div>
                    <?php endwhile; ?>
                </div>
            </div>

            <script>
                jQuery(document).ready(function($) {
                    $(".slick-slider-testimonials").slick({
                        dots: false,
                        arrows: true,
                        infinite: true,
                        autoplay: false,
                        speed: 300,
                        slidesToShow: 1,
                        slidesToScroll: 1,
                        adaptiveHeight: true,
                        prevArrow: '<div class="left-btn arrowbtn"> <img src="https://draftsite1.com/jin-yin-memorial/wp-content/uploads/2025/06/back.png"> </div>',
                        nextArrow: '<div class="right-btn arrowbtn"><img src="https://draftsite1.com/jin-yin-memorial/wp-content/uploads/2025/06/back.png"></div>',
                        responsive: [{
                                breakpoint: 1200,
                                settings: {
                                    slidesToShow: 1,
                                    slidesToScroll: 1,
                                },
                            },
                            {
                                breakpoint: 1008,
                                settings: {
                                    slidesToShow: 1,
                                    slidesToScroll: 1,
                                },
                            },
                            {
                                breakpoint: 800,
                                settings: {
                                    slidesToShow: 1,
                                    slidesToScroll: 1,
                                },
                            },
                        ],
                    });

                });
            </script>

        <?php else:
        echo 'No testimonials found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('testimonials_slider', 'display_testimonials_slider');
// testimonials slider end ------------------------------


// blog page start ------------------------------------------------------------


function display_blog($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
        ),
        $atts,
        'blog'
    );


    // Query arguments
    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );


    $blog_query = new WP_Query($args);

    ob_start();

    if ($blog_query->have_posts()): ?>
            <div class="blog-page blog-main">
                <div class="row g-md-4 g-3">
                    <?php while ($blog_query->have_posts()):
                        $blog_query->the_post();
                    ?>
                        <div class="col-md-4">
                            <div class="blog-box" data-post-id="<?php echo get_the_ID(); ?>">
                                <div class="blog-img">
                                    <a href="<?php the_permalink(); ?>" class="d-block">
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                        } ?>
                                    </a>


                                    <div class="btn-center">
                                        <a href="<?php the_permalink(); ?>" class="elementor-button theme-btn-custom"> <span
                                                class="elementor-button-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18">
                                                    <path id="Arrow"
                                                        d="M1.336,18H.984a1.158,1.158,0,0,1-.667-.378A4.935,4.935,0,0,1,0,17.016v-.387a2.012,2.012,0,0,1,.607-.88Q7.246,9.115,13.88,2.476c.043-.043.083-.087.149-.156H4.039c-.281,0-.563.005-.844,0a1.162,1.162,0,0,1-1.083-.875A1.15,1.15,0,0,1,2.669.154,3.226,3.226,0,0,1,3.059,0H17.051a4.259,4.259,0,0,1,.52.267A1.219,1.219,0,0,1,18,.984V14.941c-.014.037-.03.073-.041.112a1.161,1.161,0,0,1-2.281-.357q0-5.245,0-10.491V4l-.063-.037a1.14,1.14,0,0,1-.119.172Q8.845,10.8,2.193,17.453A1.76,1.76,0,0,1,1.336,18"
                                                        fill="#6e1e24"></path>
                                                </svg> </span> View More</a>
                                    </div>

                                    <?php
                                    $terms = get_the_terms(get_the_ID(), 'category');
                                    if ($terms && !is_wp_error($terms)) { ?>
                                        <div class="category-wrap">
                                            <?php
                                            foreach ($terms as $term) {
                                                $category_name = strtolower($term->name); ?>

                                                <span class="category-name"><?php echo $category_name; ?></span>

                                            <?php
                                            } ?>
                                        </div>
                                    <?php }
                                    ?>
                                </div>

                                <div class="content-box">
                                    <h1 class="title"> <?php echo get_the_title(); ?> </h1>
                                    <p class="date"> <?php echo strtoupper(get_the_date('F j, Y')); ?> </p>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>


                <script type="text/javascript">
                    document.addEventListener('DOMContentLoaded', function() {
                        var listItems = document.querySelectorAll('#category-filter-list a');
                        listItems.forEach(function(item) {
                            item.addEventListener('click', function(event) {
                                // No need to prevent default here; the link's href handles the filtering
                            });
                        });
                    });
                </script>


                <?php if ($blog_query->max_num_pages > 1): ?>
                    <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                        <div class="pagination-two">
                            <?php
                            echo paginate_links(array(
                                'total' => $blog_query->max_num_pages,
                                'current' => max(1, get_query_var('paged')),
                                'format' => '?paged=%#%',
                                'show_all' => false,
                                'type' => 'plain',
                                'prev_text' => '<img src="https://draftsite1.com/jin-yin-memorial/wp-content/uploads/2025/06/back.png" alt="Previous">',
                                'next_text' => '<img src="https://draftsite1.com/jin-yin-memorial/wp-content/uploads/2025/06/back.png" alt="Next" style="transform: rotate(180deg);">',
                                'end_size' => 2,
                                'mid_size' => 2
                            ));
                            ?>
                        </div>
                    </div>
                <?php endif; ?>



            <?php else:
            echo 'No blog found.';
        endif;

        wp_reset_postdata();

        return ob_get_clean();
    }
    add_shortcode('blog', 'display_blog');


    // blog list end------------


    // blog slider start  ---------------------
    function display_blog_slider($atts)
    {
        // Attributes
        $atts = shortcode_atts(
            array(
                'posts_per_page' => -1,
            ),
            $atts,
            'blog'
        );

        $args = array(
            'post_type' => 'post',
            'posts_per_page' => $atts['posts_per_page'],
            'meta_query' => array(
                array(
                    'key' => '_is_ns_featured_post',
                    'value' => 'yes',
                    'compare' => '='
                )
            )
        );

        $blog_query = new WP_Query($args);


        ob_start();

        if ($blog_query->have_posts()): ?>
                <div class="blog-slider">
                    <div class="slick-slider-blog">
                        <?php while ($blog_query->have_posts()):
                            $blog_query->the_post();
                        ?>

                            <div class="item">
                                <div class="blog-box" data-post-id="<?php echo get_the_ID(); ?>">
                                    <div class="blog-img">
                                        <a href="<?php the_permalink(); ?>" class="d-block">
                                            <?php if (has_post_thumbnail()) {
                                                the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                            } ?>
                                        </a>


                                        <div class="btn-center">
                                            <a href="<?php the_permalink(); ?>" class="elementor-button theme-btn-custom"> <span
                                                    class="elementor-button-icon">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                                        viewBox="0 0 18 18">
                                                        <path id="Arrow"
                                                            d="M1.336,18H.984a1.158,1.158,0,0,1-.667-.378A4.935,4.935,0,0,1,0,17.016v-.387a2.012,2.012,0,0,1,.607-.88Q7.246,9.115,13.88,2.476c.043-.043.083-.087.149-.156H4.039c-.281,0-.563.005-.844,0a1.162,1.162,0,0,1-1.083-.875A1.15,1.15,0,0,1,2.669.154,3.226,3.226,0,0,1,3.059,0H17.051a4.259,4.259,0,0,1,.52.267A1.219,1.219,0,0,1,18,.984V14.941c-.014.037-.03.073-.041.112a1.161,1.161,0,0,1-2.281-.357q0-5.245,0-10.491V4l-.063-.037a1.14,1.14,0,0,1-.119.172Q8.845,10.8,2.193,17.453A1.76,1.76,0,0,1,1.336,18"
                                                            fill="#6e1e24"></path>
                                                    </svg> </span> View More</a>
                                        </div>

                                        <?php
                                        $terms = get_the_terms(get_the_ID(), 'category');
                                        if ($terms && !is_wp_error($terms)) { ?>
                                            <div class="category-wrap">
                                                <?php
                                                foreach ($terms as $term) {
                                                    $category_name = strtolower($term->name); ?>

                                                    <span class="category-name"><?php echo $category_name; ?></span>

                                                <?php
                                                } ?>
                                            </div>
                                        <?php }
                                        ?>
                                    </div>

                                    <div class="content-box">
                                        <h1 class="title"> <?php echo get_the_title(); ?> </h1>
                                        <p class="date"> <?php echo strtoupper(get_the_date('F j, Y')); ?> </p>
                                    </div>
                                </div>

                            </div>
                        <?php endwhile; ?>
                    </div>
                </div>

                <script>
                    jQuery(document).ready(function($) {
                        $(".slick-slider-blog").slick({
                            dots: false,
                            arrows: false,
                            infinite: true,
                            autoplay: true,
                            autoplaySpeed: 2000,
                            speed: 300,
                            slidesToShow: 3,
                            slidesToScroll: 1,
                            adaptiveHeight: true,
                            prevArrow: '<div class="left-btn arrowbtn"> <img src="https://draftsite1.com/jin-yin-memorial/wp-content/uploads/2025/06/left-arrow.png"> </div>',
                            nextArrow: '<div class="right-btn arrowbtn"><img src="https://draftsite1.com/jin-yin-memorial/wp-content/uploads/2025/06/right-arrow.png"></div>',
                            responsive: [{
                                    breakpoint: 1200,
                                    settings: {
                                        slidesToShow: 3,
                                        slidesToScroll: 1,
                                    },
                                },
                                {
                                    breakpoint: 1008,
                                    settings: {
                                        slidesToShow: 3,
                                        slidesToScroll: 1,
                                    },
                                },
                                {
                                    breakpoint: 800,
                                    settings: {
                                        slidesToShow: 1,
                                        slidesToScroll: 1,
                                    },
                                },
                            ],
                        });

                    });
                </script>

            <?php else:
            echo 'No blog found.';
        endif;

        wp_reset_postdata();

        return ob_get_clean();
    }
    add_shortcode('blog_slider', 'display_blog_slider');
    // blog slider end ------------------------------




    // woocommerce start -------------------------------


    // product-categories start -----------------------------------------

    function wpb_woocommerce_product_categories_accordion()
    {
        // Get the current queried product category
        $queried_object = get_queried_object();
        $current_category_id = ($queried_object && isset($queried_object->term_id)) ? $queried_object->term_id : 0;

        // Get all parent categories of the current category
        $current_category_parents = [];
        if ($current_category_id) {
            $parent_categories = get_ancestors($current_category_id, 'product_cat');
            $current_category_parents = array_map('intval', $parent_categories);
        }

        // Recursive function to get subcategories with checkboxes
        function get_subcategories($parent_id, $level = 1, $current_category_id, $current_category_parents)
        {
            $args = array(
                'taxonomy' => 'product_cat',
                'orderby' => 'name',
                'order' => 'ASC',
                'parent' => $parent_id,
                'hide_empty' => false
            );
            $sub_categories = get_terms($args);

            if (!empty($sub_categories)) {
                echo '<ul class="list-unstyled ps-2">';
                foreach ($sub_categories as $sub_category) {
                    $is_checked = ($sub_category->term_id == $current_category_id) ? 'checked' : '';
                    $active_class = ($sub_category->term_id == $current_category_id) ? 'current-category' : '';

                    echo '<li class="' . $active_class . '">';
                    echo '<div class="in-menu">';
                    echo '<input type="checkbox" class="category-checkbox me-2" data-category-id="' . $sub_category->term_id . '" ' . $is_checked . '> ';

                    echo '<a href="' . get_term_link($sub_category) . '">  <span class="customcheck"></span>' . $sub_category->name . '</a>';
                    echo '</div>';
                    get_subcategories($sub_category->term_id, $level + 1, $current_category_id, $current_category_parents);
                    echo '</li>';
                }
                echo '</ul>';
            }
        }

        // Get main product categories (parent categories)
        $args = array(
            'taxonomy' => 'product_cat',
            'orderby' => 'name',
            'order' => 'ASC',
            'parent' => 0,
            'hide_empty' => false
        );
        $product_categories = get_terms($args);

        if ($product_categories) {
            ob_start();
            ?>
                <div class="accordion pe-md-5" id="productCategoriesAccordion">

                    <?php
                    $shop_page_url = wc_get_page_permalink('shop');
                    $is_shop_page = is_shop();
                    ?>

                    <div class="accordion-item <?php echo $is_shop_page ? 'current-category' : '';
                                                ?>">
                        <div class="accordion-header">
                            <label>
                                <a href="<?php echo esc_url($shop_page_url);
                                            ?>" class="main-category">
                                    All Product
                                </a>
                            </label>
                        </div>
                    </div>


                    <?php
                    $i = 0;
                    foreach ($product_categories as $category) {
                        $i++;

                        // Check if the category has subcategories
                        $sub_args = array(
                            'taxonomy' => 'product_cat',
                            'parent' => $category->term_id,
                            'hide_empty' => true
                        );
                        $sub_categories = get_terms($sub_args);
                        $has_subcategories = !empty($sub_categories);

                        // Determine if this category should be expanded
                        $is_checked = ($category->term_id == $current_category_id) ? 'checked' : '';
                        $active_class = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'current-category' : '';
                        $show_collapse = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'show' : '';
                    ?>
                        <div class="accordion-item <?php echo $active_class; ?>">
                            <div class="accordion-header d-flex align-items-center" id="heading<?php echo $i; ?>">
                                <label for="cat<?php echo $category->term_id; ?>">
                                    <input type="checkbox" class="category-checkbox me-2" id="cat<?php echo $category->term_id; ?>"
                                        data-category-id="<?php echo $category->term_id; ?>" <?php echo $is_checked; ?>>

                                    <a href="<?php echo get_term_link($category); ?>" class="main-category">
                                        <span class="customcheck"></span>
                                        <?php echo $category->name . ' <span class="count">(' . $category->count . ')</span>'; ?>
                                    </a>
                                </label>

                                <?php if ($has_subcategories) { ?>
                                    <button class="accordion-button ms-auto <?php echo ($show_collapse == '') ? 'collapsed' : ''; ?>"
                                        type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>"
                                        aria-expanded="<?php echo ($show_collapse) ? 'true' : 'false'; ?>"
                                        aria-controls="collapse<?php echo $i; ?>" data-category-id="<?php echo $category->term_id; ?>">
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                <?php } ?>
                            </div>
                            <?php if ($has_subcategories) { ?>
                                <div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse <?php echo $show_collapse; ?>"
                                    aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#productCategoriesAccordion">
                                    <div class="accordion-body ps-0 pe-0">
                                        <?php get_subcategories($category->term_id, 1, $current_category_id, $current_category_parents); ?>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    <?php
                    }
                    ?>
                </div>

                <script>
                    document.addEventListener("DOMContentLoaded", function() {
                        var savedCategories = JSON.parse(localStorage.getItem("checkedCategories")) || [];

                        savedCategories.forEach(function(categoryId) {
                            var checkbox = document.querySelector('.category-checkbox[data-category-id="' + categoryId + '"]');
                            if (checkbox) {
                                checkbox.checked = true;
                            }
                        });

                        document.querySelectorAll(".category-checkbox").forEach(function(checkbox) {
                            checkbox.addEventListener("change", function() {
                                var categoryId = this.getAttribute("data-category-id");
                                if (this.checked) {
                                    if (!savedCategories.includes(categoryId)) {
                                        savedCategories.push(categoryId);
                                    }
                                } else {
                                    savedCategories = savedCategories.filter(id => id !== categoryId);
                                }
                                localStorage.setItem("checkedCategories", JSON.stringify(savedCategories));
                            });
                        });

                        var activeCategory = localStorage.getItem("activeCategory");
                        if (activeCategory) {
                            var activeAccordion = document.querySelector('[data-category-id="' + activeCategory + '"]');
                            if (activeAccordion) {
                                var collapseElement = activeAccordion.getAttribute("data-bs-target");
                                document.querySelector(collapseElement).classList.add("show");
                                activeAccordion.classList.remove("collapsed");
                                activeAccordion.setAttribute("aria-expanded", "true");
                            }
                        }

                        document.querySelectorAll(".accordion-button").forEach(function(button) {
                            button.addEventListener("click", function() {
                                var categoryId = this.getAttribute("data-category-id");
                                if (document.querySelector(this.getAttribute("data-bs-target")).classList.contains("show")) {
                                    localStorage.removeItem("activeCategory");
                                } else {
                                    localStorage.setItem("activeCategory", categoryId);
                                }
                            });
                        });
                    });
                </script>

                <style>
                    .current-category>a {
                        font-weight: bold;
                        color: #ff6600;
                    }

                    .category-checkbox {
                        display: none;
                    }

                    span.customcheck {
                        background: #FFFFFF 0% 0% no-repeat padding-box;
                        border: 1px solid #BEC0C5;
                        border-radius: 0px;
                        width: 15px;
                        height: 15px;
                        position: relative;
                        margin-right: 2px;
                        margin-top: 0px;
                        top: 2px;
                        display: inline-block;
                    }

                    .current-category [type=checkbox]:checked~a span.customcheck {
                        background: #BEC0C5;
                        border-color: #BEC0C5;
                    }

                    .current-category [type=checkbox]~a .customcheck:after {
                        content: "";
                        position: absolute;
                    }

                    .current-category a input:checked~.customcheck:after {
                        display: block;
                    }

                    .current-category a .customcheck:after {
                        left: 5px;
                        top: 2px;
                        width: 4px;
                        height: 8px;
                        border: solid white;
                        border-width: 0 2px 2px 0;
                        -webkit-transform: rotate(45deg);
                        -ms-transform: rotate(45deg);
                        transform: rotate(45deg);
                    }
                </style>
        <?php
            return ob_get_clean();
        }
    }

    add_shortcode('product_categories_accordion', 'wpb_woocommerce_product_categories_accordion');

    // product category for sidebar end -------------------------------



    // Wrap WooCommerce product image in a div start ----------
    add_action('woocommerce_before_shop_loop_item_title', 'wrap_product_image_in_div', 5);
    function wrap_product_image_in_div()
    {
        echo '<div class="custom-image-wrapper">';
    }
    add_action('woocommerce_before_shop_loop_item_title', 'close_product_image_div', 15);
    function close_product_image_div()
    {
        echo '</div>';
    }
    // Wrap WooCommerce product image in a div end ----------


    // View Product Button ------------ 
    add_action('woocommerce_before_shop_loop_item_title', 'custom_view_product_button', 20);
    function custom_view_product_button()
    {
        global $product;
        echo '<div class="custom-view-button">
            <div class="animated-btn">
                <a href="' . get_permalink($product->get_id()) . '" class="view-product-link elementor-button theme-btn-custom">
                <span class="elementor-button-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18">
                            <path id="Arrow"
                                d="M1.336,18H.984a1.158,1.158,0,0,1-.667-.378A4.935,4.935,0,0,1,0,17.016v-.387a2.012,2.012,0,0,1,.607-.88Q7.246,9.115,13.88,2.476c.043-.043.083-.087.149-.156H4.039c-.281,0-.563.005-.844,0a1.162,1.162,0,0,1-1.083-.875A1.15,1.15,0,0,1,2.669.154,3.226,3.226,0,0,1,3.059,0H17.051a4.259,4.259,0,0,1,.52.267A1.219,1.219,0,0,1,18,.984V14.941c-.014.037-.03.073-.041.112a1.161,1.161,0,0,1-2.281-.357q0-5.245,0-10.491V4l-.063-.037a1.14,1.14,0,0,1-.119.172Q8.845,10.8,2.193,17.453A1.76,1.76,0,0,1,1.336,18"
                                fill="#6e1e24"></path>
                        </svg> 
                    </span>  
                    View More
                </a>
            </div>
          </div>';
    }
    // View Product Button end------------ 






    // Move short description before price on single product page
    remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20);

    add_action('woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 9);

    // Remove default breadcrumb location
    remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);

    // Add breadcrumb before product title
    add_action('woocommerce_single_product_summary', 'woocommerce_breadcrumb', 4);


    add_filter('woocommerce_breadcrumb_defaults', 'custom_woocommerce_breadcrumb_separator');
    function custom_woocommerce_breadcrumb_separator($defaults) {
        $defaults['delimiter'] = ' <span class="breadcrumb-separator">|</span> ';
        return $defaults;
    }
    

    // Remove default related products heading
    remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);

    // Add back related products with custom title
    add_action('woocommerce_after_single_product_summary', 'custom_output_related_products_with_custom_heading', 20);

    function custom_output_related_products_with_custom_heading()
    {
        global $product;

        $args = array(
            'posts_per_page' => 4,
            'columns' => 4,
            'orderby' => 'rand', // Or 'date', etc.
        );

        $subheading = 'YOU MAY ALSO LIKE';

        $heading = 'Complementary Ritual Items to <br>Complete Your   <span>Offering</span>';

        $related_products = wc_get_related_products($product->get_id(), $args['posts_per_page']);

        if (count($related_products) === 0) {
            return;
        }

        echo '<section class="related products">';
        echo '<h2>' . $subheading . '</h2>';
        echo '<h1>' . $heading . '</h1>';

        woocommerce_product_loop_start();

        foreach ($related_products as $related_product_id) {
            $post_object = get_post($related_product_id);
            setup_postdata($GLOBALS['post'] = &$post_object);
            wc_get_template_part('content', 'product');
        }

        woocommerce_product_loop_end();

        echo '</section>';

        wp_reset_postdata();
    }






    // validation woocommerce start 


    add_action('woocommerce_save_account_details_errors', 'validate_my_account_fields', 10, 1);

    function validate_my_account_fields($errors)
    {
        // Validate First Name
        if (isset($_POST['account_first_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_first_name'])) {
            $errors->add('validation', __('Allowed characters for First Name are alphabets and spaces only.', 'woocommerce'));
        }

        // Validate Last Name
        if (isset($_POST['account_last_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_last_name'])) {
            $errors->add('validation', __('Allowed characters for Last Name are alphabets and spaces only.', 'woocommerce'));
        }

        // Validate Display Name
        if (isset($_POST['account_display_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_display_name'])) {
            $errors->add('validation', __('Allowed characters for Display Name are alphabets and spaces only.', 'woocommerce'));
        }
    }




    add_action('woocommerce_after_save_address_validation', 'validate_billing_address_fields', 10, 2);

    function validate_billing_address_fields($user_id, $address_type)
    {
        if ('billing' === $address_type) {
            // Initialize an array to store error messages
            $validation_errors = [];

            // Get the values of the fields from the form
            $billing_first_name = isset($_POST['billing_first_name']) ? sanitize_text_field($_POST['billing_first_name']) : '';
            $billing_last_name = isset($_POST['billing_last_name']) ? sanitize_text_field($_POST['billing_last_name']) : '';
            $billing_city = isset($_POST['billing_city']) ? sanitize_text_field($_POST['billing_city']) : '';
            $billing_address_1 = isset($_POST['billing_address_1']) ? sanitize_text_field($_POST['billing_address_1']) : '';

            $billing_postcode = isset($_POST['billing_postcode']) ? sanitize_text_field($_POST['billing_postcode']) : '';
            $billing_email = isset($_POST['billing_email']) ? sanitize_email($_POST['billing_email']) : '';

            // Validate Billing First Name (Only alphabets and spaces allowed)
            if (!preg_match('/^[a-zA-Z\s]+$/', $billing_first_name)) {
                $validation_errors[] = __('Allowed characters for Billing First Name are alphabets and spaces only.', 'woocommerce');
            }

            // Validate Billing Last Name (Only alphabets and spaces allowed)
            if (!preg_match('/^[a-zA-Z\s]+$/', $billing_last_name)) {
                $validation_errors[] = __('Allowed characters for Billing Last Name are alphabets and spaces only.', 'woocommerce');
            }

            // Validate Billing Last Name (Only alphabets and spaces allowed)
            if (!preg_match('/^[a-zA-Z\s]+$/', $billing_city)) {
                $validation_errors[] = __('Allowed characters for Billing City Name are alphabets and spaces only.', 'woocommerce');
            }

            // Validate Address (Only letters, numbers, and spaces)
            if (!preg_match('/^[a-zA-Z0-9\s]+$/', $billing_address_1)) {
                $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
            }

            // Validate Postcode (Only numbers, 4-10 digits)
            if (!preg_match('/^\d{4,6}$/', $billing_postcode)) {
                $validation_errors[] = __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
            }



            // Validate Billing Email (Basic Email validation)
            if (!is_email($billing_email)) {
                $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
            }

            // If there are validation errors, stop the form submission and display the errors
            if (!empty($validation_errors)) {
                // Add all validation errors as WooCommerce notices
                foreach ($validation_errors as $error_message) {
                    wc_add_notice($error_message, 'error');  // Add error messages
                }

                // Stop the form submission by returning early
                return; // This will prevent the address from being saved
            }
        }
    }








    add_action('woocommerce_after_save_address_validation', 'validate_shipping_address_fields', 10, 2);

    function validate_shipping_address_fields($user_id, $address_type)
    {
        if ('shipping' === $address_type) {
            // Initialize an array to store error messages
            $validation_errors = [];

            // Get the values of the fields from the form
            $shipping_first_name = isset($_POST['shipping_first_name']) ? sanitize_text_field($_POST['shipping_first_name']) : '';
            $shipping_last_name = isset($_POST['shipping_last_name']) ? sanitize_text_field($_POST['shipping_last_name']) : '';
            $shipping_city = isset($_POST['shipping_city']) ? sanitize_text_field($_POST['shipping_city']) : '';
            $shipping_address_1 = isset($_POST['shipping_address_1']) ? sanitize_text_field($_POST['shipping_address_1']) : '';

            $shipping_postcode = isset($_POST['shipping_postcode']) ? sanitize_text_field($_POST['shipping_postcode']) : '';
            //  $shipping_email = isset($_POST['shipping_email']) ? sanitize_email($_POST['shipping_email']) : '';

            // Validate shipping First Name (Only alphabets and spaces allowed)
            if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_first_name)) {
                $validation_errors[] = __('Allowed characters for shipping First Name are alphabets and spaces only.', 'woocommerce');
            }

            // Validate shipping Last Name (Only alphabets and spaces allowed)
            if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_last_name)) {
                $validation_errors[] = __('Allowed characters for shipping Last Name are alphabets and spaces only.', 'woocommerce');
            }

            // Validate shipping Last Name (Only alphabets and spaces allowed)
            if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_city)) {
                $validation_errors[] = __('Allowed characters for shipping City Name are alphabets and spaces only.', 'woocommerce');
            }

            // Validate Address (Only letters, numbers, and spaces)
            if (!preg_match('/^[a-zA-Z0-9\s]+$/', $shipping_address_1)) {
                $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
            }

            // Validate Postcode (Only numbers, 4-10 digits)
            if (!preg_match('/^\d{4,6}$/', $shipping_postcode)) {
                $validation_errors[] = __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
            }



            // Validate shipping Email (Basic Email validation)
            // if (!is_email($shipping_email)) {
            //     $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
            // }

            // If there are validation errors, stop the form submission and display the errors
            if (!empty($validation_errors)) {
                // Add all validation errors as WooCommerce notices
                foreach ($validation_errors as $error_message) {
                    wc_add_notice($error_message, 'error');  // Add error messages
                }

                // Stop the form submission by returning early
                return; // This will prevent the address from being saved
            }
        }
    }




    // validation woocommerce end --------------------

    // contact form validation 




    // Validate text fields (only alphabets allowed)
    add_filter('wpcf7_validate_text', 'alpha_validation_filter_text', 20, 2);
    add_filter('wpcf7_validate_text*', 'alpha_validation_filter_text', 20, 2);

    function alpha_validation_filter_text($result, $tag)
    {
        if (class_exists('WPCF7_FormTag')) {
            $tag = new WPCF7_FormTag($tag); // Corrected class
        }

        if ('names' === $tag->name) {
            $name_of_the_input = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

            if (!preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input)) {
                $result->invalidate($tag, "Allowed characters are Alphabets only.");
            }
        }

        if ('subject' === $tag->name) {
            $name_of_the_input = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

            if (!preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input)) {
                $result->invalidate($tag, "Allowed characters are Alphabets only.");
            }
        }

        return $result;
    }

    // Validate phone number (must be exactly 10 digits)
    add_filter('wpcf7_validate_tel', 'numeric_phone_validation_filter', 20, 2);
    add_filter('wpcf7_validate_tel*', 'numeric_phone_validation_filter', 20, 2);

    function numeric_phone_validation_filter($result, $tag)
    {
        if (class_exists('WPCF7_FormTag')) {
            $tag = new WPCF7_FormTag($tag); // Corrected class
        }

        if ('phone' === $tag->name) {
            $phone_number = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

            if (!preg_match('/^\d{8}$/', $phone_number)) {
                $result->invalidate($tag, "Phone number must contain exactly 8 digits.");
            }
        }

        return $result;
    }



    // Validate email (must be a valid email format)
    add_filter('wpcf7_validate_email', 'validate_email_filter', 20, 2);
    add_filter('wpcf7_validate_email*', 'validate_email_filter', 20, 2);

    function validate_email_filter($result, $tag)
    {
        if (class_exists('WPCF7_FormTag')) {
            $tag = new WPCF7_FormTag($tag); // Corrected class
        }

        if ('email' === $tag->name) {
            $email = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

            if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                $result->invalidate($tag, "Please enter a valid email address.");
            }
        }

        return $result;
    }


    // Validate textarea field (message)
    add_filter('wpcf7_validate_textarea', 'validate_textarea_filter', 20, 2);
    add_filter('wpcf7_validate_textarea*', 'validate_textarea_filter', 20, 2);

    function validate_textarea_filter($result, $tag)
    {
        if (class_exists('WPCF7_FormTag')) {
            $tag = new WPCF7_FormTag($tag); // Corrected class
        }

        if ('message' === $tag->name) {
            $message = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

            // Allowed characters: alphabets, spaces, common punctuation marks
            if (!preg_match('/^[a-zA-Z0-9\s.,!?()-]+$/', $message)) {
                $result->invalidate($tag, "Message contains invalid characters. Only letters, numbers, spaces, and punctuation are allowed.");
            }

            // Min 10 characters, Max 500 characters
            if (strlen($message) < 10 || strlen($message) > 500) {
                $result->invalidate($tag, "Message must be between 10 and 500 characters.");
            }
        }

        return $result;
    }





    add_filter('woocommerce_breadcrumb_defaults', 'custom_woocommerce_breadcrumbs');

function custom_woocommerce_breadcrumbs($defaults) {
    $defaults['delimiter'] = ' | ';
    return $defaults;
}




        ?>