jQuery(document).ready(function ($) {
  $("#load-more-promotion").on("click", function () {
    var button = $(this);
    var page = button.data("page");
    var maxPages = button.data("max-pages");
    var category = ajax_params.category; // Get category from localized script

    $.ajax({
      url: ajax_params.ajax_url, // Use the localized AJAX URL
      type: "POST",
      data: {
        action: "load_more_promotions",
        page: page + 1, // Load next page
        category: category, // Send category if selected
      },
      success: function (response) {
        if (response) {
          $("#promotion-container").append(response);
          button.data("page", page + 1);

          if (page + 1 >= maxPages) {
            button.remove(); // Remove button if there are no more pages
          }
        } else {
          button.remove(); // Remove button if no more posts
        }
      },
    });
  });
});
