<?php
// Enqueue the parent theme's stylesheet

function hello_elementor_child_enqueue_styles()
{
    wp_enqueue_style('hello-elementor-parent-style', get_template_directory_uri() . '/../hello-elementor-child/style.css');
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles');




// custom code

// Enqueue Booststrap 
function enqueue_bootstrap()
{
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');


//  Slick carousel script and styles
function enqueue_slick_scripts()
{
    //  Slick carousel script
    wp_enqueue_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js', array('jquery'), null, true);
    //  Slick carousel CSS
    wp_enqueue_style('slick-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_slick_scripts');


// Enqueue jQuery and custom script for Load More functionality
function enqueue_load_more_scripts()
{
    wp_enqueue_script('jquery');
    wp_enqueue_script('load-more-script', get_template_directory_uri() . '/../hello-elementor-child/custom-script.js', array('jquery'), null, true);
    wp_localize_script('load-more-script', 'ajax_params', array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
    ));
}
add_action('wp_enqueue_scripts', 'enqueue_load_more_scripts');


function all_testimonials()
{
    // Define your HTML content here
    $html_content = '		            
        <div class="testimonial-box">
            <div class="testimonial-header d-flex align-items-center mb-4">
                <img src="https://www.jteamhairstudio.com/wp-content/uploads/2024/09/unnamed.png" alt="Testimonial Image" width="120">
                <h3 class="ms-3 mb-0">John Doe</h3>
            </div>            
            <p class="description">“Thanks to this course, I’ve mastered Generative AI tools to create impactful visuals and content that align perfectly with my business goals. The hands-on approach and practical tips made it easy to apply the skills immediately. Highly recommended!”</p>
        </div>
	';
    return $html_content;
}
add_shortcode('all_testimonials', 'all_testimonials');




function display_blog($atts)
{
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 12,
        ),
        $atts,
        'blog'
    );
    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );


    $blog_query = new WP_Query($args);

    ob_start();

    if ($blog_query->have_posts()): ?>
        <div class="blog-page blog-main">
            <div class="container-fluid px-1">
                <div class="row">
                    <?php while ($blog_query->have_posts()):
                        $blog_query->the_post();
                    ?>
                        <div class="col-lg-3 col-md-4 col-sm-6">
                            <div class="blog-box">
                                <a href="<?php the_permalink(); ?>">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('full', array('class' => 'main-img w-100 mb-2'));
                                    } ?>
                                    <h3><?php the_title(); ?></h3>
                                </a>
                            </div>
                        </div>

                    <?php endwhile; ?>
                </div>

                <div class="pagination-center text-start mt-md-5 mt-3 mb-3">
                    <div class="pagination-two d-inline-block">
                        <?php
                        echo paginate_links(
                            array(
                                'total' => $blog_query->max_num_pages,
                                'current' => max(1, get_query_var('paged')),
                                // 'format' => '?paged=%#%', 
                                'format' => '/page/%#%/',
                                'show_all' => false,
                                'type' => 'plain',
                                'prev_text' => __('<'),
                                'next_text' => __('>'),
                                'end_size' => 2,
                                'mid_size' => 2
                            )
                        );
                        ?>
                    </div>
                </div>
            </div>
        </div>



    <?php else:
        echo 'No blog found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('blog_list', 'display_blog');


function get_related_articles($post_id, $number_of_posts = 3)
{
    $current_post = get_post($post_id);
    $related_posts = array();

    // Get categories of the current post
    $categories = wp_get_post_categories($post_id);
    if ($categories) {
        $args = array(
            'category__in' => $categories,
            'post__not_in' => array($post_id),
            'posts_per_page' => $number_of_posts,
            'ignore_sticky_posts' => 1,
        );
        $related_posts = get_posts($args);
    }

    // If not enough related posts by category, get related posts by tag
    if (count($related_posts) < $number_of_posts) {
        $tags = wp_get_post_tags($post_id);
        if ($tags) {
            $tag_ids = array();
            foreach ($tags as $tag) {
                $tag_ids[] = $tag->term_id;
            }
            $args = array(
                'tag__in' => $tag_ids,
                'post__not_in' => array_merge(array($post_id), wp_list_pluck($related_posts, 'ID')),
                'posts_per_page' => $number_of_posts - count($related_posts),
                'ignore_sticky_posts' => 1,
            );
            $more_related_posts = get_posts($args);
            $related_posts = array_merge($related_posts, $more_related_posts);
        }
    }

    return $related_posts;
}

// blog end --------------------------






// promotion  start -------------------------------------------------------

function display_promotion($atts)
{
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 4,
        ),
        $atts,
        'promotion_list_view'
    );


    $selected_category = isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '';


    $args = array(
        'post_type' => 'promotions',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => 1,
    );


    if (!empty($selected_category)) {
        $args['category_name'] = $selected_category;
    }

    // WP Query
    $promotion_query = new WP_Query($args);


    ob_start();

    if ($promotion_query->have_posts()):
    ?>
        <div class="promotion">
            <div class="row py-5" id="promotion-container">
                <?php while ($promotion_query->have_posts()):
                    $promotion_query->the_post(); ?>

                    <div class="col-lg-3 col-md-4 col-sm-6">
                        <div class="blog-box">
                            <a href="<?php the_permalink(); ?>">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'main-img w-100'));
                                } ?>
                                <h3> <?php the_title(); ?></h3>
                            </a>
                        </div>
                    </div>

                <?php endwhile; ?>
            </div>
        </div>

        <!-- Load More Button -->
        <?php if ($promotion_query->max_num_pages > 1): ?>
            <div class="text-center mt-md-5 mt-3 mb-3">
                <button id="load-more-promotion" class="load-more-btn btn-custom" data-page="1"
                    data-max-pages="<?php echo $promotion_query->max_num_pages; ?>">Load More</button>
            </div>
        <?php endif; ?>

        <?php else:
        echo 'No promotion found.';
    endif;

    // Reset post data
    wp_reset_postdata();

    // Return the buffered content
    return ob_get_clean();
}
add_shortcode('promotion_list_view', 'display_promotion');

// Handle AJAX request for loading more posts
function load_more_promotions()
{
    $paged = isset($_POST['page']) ? intval($_POST['page']) : 1;
    $selected_category = isset($_POST['category']) ? sanitize_text_field($_POST['category']) : '';

    $args = array(
        'post_type' => 'promotions',
        'posts_per_page' => 4,
        'paged' => $paged,
    );

    if (!empty($selected_category)) {
        $args['category_name'] = $selected_category;
    }

    $promotion_query = new WP_Query($args);

    if ($promotion_query->have_posts()) {
        while ($promotion_query->have_posts()):
            $promotion_query->the_post(); ?>
            <div class="col-lg-3 col-md-4 col-sm-6">
                <div class="blog-box">
                    <a href="<?php the_permalink(); ?>">
                        <?php if (has_post_thumbnail()) {
                            the_post_thumbnail('full', array('class' => 'main-img w-100'));
                        } ?>
                        <h3> <?php the_title(); ?></h3>
                    </a>
                </div>
            </div>
        <?php endwhile;
    } else {
        echo 'No more promotions found.';
    }

    wp_reset_postdata();
    wp_die();
}
add_action('wp_ajax_load_more_promotions', 'load_more_promotions');
add_action('wp_ajax_nopriv_load_more_promotions', 'load_more_promotions');


// Event  end -------------------------------------------------------



// woocommerce

// user dashboard start ----------------------------------------------------------
// Remove Wishlist and Downloads from My Account menu

function remove_my_account_links($menu_links)
{
    unset($menu_links['wishlist']); // remove wishlist
    unset($menu_links['downloads']); // remove downloads
    return $menu_links;
}
add_filter('woocommerce_account_menu_items', 'remove_my_account_links');

// user dashboard end ------------------------------------------------------------


// product-categories start ----------------------------------------- 
function wpb_woocommerce_product_categories_accordion()
{
    // Get the current queried product category
    $queried_object = get_queried_object();
    $current_category_id = ($queried_object && isset($queried_object->term_id)) ? $queried_object->term_id : 0;

    // Get all parent categories of the current category
    $current_category_parents = [];
    if ($current_category_id) {
        $parent_categories = get_ancestors($current_category_id, 'product_cat');
        $current_category_parents = array_map('intval', $parent_categories);
    }

    // Recursive function to get subcategories with checkboxes
    function get_subcategories($parent_id, $level = 1, $current_category_id, $current_category_parents)
    {
        $args = array(
            'taxonomy' => 'product_cat',
            'orderby' => 'name',
            'order' => 'ASC',
            'parent' => $parent_id,
            'hide_empty' => true
        );
        $sub_categories = get_terms($args);

        if (!empty($sub_categories)) {
            echo '<ul class="list-unstyled ps-2">';
            foreach ($sub_categories as $sub_category) {
                $is_checked = ($sub_category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($sub_category->term_id == $current_category_id) ? 'current-category' : '';

                echo '<li class="' . $active_class . '">';
                echo '<div class="in-menu">';
                echo '<input type="checkbox" class="category-checkbox me-2" data-category-id="' . $sub_category->term_id . '" ' . $is_checked . '> ';

                echo '<a href="' . get_term_link($sub_category) . '">  <span class="customcheck"></span>' . $sub_category->name . '</a>';
                echo '</div>';
                get_subcategories($sub_category->term_id, $level + 1, $current_category_id, $current_category_parents);
                echo '</li>';
            }
            echo '</ul>';
        }
    }

    // Get main product categories (parent categories)
    $args = array(
        'taxonomy' => 'product_cat',
        'orderby' => 'name',
        'order' => 'ASC',
        'parent' => 0,
        'hide_empty' => true
    );
    $product_categories = get_terms($args);

    if ($product_categories) {
        ob_start();
        ?>
        <div class="accordion" id="productCategoriesAccordion">

            <?php
            $shop_page_url = wc_get_page_permalink('shop');
            $is_shop_page = is_shop();
            ?>

            <div class="accordion-item">
                <div class="accordion-header <?php echo $is_shop_page ? 'current-category' : ''; ?>">
                    <label>
                        <a href="<?php echo esc_url($shop_page_url); ?>" class="main-category">
                            All Product
                        </a>
                    </label>
                </div>
            </div>


            <?php
            $i = 0;
            foreach ($product_categories as $category) {
                $i++;

                // Check if the category has subcategories
                $sub_args = array(
                    'taxonomy' => 'product_cat',
                    'parent' => $category->term_id,
                    'hide_empty' => true
                );
                $sub_categories = get_terms($sub_args);
                $has_subcategories = !empty($sub_categories);

                // Determine if this category should be expanded
                $is_checked = ($category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'current-category' : '';
                $show_collapse = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'show' : '';
            ?>
                <div class="accordion-item <?php echo $active_class; ?>">
                    <div class="accordion-header d-flex align-items-center" id="heading<?php echo $i; ?>">
                        <label for="cat<?php echo $category->term_id; ?>">
                            <input type="checkbox" class="category-checkbox me-2" id="cat<?php echo $category->term_id; ?>"
                                data-category-id="<?php echo $category->term_id; ?>" <?php echo $is_checked; ?>>

                            <a href="<?php echo get_term_link($category); ?>" class="main-category">
                                <span class="customcheck"></span> <?php echo $category->name; ?>
                            </a>
                        </label>

                        <?php if ($has_subcategories) { ?>
                            <button class="accordion-button ms-auto <?php echo ($show_collapse == '') ? 'collapsed' : ''; ?>"
                                type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>"
                                aria-expanded="<?php echo ($show_collapse) ? 'true' : 'false'; ?>"
                                aria-controls="collapse<?php echo $i; ?>" data-category-id="<?php echo $category->term_id; ?>">
                                <i class="fa fa-angle-down"></i>
                            </button>
                        <?php } ?>
                    </div>
                    <?php if ($has_subcategories) { ?>
                        <div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse <?php echo $show_collapse; ?>"
                            aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#productCategoriesAccordion">
                            <div class="accordion-body ps-0 pe-0">
                                <?php get_subcategories($category->term_id, 1, $current_category_id, $current_category_parents); ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            <?php
            }
            ?>
        </div>

        <script>
            document.addEventListener("DOMContentLoaded", function() {
                var savedCategories = JSON.parse(localStorage.getItem("checkedCategories")) || [];

                savedCategories.forEach(function(categoryId) {
                    var checkbox = document.querySelector('.category-checkbox[data-category-id="' + categoryId + '"]');
                    if (checkbox) {
                        checkbox.checked = true;
                    }
                });

                document.querySelectorAll(".category-checkbox").forEach(function(checkbox) {
                    checkbox.addEventListener("change", function() {
                        var categoryId = this.getAttribute("data-category-id");
                        if (this.checked) {
                            if (!savedCategories.includes(categoryId)) {
                                savedCategories.push(categoryId);
                            }
                        } else {
                            savedCategories = savedCategories.filter(id => id !== categoryId);
                        }
                        localStorage.setItem("checkedCategories", JSON.stringify(savedCategories));
                    });
                });

                var activeCategory = localStorage.getItem("activeCategory");
                if (activeCategory) {
                    var activeAccordion = document.querySelector('[data-category-id="' + activeCategory + '"]');
                    if (activeAccordion) {
                        var collapseElement = activeAccordion.getAttribute("data-bs-target");
                        document.querySelector(collapseElement).classList.add("show");
                        activeAccordion.classList.remove("collapsed");
                        activeAccordion.setAttribute("aria-expanded", "true");
                    }
                }

                document.querySelectorAll(".accordion-button").forEach(function(button) {
                    button.addEventListener("click", function() {
                        var categoryId = this.getAttribute("data-category-id");
                        if (document.querySelector(this.getAttribute("data-bs-target")).classList.contains("show")) {
                            localStorage.removeItem("activeCategory");
                        } else {
                            localStorage.setItem("activeCategory", categoryId);
                        }
                    });
                });
            });
        </script>

        <style>
            .current-category>a {
                font-weight: bold;
                color: #ff6600;
            }

            .category-checkbox {
                display: none;
            }

            span.customcheck {
                background: #FFFFFF 0% 0% no-repeat padding-box;
                border: 1px solid #B7DBEE;
                border-radius: 5px;
                width: 15px;
                height: 15px;
                position: relative;
                margin-right: 6px;
                margin-top: 0px;
                top: 2px;
                display: none;
            }

            .current-category [type=checkbox]:checked~a span.customcheck {
                background: #326783;
                border-color: #326783;
            }

            .current-category [type=checkbox]~a .customcheck:after {
                content: "";
                position: absolute;
            }

            .current-category a input:checked~.customcheck:after {
                display: block;
            }

            .current-category a .customcheck:after {
                left: 5px;
                top: 2px;
                width: 4px;
                height: 8px;
                border: solid white;
                border-width: 0 2px 2px 0;
                -webkit-transform: rotate(45deg);
                -ms-transform: rotate(45deg);
                transform: rotate(45deg);
            }
        </style>
<?php
        return ob_get_clean();
    }
}

add_shortcode('product_categories_accordion', 'wpb_woocommerce_product_categories_accordion');

// product category for sidebar end -------------------------------
