<?php get_header(); ?>


<?php echo do_shortcode('[hfe_template id="3320"]'); ?>

<div class="blog-detail">


    <div class="container-fluid">

        <?php
        if (have_posts()):
            while (have_posts()):
                the_post();
        ?>
                <div class="row">
                    <div class="col-lg-12  position-relative">
                        <a href="javascript:void(0);" onclick="window.history.back();" class="back-btn d-flex align-items-center">
                            <img src="https://www.jteamhairstudio.com/wp-content/uploads/2024/02/Group-90.svg" alt="" class="me-3"> Back
                        </a>
                    </div>
                </div>
                <div class="row pb-5 pt-3 px-3" id="<?php echo get_the_ID(); ?>">
                    <div class="col-lg-5 col-md-5">


                        <?php
                        // Get the post thumbnail URL
                        $thumbnails = []; // Array to hold the thumbnail images for the slider navigation

                        if (has_post_thumbnail()) {
                            $thumbnail_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
                            $thumbnails[] = [
                                'url' => $thumbnail_url,
                                'alt' => get_the_title()
                            ];
                        }

                        // Get the entire group field
                        $gallery = get_field('gallery');

                        if ($gallery || isset($thumbnail_url)) {

                            // Slider container
                            echo '<div class="gallery-slider gallery-slider-promotion">';

                            // Display the post thumbnail as the first slide if it exists
                            if (isset($thumbnail_url)) {
                        ?>
                                <div>
                                    <img src="<?php echo esc_url($thumbnail_url); ?>" alt="<?php echo esc_attr(get_the_title()); ?>"
                                        class="attachment-full size-full wp-post-image" style="width:100%;">
                                </div>
                                <?php
                            }

                            // Retrieve and display each image from the gallery
                            $images = [
                                isset($gallery['first']) ? $gallery['first'] : null,
                                isset($gallery['second']) ? $gallery['second'] : null,
                                isset($gallery['third']) ? $gallery['third'] : null,
                                isset($gallery['fourth']) ? $gallery['fourth'] : null
                            ];

                            foreach ($images as $image) {
                                if ($image && isset($image['url'])) {
                                ?>
                                    <div>
                                        <img src="<?php echo esc_url($image['url']); ?>"
                                            alt="<?php echo esc_attr($image['alt'] ? $image['alt'] : get_the_title()); ?>"
                                            class="attachment-full size-full wp-post-image" style="width:100%;">
                                    </div>
                        <?php
                                    $thumbnails[] = [
                                        'url' => $image['url'],
                                        'alt' => isset($image['alt']) ? $image['alt'] : get_the_title()
                                    ];
                                }
                            }

                            echo '</div>';
                        }
                        ?>

                        <!-- Thumbnails for navigation -->
                        <div class="custom-dots d-none">
                            <?php foreach ($thumbnails as $thumbnail): ?>
                                <div class="custom-dot">
                                    <img src="<?php echo esc_url($thumbnail['url']); ?>"
                                        alt="<?php echo esc_attr($thumbnail['alt']); ?>" style="width:100px; height:auto;">
                                </div>
                            <?php endforeach; ?>
                        </div>

                        <script type="text/javascript">
                            jQuery(document).ready(function($) {
                                $('.gallery-slider').slick({
                                    infinite: true,
                                    slidesToShow: 1,
                                    slidesToScroll: 1,
                                    arrows: true,
                                    prevArrow: '<button type="button" class="slick-prev"><svg xmlns="http://www.w3.org/2000/svg" width="25" height="16" viewBox="0 0 25 16" fill="none"><path d="M0.29215 7.2929C-0.0983734 7.68342 -0.0983734 8.31658 0.292151 8.70711L6.65611 15.0711C7.04664 15.4616 7.6798 15.4616 8.07033 15.0711C8.46085 14.6805 8.46085 14.0474 8.07033 13.6569L2.41347 8L8.07033 2.34315C8.46085 1.95262 8.46085 1.31946 8.07033 0.928934C7.6798 0.538409 7.04664 0.538409 6.65611 0.928934L0.29215 7.2929ZM24.2891 7L0.999258 7L0.999258 9L24.2891 9L24.2891 7Z" fill="#A6A6A6"></path></svg></button>',
                                    nextArrow: '<button type="button" class="slick-next ms-3"><svg xmlns="http://www.w3.org/2000/svg" width="26" height="16" viewBox="0 0 26 16" fill="none"><path d="M24.7782 8.70711C25.1687 8.31658 25.1687 7.68342 24.7782 7.29289L18.4142 0.928932C18.0237 0.538408 17.3905 0.538408 17 0.928932C16.6095 1.31946 16.6095 1.95262 17 2.34315L22.6568 8L17 13.6569C16.6095 14.0474 16.6095 14.6805 17 15.0711C17.3905 15.4616 18.0237 15.4616 18.4142 15.0711L24.7782 8.70711ZM0.78125 9L24.0711 9V7L0.78125 7L0.78125 9Z" fill="#A6A6A6"></path></svg></button>',
                                    dots: false,
                                    customPaging: function(slider, i) {
                                        var thumb = $('.custom-dot img').eq(i).attr('src');
                                        return '<img src="' + thumb + '" class="slick-thumb">';
                                    },
                                    autoplay: true,
                                    autoplaySpeed: 2000,
                                });

                                // Synchronize custom thumbnail clicks with the slider
                                $('.custom-dot').on('click', function() {
                                    var index = $(this).index();
                                    $('.gallery-slider').slick('slickGoTo', index);
                                });
                            });
                        </script>




                        <!-- Carousel -->
                        <!-- <div id="demo" class="carousel slide" data-bs-ride="carousel">
                        
                            <div class="carousel-inner">
                                <div class="carousel-item active">
                                    <img src="https://www.jteamhairstudio.com/wp-content/uploads/2024/01/WhatsApp-Image-2024-05-15-at-09.47.08.jpeg"
                                        class="d-block w-100">
                                </div>
                                <div class="carousel-item">
                                    <img src="https://www.jteamhairstudio.com/wp-content/uploads/2024/01/WhatsApp-Image-2024-05-15-at-09.47.08.jpeg"
                                        class="d-block w-100">
                                </div>
                                <div class="carousel-item">
                                    <img src="https://www.jteamhairstudio.com/wp-content/uploads/2024/01/WhatsApp-Image-2024-05-15-at-09.47.08.jpeg"
                                        class="d-block w-100">
                                </div>
                            </div>

                          
                            <div class="text-center mt-3">
                                <span data-bs-target="#demo" data-bs-slide="prev" class="me-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="25" height="16" viewBox="0 0 25 16"
                                        fill="none">
                                        <path
                                            d="M0.29215 7.2929C-0.0983734 7.68342 -0.0983734 8.31658 0.292151 8.70711L6.65611 15.0711C7.04664 15.4616 7.6798 15.4616 8.07033 15.0711C8.46085 14.6805 8.46085 14.0474 8.07033 13.6569L2.41347 8L8.07033 2.34315C8.46085 1.95262 8.46085 1.31946 8.07033 0.928934C7.6798 0.538409 7.04664 0.538409 6.65611 0.928934L0.29215 7.2929ZM24.2891 7L0.999258 7L0.999258 9L24.2891 9L24.2891 7Z"
                                            fill="#A6A6A6"></path>
                                    </svg>
                                </span>
                                <span data-bs-target="#demo" data-bs-slide="next" class="ms-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="26" height="16" viewBox="0 0 26 16"
                                        fill="none">
                                        <path
                                            d="M24.7782 8.70711C25.1687 8.31658 25.1687 7.68342 24.7782 7.29289L18.4142 0.928932C18.0237 0.538408 17.3905 0.538408 17 0.928932C16.6095 1.31946 16.6095 1.95262 17 2.34315L22.6568 8L17 13.6569C16.6095 14.0474 16.6095 14.6805 17 15.0711C17.3905 15.4616 18.0237 15.4616 18.4142 15.0711L24.7782 8.70711ZM0.78125 9L24.0711 9V7L0.78125 7L0.78125 9Z"
                                            fill="#A6A6A6"></path>
                                    </svg>
                                </span>
                            </div>
                        </div> -->
                    </div>
                    <div class="col-lg-7 col-md-7 ps-lg-3">
                        <div class="promo-details">
                            <!-- <h1 class="single-page-title"><?php the_title(); ?></h1> -->
                            <h1 class="single-page-title">About This Promotion</h1>
                            <div class="ps-lg-4">
                                <?php the_content(); ?>
                            </div>
                        </div>
                    </div>
                </div>



                <div class="row py-5">

                    <?php $terms_and_conditions = get_field('terms_and_conditions');
                    if ($terms_and_conditions): ?>
                        <div class="col-md-4">
                            <?php
                            echo '<h2 class="single-page-title">';
                            echo 'Terms & Conditions';
                            echo '</h2>';
                            ?>
                        </div>
                        <div class="col-md-8">
                            <?php
                            echo '<div class="promo-details">';
                            echo $terms_and_conditions;
                            echo '</div>';
                            ?>
                        </div>

                    <?php endif; ?>

                </div>

        <?php
            endwhile;
        else:
            echo 'No post found.';
        endif;
        ?>



        <?php
        $related_post_ids = array();


        $related_args = array(
            'posts_per_page' => 4,
            'post_type' => 'promotions',
            'post__in' => $related_post_ids,
            'post__not_in' => array(get_the_ID()),
            'orderby' => 'post__in',
        );

        $related_query = new WP_Query($related_args); ?>





        <div class="row pb-5 intrested-promo">
            <div class="col-lg-12 mb-5">
                <h1 class="single-page-title text-center">You Might Be interested in</h1>
            </div>

            <?php if ($related_query->have_posts()):
                while ($related_query->have_posts()):
                    $related_query->the_post();
            ?>

                    <div class="col-lg-3 col-md-4 col-sm-6">
                        <div class="blog-box">
                            <a href="<?php the_permalink(); ?>">

                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'w-100 main-img'));
                                } ?>

                                <h3><?php the_title(); ?></h3>
                            </a>
                        </div>
                    </div>
            <?php
                endwhile;
                wp_reset_postdata();
            else:
                echo 'No related Promotions found.';
            endif;
            ?>
        </div>
    </div>

</div>



<script>
    function goBack() {
        window.history.back();
    }
</script>

<?php get_footer(); ?>