<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'front';

$route['swi-admin'] = "admin_login/adminLoginPage";
$route[A.'-login'] = "admin_login/adminLoginPage";
$route['adminlogin'] = "admin_login/doLogin";

$route[A] = A;
$route[A.'-logout'] = A."/logout";

$route[A.'/add-admin'] = A."/addAdminPage";
$route[A.'/edit-admin/(:any)'] = A."/editAdminPage/$1";
$route[A.'/admin-authority/(:any)'] = A."/adminAuthorityPage/$1";

//category links
$route[A.'/add-category'] = A."/addCategoryPage";
$route[A.'/all-category'] = A."/categoryListPage";
$route[A.'/home-category-banner'] = A."/categoryHomeBannerPage";

$route[A.'/dollar-rate'] = A."/addDollarRatePage";

$route[A.'/web-setting'] = A."/webSettingPage";

$route[A.'/add-tag'] = A."/addTagPage";
$route[A.'/edit-tag/(:any)'] = A."/editTagPage/$1";

$route[A.'/add-news-category'] = A."/addBlogCategoryPage";
$route[A.'/edit-news-category/(:any)'] = A."/editBlogCategoryPage/$1";
$route[A.'/add-news'] = A."/addBlogPage";
$route[A.'/all-news'] = A."/allBlogList";
$route[A.'/all-news/(:any)'] = A."/allBlogList/$1";
$route[A.'/edit-news/(:any)'] = A."/editBlogPage/$1";

$route[A.'/add-events'] = A."/addEventsPage";
$route[A.'/all-events'] = A."/allEventsList";
$route[A.'/all-events/(:any)'] = A."/allEventsList/$1";
$route[A.'/edit-events/(:any)'] = A."/editEventsPage/$1";

$route[A.'/add-bclass'] = A."/addBclassPage";
$route[A.'/all-bclass'] = A."/allBclassList";
$route[A.'/all-bclass/(:any)'] = A."/allBclassList/$1";
$route[A.'/edit-bclass/(:any)'] = A."/editBclassPage/$1";

$route[A.'/add-testimonial'] = A."/addTestimonialPage";
$route[A.'/all-testimonials'] = A."/allTestimonialList";
$route[A.'/edit-testimonial/(:any)'] = A."/editTestimonialPage/$1";

$route[A.'/add-team'] = A."/addTeamPage";
$route[A.'/all-teams'] = A."/allTeamList";
$route[A.'/edit-team/(:any)'] = A."/editTeamPage/$1";

$route[A.'/add-btools'] = A."/addpartnerPage";
$route[A.'/all-btools'] = A."/allpartnerList";
$route[A.'/edit-btools/(:any)'] = A."/editpartnerPage/$1";

$route[A.'/add-credential'] = A."/addcredentialPage";
$route[A.'/all-credentials'] = A."/allcredentialList";
$route[A.'/edit-credential/(:any)'] = A."/editcredentialPage/$1";

$route[A.'/recipe-category'] = A."/addrecipeCategoryPage";
$route[A.'/edit-recipe-category/(:any)'] = A."/editrecipeCategoryPage/$1";
$route[A.'/add-recipe'] = A."/addrecipePage";
$route[A.'/all-recipe'] = A."/allrecipeList";
$route[A.'/edit-recipe/(:any)'] = A."/editrecipePage/$1";

$route[A.'/ep-category'] = A."/addEpCategoryPage";
$route[A.'/edit-ep-category/(:any)'] = A."/editEpCategoryPage/$1";
$route[A.'/add-ep'] = A."/addEpPage";
$route[A.'/all-ep'] = A."/allEpList";
$route[A.'/edit-ep/(:any)'] = A."/editEpPage/$1";

$route[A.'/faq-category'] = A."/addFaqCategoryPage";
$route[A.'/edit-faq-category/(:any)'] = A."/editFaqCategoryPage/$1";
$route[A.'/add-faq'] = A."/addfaqPage";
$route[A.'/all-faq'] = A."/allfaqList";
$route[A.'/edit-faq/(:any)'] = A."/editfaqPage/$1";

$route[A.'/gallery-category'] = A."/addGalleryCategoryPage";
$route[A.'/edit-gallery-category/(:any)'] = A."/editGalleryCategoryPage/$1";
$route[A.'/add-gallery'] = A."/addGalleryPage";
$route[A.'/all-gallery'] = A."/allGalleryList";
$route[A.'/all-gallery/(:any)'] = A."/allGalleryList/$1";
$route[A.'/all-gallery-projects'] = A."/allGalleryProjectsList";
$route[A.'/all-gallery-projects/(:any)'] = A."/allGalleryProjectsList/$1";
$route[A.'/edit-gallery/(:any)'] = A."/editGalleryPage/$1";

$route[A.'/add-service-gallery'] = A."/addServiceGalleryPage";
$route[A.'/all-service-gallery'] = A."/allServiceGalleryList";
$route[A.'/all-service-gallery/(:any)'] = A."/allServiceGalleryList/$1";
$route[A.'/edit-service-gallery/(:any)'] = A."/editServiceGalleryPage/$1";

$route[A.'/add-learning-resources'] = A."/addLRPage";
$route[A.'/all-learning-resources'] = A."/allLRList";
$route[A.'/edit-learning-resources/(:any)'] = A."/editLRPage/$1";

//product links
$route[A.'/add-product'] = A."/addProductPage";
$route[A.'/product-list'] = A."/allProductList";
$route[A.'/product-list/(:any)'] = A."/allProductList/$1";
$route[A.'/edit-product/(:any)'] = A."/editProductPage/$1";

$route[A.'/all-product-tag'] = A."/allProductTagsPage";

$route[A.'/order-gst'] = A."/calculateGstPage";

$route[A.'/coupon-list'] = A."/couponListPage";
$route[A.'/rewards-point'] = A."/rewardsPointPage";
$route[A.'/edit-rewards-point/(:any)'] = A."/editRewardsPointPage/$1";

$route[A.'/user-list'] = A."/usersListPage";

$route[A.'/user-point-history/(:any)'] = A."/userPointsHistoryPage/$1";

$route[A.'/newsletter-list'] = A."/newsletterListPage";
$route[A.'/newsletter-list/(:any)'] = A."/newsletterListPage/$1";

$route[A.'/pincode-list'] = A."/pincodeListPage";
$route[A.'/pincode-list/(:any)'] = A."/pincodeListPage/$1";

$route[A.'/Flex-image'] = A."/addFleximagePage";
$route[A.'/Left-image'] = A."/addLeftimagePage";

$route[A.'/product-notify-list'] = A."/productNotifyListPage";

$route[A.'/order-report-search'] = A."/reportSearchPage";
$route[A.'/order-report'] = A."/orderReport";

$route[A.'/order-list'] = A."/allOrderListPage";
$route[A.'/order-invoice/(:any)'] = A."/orderInvoice/$1";
$route[A.'/cancle-order-list'] = A."/cancleOrderList";

$route[A.'/add-slider-banner'] = A."/addSliderBannerPage";
$route[A.'/edit-slider/(:any)'] = A."/editSliderBannerPage/$1";

$route[A.'/below-slider-banner'] = A."/addBelowSliderBannerPage";

$route[A.'/add-brand'] = A."/addBrandPage";
$route[A.'/edit-brand/(:any)'] = A."/editBrandPage/$1";

//front

$route['articles'] = "front/ourBlogList";
$route['articles/(:any)'] = "front/ourBlogList/$1";
$route['article-detail/(:any)/(:any)'] = "front/blogDetailPage/$1/$2";

$route['events'] = "front/eventsList";
$route['events/(:any)'] = "front/eventsList/$1";
$route['event-detail/(:any)/(:any)'] = "front/eventDetailPage/$1/$2";

$route['category-list/(:any)/(:any)'] = "front/getCategoryListPage/$1/$2";
$route['category-list/(:any)/(:any)/(:any)'] = "front/getSubCategoryListPage/$1/$2/$3";

$route['all-brands'] = "front/brandPage";

// $route['products'] = "front/getAllProducts";
$route['products'] = "front/eproductsPage";
$route['products/(:any)'] = "front/eproductsPage/$1";
$route['product-enquire'] = "front/eproductsEnquiryPage";
$route['product-detail/(:any)/(:any)'] = "front/eproductDetailPage/$1/$2";

$route['shop'] = "front/shopPage";
$route['shop/(:any)'] = "front/shopPage/$1";
$route['shop/(:any)/(:any)'] = "front/shopPage/$1/$2";
$route['shop-detail/(:any)/(:any)'] = "front/productDetailPage/$1/$2";
$route['product-iframe/(:any)/(:any)'] = "front/productIframePage/$1/$2";

$route['shopping-cart'] = "checkout/shoppingCartPage";
$route['checkout'] = "checkout/userCheckoutPage";
$route['thank-you'] = "checkout/thankYouPage";

$route['about-us'] = "front/aboutUsPage";
$route['award'] = "front/awardPage";
$route['contact-us'] = "front/contactUsPage";
$route['contact'] = "front/contactUsPage";
$route['recipes'] = "front/recipesPage";
$route['recipe-detail/(:any)/(:any)'] = "front/recipeDetailPage/$1/$2";
$route['testimonial'] = "front/testimonialPage";
$route['testimonial/(:any)'] = "front/testimonialPage/$1";
$route['services'] = "front/servicesPage";
$route['service/(:any)/(:any)'] = "front/serviceGalleryPage/$1/$2";
$route['service-baking-class'] = "front/serviceBakingClassPage";
$route['class-detail/(:any)/(:any)'] = "front/serviceBakingClassDetailPage/$1/$2";

$route['privacy-policy'] = "front/privacyPolicyPage";

$route['wishlist'] = "front/wishlistPage";

$route['our-programmes'] = "front/ourBlogList";
$route['programmes-detail/(:any)/(:any)'] = "front/blogDetailPage/$1/$2";

$route['portfolio'] = "front/prPage";
$route['portfolio/(:any)'] = "front/prPage/$1";
$route['portfolio-detail/(:any)/(:any)'] = "front/galleryDetailPage/$1/$2";

$route['privacy-policy'] = "front/privacyPolicyPage";
$route['refund-policy'] = "front/refundPolicyPage";
$route['terms-and-conditions'] = "front/termConditionPage";
$route['payment'] = "front/paymentPage";
$route['track-order'] = "front/trackOrderPage";
$route['trackorder'] = "front/trackPage";
$route['track-order-action'] = "front/trackOrderAction";

$route['search-product'] = "front/directSearchProduct";
$route['search-product-auto'] = "front/searchProductAuto";


$route['my-favourites'] = "front/userfavouritesPage";
$route['my-favourites/(:any)'] = "front/userfavouritesPage/$1";

$route['registration-thank-you'] = "front/registrationThankyouPage";


/** User **/

$route['user-login'] = "user_login/loginPage";
$route['user-registration'] = "user_login/registrationPage";
$route['user-verify-email'] = "user_login/verifyAccountPage";
$route['user-verify'] = "profile/verifyPage";
$route['dashboard'] = "profile/userDashboardPage";
$route['points-history'] = "profile/pointsHistoryPage";
$route['points-history/(:any)'] = "profile/pointsHistoryPage/$1";
$route['fast-track'] = "profile/fastTrackPage";
$route['user-profile'] = "profile/userProfilePage";
$route['user-edit-profile'] = "profile/userEditProfilePage";

$route['add-address'] = "profile/addAddressPage";
$route['edit-address/(:any)'] = "profile/editAddressPage/$1";

$route['add-shipping-address'] = "profile/userShippingAddressPage";
$route['user-change-password'] = "profile/userChangePasswordPage";

$route['all-orders'] = "profile/allOrdersPage";
$route['user-order-detail/(:any)'] = "profile/orderCartDetailPage/$1";

$route['user-rewards'] = "profile/userRewardsPage";
$route['user-point-history'] = "profile/userPointsHistoryPage";

$route['forgot-password'] = "user_login/forgetPasswordPage";

$route['unsubscribeNewsletter'] = "front/unsubscribeNewsletterNow";

/** User **/

$route['logout'] = "front/logout";



$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;
