<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class MY_Controller extends CI_Controller

{

	function __construct()

	{

		parent::__construct();

		$this->load->model('common_model','common');

		$this->config->load('custom');

		$this->load->library('cart');
		$this->load->helper('cart_helper');

		$this->load->library('wishlist');

		$this->lang->load('user');

		$this->load->library('email');

		$this->load->library('image_lib');

		$this->load->library('pagination');
		$this->load->helper('image');
		
		$segment = $this->uri->segment(1);

		

		/* Protact User to come back after logout code START */

		$segment = $this->uri->segment(1);

		$seg_array = array("product-detail");

		$this->output->set_header('Last-Modified:'.gmdate('D, d M Y H:i:s').'GMT');

		$this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate');

		if(!in_array($segment, $seg_array)){

			$this->output->set_header('Cache-Control: post-check=0, pre-check=0',false);

		}else{

			$this->output->set_header('Cache-Control: post-check=0, pre-check=0');

		}

		$this->output->set_header('Pragma: no-cache');

		$this->dollar = ($this->session->userdata('currency')=="USD")?'USD':'INR';

		$this->content = $this->common->getsData('web_setting',array('id'=>1));

		$ud1 = $this->common->getsData('user',array('profileid'=>$this->session->userdata('profileid')));
		$level = (isset($ud1['package']))?$ud1['package']:0;

		$uod = $this->db->query('select sum(grandtotal) as utotal from orders where payment_status="Complete" and profileid="'.$this->session->userdata('profileid').'"')->result_array();
		// $uod = $this->db->query('select sum(grandtotal) as utotal from orders where order_status=4 and profileid="'.$this->session->userdata('profileid').'"')->result_array();
		if(isset($uod[0]['utotal']) && $uod[0]['utotal']){
			$user_order_amount = $uod[0]['utotal'];
		}else{
			$user_order_amount = 0;
		}
		$this->user_order_amount = $user_order_amount;
		if($user_order_amount>=10000){
			$this->common->updateData('user',array('order_amount'=>$user_order_amount,'package'=>2),array('profileid'=>$this->session->userdata('profileid')));
		}else if($user_order_amount>3000 && $level<2){
			$this->common->updateData('user',array('order_amount'=>$user_order_amount,'package'=>1),array('profileid'=>$this->session->userdata('profileid')));
		}else{
			$this->common->updateData('user',array('order_amount'=>$user_order_amount),array('profileid'=>$this->session->userdata('profileid')));
		}

		$ud = $this->common->getsData('user',array('profileid'=>$this->session->userdata('profileid')));
        $this->level = (isset($ud['package']))?$ud['package']:0;
        if($this->level==0){
        	$this->shipping = 15;
        	$this->shippingCart = 50;
        	$this->coinspend = 5;
        	$this->extra_coin = 50;
        }else if($this->level==1){
        	$this->shipping = 15;
        	$this->shippingCart = 30;
        	$this->coinspend = 7;
        	$this->extra_coin = 70;
        }else{
        	$this->shipping = 15;
        	$this->shippingCart = 20;
        	$this->coinspend = 10;
        	$this->extra_coin = 100;
        }
        $this->flat_charge = 10;
        $this->shippingCart = 0;
		// $this->shipping = $this->content['shipping_charge'];
		// $this->shippingCart = $this->content['shipping_cart_amount'];

		$this->menu = $this->common->getCategories();
		// echo "<pre>";
		// print_r($this->menu); die; 

		$this->type = $this->session->userdata('type');

	}



	public function loadHtml($pagename='',$title='',$data=array())
	{

		$data['title'] = $title;

		$is_logged_in = $this->session->userdata('is_logged_in');

		if(!isset($is_logged_in) || $is_logged_in != true)

		{

			$header = 'header';

			$this->load->view($header,$data);

		}else{

			$header = 'header';

		}

		$this->load->view($pagename,$data);

		$this->load->view('footer');

	}



	public function loadAdminHtml($pagename='',$title='',$data=array())

	{

		$data['head_title'] = $title;

		$is_admin_logged_in = $this->session->userdata('is_admin_logged_in');

		if(!isset($is_admin_logged_in) || $is_admin_logged_in != true)

		{

			$header = 'admin_header';

		}else{

			$header = 'admin_header';

		}

		$this->load->view($header,$data);

		if(!isset($is_admin_logged_in) || $is_admin_logged_in != true)

		{

		}else{

			$sidebar = 'admin_sidebar';

			$this->load->view($sidebar,$data);

		}

		$this->load->view($pagename,$data);

		$this->load->view('admin_footer');

	}



} 