<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin extends MY_Admin_Controller {

	Public function __construct() { 
		parent::__construct();
		$this->is_logged_in();		
	}

	public function is_logged_in(){

		$is_admin_logged_in = $this->session->userdata('is_admin_logged_in');
		if(!isset($is_admin_logged_in) || $is_admin_logged_in != true){

			redirect(base_url(A."-login"));
		}
	}

	/*public function counter(){
		$c_data=$this->common->getData("site_visit");
        foreach ($c_data as $key => $value) {
        	$visit[]= $value['count'];
        }
        return array_sum($visit);
	}*/

	public function indexOld(){
		//$data['site_visit']=$this->counter();
		//$data['site_visitor'] = $this->admin->siteVisitorCount('site_visit');
		$data['t_order'] = $this->admin->getOrderCount('orders');
		$data['tc_order'] = $this->admin->getOrderCount('orders',array('order_status'=>5));
		$data['tp_order'] = $this->admin->getOrderCount('orders',array('order_status'=>1));
		$data['tco_order'] = $this->admin->getOrderCount('orders',array('order_status'=>4));

		$data['total_product'] = $this->admin->getTotalEntryCount('products',array(),'pid');
		$data['total_category'] = $this->admin->getTotalEntryCount('category',array('parent'=>0),'c_id');
		$data['total_user'] = $this->admin->getTotalEntryCount('user',array('user_type'=>'register_user'),'id');

		$data['porders'] = $this->admin->getOrders('','',array('order_status'=>1));
		$this->loadAdminHtml("index-old","Home Page",$data);
	}

	public function index(){
		$data['porders'] = $this->admin->getOrders('','',array('order_status'=>1));
		$this->loadAdminHtml("index","Home Page",$data);
	}

	public function webSettingPage()
    {
        $data['setting'] = $this->common->getsData('web_setting',array('id'=>1));
        $data['info'] = $this->common->getsData('admin',array('id'=>1));
        $this->loadAdminHtml('about-text','Setting',$data);
    }

    public function addAdminPage()
    {
        $data['admin'] = $this->common->getData('admin',array('admin_type'=>'subadmin'),array(),array('field'=>'id','by'=>'desc'));
        $this->loadAdminHtml('subadmin/add-admin','Add Admin',$data);
    }

    public function editAdminPage($id='')
    {
        $data['admin'] = $this->common->getsData('admin',array('id'=>$id));
        $this->loadAdminHtml('subadmin/edit-admin','Add Admin',$data);
    }

    public function adminAuthorityPage($id='')
    {
        $data['admin'] = $this->common->getsData('admin',array('id'=>$id));
        $this->loadAdminHtml('subadmin/admin-authority','Admin Authority',$data);
    }

	public function addGalleryCategoryPage()
    {
        $data['cat'] = $this->common->getData('gallery_category',array(),array(),array('field'=>'item_order','by'=>'asc'));
        $this->loadAdminHtml('gallery/add-category','Add Gallery Category',$data);
    }

    public function editGalleryCategoryPage($id='')
    {
        $data['cat'] = $this->common->getsData('gallery_category',array('id'=>$id));
        $this->loadAdminHtml('gallery/edit-category','Edit  Gallery Category',$data);
    }

	public function addGalleryPage()
    {
    	$data['category'] = $this->common->getData('gallery_category',array(),array(),array('field'=>'item_order','by'=>'asc'));
        $this->loadAdminHtml('gallery/add-gallery','Add gallery',$data);
    }

    public function allGalleryProjectsList($limit='')
    {
    	$get=array();
        if (isset($_GET)) {
            $get = $_GET;
        }
        if($limit!="")
        {
            $get['limit'] = $limit;            
        }
        $get['base_url'] = base_url(A.'/all-gallery-projects');
        $data = $this->admin->getGalleryProjectsListWithPag($get);
        $data['k'] = ($limit!="")?$limit+1:1;
        $this->loadAdminHtml('gallery/all-projects','All Gallery Projects',$data);
    }

    public function allGalleryList($limit='')
    {
        $get=array();
        if (isset($_GET)) {
            $get = $_GET;
        }
        if($limit!="")
        {
            $get['limit'] = $limit;            
        }
        $get['base_url'] = base_url(A.'/all-gallery');
        $data = $this->admin->getGalleryListWithPag($get);
        $data['k'] = ($limit!="")?$limit+1:1;
        $this->loadAdminHtml('gallery/all-gallery','All Gallery Images',$data);
    }

    public function editGalleryPage($projectid='')
    {
    	$data['category'] = $this->common->getData('gallery_category',array(),array(),array('field'=>'item_order','by'=>'asc'));
        $data['post'] = $this->common->getsData('gallery_project',array('projectid'=>$projectid));
        $this->loadAdminHtml('gallery/edit-gallery','Edit gallery',$data);
    }

	public function addServiceGalleryPage()
    {
    	$data['category'] = $this->common->getData('service_category',array('parent'=>0),array(),array('field'=>'item_order','by'=>'asc'));
        $this->loadAdminHtml('service/add','Add service gallery',$data);
    }

    public function allServiceGalleryList($limit='')
    {
        $get=array();
        if (isset($_GET)) {
            $get = $_GET;
        }
        if($limit!="")
        {
            $get['limit'] = $limit;            
        }
        $get['base_url'] = base_url(A.'/all-service-gallery');
        $data = $this->admin->getServiceGalleryListWithPag($get);
        $data['k'] = ($limit!="")?$limit+1:1;
        $this->loadAdminHtml('service/all','All service Gallery Images',$data);
    }

    public function editServiceGalleryPage($id='')
    {
    	$data['category'] = $this->common->getData('service_category',array('parent'=>0),array(),array('field'=>'item_order','by'=>'asc'));
        $data['post'] = $this->common->getsData('service_gallery',array('id'=>$id));
        $this->loadAdminHtml('service/edit','Edit service gallery',$data);
    }

	public function addLRPage()
    {
        $this->loadAdminHtml('lr/add','Add Learning Resource');
    }

    public function allLRList()
    {
        $data['post'] = $this->common->getData('lresource',array(),array(),array('field'=>'item_order','by'=>'asc'));
        $this->loadAdminHtml('lr/all','All Learning Resources',$data);
    }

    public function editLRPage($id='')
    {
        $data['post'] = $this->common->getsData('lresource',array('id'=>$id));
        $this->loadAdminHtml('lr/edit','Edit Learning Resource',$data);
    }

    public function addpartnerPage()
    {
        $this->loadAdminHtml('partner/add','Add Tool');
    }

    public function allpartnerList()
    {
        $data['post'] = $this->common->getData('partners',array(),array(),array('field'=>'item_order','by'=>'asc'));
        $this->loadAdminHtml('partner/all','All Tools',$data);
    }

    public function editpartnerPage($id='')
    {
        $data['post'] = $this->common->getsData('partners',array('id'=>$id));
        $this->loadAdminHtml('partner/edit','Edit Tool',$data);
    }

    public function addcredentialPage()
    {
        $this->loadAdminHtml('credential/add','Add Credential');
    }

    public function allcredentialList()
    {
        $data['post'] = $this->common->getData('credentials',array(),array(),array('field'=>'item_order','by'=>'asc'));
        $this->loadAdminHtml('credential/all','All Credentials',$data);
    }

    public function editcredentialPage($id='')
    {
        $data['post'] = $this->common->getsData('credentials',array('id'=>$id));
        $this->loadAdminHtml('credential/edit','Edit Credential',$data);
    }

	public function addTestimonialPage()
    {
        $this->loadAdminHtml('testimonial/add','Add Review');
    }

    public function allTestimonialList()
    {
        $data['post'] = $this->common->getData('testimonial',array(),array(),array('field'=>'item_order','by'=>'asc'));
        $this->loadAdminHtml('testimonial/all','All Reviews',$data);
    }

    public function editTestimonialPage($id='')
    {
        $data['post'] = $this->common->getsData('testimonial',array('id'=>$id));
        $this->loadAdminHtml('testimonial/edit','Edit Review',$data);
    }

	public function addTeamPage()
    {
        $this->loadAdminHtml('team/add','Add Team');
    }

    public function allTeamList()
    {
        $data['post'] = $this->common->getData('team',array(),array(),array('field'=>'item_order','by'=>'asc'));
        $this->loadAdminHtml('team/all','All Teams',$data);
    }

    public function editTeamPage($id='')
    {
        $data['post'] = $this->common->getsData('team',array('id'=>$id));
        $this->loadAdminHtml('team/edit','Edit Team',$data);
    }

	public function addrecipeCategoryPage()
    {
        $data['cat'] = $this->common->getData('recipe_category',array(),array(),array('field'=>'item_order','by'=>'asc'));
        $this->loadAdminHtml('recipe/add-category','Add recipe Category',$data);
    }

    public function editrecipeCategoryPage($id='')
    {
        $data['cat'] = $this->common->getsData('recipe_category',array('id'=>$id));
        $this->loadAdminHtml('recipe/edit-category','Edit  recipe Category',$data);
    }

	public function addrecipePage()
    {
    	$data['category'] = $this->common->getData('recipe_category',array(),array(),array('field'=>'item_order','by'=>'asc'));
        $this->loadAdminHtml('recipe/add','Add recipe',$data);
    }

    public function allrecipeList()
    {
        $data['post'] = $this->common->getData('recipe',array(),array(),array('field'=>'item_order','by'=>'asc'));
        $this->loadAdminHtml('recipe/all','All recipe',$data);
    }

    public function editrecipePage($id='')
    {
    	$data['category'] = $this->common->getData('recipe_category',array(),array(),array('field'=>'item_order','by'=>'asc'));
        $data['post'] = $this->common->getsData('recipe',array('id'=>$id));
        $this->loadAdminHtml('recipe/edit','Edit recipe',$data);
    }

    public function addEpCategoryPage()
    {
        $data['cat'] = $this->common->getData('ep_category',array(),array(),array('field'=>'item_order','by'=>'asc'));
        $this->loadAdminHtml('ep/add-category','Add ep Category',$data);
    }

    public function editEpCategoryPage($id='')
    {
        $data['cat'] = $this->common->getsData('ep_category',array('id'=>$id));
        $this->loadAdminHtml('ep/edit-category','Edit  ep Category',$data);
    }

    public function addEpPage()
    {
        $data['category'] = $this->common->getData('ep_category',array(),array(),array('field'=>'item_order','by'=>'asc'));
        $this->loadAdminHtml('ep/add','Add ep',$data);
    }

    public function allEpList()
    {
        $data['post'] = $this->common->getData('eproduct',array(),array(),array('field'=>'item_order','by'=>'asc'));
        $this->loadAdminHtml('ep/all','All ep',$data);
    }

    public function editEpPage($id='')
    {
        $data['category'] = $this->common->getData('ep_category',array(),array(),array('field'=>'item_order','by'=>'asc'));
        $data['post'] = $this->common->getsData('eproduct',array('id'=>$id));
        $this->loadAdminHtml('ep/edit','Edit ep',$data);
    }

    public function addFaqCategoryPage()
    {
        $data['cat'] = $this->common->getData('faq_category',array(),array(),array('field'=>'item_order','by'=>'asc'));
        $this->loadAdminHtml('faq/add-category','Add FAQ Category',$data);
    }

    public function editFaqCategoryPage($id='')
    {
        $data['cat'] = $this->common->getsData('faq_category',array('id'=>$id));
        $this->loadAdminHtml('faq/edit-category','Edit  FAQ Category',$data);
    }

    public function addfaqPage()
    {
        $data['category'] = $this->common->getData('faq_category',array(),array(),array('field'=>'item_order','by'=>'asc'));
        $this->loadAdminHtml('faq/add','Add FAQ',$data);
    }

    public function allfaqList()
    {
        $data['post'] = $this->common->getData('faq',array(),array(),array('field'=>'item_order','by'=>'asc'));
        $this->loadAdminHtml('faq/all','All FAQ',$data);
    }

    public function editfaqPage($id='')
    {
        $data['category'] = $this->common->getData('faq_category',array(),array(),array('field'=>'item_order','by'=>'asc'));
        $data['post'] = $this->common->getsData('faq',array('id'=>$id));
        $this->loadAdminHtml('faq/edit','Edit FAQ',$data);
    }

	public function addBrandPage()
    {
        $data['brand'] = $this->common->getData('brand',array(),array(),array('field'=>'id','by'=>'desc'));
        $this->loadAdminHtml('add-brand','Add Brand',$data);
    }

    public function editBrandPage($id='')
    {
        $data['brand'] = $this->common->getsData('brand',array('id'=>$id));
        $this->loadAdminHtml('edit-brand','Edit Brand',$data);
    }

	public function addReview()
	{
		$this->db->from('products');
		$query = $this->db->get();
		$data['products'] = $query->result_array();
		$this->loadAdminHtml("add-review", "Add Review", $data);
	}

	public function reviewList()
	{
	 	$data['ratings'] = $this->common->getData('prodcut_rating');
	 	$data['products'] = $this->common->getData('products');
		$this->loadAdminHtml('review-list', "All Reviews", $data);
	}

	public function addTagPage()
    {
        $data['cat'] = $this->common->getData('tag',array(),array(),array('field'=>'id','by'=>'desc'));
        $this->loadAdminHtml('add-tag','Add Product Tag',$data);
    }

    public function editTagPage($id='')
    {
        $data['cat'] = $this->common->getsData('tag',array('id'=>$id));
        $this->loadAdminHtml('edit-tag','Edit Product Tag',$data);
    }

	public function addBlogCategoryPage()
    {
        $data['cat'] = $this->common->getData('blog_category',array(),array(),array('field'=>'id','by'=>'desc'));
        $this->loadAdminHtml('blog/add-category','Add Category',$data);
    }

    public function editBlogCategoryPage($id='')
    {
        $data['cat'] = $this->common->getsData('blog_category',array('id'=>$id));
        $this->loadAdminHtml('blog/edit-category','Edit Category',$data);
    }

	public function addBlogPage()
    {
    	$data['cat'] = $this->common->getData('blog_category',array(),array(),array('field'=>'id','by'=>'desc'));
        $this->loadAdminHtml('blog/add-blog','Add news',$data);
    }

    public function allBlogList($limit='')
    {
        $get=array();
        if (isset($_GET)) {
            $get = $_GET;
        }
        if($limit!="")
        {
            $get['limit'] = $limit;            
        }
        $get['base_url'] = base_url(A.'/all-news');
        $data = $this->admin->getBlogListWithPag($get);
        $data['k'] = ($limit!="")?$limit+1:1;
        $this->loadAdminHtml('blog/all-blog','All news',$data);
    }

    public function editBlogPage($blogid='')
    {
    	$data['cat'] = $this->common->getData('blog_category',array(),array(),array('field'=>'id','by'=>'desc'));
        $data['post'] = $this->common->getsData('post',array('id'=>$blogid));
        $this->loadAdminHtml('blog/edit-blog','Edit news',$data);
    }

    public function addEventsPage()
    {
        $this->loadAdminHtml('event/add-blog','Add Event');
    }

    public function allEventsList($limit='')
    {
        $get=array();
        if (isset($_GET)) {
            $get = $_GET;
        }
        if($limit!="")
        {
            $get['limit'] = $limit;            
        }
        $get['type'] = 1;
        $get['base_url'] = base_url(A.'/all-events');
        $data = $this->admin->getBlogListWithPag($get);
        $data['k'] = ($limit!="")?$limit+1:1;
        $this->loadAdminHtml('event/all-blog','All Events',$data);
    }

    public function editEventsPage($blogid='')
    {
        $data['post'] = $this->common->getsData('post',array('id'=>$blogid));
        $this->loadAdminHtml('event/edit-blog','Edit Event',$data);
    }

    public function addBclassPage()
    {
        $this->loadAdminHtml('bclass/add-blog','Add Baking Class');
    }

    public function allBclassList($limit='')
    {
        $get=array();
        if (isset($_GET)) {
            $get = $_GET;
        }
        if($limit!="")
        {
            $get['limit'] = $limit;            
        }
        $get['type'] = 2;
        $get['base_url'] = base_url(A.'/all-bclass');
        $data = $this->admin->getBlogListWithPag($get);
        $data['k'] = ($limit!="")?$limit+1:1;
        $this->loadAdminHtml('bclass/all-blog','All Baking Classes',$data);
    }

    public function editBclassPage($blogid='')
    {
        $data['post'] = $this->common->getsData('post',array('id'=>$blogid));
        $this->loadAdminHtml('bclass/edit-blog','Edit Baking Class',$data);
    }

	public function addCategoryPage()
	{
		$data['category'] = $this->admin->getCategories();
		$this->loadAdminHtml("add-category","Add Category",$data);
	}

	public function categoryListPage()
	{
		$data['allcategory'] = $this->admin->getCategories();
		$this->loadAdminHtml('category-list','All Category List',$data);
	}

	public function categoryHomeBannerPage()
	{	
		$data['category'] = $this->common->getData('category');
		$data['cathomebanner'] = $this->common->getData("home_cat_banner",array(),array(),array('field'=>'id','by'=>'desc'));
		$this->loadAdminHtml('home-cat-banner','Add Banner',$data);
	}

	public function addDollarRatePage()
	{
		$data['dollar'] = $this->common->getsData('dollarprice',array('id'=>1));
		$this->loadAdminHtml("dollar-price","Add Dollar Price",$data);
	}

	public function addProductPage()
	{
		$data['category'] = $this->admin->getCategories();
		$this->loadAdminHtml('add-product','Add Product',$data);
	}

	public function allProductList($limit='')
	{
		$get=array();
        if (isset($_GET)) {
            $get = $_GET;
        }
        if($limit!="")
        {
            $get['limit'] = $limit;            
        }
        $get['base_url'] = base_url(A.'/product-list');

		$where = array("P.type"=>"0");
		$data = $this->admin->getProductsWithpag($where,$get);
		// echo $this->db->last_query();
		// echo "<pre>";
		// print_r($data); die;
		$data['k'] = ($limit!="")?$limit+1:1;
		$data['category'] = $this->common->getData("category",array(),array("c_id","category"));
		$data['allcategory'] = $this->admin->getCategories();
		$this->loadAdminHtml('product-list','All Products',$data);
	}


	public function editProductPage($productid='')
	{	
		$data['category'] = $this->admin->getCategories();
		$data['product'] = $this->common->getsData("products",array("productid"=>$productid));
		$this->loadAdminHtml('edit-product','Edit Product',$data);
	}


	public function allProductTagsPage()
	{	
		$data['tag']=$this->admin->getProductTags();
		$this->loadAdminHtml('all-product-tag','All Product Tags',$data);
	}


	public function couponListPage()
	{
		$data['coupon'] = $this->common->getData('coupon',array('profileid'=>$this->adminid),array(),array('field'=>'id','by'=>'desc'));
		$this->loadAdminHtml('coupon','Coupon List',$data);
	}


	public function rewardsPointPage()
	{
		$data['list'] = $this->common->getData('reward_point',array(),array(),array('field'=>'id','by'=>'desc'));
		$this->loadAdminHtml('reward-point','Reward Points List',$data);
	}

	public function editRewardsPointPage($id='')
	{
		$data['point'] = $this->common->getsData('reward_point',array('id'=>$id));
		$this->loadAdminHtml('edit-reward-point','Edit Reward Points',$data);
	}

	public function addSliderBannerPage()
	{	
		$data['slider'] = $this->common->getData("slider",array('type!='=>'catbanner'),array(),array('field'=>'id','by'=>'desc'));
		$this->loadAdminHtml('slider','Add Banner',$data);
	}

	public function editSliderBannerPage($sid='')
	{	
		$data['post'] = $this->common->getsData("slider",array('id'=>$sid));
		$this->loadAdminHtml('edit-slider','Edit Banner',$data);
	}
	public function addFleximagePage()
	{	
		$data['flex'] = $this->common->getData("flex_image");
		$this->loadAdminHtml('flex-image','Add Flex',$data);
	}
	public function addLeftimagePage()
	{	
		$data['left'] = $this->common->getData("left_image");
		$this->loadAdminHtml('Left-image','Add Left Image',$data);
	}

	public function addBelowSliderBannerPage()
	{	
		$data['slider'] = $this->common->getData("slider",array('type'=>'catbanner'),array(),array('field'=>'id','by'=>'desc'));
		$data['category'] = $this->common->getData("category");
		$this->loadAdminHtml('below-sliderbanner','Add Banner',$data);
	}

	public function allOrderListPage()
	{
		$data['orders'] = $this->admin->getOrders();
		$this->loadAdminHtml('all-order-list','All Orders',$data);
	}

	public function orderInvoice($orderid='')
	{
		$data['invoice'] = $this->admin->getOrders($orderid,1);
		
		$data['order_status'] = $this->common->getData("order_status",array(),array(),array("field"=>"ob","by"=>"asc"));
		$data['cart'] = $this->common->getData("cart_mapping",array("orderid"=>$data['invoice']['orderid']),array(),array(),array("field"=>"cmid","by"=>"asc"));
		//$data['cancle_orders'] = $this->admin->getCancleOrder(array("O.orderid"=>$orderid));
		$this->loadAdminHtml('order-invoice','Orders Invoice',$data);
	}

	public function calculateGstPage()
	{	
		$where = array();
		if(isset($_GET['date']) && $_GET['date']!=''){
			$where['date'] = $_GET['date'];
		}
		if(isset($_GET['category']) && $_GET['category']!=''){
			$where['category'] = $_GET['category'];
		}
		if(!empty($where)){
			$data['gst'] = $this->admin->calculateGst($where);
			// echo "<pre>";
			// echo $this->db->last_query();
			// print_r($data);die;
		}
		$data['category'] = $this->common->getData('category');
		$this->loadAdminHtml('gst','Calculate Gst',$data);
	}

	public function cancleOrderList()
	{
		$data['orders'] = $this->admin->getCancleOrder();
		$this->loadAdminHtml('cancle-order-list','Cancle Orders',$data);
	}

	public function usersListPageOld()
    {
    	if(isset($_GET['used_referral']) && $_GET['used_referral']!=''){
    		$data['users'] = $this->common->getData("user",array('user_type'=>'register_user','used_referal'=>$_GET['used_referral']),array(),array('field'=>'id','by'=>'desc'));
    	}else{
    		$data['users'] = $this->common->getData("user",array('user_type'=>'register_user'),array(),array('field'=>'id','by'=>'desc'));
    	}
    	$this->loadAdminHtml('users-list','All Users List',$data);
    }

	public function usersListPage()
    {
    	$query = 'select * from user as U where U.user_type="register_user" ';
    	if(isset($_GET['used_referral']) && $_GET['used_referral']!=''){
    		$query .= ' and U.used_referal="'.$_GET['used_referral'].'"';
    	}
    	if(isset($_GET['name']) && $_GET['name']!=''){
    		$query .= ' and U.name like "%'.$_GET['name'].'%"';
    	}
    	if(isset($_GET['email']) && $_GET['email']!=''){
    		$query .= ' and U.email = "'.$_GET['email'].'"';
    	}
    	if(isset($_GET['mobile_no']) && $_GET['mobile_no']!=''){
    		$query .= ' and U.mobile_no = "'.$_GET['mobile_no'].'"';
    	}
    	if(isset($_GET['level']) && $_GET['level']==1){
    		$query .= ' and U.total_point <= 300 ';
    	}
    	if(isset($_GET['level']) && $_GET['level']==2){
    		$query .= ' and (U.total_point > 300 && U.total_point <= 500) ';
    	}
    	if(isset($_GET['level']) && $_GET['level']==3){
    		$query .= ' and (U.total_point > 500) ';
    	}
    	$query .= ' order by U.id desc';
    	$data['users'] = $this->db->query($query)->result_array();
    	$this->loadAdminHtml('users-list','All Users List',$data);
    }

    public function userPointsHistoryPage($pid='')
    {
        $data['user'] = $this->common->getsData("user",array("profileid"=>$pid));
        $data['history'] = $this->common->getData("point_history",array("profileid"=>$pid),array(),array('field'=>'id','by'=>'desc'));
        $this->loadAdminHtml("user-point-history","Point History",$data);
    }

    public function userdetail()
    {
    	$data['profile'] = $this->common->getsData("user",array('profileid'=>$_GET['userid']));
    	$this->loadAdminHtml('user-detail','User Detail',$data);
    }

	public function newsletterListPage($limit='')
    {
    	$get=array();
        if (isset($_GET)) {
            $get = $_GET;
        }
        if($limit!="")
        {
            $get['limit'] = $limit;            
        }
        $get['base_url'] = base_url(A.'/newsletter-list');

		$where = array();
		$data = $this->admin->getNewsletterUserWithPag($where,$get);
		$data['k'] = ($limit!="")?$limit+1:1;
    	$this->loadAdminHtml('newsletter-user','Newsletter Users List',$data);
    }

	public function pincodeListPage($limit='')
    {
    	$get=array();
        if (isset($_GET)) {
            $get = $_GET;
        }
        if($limit!="")
        {
            $get['limit'] = $limit;            
        }
        $get['base_url'] = base_url(A.'/pincode-list');

		$where = array("P.type"=>"0");
		$data = $this->admin->getPincodeWithpag($where,$get);
		// echo $this->db->last_query();
		// echo "<pre>";
		// print_r($data); die;
		$data['k'] = ($limit!="")?$limit+1:1;
    	$this->loadAdminHtml('pincode-list','All Pincode List',$data);
    }

    public function productNotifyListPage()
    {
    	$data['users'] = $this->common->getData("product_notify");
    	$this->loadAdminHtml('product-notify-list','Product Notify Users List',$data);
    }

    public function reportSearchPage()
	{
		$data['category'] = $this->common->getData("category",array(),array("c_id","category"));
		$data['order_status'] = $this->common->getData("order_status",array(),array(),array("field"=>"ob","by"=>"asc"));
		$this->loadAdminHtml('report-search','Report Search Page',$data);
	}



	function logout(){

		$this->session->unset_userdata('email');
		$this->session->unset_userdata('adminid');
		$this->session->unset_userdata('admin_type');
		$this->session->unset_userdata('is_admin_logged_in');
		redirect(base_url(A."-login"));
	}
}
