<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Front_Model extends CI_Model
{

	public function __construct()
	{
		parent::__construct();	
	}

	public function record_count($table,$post=array()) {
		if(isset($post['fav']) && $post['fav']==1){
			$query = "SELECT COUNT(W.id) as trows FROM ".$table." as W left join products as P on P.productid=W.productid WHERE P.pid!='' and W.profileid='".$post['profileid']."' ";
		}else{
			$query = "SELECT COUNT(P.pid) as trows FROM ".$table." as P WHERE P.pid!='' ";
		}
		if(isset($post['product_category']) && $post['product_category']!=""){
			$cat = explode(",", $post['product_category']);
			if($cat){
				$query.=" and (";
				foreach ($cat as $key => $value) {
					$query.=(($key==0)?"":" or ").' P.product_category REGEXP "[[:<:]]'.$value.'[[:>:]]" ';
				}
				$query.=" )";
			}
		}

		// if(isset($post['product_category']) && ($post['product_category']=="218" || $post['product_category']=="596" || $post['product_category']=="597")){

		// }else{
		// 	if(isset($post['fav']) && $post['fav']==1){

		// 	}else{
		// 		$query.=' and P.product_category NOT REGEXP "[[:<:]]218[[:>:]]" ';
		// 	}
		// }


		if(isset($post['keyword']) && $post['keyword']!=""){
			$query.=' and ( P.product_name like "%'.$post['keyword'].'%" ';
			$query.=' or P.search_text like "%'.$post['keyword'].'%" ';
			$query.=' or P.product_tag regexp "[[:<:]]'.$post['keyword'].'[[:>:]]" ';
			$query.=' or P.product_sku like "%'.$post['keyword'].'%" )';
		}

		if(isset($post['price']) && $post['price']!=""){
			if(isset($post['usd']) && $post['usd']!=''){
				$range = explode('-', $post['price']);
				$query.=' and (P.product_price!=0) and ( P.product_price BETWEEN '.$range[0]*$post['usd'].' AND '.$range[1]*$post['usd'].' )';
			}else{
				if($post['price']=='999-above'){
					$range = explode('-', $post['price']);
					$query.=' and (P.product_price!=0) and ( P.product_price >= '.$range[0].' )';
				}else{
					$range = explode('-', $post['price']);
					$query.=' and (P.product_price!=0) and ( P.product_price BETWEEN '.$range[0].' AND '.$range[1].' )';
				}
			}
		}

		if(isset($post['brandid']) && $post['brandid']!=""){
			$brandid = $post['brandid'];
			if($brandid){
				$query.=" and (";
				foreach ($brandid as $key => $value) {
					$query.=(($key==0)?"":" or ").' P.brandid = "'.$value.'" ';
				}
				$query.=" )";
			}
			// $query.=' and ( P.brandid="'.$post['brandid'].'" )';
		}

		if(isset($post['sale']) && $post['sale']!=""){
			$query.=' and ( P.best_selling = "'.$post['sale'].'" )';
		}

		if(isset($post['top']) && $post['top']!=""){
			$query.=' and ( P.shop_rewards = "'.$post['top'].'" )';
		}else{
			// $query.=' and ( P.shop_rewards = 0 )';
		}

		if(isset($post['new']) && $post['new']!=""){
			$query.=' and ( P.new_arrival = "'.$post['new'].'" )';
		}

		if(isset($post['feat_prod']) && $post['feat_prod']!=""){
			$query.=' and ( P.feat_prod = "'.$post['feat_prod'].'" )';
		}

		$res = $this->db->query($query)->result_array();
		if($res){
			$count = $res[0]['trows'];
		}else{
			$count = 0;
		}
		//print_r($count);
		return $count;
	}

	public function getProducts($post=array(),$limit='',$offset='')
	{
		$sd='';

		if(isset($post['fav']) && $post['fav']==1){
			$query='select P.pid,P.productid,P.product_name,P.product_slug,P.product_price,P.product_sale_price,P.product_category,P.discount,P.shop_rewards,P.unit_label,PM.product_image from wishlist as W left join products as P on P.productid=W.productid LEFT JOIN product_media as PM ON P.productid=PM.product_id where P.productid!="" and PM.isThumb=1 and W.profileid="'.$post['profileid'].'" ';
		}else{
			$query='select P.pid,P.productid,P.product_name,P.product_slug,P.product_price,P.product_sale_price,P.product_category,P.discount,P.shop_rewards,P.unit_label,PM.product_image from products as P LEFT JOIN product_media as PM ON P.productid=PM.product_id where P.productid!="" and PM.isThumb=1 ';
		}

		if(isset($post['product_category']) && $post['product_category']!=""){
			$cat = explode(",", $post['product_category']);
			if($cat){
				$query.=" and (";
				foreach ($cat as $key => $value) {
					$query.=(($key==0)?"":" or ").' P.product_category REGEXP "[[:<:]]'.$value.'[[:>:]]" ';
				}
				$query.=" )";
			}
		}

		// if(isset($post['product_category']) && ($post['product_category']=="218" || $post['product_category']=="596" || $post['product_category']=="597")){

		// }else{
		// 	if(isset($post['fav']) && $post['fav']==1){

		// 	}else{
		// 		$query.=' and P.product_category NOT REGEXP "[[:<:]]218[[:>:]]" ';
		// 	}
		// }

		if(isset($post['keyword']) && $post['keyword']!=""){
			$query.=' and ( P.product_name like "%'.$post['keyword'].'%" ';
			$query.=' or P.search_text like "%'.$post['keyword'].'%" ';
			$query.=' or P.product_tag regexp "[[:<:]]'.$post['keyword'].'[[:>:]]" ';
			$query.=' or P.product_sku like "%'.$post['keyword'].'%" )';
		}

		if(isset($post['brandid']) && $post['brandid']!=""){
			// $query.=' and ( P.brandid="'.$post['brandid'].'" )';
			$brandid = $post['brandid'];
			if($brandid){
				$query.=" and (";
				foreach ($brandid as $key => $value) {
					$query.=(($key==0)?"":" or ").' P.brandid = "'.$value.'" ';
				}
				$query.=" )";
			}
		}

		if(isset($post['productid']) && $post['productid']!=""){
			$query.=' and ( P.productid = '.$post['productid'].' )';
		}

		if(isset($post['sale']) && $post['sale']!=""){
			$query.=' and ( P.best_selling = "'.$post['sale'].'" )';
		}

		if(isset($post['top']) && $post['top']!=""){
			$query.=' and ( P.shop_rewards = "'.$post['top'].'" )';
		}else{
			// $query.=' and ( P.shop_rewards = 0 )';
		}

		if(isset($post['new']) && $post['new']!=""){
			$query.=' and ( P.new_arrival = "'.$post['new'].'" )';
		}

		if(isset($post['feat_prod']) && $post['feat_prod']!=""){
			$query.=' and ( P.feat_prod = "'.$post['feat_prod'].'" )';
		}

		if(isset($post['npid']) && $post['npid']!=""){
			$query.=' and ( P.productid != "'.$post['npid'].'" )';
		}

		if(isset($post['price']) && $post['price']!=""){
			if(isset($post['usd']) && $post['usd']!=''){
				$range = explode('-', $post['price']);
				$query.=' and (P.product_price!=0) and ( P.product_price BETWEEN '.$range[0]*$post['usd'].' AND '.$range[1]*$post['usd'].' )';
			}else{
				if($post['price']=='999-above'){
					$range = explode('-', $post['price']);
					$query.=' and (P.product_price!=0) and ( P.product_price >= '.$range[0].' )';
				}else{
					$range = explode('-', $post['price']);
					$query.=' and (P.product_price!=0) and ( P.product_price BETWEEN '.$range[0].' AND '.$range[1].' )';
				}
			}
		}

		if(isset($post['discount']) && $post['discount']!=""){
			$query.=' and ( P.discount >= '.$post['discount'].' )';
		}

		if(isset($post['where']) && is_array($post['where']) && !empty($post['where'])){
			$query.=" and (";
			foreach ($post['where'] as $key => $value) {
				$query.=(($key==0)?"":" and ").$key."'".$value."'";
			}
			$query.=" )";
		}

		if(isset($post['k']) && $post['k']!=""){
			$term1 = str_replace(array('(',')'), "", $post['k']);
    		$keywords = explode(",", $term1);
			if (is_array($keywords) && !empty($keywords)){
                foreach ($keywords as $key => $value) :
                    $k1 = explode(" ", trim($value));
                    $sd .= ($key==0)?"":" or ";
                    $sd .= ' P.product_name REGEXP "[[:<:]]'.trim($value).'[[:>:]]" ';
                    if(count($k1)>1){
                        $sd.=' or (';
                        foreach ($k1 as $key1 => $value1) {
                            $k2 = trim($value1);
                            $sd .= ($key1==0)?"":" and ";
                            $sd .= ' P.product_name REGEXP "[[:<:]]'.$k2.'[[:>:]]" ';
                        }
                        $sd.=' ) ';
                    }
                endforeach;
                $query.=($sd)?" and ( ".$sd." )":"";
            }
        }

        // $query.=' group by P.productid, PM.product_id';

        if(isset($post['order_by']) && $post['order_by']==1){
        	$post['order'] = array('field'=>'pid','by'=>'desc');
        }else if(isset($post['order_by']) && $post['order_by']==2){
        	$post['order'] = array('field'=>'discount','by'=>'desc');
        }else if(isset($post['order_by']) && $post['order_by']==3){
        	$post['order'] = array('field'=>'product_price','by'=>'desc');
        }else if(isset($post['order_by']) && $post['order_by']==4){
        	$post['order'] = array('field'=>'product_price','by'=>'asc');
        }else if(isset($post['order_by']) && $post['order_by']==5){
        	$post['order'] = array('field'=>'rating','by'=>'desc');
        }else if(isset($post['order_by']) && $post['order_by']==6){
        	$post['order'] = array('field'=>'reviews','by'=>'desc');
        }

		if(isset($post['last_products']) && $post['last_products']!=""){
			$query.=' order by P.last_products desc';
		}else{
			if(isset($post['order']) && is_array($post['order']) && !empty($post['order'])){
				$query.=' order by cast(P.'.$post['order']['field']." as decimal(38,10)) ".$post['order']['by'];
				// $query.=' order by '.$post['order']['field']." ".$post['order']['by'];
			}else{
				$query.=' order by P.pid desc';
			}
		}

		if(isset($post['limit']) && isset($post['offset'])){
			$query.=' limit '.$post['limit']." offset ".$post['offset'];
		}

		if(isset($post['limit']) && !isset($post['offset'])){
			$query.=' limit '.$post['limit'];
		}

		if((isset($limit) && $limit!='') && (isset($offset) && $offset!=''))
		{
			$query.=' limit '.$offset.','.$limit;
		}

		else if(isset($limit) && $limit!='')
		{
			$query.=' limit '.$limit;
		}

		$res = $this->db->query($query)->result_array();
		// echo $this->db->last_query();die;

		return $res;
	}

	public function directSearchProduct($post)
    {
    	$result=0;
		$query = 'select P.*,PM.product_image from products as P LEFT JOIN product_media as PM ON P.productid=PM.product_id where ';
		$query .= ' P.product_name LIKE "%'.$post['search'].'%"';
		/*$result1=array();
		$search_string = explode(" ", $post['search']);
		$common_words = $this->config->item('commonWords');
		//print_r($common_words); die;
		$result1 = array_diff($search_string, $common_words);
		$query_1="";
		if ($result1) {
			$or = false;
			foreach ($result1 as $key => $value) {
				if ($value != "" and $value != '(' and $value != ')') {
					$query_1 .= (($or)?' or ':'').'P.product_name LIKE "%'.trim($value).'%"';
					$or = true;
				}
			}
		}
		$result=1;
		$query.=' MATCH(P.product_name) AGAINST ("'.$_POST['search'].'" IN NATURAL LANGUAGE MODE) '.' UNION '.$query.$query_1;*/

		$query.=' group by P.productid, PM.product_id';

		$products = $this->db->query($query)->result_array();

		return $products;
    }


    public function autocomplete($term)
    {

    	$c=$sc=array();

    	$sd='';

    	$category = $this->common->getData("category",array(),array("c_id","category"));

    	$subcategory = $this->common->getData("subcategory",array(),array("sc_id","subcategory"));

    	if($category){

	    	foreach ($category as $key => $value) {

	    		$c[$value['c_id']]=$value['category'];

	    	}

	    }

	    if($subcategory){

	    	foreach ($subcategory as $key => $value) {

	    		$sc[$value['sc_id']]=$value['subcategory'];

	    	}

	    }

    	if($term!=""){

    		$term1 = str_replace(array('(',')'), "", $term);

    		$keywords = explode(",", $term1);


	        $query = "SELECT P.product_name,P.pid,P.productid,P.product_slug,P.product_category,P.product_subcategory FROM products P WHERE  ";

	           
	        if (is_array($keywords) && !empty($keywords)){

                foreach ($keywords as $key => $value) :

                    $k1 = explode(" ", trim($value));

                    $sd .= ($key==0)?"":" or ";
                    
                    $sd .= ' P.product_name LIKE "%'.trim($value).'%" ';

                    if(count($k1)>1){

                        $sd.=' or (';

                        foreach ($k1 as $key1 => $value1) {

                            $k2 = trim($value1);

                            $sd .= ($key1==0)?"":" or ";

                            $sd .= ' P.product_name LIKE "%'.$k2.'%" ';

                        }

                        $sd.=' ) ';

                    }

                endforeach;

                $query.=($sd)?" ( ".$sd." )":"";

            }

            $query.=" GROUP BY P.product_category";

	        $q = $this->db->query($query);

	        $result = $q->result_array();

	        // echo $this->db->last_query();
	        // echo "<pre>";
	        // print_r($result); die;

	        foreach ($result as $key => $value) {

	        	if($value['product_category']!=""){

	        		$product_category = explode(",", $value['product_category']);

	        		//print_r($product_category);

	        		//echo "count = ".count($product_category);

	        		if(count($product_category)==1){

	        			if(array_key_exists($value['product_category'], $c)){

	        				$result[$key]['category_name'] = $c[$value['product_category']];

	        			}

	        		}else{

	        			$cat=array();

	        			foreach ($product_category as $key1 => $value1) {

	        				if(array_key_exists($value1, $c)){

		        				array_push($cat,$c[$value1]);

		        			}

	        			}

	        			$result[$key]['category_name'] = implode(",", $cat);

	        		}

	        	}



	        	if($value['product_subcategory']!=""){

	        		$product_subcategory = explode(",", $value['product_subcategory']);

	        		if(count($product_subcategory)==1){

	        			if(array_key_exists($value['product_subcategory'], $sc)){

	        				$result[$key]['subcategory_name'] = $sc[$value['product_subcategory']];

	        			}

	        		}else{

	        			$subcat=array();

	        			foreach ($product_subcategory as $key1 => $value1) {

	        				if(array_key_exists($value1, $sc)){

		        				array_push($subcat,$sc[$value1]);

		        			}

	        			}

	        			$result[$key]['subcategory_name'] = implode(",", $subcat);

	        		}

	        	}

	        	$result[$key]['keyword'] = $term;

	        }

	        //print_r($result); die;

	        return $result;

    	}

    }

	public function searchByTag($post='')
	{
		$query='select P.product_name,P.product_slug,P.productid,P.product_sale_price,P.product_price,PM.product_image from products as P LEFT JOIN product_media as PM ON P.productid=PM.product_id where P.productid!="" and P.product_tag!=""';
		if(isset($post) && $post!=""){
			$query.=' and ( P.product_tag REGEXP "[[:<:]]'.$post.'[[:>:]]" )';
		}

		$res = $this->db->query($query)->result_array();
		return $res;
	}

	public function getOrders($orderid=array(),$single='',$profileid='')
	{
		$this->db->select("O.*,O.orderid as order_id,UOA.*,OS.order_status_name,U.name");
		$this->db->from("orders as O");
		$this->db->join("cart_mapping as CM","CM.orderid=O.orderid","left");
		$this->db->join("user as U","O.profileid=U.profileid","left");
		$this->db->join("user_order_address as UOA","O.orderid=UOA.orderid","left");
		$this->db->join("payment_method as PM","O.payment_method=PM.pm_id","left");
		$this->db->join("order_status as OS","O.order_status=OS.os_id","left");
		if($orderid){
			$this->db->where("O.orderid",$orderid);
		}
		if($profileid){
			$this->db->where("O.profileid",$profileid);
		}
		$this->db->group_by("CM.orderid");
		$this->db->order_by("O.id","desc");
		$res = $this->db->get()->result_array();
		$this->session->set_userdata('order_invoice',$this->db->last_query());
		//echo $this->db->last_query();
		if($res)
		{
			if($profileid){
				return $res;
			}else{
				return $res[0];
			}
		}else{
			return $res;
		}

	}

	public function getBlogList($post=array(),$params = array(),$count='')
	{
		//echo "<pre>";print_r($post);die; 
		$fields = $query = $wh = $like = '';
        $query = 'SELECT P.* FROM `post` as P where P.id!="" ';
        $query.=$wh.$like;
        if(isset($post['category']) && $post['category']!=''){
        	$query .= ' and P.post_category regexp "[[:<:]]'.$post['category'].'[[:>:]]"';
        }
        if(isset($post['et']) && $post['et']=='past'){
        	$query .= ' and P.publish_date < "'.date('Y-m-d H:i:s').'"';
        }else if(isset($post['et']) && $post['et']=='ongoing'){
        	$query .= ' and date(P.publish_date) = "'.date('Y-m-d').'"';
        }else if(isset($post['et']) && $post['et']=='upcoming'){
        	$query .= ' and P.publish_date > "'.date('Y-m-d H:i:s').'"';
        }
        if(isset($post['type']) && $post['type']==2){
        	$query .= ' and P.type=2';
        }else if(isset($post['type']) && $post['type']==1){
        	$query .= ' and P.type=1';
        }else{
        	$query .= ' and P.type=0';
        }
        $query.=' order by P.id desc ';
        if(array_key_exists("start",$params) && array_key_exists("limit",$params)){
            $query.=' limit '.$params['start'].', '.$params['limit'];
        }
        if(!array_key_exists("start",$params) && array_key_exists("limit",$params)){
            $query.=' limit '.$params['limit'];
        }
        $rquery=$this->db->query($query);
        //echo "<pre>";print_r($query->result_array());
        if($count==0){
            //echo "<pre>";echo $this->db->last_query()."<br>";
            $result = $rquery->result_array();
            //print_r($result);die;
        }else{
            $result = $rquery->num_rows();
        }
        $rquery->free_result();
        return $result;
	}

	public function getBlogListWithPag($get=array())
    {
        //echo "<pre>";print_r($get);
        $like=0;
        $page = (isset($get['limit']) && $get['limit'])?$get['limit']:0;
        if($page==0){
            $offset = 0;
            $where1 = array('limit'=>9);
        }else{
            $offset = $page;
            $where1 = array('start'=>$offset,'limit'=>9);
        }
        $totalRec = $this->getBlogList($get,array(),1);
        $data1['blog'] = $this->getBlogList($get,$where1,0);
        //echo "<pre>";print_r($data1);die;
        $config=array(
                'target' => '#postList',
                'base_url' => $get['base_url'],
                'total_rows' => $totalRec,
                'per_page' => 9,
                'reuse_query_string' => true,
                'page_query_string' => true,
                'full_tag_open' => "<ul class='pagination justify-content-center align-items-center mt-md-5 mt-4 mb-4'>",
	            'full_tag_close' => "</ul>",
	            'first_tag_open' => '<li class="page-item">',
	            'first_tag_close' => '</li>',
	            'last_tag_open' => '<li class="page-item">',
	            'last_tag_close' => '</li>',
	            'next_tag_open' => '<li class="page-item ps-3">',
	            'next_tag_close' => '</li>',
	            'prev_tag_open' => '<li class="page-item pe-3">',
	            'prev_tag_close' => '</li>',
	            'num_tag_open' => '<li class="page-item">',
	            'num_tag_close' => '</li>',
	            'cur_tag_open' => "<li class='page-item'><a class='active page-link'>",
	            'cur_tag_close' => "</a></li>"
            );
        // $config['uri_segment'] =2;
        $config['prev_link'] = '<i class="fa fa-angle-left fs-4"></i>';
        $config['next_link'] = '<i class="fa fa-angle-right fs-4"></i>';
        $this->pagination->initialize($config);
        //$data1['html'] = getTenders($data1["post"],'tenders');
        $data1['links'] = $this->pagination->create_links();
        $data1['h1'] = $this->pagination->totalRecords();
        $data1['h2'] = $this->pagination->noOfRecords();
        //echo "<pre>";print_r($data1);die;
        return $data1;
    }

	public function getGalleryProjectList($post=array(),$params = array(),$count='')
	{
		//echo "<pre>";print_r($post);die; 
		$fields = $query = $wh = $like = '';
        $query = 'SELECT P.* FROM `gallery_project` as P where P.id!="" ';
        $query.=$wh.$like;
        if(isset($post['catid']) && $post['catid']!=''){
        	$query .= ' and P.category regexp "[[:<:]]'.$post['catid'].'[[:>:]]"';
        }
        $query.=' order by P.id asc ';
        if(array_key_exists("start",$params) && array_key_exists("limit",$params)){
            $query.=' limit '.$params['start'].', '.$params['limit'];
        }
        if(!array_key_exists("start",$params) && array_key_exists("limit",$params)){
            $query.=' limit '.$params['limit'];
        }
        $rquery=$this->db->query($query);
        //echo "<pre>";print_r($query->result_array());
        if($count==0){
            //echo "<pre>";echo $this->db->last_query()."<br>";
            $result = $rquery->result_array();
            //print_r($result);die;
        }else{
            $result = $rquery->num_rows();
        }
        $rquery->free_result();
        return $result;
	}

	public function getGalleryProjectListWithPag($get=array())
    {
        //echo "<pre>";print_r($get);
        $like=0;
        $page = (isset($get['limit']) && $get['limit'])?$get['limit']:0;
        if($page==0){
            $offset = 0;
            $where1 = array('limit'=>9);
        }else{
            $offset = $page;
            $where1 = array('start'=>$offset,'limit'=>9);
        }
        $totalRec = $this->getGalleryProjectList($get,array(),1);
        $data1['project'] = $this->getGalleryProjectList($get,$where1,0);
        //echo "<pre>";print_r($data1);die;
        $config=array(
                'target' => '#postList',
                'base_url' => $get['base_url'],
                'total_rows' => $totalRec,
                'per_page' => 9,
                'reuse_query_string' => true,
                'page_query_string' => true,
                'full_tag_open' => "<ul class='pagination justify-content-center align-items-center'>",
	            'full_tag_close' => "</ul>",
	            'first_tag_open' => '<li class="page-item">',
	            'first_tag_close' => '</li>',
	            'last_tag_open' => '<li class="page-item">',
	            'last_tag_close' => '</li>',
	            'next_tag_open' => '<li class="page-item ps-3">',
	            'next_tag_close' => '</li>',
	            'prev_tag_open' => '<li class="page-item pe-3">',
	            'prev_tag_close' => '</li>',
	            'num_tag_open' => '<li class="page-item">',
	            'num_tag_close' => '</li>',
	            'cur_tag_open' => "<li class='page-item'><a class='active page-link'>",
	            'cur_tag_close' => "</a></li>"
            );
        // $config['uri_segment'] =2;
        $config['prev_link'] = '<i class="fa fa-angle-left fs-4"></i>';
        $config['next_link'] = '<i class="fa fa-angle-right fs-4"></i>';
        $this->pagination->initialize($config);
        $data1['total'] = $totalRec;
        $data1['links'] = $this->pagination->create_links();
        $data1['h1'] = $this->pagination->totalRecords();
        $data1['h2'] = $this->pagination->noOfRecords();
        //echo "<pre>";print_r($data1);die;
        return $data1;
    }

	public function getTestimonialList($post=array(),$params = array(),$count='')
	{
		//echo "<pre>";print_r($post);die; 
		$fields = $query = $wh = $like = '';
        $query = 'SELECT P.* FROM `testimonial` as P where P.id!="" ';
        $query.=$wh.$like;
        if(isset($post['type']) && $post['type']=='fb'){
        	$query .= ' and P.ratting_by=0';
        }
        if(isset($post['type']) && $post['type']=='google'){
        	$query .= ' and P.ratting_by=1';
        }
        $query.=' order by P.item_order asc';
        if(array_key_exists("start",$params) && array_key_exists("limit",$params)){
            $query.=' limit '.$params['start'].', '.$params['limit'];
        }
        if(!array_key_exists("start",$params) && array_key_exists("limit",$params)){
            $query.=' limit '.$params['limit'];
        }
        $rquery=$this->db->query($query);
        //echo "<pre>";print_r($query->result_array());
        if($count==0){
            //echo "<pre>";echo $this->db->last_query()."<br>";
            $result = $rquery->result_array();
            //print_r($result);die;
        }else{
            $result = $rquery->num_rows();
        }
        $rquery->free_result();
        return $result;
	}

	public function getTestimonialListWithPag($get=array())
    {
        //echo "<pre>";print_r($get);
        $like=0;
        $page = (isset($get['limit']) && $get['limit'])?$get['limit']:0;
        if($page==0){
            $offset = 0;
            $where1 = array('limit'=>6);
        }else{
            $offset = $page;
            $where1 = array('start'=>$offset,'limit'=>6);
        }
        $totalRec = $this->getTestimonialList($get,array(),1);
        $data1['testimonial'] = $this->getTestimonialList($get,$where1,0);
        //echo "<pre>";print_r($data1);die;
        $config=array(
                'target' => '#postList',
                'base_url' => $get['base_url'],
                'total_rows' => $totalRec,
                'per_page' => 6,
                'reuse_query_string' => true,
                'page_query_string' => true,
                'full_tag_open' => "<ul class='pagination justify-content-center align-items-center'>",
	            'full_tag_close' => "</ul>",
	            'first_tag_open' => '<li class="page-item">',
	            'first_tag_close' => '</li>',
	            'last_tag_open' => '<li class="page-item">',
	            'last_tag_close' => '</li>',
	            'next_tag_open' => '<li class="page-item ps-3">',
	            'next_tag_close' => '</li>',
	            'prev_tag_open' => '<li class="page-item pe-3">',
	            'prev_tag_close' => '</li>',
	            'num_tag_open' => '<li class="page-item">',
	            'num_tag_close' => '</li>',
	            'cur_tag_open' => "<li class='page-item'><a class='active page-link'>",
	            'cur_tag_close' => "</a></li>"
            );
        // $config['uri_segment'] =2;
        $config['prev_link'] = '<i class="fa fa-angle-left fs-4"></i>';
        $config['next_link'] = '<i class="fa fa-angle-right fs-4"></i>';
        $this->pagination->initialize($config);
        $data1['total'] = $totalRec;
        $data1['links'] = $this->pagination->create_links();
        $data1['h1'] = $this->pagination->totalRecords();
        $data1['h2'] = $this->pagination->noOfRecords();
        //echo "<pre>";print_r($data1);die;
        return $data1;
    }

	public function getRecipesList($post=array(),$params = array(),$count='')
	{
		//echo "<pre>";print_r($post);die; 
		$fields = $query = $wh = $like = '';
        $query = 'SELECT P.* FROM `recipe` as P where P.id!="" ';
        $query.=$wh.$like;
        if(isset($post['catid']) && $post['catid']!=''){
        	$query .= ' and P.type='.$post['catid'];
        }
        if(isset($post['nid']) && $post['nid']!=''){
        	$query .= ' and P.id!='.$post['nid'];
        }
        $query.=' order by P.item_order asc';
        if(array_key_exists("start",$params) && array_key_exists("limit",$params)){
            $query.=' limit '.$params['start'].', '.$params['limit'];
        }
        if(!array_key_exists("start",$params) && array_key_exists("limit",$params)){
            $query.=' limit '.$params['limit'];
        }
        $rquery=$this->db->query($query);
        //echo "<pre>";print_r($query->result_array());
        if($count==0){
            //echo "<pre>";echo $this->db->last_query()."<br>";
            $result = $rquery->result_array();
            //print_r($result);die;
        }else{
            $result = $rquery->num_rows();
        }
        $rquery->free_result();
        return $result;
	}

	public function getRecipesListWithPag($get=array())
    {
        //echo "<pre>";print_r($get);
        $like=0;
        $page = (isset($get['limit']) && $get['limit'])?$get['limit']:0;
        if($page==0){
            $offset = 0;
            $where1 = array('limit'=>9);
        }else{
            $offset = $page;
            $where1 = array('start'=>$offset,'limit'=>9);
        }
        $totalRec = $this->getRecipesList($get,array(),1);
        $data1['recipes'] = $this->getRecipesList($get,$where1,0);
        //echo "<pre>";print_r($data1);die;
        $config=array(
                'target' => '#postList',
                'base_url' => $get['base_url'],
                'total_rows' => $totalRec,
                'per_page' => 9,
                'reuse_query_string' => true,
                'page_query_string' => true,
                'full_tag_open' => "<ul class='pagination justify-content-center align-items-center mt-md-5 mt-4 mb-4'>",
	            'full_tag_close' => "</ul>",
	            'first_tag_open' => '<li class="page-item">',
	            'first_tag_close' => '</li>',
	            'last_tag_open' => '<li class="page-item">',
	            'last_tag_close' => '</li>',
	            'next_tag_open' => '<li class="page-item ps-3">',
	            'next_tag_close' => '</li>',
	            'prev_tag_open' => '<li class="page-item pe-3">',
	            'prev_tag_close' => '</li>',
	            'num_tag_open' => '<li class="page-item">',
	            'num_tag_close' => '</li>',
	            'cur_tag_open' => "<li class='page-item'><a class='active page-link'>",
	            'cur_tag_close' => "</a></li>"
            );
        // $config['uri_segment'] =2;
        $config['prev_link'] = '<i class="fa fa-angle-left fs-4"></i>';
        $config['next_link'] = '<i class="fa fa-angle-right fs-4"></i>';
        $this->pagination->initialize($config);
        $data1['total'] = $totalRec;
        $data1['links'] = $this->pagination->create_links();
        $data1['h1'] = $this->pagination->totalRecords();
        $data1['h2'] = $this->pagination->noOfRecords();
        //echo "<pre>";print_r($data1);die;
        return $data1;
    }

	public function getEnqProductsList($post=array(),$params = array(),$count='')
	{
		//echo "<pre>";print_r($post);die; 
		$fields = $query = $wh = $like = '';
        $query = 'SELECT P.* FROM `eproduct` as P where P.id!="" ';
        $query.=$wh.$like;
        if(isset($post['catid']) && $post['catid']!=''){
        	$query .= ' and P.category='.$post['catid'];
        }
        if(isset($post['nid']) && $post['nid']!=''){
        	$query .= ' and P.id!='.$post['nid'];
        }
        if(isset($post['keyword']) && $post['keyword']!=''){
        	$query .= ' and P.title like "%'.$post['keyword'].'%"';
        }
        $query.=' order by P.item_order asc';
        if(array_key_exists("start",$params) && array_key_exists("limit",$params)){
            $query.=' limit '.$params['start'].', '.$params['limit'];
        }
        if(!array_key_exists("start",$params) && array_key_exists("limit",$params)){
            $query.=' limit '.$params['limit'];
        }
        $rquery=$this->db->query($query);
        //echo "<pre>";print_r($query->result_array());
        if($count==0){
            //echo "<pre>";echo $this->db->last_query()."<br>";
            $result = $rquery->result_array();
            //print_r($result);die;
        }else{
            $result = $rquery->num_rows();
        }
        $rquery->free_result();
        return $result;
	}

	public function getEnqProductsListWithPag($get=array())
    {
        //echo "<pre>";print_r($get);
        $like=0;
        $page = (isset($get['limit']) && $get['limit'])?$get['limit']:0;
        if($page==0){
            $offset = 0;
            $where1 = array('limit'=>9);
        }else{
            $offset = $page;
            $where1 = array('start'=>$offset,'limit'=>9);
        }
        $totalRec = $this->getEnqProductsList($get,array(),1);
        $data1['products'] = $this->getEnqProductsList($get,$where1,0);
        //echo "<pre>";print_r($data1);die;
        $config=array(
                'target' => '#postList',
                'base_url' => $get['base_url'],
                'total_rows' => $totalRec,
                'per_page' => 9,
                'reuse_query_string' => true,
                'page_query_string' => true,
                'full_tag_open' => "<ul class='pagination justify-content-center align-items-center mt-md-5 mt-4 mb-4'>",
	            'full_tag_close' => "</ul>",
	            'first_tag_open' => '<li class="page-item">',
	            'first_tag_close' => '</li>',
	            'last_tag_open' => '<li class="page-item">',
	            'last_tag_close' => '</li>',
	            'next_tag_open' => '<li class="page-item ps-3">',
	            'next_tag_close' => '</li>',
	            'prev_tag_open' => '<li class="page-item pe-3">',
	            'prev_tag_close' => '</li>',
	            'num_tag_open' => '<li class="page-item">',
	            'num_tag_close' => '</li>',
	            'cur_tag_open' => "<li class='page-item'><a class='active page-link'>",
	            'cur_tag_close' => "</a></li>"
            );
        // $config['uri_segment'] =2;
        $config['prev_link'] = '<i class="fa fa-angle-left fs-4"></i>';
        $config['next_link'] = '<i class="fa fa-angle-right fs-4"></i>';
        $this->pagination->initialize($config);
        $data1['total'] = $totalRec;
        $data1['links'] = $this->pagination->create_links();
        $data1['h1'] = $this->pagination->totalRecords();
        $data1['h2'] = $this->pagination->noOfRecords();
        //echo "<pre>";print_r($data1);die;
        return $data1;
    }
	
}
?>