<?php if (!defined('BASEPATH')) exit('No direct script access allowed');



class Profile extends MY_Profile_Controller {



    Public function __construct(){

        parent::__construct();
        $this->load->helper('front_helper');

    }

    public function checkVerification()
    {
        $profile = $this->common->getsData("user",array("profileid"=>$this->profileid),'verify');
        if($profile['verify']==1){
            // return 1;
            redirect(base_url('user-profile'));
        }else{
            redirect(base_url('user-verify'));
        }
    }

    public function resendVerificationLink()
    {
        $profile = $this->common->getsData("user",array("profileid"=>$this->profileid),'email');
        $edata['link'] = base_url('user-verify-email?info='.base64_encode($profile['email']));
        $email_message = $this->load->view('email_temp/account-verify',$edata,true);
        // echo $email_message; die;
        $subject = 'Verify your Email';
        $this->common->sendMailBySendGrid($profile['email'],'','ben@websentials.com.sg','BSI Supply',$subject,$email_message);
        // $this->email->from('ben@websentials.com.sg','BSI Supply');
        // $this->email->to($profile['email']);
        // $this->email->subject('Verify your Email');
        // $this->email->message($email_message);
        // $this->email->send();
        //echo $this->email->print_debugger(); die;
        $this->session->set_flashdata('message',"Verification Link Sent to Your Email. Please Check Your Email.");
        redirect($_SERVER['HTTP_REFERER']);
    }

    public function verifyPage($value='')
    {
        // $this->checkVerification();
        $data['profile'] = $this->common->getsData("user",array("profileid"=>$this->profileid));
        if($data['profile']['verify']==1){
            redirect(base_url('user-profile'));
        }
        $this->loadHtml("verify","My Profile",$data);
    }

    public function index()
    {
        // $this->checkVerification();
        redirect(base_url("user-profile"));
    }

    public function userProfilePage()
    {
        // $this->checkVerification();
        $data['profile'] = $this->common->getsData("user",array("profileid"=>$this->profileid));
        $this->loadHtml("dashboard","My Profile",$data);
    }
    public function userDashboardPage()
    {
        $data['order'] = $this->profile->getOrders(array("profileid"=>$this->profileid),array('limit'=>5),array("field"=>"O.id","by"=>"desc"));
        $this->loadHtml("dashboard","Dashboard",$data);
    }
    public function fastTrackPage()
    {
        $this->loadHtml("fast-track","Fast Track");
    }

    public function pointsHistoryPage($limit='')
    {
        $get=$where=array();
        if (isset($_GET)) {
            $get = $_GET;
        }
        if($limit!="")
        {
            $get['limit'] = $limit;            
        }
        $get['base_url'] = base_url('points-history');
        $data = $this->profile->getPointsHistoryWithpag($where,$get);
        $data['k'] = ($limit!="")?$limit+1:1;
        $this->loadHtml('points-history','Points History',$data);
    }

    public function userEditProfilePage()
    {
        // $this->checkVerification();
        $data['profile'] = $this->common->getsData("user",array("profileid"=>$this->profileid));
        $this->loadHtml("edit-profile","Edit Profile",$data);
    }

    public function addAddressPage()
    {
        $this->loadHtml("add-address","Add Address");
    }

    public function editAddressPage($id='')
    {
        $data['profile'] = $this->common->getsData("user_address",array("profileid"=>$this->profileid,'id'=>$id));
        $this->loadHtml("edit-address","Add Billing Address",$data);
    }

    public function userShippingAddressPage()
    {
        // $this->checkVerification();
        $data['sprofile'] = $this->common->getsData("user_address",array("profileid"=>$this->profileid),array("sname","smobile_no","sstate","scity","saddress1","saddress2","spincode","semail"));
        $this->loadHtml("shipping-address","Add Shipping Address",$data);
    }

    public function userChangePasswordPage()
    {
        // $this->checkVerification();
        $data['profile'] = $this->common->getsData("user",array("profileid"=>$this->profileid));
        $this->loadHtml("change-password","Change Password",$data);
    }

    public function userRewardsPage()
    {
        // $this->checkVerification();
        $data['profile'] = $this->common->getsData("user",array("profileid"=>$this->profileid));
        $this->loadHtml("favourites","Rewards",$data);
    }

    public function userPointsHistoryPage()
    {
        // $this->checkVerification();
        $data['profile'] = $this->common->getsData("user",array("profileid"=>$this->profileid));
        $data['history'] = $this->common->getData("point_history",array("profileid"=>$this->profileid),array(),array('field'=>'id','by'=>'desc'));
        $this->loadHtml("user-point-history","Point History",$data);
    }
    // public function userfavouritesPage()
    // {
    //     $this->checkVerification();
    //     $this->loadHtml("favourites","Favourites");
    // }

    public function changePassword()
    {
        $data = $this->common->getsData('user',array('email'=>$_POST['email']),array('profileid','password'));
        if($data){
            if($data['password'] != md5($_POST['password']))
            {
                $this->session->set_flashdata('emessage',"Old Password Wrong");
            }else{
                // if(md5($_POST['new_password'])==md5($_POST['confirm_password']))
                // {
                    $this->common->updateData('user',array('plain_password'=>$_POST['new_password'],'password'=>md5($_POST['new_password'])),array('profileid'=>$data['profileid']));
                    // $this->session->set_flashdata('message',"Password Update Successfully");
                    redirect(base_url('logout'));
                // }
            }
        }else{
            $this->session->set_flashdata('emessage',"Something went wrong");
        }
        redirect($_SERVER['HTTP_REFERER']);
    }



    public function allOrdersPage()
    {
        // $this->checkVerification();
        $data['profile'] = $this->common->getsData("user",array("profileid"=>$this->profileid));
        $data['order'] = $this->profile->getOrders(array("profileid"=>$this->profileid),array(),array("field"=>"O.id","by"=>"desc"));
        $this->loadHtml("all-orders","All Orders",$data);
    }

    public function orderCartDetailPage($orderid='')
    {
        // $this->checkVerification();
        $this->load->model(A."/".A."_model","admin");
        $data['invoice'] = $this->admin->getOrders($orderid,1);
        $data['order_status'] = $this->common->getData("order_status");
        $data['cart'] = $this->common->getData("cart_mapping",array("orderid"=>$data['invoice']['orderid']),array(),array(),array("field"=>"cmid","by"=>"asc"));
        $data['cancle_orders'] = $this->admin->getCancleOrder(array("O.orderid"=>$orderid));
        $this->loadHtml('order-detail','Orders Invoice',$data);
    }

    public function cancleOrder()
    {
        // echo "<pre>";
        // print_r ($_POST);
        // echo "</pre>"; die;
        if(isset($_POST)){
            $status_cancle = $this->common->updateData('orders',array('order_status'=>5),array('orderid'=>$_POST['orderid']));
            if($status_cancle){
                $_POST['cancle_by'] = "User";
                $res = $this->common->insertData('cancle_order',$_POST);
                if($res){
                    $usermobile = $this->common->getsData('user',array('profileid'=>$_POST['profileid']),'mobile_no,email');
                    $mobile_no = $usermobile['mobile_no'];
                    $email = $usermobile['email'];

                    $umessage = "User Cancelled this Order (".$_POST['orderid'].") because of ".$_POST['order_cancle_reson'];

                    $this->email->from("info@petmart.sg","Pet Mart");

                    $this->email->to('info@petmart.sg,ankit.d100@gmail.com');

                    $this->email->subject("Your Pet Mart order is Cancelled with Order Id ".$_POST['orderid']);

                    $this->email->message($umessage);

                    // $this->email->send();

                    $this->session->set_flashdata("message","Order Is Cancelled");
                }else{
                    $this->session->set_flashdata("emessage","something Went Wrong");
                }
            }else{
                $this->session->set_flashdata("emessage","something Went Wrong");
            }
        }
        redirect(base_url('user-profile'));
    }

}