<?php
// Enqueue the parent theme's stylesheet

function hello_elementor_child_enqueue_styles()
{
    wp_enqueue_style('hello-elementor-parent-style', get_template_directory_uri() . '/../hello-elementor-child/style.css');
    wp_enqueue_style('hello-elementor-parent-ecommerce', get_template_directory_uri() . '/../hello-elementor-child/ecommerce.css');
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles');


// Enqueue Booststrap 
function enqueue_bootstrap()
{
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');


//  Slick carousel script and styles
function enqueue_slick_scripts()
{
    //  Slick carousel script
    wp_enqueue_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js', array('jquery'), null, true);
    //  Slick carousel CSS
    wp_enqueue_style('slick-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_slick_scripts');








// Home slider Start --------------------------------------------
function display_banner_home($atts)
{

    $atts = shortcode_atts(
        array(
            'posts_per_page' => 3,
        ),
        $atts,
        'testimonials'
    );

    $args = array(
        'post_type' => 'main-slider',
        'posts_per_page' => $atts['posts_per_page'],
    );

    $mainslider_query = new WP_Query($args);

    ob_start();

    if ($mainslider_query->have_posts()):
        $total_slides = $mainslider_query->post_count;
        $slide_num = 1;
        ?>
        <div id="demo" class="carousel slide carousel-fade hero-banner" data-bs-ride="carousel">
            <div class="carousel-inner">
                <?php
                $first = true;
                $slide_index = 1;
                while ($mainslider_query->have_posts()):
                    $mainslider_query->the_post(); ?>

                    <div class="carousel-item <?php echo $first ? 'active' : ''; ?>">
                        <div class="row m-0">
                            <div class="col-md-9 p-0">
                                <div class="position-relative">
                                    <div class="banner-img">
                                        <?php
                                        if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                        }
                                        ?>
                                    </div>
                                    <div class="caption-left">
                                        <h1><?php the_title(); ?></h1>

                                        <div class="btnlight">
                                            <?php
                                            $links = get_field('button_link');
                                            if ($links) {
                                                $link_url = $links['url'];
                                                $link_title = $links['title'];
                                                ?>
                                                <a href="<?php echo esc_url($link_url); ?>"
                                                    class="elementor-button"><?php echo esc_html($link_title); ?> <i
                                                        class="icon icon-arrow-right"></i></a>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 p-0 slider-caption">
                                <div class="carousel-captions">
                                    <?php
                                    $sub_title = get_field('sub_title');
                                    if ($sub_title):
                                        echo '<p class="subtitle">';
                                        echo $sub_title;
                                        echo '</p>';
                                    endif; ?>
                                    <div class="desription"> <?php the_content(); ?> </div>

                                </div>
                            </div>
                        </div>

                    </div>
                    <?php
                    $first = false;
                    $slide_index++;
                endwhile; ?>
            </div>

            <?php if ($total_slides > 1): ?>
                <div class="indicators-num">
                    <div class="carousel-indicator">
                        <p id="current-slide-number" class="mb-0 startslide"> <span
                                id="current-slide"><?php echo str_pad($slide_num, 2, '0', STR_PAD_LEFT); ?></span> </p>

                        <p id="current-slide-number" class="mb-0 endslide">
                            / <?php echo str_pad($total_slides, 2, '0', STR_PAD_LEFT); ?>
                        </p>
                    </div>
                </div>

            <?php endif; ?>


            <?php
            // Re-run the same query again for the indicators
            $indicator_query = new WP_Query($args);

            $indicator_index = 0; ?>
            <div class="slider_indegator">
                <?php if ($indicator_query->have_posts()):
                    while ($indicator_query->have_posts()):
                        $indicator_query->the_post();
                        ?>
                        <button type="button" data-bs-target="#demo" data-bs-slide-to="<?php echo $indicator_index; ?>"
                            class="<?php echo ($indicator_index === $slide_num) ? 'active' : ''; ?>">
                            <?php if (has_post_thumbnail()): ?>
                                <div class="indicator-thumbnail">
                                    <?php the_post_thumbnail('full'); ?>
                                </div>
                            <?php endif; ?>

                        </button>
                        <?php

                        $indicator_index++;
                    endwhile;
                    wp_reset_postdata();
                endif;
                ?>
            </div>


            <script>
                document.addEventListener("DOMContentLoaded", function () {
                    var myCarousel = document.querySelector("#demo");
                    var currentSlideElement = document.querySelector("#current-slide");
                    var indicatorButtons = document.querySelectorAll(".slider_indegator button");

                    myCarousel.addEventListener("slid.bs.carousel", function (event) {
                        var activeIndex = event.to; // 0-based index

                        // Update the slide number text
                        if (currentSlideElement) {
                            currentSlideElement.textContent = String(activeIndex + 1).padStart(2, '0');

                        }

                        // Remove 'active' class from all indicators
                        indicatorButtons.forEach(function (btn) {
                            btn.classList.remove("active");
                        });

                        // Add 'active' to the currently active indicator
                        if (indicatorButtons[activeIndex]) {
                            indicatorButtons[activeIndex].classList.add("active");
                        }
                    });
                });
            </script>


        </div>

    <?php else: ?>
        <div>No Slider found.</div>
    <?php endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('banner_home', 'display_banner_home');


// Home slider end --------------------------------------------





// blog slider start 
function display_blog_slider($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
        ),
        $atts,
        'blog'
    );

    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['posts_per_page'],
    );

    $blog_query = new WP_Query($args);

    ob_start();

    if ($blog_query->have_posts()): ?>
        <div class="blog-slider">
            <div class="slick-slider-blog pb-2">
                <?php while ($blog_query->have_posts()):
                    $blog_query->the_post();
                    ?>

                    <div class="item ps-2 pt-2 pb-2 pe-2">

                        <div class="blog-box" data-post-id="<?php echo get_the_ID(); ?>">
                            <div class="content-box">
                                <p class="date"><?php echo get_the_date(); ?></p>
                                <h1 class="title"> <?php echo get_the_title(); ?> </h1>
                                <div class="description">
                                    <?php echo get_the_excerpt(); ?>
                                </div>
                            </div>

                            <a href="<?php the_permalink(); ?>" class="img-box">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                } ?>
                            </a>
                            <div class="content-box">
                                <div class="read-now btn-custom-animation">
                                    <a href="<?php the_permalink(); ?>" class="btn-read-now"> <span> Read More </span> <i
                                            class="fa fa-arrow-right" aria-hidden="true"></i> </a>
                                </div>
                            </div>
                        </div>

                    </div>
                <?php endwhile; ?>
            </div>
        </div>

        <script>
            jQuery(document).ready(function ($) {
                $(".slick-slider-blog").slick({
                    dots: false,
                    arrows: false,
                    infinite: true,
                    speed: 300,
                    slidesToShow: 2,
                    slidesToScroll: 1,
                    adaptiveHeight: true,
                    centerMode: true,
                    centerPadding: '80px',
                    prevArrow: '<div class="left-btn arrowbtn"><i class="icon icon-left-arrows"></i></div>',
                    nextArrow: '<div class="right-btn arrowbtn"><i class="icon icon-right-arrow1"></i></div>',
                    responsive: [{
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 1,
                        },
                    },
                    {
                        breakpoint: 1008,
                        settings: {
                            slidesToShow: 3,
                            slidesToScroll: 1,
                        },
                    },
                    {
                        breakpoint: 800,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                        },
                    },
                    ],
                });

            });
        </script>

    <?php else:
        echo 'No blog found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('blog_slider', 'display_blog_slider');
// blog slider end ------------------------------




// blog page start ------------------------------------------------------------

function display_articles($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'blog'
    );

    // Get the current page

    $selected_category = isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '';

    // Query arguments
    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );

    // Add category filter to query arguments if a category is selected
    if (!empty($selected_category)) {
        $args['category_name'] = $selected_category;
    }


    $articles_query = new WP_Query($args);


    ob_start();

    if ($articles_query->have_posts()): ?>
        <div class="articles-page articles-main">
            <div class="row g-md-5 g-3">
                <div class="col-md-8">
                    <div class="row g-md-4 g-3">
                        <?php while ($articles_query->have_posts()):
                            $articles_query->the_post();
                            ?>
                            <div class="col-md-6 mb-md-3 mb-3">
                                <div class="articles-box" data-post-id="<?php echo get_the_ID(); ?>">
                                    <a href="<?php the_permalink(); ?>" class="articles-img">
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                        } ?>
                                    </a>
                                    <div class="content-box">

                                        <h1 class="name"> <?php echo get_the_title(); ?> </h1>
                                        <p class="date"><?php echo get_the_date(); ?></p>
                                        <div class="desription">
                                            <?php echo get_the_excerpt(); ?>
                                        </div>
                                        <div class="read-now btn-custom-animation">
                                            <a href="<?php the_permalink(); ?>" class="btn-read-now"> <span> Read More </span> <i
                                                    class="fa fa-arrow-right" aria-hidden="true"></i> </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                </div>


                <div class="col-lg-4 col-md-4">
                    <div class="featured-blog">
                        <h4>Featured Blog</h4>
                        <?php
                        $featured_args = array(
                            'post_type' => 'post',
                            'posts_per_page' => 5,
                            'meta_query' => array(
                                array(
                                    'key' => '_is_ns_featured_post',
                                    'value' => 'yes'
                                )
                            )
                        );
                        $featured_query = new WP_Query($featured_args);

                        if ($featured_query->have_posts()):
                            while ($featured_query->have_posts()):
                                $featured_query->the_post(); ?>
                                <a href="<?php the_permalink(); ?>" class="featured-item">
                                    <div class="row g-2">
                                        <div class="col-md-4 col-3">
                                            <div class="articles-img">
                                                <?php if (has_post_thumbnail()) {
                                                    the_post_thumbnail('medium', array('class' => 'd-block w-100'));
                                                } ?>
                                            </div>
                                        </div>
                                        <div class="col-md-8 col-9">
                                            <div class="content-box">
                                                <p class="date"><?php echo get_the_date(); ?></p>
                                                <h1 class="name"><?php the_title(); ?></h1>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            <?php endwhile; else: ?>
                            <p>No featured post found.</p>
                        <?php endif;
                        wp_reset_postdata();
                        ?>
                    </div>

                </div>


                <script type="text/javascript">
                    document.addEventListener('DOMContentLoaded', function () {
                        var listItems = document.querySelectorAll('#category-filter-list a');
                        listItems.forEach(function (item) {
                            item.addEventListener('click', function (event) {
                                // No need to prevent default here; the link's href handles the filtering
                            });
                        });
                    });
                </script>


                <?php if ($articles_query->max_num_pages > 1): ?>
                    <div class="pagination-center text-start mt-md-5 mt-3 mb-3">
                        <div class="pagination-two">
                            <?php
                            echo paginate_links(array(
                                'total' => $articles_query->max_num_pages,
                                'current' => max(1, get_query_var('paged')),
                                'format' => '?paged=%#%',
                                'show_all' => false,
                                'type' => 'plain',
                                'prev_text' => '<i class="fa fa-arrow-left" aria-hidden="true"></i>',
                                'next_text' => '<i class="fa fa-arrow-right" aria-hidden="true"></i>',
                                'end_size' => 2,
                                'mid_size' => 2
                            ));
                            ?>
                        </div>
                    </div>
                <?php endif; ?>



            <?php else:
        echo 'No articles found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('articles', 'display_articles');


// blog list end------------


// our-portfolio page start ------------------------------------------------------------

function display_portfolio($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'portfolio'
    );

    // Get the current page


    $args = array(
        'post_type' => 'our-portfolio',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );


    // Filter by category if provided
    if (!empty($atts['category'])) {
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'portfolio-category',
                'field' => 'slug',
                'terms' => $atts['category'],
            ),
        );
    }
    // Get categories
    $categories = get_terms(array(
        'taxonomy' => 'portfolio-category',
        'hide_empty' => true,
    ));

    if ($categories):
        ?>
                <div class="text-center">
                    <ul id="project-filter-list" class="mb-5">



                        <li><a href="<?php echo esc_url(add_query_arg('category', '', home_url('/portfolio'))); ?>"
                                class="cats <?php echo empty($atts['category']) ? 'active' : ''; ?>"> All </a></li>
                        <?php foreach ($categories as $category):
                            $active_class = ($atts['category'] === $category->slug) ? 'active' : '';
                            ?>
                            <li>
                                <a href="<?php echo esc_url(add_query_arg('category', $category->slug, home_url('/portfolio'))); ?>"
                                    class="cats <?php echo esc_attr($active_class); ?>">
                                    <?php echo esc_html($category->name); ?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php
    endif;


    $portfolio_query = new WP_Query($args);

    ob_start();

    if ($portfolio_query->have_posts()): ?>
                <div class="portfolio-page portfolio-main">
                    <div class="row g-md-3 g-3">
                        <?php while ($portfolio_query->have_posts()):
                            $portfolio_query->the_post();
                            ?>
                            <div class="col-md-4">
                                <div class="portfolio-box show-more-content-btn" id="<?php echo get_the_ID(); ?>">
                                    <a href="<?php the_permalink(); ?>" class="d-block">
                                        <div class="portfolio-img">
                                            <?php if (has_post_thumbnail()) {
                                                the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                            } ?>
                                        </div>
                                        <div class="content-box">
                                            <div class="box-wrap">
                                                <?php
                                                $terms = get_the_terms(get_the_ID(), 'portfolio-category');
                                                if ($terms && !is_wp_error($terms)) { ?>
                                                    <div class="category-wrap">
                                                        <?php
                                                        foreach ($terms as $term) {
                                                            $category_name = strtolower($term->name); ?>

                                                            <span class="category-name"><?php echo $category_name; ?></span>

                                                            <?php
                                                        } ?>
                                                    </div>
                                                <?php }
                                                ?>

                                                <h1 class="name"> <?php echo get_the_title(); ?> </h1>
                                                <p class="description mb-0"> <?php echo get_the_excerpt(); ?> </p>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>

                    <script type="text/javascript">
                        document.addEventListener('DOMContentLoaded', function () {
                            var listItems = document.querySelectorAll('#category-filter-list a');
                            listItems.forEach(function (item) {
                                item.addEventListener('click', function (event) {
                                    // No need to prevent default here; the link's href handles the filtering
                                });
                            });
                        });
                    </script>




                    <?php if ($portfolio_query->max_num_pages > 1): ?>
                        <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                            <div class="pagination-two">
                                <?php
                                echo paginate_links(array(
                                    'total' => $portfolio_query->max_num_pages,
                                    'current' => max(1, get_query_var('paged')),
                                    'format' => '?paged=%#%',
                                    'show_all' => false,
                                    'type' => 'plain',
                                    'prev_text' => '<i class="fa fa-arrow-left" aria-hidden="true"></i>',
                                    'next_text' => '<i class="fa fa-arrow-right" aria-hidden="true"></i>',
                                    'end_size' => 2,
                                    'mid_size' => 2
                                ));
                                ?>
                            </div>
                        </div>
                    <?php endif; ?>


                <?php else:
        echo 'No portfolio found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('portfolio', 'display_portfolio');


// portfolio page End ------------------------------------------------------------


// testimonials slider start 
function display_testimonials_home($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 3,
        ),
        $atts,
        'testimonials'
    );

    $args = array(
        'post_type' => 'testimonials',
        'posts_per_page' => $atts['posts_per_page'],
    );

    $testimonials_query = new WP_Query($args);

    ob_start();

    if ($testimonials_query->have_posts()): ?>

                    <div class="row g-md-4">
                        <?php while ($testimonials_query->have_posts()):
                            $testimonials_query->the_post();
                            ?>

                            <div class="col-lg-4 col-sm-4">
                                <div class="testimonials-box">
                                    <img src="https://draftsite1.com/shen-yi-engineering/wp-content/uploads/2025/05/Quote.png"
                                        alt="" class="quoteimg">
                                    <div class="img-box">
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'd-block w-100 clientlogo'));
                                        } ?>
                                    </div>
                                    <div class="description">
                                        <?php echo get_the_excerpt(); ?>
                                    </div>
                                    <div class="infowrap">
                                        <h4 class="name"><?php echo get_the_title(); ?> </h4>

                                        <?php
                                        $positions = get_field('positions');
                                        if ($positions):
                                            echo '<p class="position">';
                                            echo $positions;
                                            echo '</p>';
                                        endif; ?>


                                        <?php
                                        $pdf_url = get_field('view_pdf');

                                        if (!empty($pdf_url)) {
                                            echo '<a href="' . esc_url($pdf_url) . '" class="viewbtn" target="_blank">View More</a>';
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>

                <?php else:
        echo 'No testimonials found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('testimonials_home', 'display_testimonials_home');
// testimonials slider end ------------------------------



// testimonials page start ------------------------------------------------------------

function display_testimonials($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'testimonials'
    );
    // Get the current page
    $selected_category = isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '';
    // Query arguments
    $args = array(
        'post_type' => 'testimonials',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );

    if (!empty($selected_category)) {
        $args['category_name'] = $selected_category;
    }

    $testimonials_query = new WP_Query($args);
    ob_start();
    if ($testimonials_query->have_posts()): ?>
                    <div class="row g-md-4 g-3">
                        <?php while ($testimonials_query->have_posts()):
                            $testimonials_query->the_post();
                            ?>
                            <div class="col-lg-4 col-sm-4">
                                <div class="testimonials-box">
                                    <img src="https://draftsite1.com/shen-yi-engineering/wp-content/uploads/2025/05/Quote.png"
                                        alt="" class="quoteimg">
                                    <div class="img-box">
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'd-block w-100 clientlogo'));
                                        } ?>
                                    </div>
                                    <div class="description">
                                        <?php echo get_the_excerpt(); ?>
                                    </div>
                                    <div class="infowrap">
                                        <h4 class="name"><?php echo get_the_title(); ?> </h4>

                                        <?php
                                        $positions = get_field('positions');
                                        if ($positions):
                                            echo '<p class="position">';
                                            echo $positions;
                                            echo '</p>';
                                        endif; ?>


                                        <?php
                                        $pdf_url = get_field('view_pdf');

                                        if (!empty($pdf_url)) {
                                            echo '<a href="' . esc_url($pdf_url) . '" class="viewbtn" target="_blank">View More</a>';
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>

                    <?php if ($testimonials_query->max_num_pages > 1): ?>
                        <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                            <div class="pagination-two">
                                <?php
                                echo paginate_links(array(
                                    'total' => $testimonials_query->max_num_pages,
                                    'current' => max(1, get_query_var('paged')),
                                    'format' => '?paged=%#%',
                                    'show_all' => false,
                                    'type' => 'plain',
                                    'prev_text' => '<i class="fa fa-arrow-left" aria-hidden="true"></i>',
                                    'next_text' => '<i class="fa fa-arrow-right" aria-hidden="true"></i>',
                                    'end_size' => 2,
                                    'mid_size' => 2
                                ));
                                ?>
                            </div>
                        </div>
                    <?php endif; ?>

                <?php else:
        echo 'No testimonials found.';
    endif;
    wp_reset_postdata();
    return ob_get_clean();
}
add_shortcode('testimonials', 'display_testimonials');


// blog list end------------




// woocommerce start 

function wpb_woocommerce_product_categories_accordion()
{
    // Get the current queried product category
    $queried_object = get_queried_object();
    $current_category_id = ($queried_object && isset($queried_object->term_id)) ? $queried_object->term_id : 0;

    // Get all parent categories of the current category
    $current_category_parents = [];
    if ($current_category_id) {
        $parent_categories = get_ancestors($current_category_id, 'product_cat');
        $current_category_parents = array_map('intval', $parent_categories);
    }

    // Recursive function to get subcategories with checkboxes
    function get_subcategories($parent_id, $level = 1, $current_category_id, $current_category_parents)
    {
        $args = array(
            'taxonomy' => 'product_cat',
            'orderby' => 'name',
            'order' => 'ASC',
            'parent' => $parent_id,
            'hide_empty' => false
        );
        $sub_categories = get_terms($args);

        if (!empty($sub_categories)) {
            echo '<ul class="list-unstyled ps-2">';
            foreach ($sub_categories as $sub_category) {
                $is_checked = ($sub_category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($sub_category->term_id == $current_category_id) ? 'current-category' : '';

                echo '<li class="' . $active_class . '">';
                echo '<div class="in-menu">';
                echo '<input type="checkbox" class="category-checkbox me-2" data-category-id="' . $sub_category->term_id . '" ' . $is_checked . '> ';

                echo '<a href="' . get_term_link($sub_category) . '">  <span class="customcheck"></span>' . $sub_category->name . '</a>';
                echo '</div>';
                get_subcategories($sub_category->term_id, $level + 1, $current_category_id, $current_category_parents);
                echo '</li>';
            }
            echo '</ul>';
        }
    }

    // Get main product categories (parent categories)
    $args = array(
        'taxonomy' => 'product_cat',
        'orderby' => 'name',
        'order' => 'ASC',
        'parent' => 0,
        'hide_empty' => false
    );
    $product_categories = get_terms($args);

    if ($product_categories) {
        ob_start();
        ?>
                    <div class="accordion" id="productCategoriesAccordion">

                        <?php
                        $shop_page_url = wc_get_page_permalink('shop');
                        $is_shop_page = is_shop();
                        ?>

                        <!-- <div class="accordion-item">
                    <div class="accordion-header <?php //echo $is_shop_page ? 'current-category' : ''; 
                            ?>">
                        <label>
                            <a href="<?php // echo esc_url($shop_page_url); 
                                    ?>" class="main-category">
                                All Product
                            </a>
                        </label>
                    </div>
                </div> -->


                        <?php
                        $i = 0;
                        foreach ($product_categories as $category) {
                            $i++;

                            // Check if the category has subcategories
                            $sub_args = array(
                                'taxonomy' => 'product_cat',
                                'parent' => $category->term_id,
                                'hide_empty' => true
                            );
                            $sub_categories = get_terms($sub_args);
                            $has_subcategories = !empty($sub_categories);

                            // Determine if this category should be expanded
                            $is_checked = ($category->term_id == $current_category_id) ? 'checked' : '';
                            $active_class = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'current-category' : '';
                            $show_collapse = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'show' : '';
                            ?>
                            <div class="accordion-item <?php echo $active_class; ?>">
                                <div class="accordion-header d-flex align-items-center" id="heading<?php echo $i; ?>">
                                    <label for="cat<?php echo $category->term_id; ?>">
                                        <input type="checkbox" class="category-checkbox me-2"
                                            id="cat<?php echo $category->term_id; ?>"
                                            data-category-id="<?php echo $category->term_id; ?>" <?php echo $is_checked; ?>>

                                        <a href="<?php echo get_term_link($category); ?>" class="main-category">
                                            <span class="customcheck"></span>
                                            <?php echo $category->name . ' <span class="count">(' . $category->count . ')</span>'; ?>
                                        </a>
                                    </label>

                                    <?php if ($has_subcategories) { ?>
                                        <button
                                            class="accordion-button ms-auto <?php echo ($show_collapse == '') ? 'collapsed' : ''; ?>"
                                            type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>"
                                            aria-expanded="<?php echo ($show_collapse) ? 'true' : 'false'; ?>"
                                            aria-controls="collapse<?php echo $i; ?>"
                                            data-category-id="<?php echo $category->term_id; ?>">
                                            <i class="fa fa-angle-down"></i>
                                        </button>
                                    <?php } ?>
                                </div>
                                <?php if ($has_subcategories) { ?>
                                    <div id="collapse<?php echo $i; ?>"
                                        class="accordion-collapse collapse <?php echo $show_collapse; ?>"
                                        aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#productCategoriesAccordion">
                                        <div class="accordion-body ps-0 pe-0">
                                            <?php get_subcategories($category->term_id, 1, $current_category_id, $current_category_parents); ?>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                            <?php
                        }
                        ?>
                    </div>

                    <script>
                        document.addEventListener("DOMContentLoaded", function () {
                            var savedCategories = JSON.parse(localStorage.getItem("checkedCategories")) || [];

                            savedCategories.forEach(function (categoryId) {
                                var checkbox = document.querySelector('.category-checkbox[data-category-id="' + categoryId + '"]');
                                if (checkbox) {
                                    checkbox.checked = true;
                                }
                            });

                            document.querySelectorAll(".category-checkbox").forEach(function (checkbox) {
                                checkbox.addEventListener("change", function () {
                                    var categoryId = this.getAttribute("data-category-id");
                                    if (this.checked) {
                                        if (!savedCategories.includes(categoryId)) {
                                            savedCategories.push(categoryId);
                                        }
                                    } else {
                                        savedCategories = savedCategories.filter(id => id !== categoryId);
                                    }
                                    localStorage.setItem("checkedCategories", JSON.stringify(savedCategories));
                                });
                            });

                            var activeCategory = localStorage.getItem("activeCategory");
                            if (activeCategory) {
                                var activeAccordion = document.querySelector('[data-category-id="' + activeCategory + '"]');
                                if (activeAccordion) {
                                    var collapseElement = activeAccordion.getAttribute("data-bs-target");
                                    document.querySelector(collapseElement).classList.add("show");
                                    activeAccordion.classList.remove("collapsed");
                                    activeAccordion.setAttribute("aria-expanded", "true");
                                }
                            }

                            document.querySelectorAll(".accordion-button").forEach(function (button) {
                                button.addEventListener("click", function () {
                                    var categoryId = this.getAttribute("data-category-id");
                                    if (document.querySelector(this.getAttribute("data-bs-target")).classList.contains("show")) {
                                        localStorage.removeItem("activeCategory");
                                    } else {
                                        localStorage.setItem("activeCategory", categoryId);
                                    }
                                });
                            });
                        });
                    </script>

                    <style>
                        .current-category>a {
                            font-weight: bold;
                            color: #ff6600;
                        }

                        .category-checkbox {
                            display: none;
                        }

                        span.customcheck {
                            background: #FFFFFF 0% 0% no-repeat padding-box;
                            border: 1px solid #BEC0C5;
                            border-radius: 0px;
                            width: 15px;
                            height: 15px;
                            position: relative;
                            margin-right: 2px;
                            margin-top: 0px;
                            top: 2px;
                            display: none;
                        }

                        .current-category [type=checkbox]:checked~a span.customcheck {
                            background: #BEC0C5;
                            border-color: #BEC0C5;
                        }

                        .current-category [type=checkbox]~a .customcheck:after {
                            content: "";
                            position: absolute;
                        }

                        .current-category a input:checked~.customcheck:after {
                            display: block;
                        }

                        .current-category a .customcheck:after {
                            left: 5px;
                            top: 2px;
                            width: 4px;
                            height: 8px;
                            border: solid white;
                            border-width: 0 2px 2px 0;
                            -webkit-transform: rotate(45deg);
                            -ms-transform: rotate(45deg);
                            transform: rotate(45deg);
                        }
                    </style>
                    <?php
                    return ob_get_clean();
    }
}

add_shortcode('product_categories_accordion', 'wpb_woocommerce_product_categories_accordion');

// product category for sidebar end -------------------------------


// Wrap WooCommerce product image in a div start ----------
add_action('woocommerce_before_shop_loop_item_title', 'wrap_product_image_in_div', 5);
function wrap_product_image_in_div()
{
    echo '<div class="custom-image-wrapper">';
}
add_action('woocommerce_before_shop_loop_item_title', 'close_product_image_div', 15);
function close_product_image_div()
{
    echo '</div>';
}
// Wrap WooCommerce product image in a div end ----------



add_action('woocommerce_before_shop_loop_item_title', 'custom_view_product_button', 20);
function custom_view_product_button()
{
    global $product;

    // Get product info
    $product_id = $product->get_id();
    $add_to_cart_url = esc_url($product->add_to_cart_url());
    $add_to_cart_text = esc_html($product->add_to_cart_text());
    $product_type = $product->get_type();

    echo '<div class="custom-view-button">';

    // Add to Cart Button
    echo '<div class="animated-btn">';
    echo apply_filters(
        'woocommerce_loop_add_to_cart_link',
        sprintf(
            '<a href="%s" data-quantity="1" class="button %s" data-product_id="%s" data-product_sku="%s" aria-label="%s" rel="nofollow">
                <img src="https://draftsite1.com/shen-yi-engineering/wp-content/uploads/2025/05/Cart-1.svg" class="carticon">
            </a>',
            $add_to_cart_url,
            esc_attr(implode(' ', array_filter([
                'product_type_' . $product_type,
                'add_to_cart_button',
                ($product->supports('ajax_add_to_cart') ? 'ajax_add_to_cart' : '')
            ]))),
            esc_attr($product_id),
            esc_attr($product->get_sku()),
            esc_attr($add_to_cart_text)
        ),
        $product
    );
    echo '</div>';

    // View Product Button
    echo '<div class="animated-btn">';
    echo '<a href="' . esc_url(get_permalink($product_id)) . '" class="view-product-link elementor-button">
            <i class="fas fa-arrow-right"></i>
          </a>';
    echo '</div>';

    echo '</div>';
}



function MILESTONE()
{
    ob_start();
    ?>

                <div class="timeline-slider ps-2 pe-2">
                    <div class="timeline-item top">
                        <div class="year">2003</div>
                        <h3>Founded</h3>
                        <p>Established with a vision to deliver cutting-edge control and automation solutions.</p>
                    </div>

                    <div class="timeline-item bottom">
                        <div class="year">2005</div>
                        <h3>First Major Project</h3>
                        <p>Completed a large-scale process control system for the water treatment industry.</p>
                    </div>

                    <div class="timeline-item top">
                        <div class="year">2010</div>
                        <h3>Expansion</h3>
                        <p>Expertise in Wafer FAB chemical & slurry systems, shutdown systems, and safety systems.</p>
                    </div>

                    <div class="timeline-item bottom">
                        <div class="year">2015</div>
                        <h3>Global Reach</h3>
                        <p>Executed projects across Asia, the Middle East, and South America.</p>
                    </div>

                    <div class="timeline-item top">
                        <div class="year">2020</div>
                        <h3>Expansion</h3>
                        <p>Expertise in Wafer FAB chemical & slurry systems, shutdown systems, and safety systems.</p>
                    </div>

                    <div class="timeline-item bottom">
                        <div class="year">2025</div>
                        <h3>Global Reach</h3>
                        <p>Executed projects across Asia, the Middle East, and South America.</p>
                    </div>

                </div>

                <script>
                    jQuery(document).ready(function ($) {
                        $('.timeline-slider').slick({
                            slidesToShow: 4,
                            slidesToScroll: 1,
                            arrows: true,
                            dots: false,
                            prevArrow: '<div class="left-btn arrowbtn"><i class="fa fa-arrow-left"></i></div>',
                            nextArrow: '<div class="right-btn arrowbtn"><i class="fa fa-arrow-right"></i></div>',
                            responsive: [
                                {
                                    breakpoint: 768,
                                    settings: {
                                        slidesToShow: 1
                                    }
                                }
                            ]
                        });
                    });
                </script>

                <?php
                return ob_get_clean();
}
add_shortcode('MILESTONE', 'MILESTONE');





// milestone slider start 
function display_milestone_slider($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => -1,
        ),
        $atts,
        'milestone'
    );

    $args = array(
        'post_type' => 'milestone',
        'posts_per_page' => $atts['posts_per_page'],
        'orderby' => 'date',
        'order' => 'ASC', // ascending order (oldest to newest)
    );

    $milestone_query = new WP_Query($args);

    ob_start();

    if ($milestone_query->have_posts()): ?>
                    <div class="timeline-slider ps-2 pe-2">
                        <?php while ($milestone_query->have_posts()):
                            $milestone_query->the_post();
                            ?>

                            <div class="timeline-item ms-1 me-1 bottom" id="<?php echo get_the_ID(); ?>">

                                <?php
                                $year = get_field('year');
                                if ($year):
                                    echo '<div class="year">';
                                    echo $year;
                                    echo '</div>';
                                endif; ?>

                                <h3><?php echo get_the_title(); ?> </h3>
                                <p> <?php echo get_the_content(); ?> </p>
                            </div>

                        <?php endwhile; ?>
                    </div>

                    <script>
                        jQuery(document).ready(function ($) {
                            $('.timeline-slider').slick({
                                slidesToShow: 4,
                                slidesToScroll: 1,
                                arrows: true,
                                dots: false,
                                prevArrow: '<div class="left-btn arrowbtn"><i class="fa fa-arrow-left"></i></div>',
                                nextArrow: '<div class="right-btn arrowbtn"><i class="fa fa-arrow-right"></i></div>',
                                responsive: [
                                    {
                                        breakpoint: 768,
                                        settings: {
                                            slidesToShow: 1
                                        }
                                    }
                                ]
                            });
                        });
                    </script>

                <?php else:
        echo 'No milestone found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('milestone_slider', 'display_milestone_slider');
// milestone slider end ------------------------------
