<?php get_header(); ?>
<div class="portfolio-detail">
    <div class="container">
        <div class="row g-md-5 g-3 justify-content-center">
            <div class="col-lg-5">
                <?php
                if (have_posts()):
                    while (have_posts()):
                        the_post();
                        ?>
                        <div class="content-area">
                            <div class="content-area">
                                <h1 class="title"><?php echo the_title(); ?></h1>
                                <div class="desription">
                                    <?php the_content(); ?>
                                </div>
                                <div class="wrapitem">

                                    <div class="wrap">
                                        <?php
                                        $location = get_field('location');
                                        if ($location):
                                            echo '  <p class="other-title"> Location </p>';
                                            echo '<p class="other-text mb-0">';
                                            echo $location;
                                            echo '</p>';
                                        endif; ?>
                                    </div>
                                    <div class="wrap">
                                        <?php
                                        $project = get_field('project');
                                        if ($project):
                                            echo '  <p class="other-title"> Project </p>';
                                            echo '<p class="other-text mb-0">';
                                            echo $project;
                                            echo '</p>';
                                        endif; ?>
                                    </div>
                                    <div class="wrap">
                                        <?php
                                        $year = get_field('year');
                                        if ($year):
                                            echo '  <p class="other-title"> Year </p>';
                                            echo '<p class="other-text mb-0">';
                                            echo $year;
                                            echo '</p>';
                                        endif; ?>
                                    </div>

                                </div>
                            </div>
                        </div>
                    <?php endwhile; else:
                    echo 'No post found.'; ?>

                    <?php
                    wp_reset_postdata();
                endif;
                ?>
            </div>
            <div class="col-md-6">
                <div class="img-wrap">
                    <?php if (has_post_thumbnail()) {
                        the_post_thumbnail('full', array('class' => 'd-block w-100'));
                    } ?>
                </div>
            </div>
            <div class="col-lg-11">
                <div class="row g-3">
                    <?php 
                    $portfolio_gallery = get_field('portfolio_gallery', get_the_ID());
                    if (!empty($portfolio_gallery)): ?>

                        <?php foreach ($portfolio_gallery as $row):
                            $image_url = $row['gallery_image']; // Direct image URL if return format is 'URL'
                            if (!empty($image_url)): ?>
                                <div class="col-md-4">
                                    <div class="img-wraps">
                                        <img src="<?php echo esc_url($image_url); ?>" alt="" class="w-100">
                                    </div>
                                </div>
                            <?php endif;
                        endforeach; ?>
                    <?php  endif; ?>
            </div>

            <div class="d-block pt-5 text-center">
                <a href="<?php echo esc_url(home_url('portfolio')); ?>" class="btn-back"> Back </a>
            </div>
        </div>
    </div>
</div>
</div>

<?php get_footer(); ?>