<?php
// Enqueue the parent theme's stylesheet

function hello_elementor_child_enqueue_styles()
{
    wp_enqueue_style('hello-elementor-parent-style', get_template_directory_uri() . '/../hello-elementor-child/style.css');
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles');


// Enqueue Booststrap 
function enqueue_bootstrap()
{
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');

//  Slick carousel script and styles
function enqueue_slick_scripts()
{
    //  Slick carousel script
    wp_enqueue_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js', array('jquery'), null, true);
    //  Slick carousel CSS
    wp_enqueue_style('slick-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_slick_scripts');

function custom_inline_footer_script()
{
    ?>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const toggleButtons = document.querySelectorAll(".form-buttontoggle");
            const enqForms = document.querySelectorAll(".enq-form");

            toggleButtons.forEach(function (button) {
                button.addEventListener("click", function () {
                    enqForms.forEach(function (form) {
                        form.classList.toggle("open-enq-form");
                    });
                });
            });
        });
    </script>

    <script>
        window.addEventListener("scroll", function () {
            var header = document.getElementById("masthead");
            if (window.scrollY > 0) { // you can change '0' to any pixel value
                header.classList.add("fixed");
            } else {
                header.classList.remove("fixed");
            }
        });
    </script>
    <?php
}
add_action('wp_footer', 'custom_inline_footer_script', 100);



// custom code



// Home slider Start --------------------------------------------
function display_banner_home($atts)
{
    $args = array(
        'post_type' => 'main-slider',
    );

    $mainslider_query = new WP_Query($args);

    ob_start();

    if ($mainslider_query->have_posts()):
        $total_slides = $mainslider_query->post_count;
        ?>
        <div class="home-banner">
            <div id="demo" class="carousel slide hero-banner" data-bs-ride="carousel">
                <div class="carousel-inner">
                    <?php
                    $first = true;
                    while ($mainslider_query->have_posts()):
                        $mainslider_query->the_post(); ?>

                        <div class="carousel-item <?php echo $first ? 'active' : ''; ?>">

                            <?php if (has_post_thumbnail()) {
                                the_post_thumbnail('full', array('class' => 'd-block w-100'));
                            } ?>

                            <div class="carousel-caption">
                                <h1><?php the_title(); ?></h1>
                                <p><?php the_content(); ?></p>

                                <div class="btnlight pt-3">
                                    <?php
                                    $links = get_field('button_link');
                                    if ($links) {
                                        $link_url = $links['url'];
                                        $link_title = $links['title'];
                                        ?>
                                        <a href="<?php echo esc_url($link_url); ?>" class="elementor-button">
                                            <span> <?php echo esc_html($link_title); ?>
                                                <img src="https://draftsite1.com/t2960/wp-content/uploads/2025/07/arrow-right.svg"
                                                    alt="" class="ms-2">
                                            </span>
                                        </a>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                        <?php
                        $first = false;
                    endwhile; ?>
                </div>

                <!-- Indicators/dots -->
                <?php if ($total_slides > 1): ?>
                    <div class="carousel-indicators">
                        <?php for ($i = 0; $i < $total_slides; $i++): ?>
                            <div class="carousel-btn">
                                <button type="button" data-bs-target="#demo" data-bs-slide-to="<?php echo $i; ?>"
                                    class="<?php echo $i === 0 ? 'active' : ''; ?>">
                                    <span> <?php echo str_pad($i + 1, 2, '0', STR_PAD_LEFT); ?> </span>
                                </button>
                            </div>
                        <?php endfor; ?>
                    </div>
                <?php endif; ?>

                <?php /* if ($total_slides > 1): ?>
                                                                                                          <span class="carousel-control-prev" data-bs-target="#demo" data-bs-slide="prev">
                                                                                                          <
                                                                                                          </span>
                                                                                                          <span class="carousel-control-next" data-bs-target="#demo" data-bs-slide="next">
                                                                                                          >
                                                                                                          </span>
                                                                                                      <?php endif; */ ?>

            </div>
        </div>

    <?php else: ?>
        <div>No Slider found.</div>
    <?php endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('banner_home', 'display_banner_home');


// Home slider end --------------------------------------------



// downloads list ---------

function display_downloads($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
        ),
        $atts,
        'downloads'
    );

    $paged = (get_query_var('paged')) ? get_query_var('paged') : (get_query_var('page') ? get_query_var('page') : 1);


    // Get current page
    $args = array(
        'post_type' => 'download',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => $paged,
        'orderby' => 'date',
        'order' => 'DESC',
    );


    // Start Query
    $downloads_query = new WP_Query($args);
    ob_start();
    if ($downloads_query->have_posts()): ?>
        <div class="downloads-page">
            <div class="row g-md-5 g-3">
                <?php while ($downloads_query->have_posts()):
                    $downloads_query->the_post();
                    $pdf_url = get_field('pdf');
                    ?>
                    <div class="col-lg-4 col-md-6 col-sm-6 col-6">
                        <?php if (!empty($pdf_url)): ?>

                            <div class="downloads-box" data-post-id="<?php echo get_the_ID(); ?>">
                                <a href="<?php echo esc_url($pdf_url); ?>" target="_blank">
                                    <div class="img-box text-center">
                                        <img src="https://draftsite1.com/t2960/wp-content/uploads/2025/07/icon-pdf.svg" alt=""
                                            class="img-fluid">
                                        <div class="overlay">
                                            <img src="https://draftsite1.com/t2960/wp-content/uploads/2025/07/icon-popup.svg" alt=""
                                                class="" width="60">
                                        </div>
                                    </div>
                                    <div class="downloads-text">
                                        <h5 class="title mt-3"><?php echo get_the_title(); ?></h5>
                                    </div>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endwhile; ?>
            </div>
        </div>


        <?php if ($downloads_query->max_num_pages > 1): ?>
            <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                <div class="pagination-two">
                    <?php
                    echo paginate_links(array(
                        'total' => $downloads_query->max_num_pages,
                        'current' => max(1, get_query_var('paged')),
                        'format' => '?paged=%#%',
                        'show_all' => false,
                        'type' => 'plain',
                        'prev_text' => '<img src="https://draftsite1.com/t2960/wp-content/uploads/2025/07/arrow-next.png" alt="Previous" style="transform: rotate(180deg);">',
                        'next_text' => '<img src="https://draftsite1.com/t2960/wp-content/uploads/2025/07/arrow-next.png" alt="Next">',
                        'end_size' => 2,
                        'mid_size' => 2
                    ));
                    ?>
                </div>
            </div>
        <?php endif; ?>
    <?php

    else:
        echo 'No downloads found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('downloads_materials', 'display_downloads');

// downloads end ---------




// video library start ----------------

function display_videolibrary($atts)
{

    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
        ),
        $atts,
        'video'
    );

    // Get the current page

    $args = array(
        'post_type' => 'video',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );


    $videolibrary_query = new WP_Query($args);

    ob_start();

    if ($videolibrary_query->have_posts()): ?>
        <div class="video-page video-main">
            <div class="row g-md-5 g-3">
                <?php while ($videolibrary_query->have_posts()):
                    $videolibrary_query->the_post();
                    ?>

                    <div class="col-lg-4 col-md-6 col-sm-6 col-6">
                        <div class="video-box" data-post-id="<?php echo get_the_ID(); ?>" data-bs-toggle="modal"
                            data-bs-target="#videoModal<?php echo get_the_ID(); ?>">
                            <div class="img-box text-center">
                                <?php
                                $video_url = get_field('video_url');
                                $video_file = get_field('upload_video');
                                ?>
                                <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'd-block w-100 featured'));
                                    } elseif ($video_url) {
                                    $autoplay_url = add_query_arg([
                                        'autoplay' => 1,
                                        'mute' => 1,
                                    ], $video_url);

                                    echo wp_oembed_get($autoplay_url);
                                } elseif ($video_file) {
                                    echo '<video autoplay width="100%" preload="metadata">';
                                    echo '<source src="' . esc_url($video_file) . '" type="video/mp4">';
                                    echo 'Your browser does not support the video tag.';
                                    echo '</video>';
                                } ?>
                                <img src="https://draftsite1.com/t2960/wp-content/uploads/2025/07/icon-playvideo.svg" alt=""
                                    class="play-button" width="60">
                            </div>
                            <div class="video-text">
                                <h5 class="title mt-3"><?php echo get_the_title(); ?></h5>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>

            <?php while ($videolibrary_query->have_posts()):
                $videolibrary_query->the_post();
                ?>
                <div class="modal fade" id="videoModal<?php echo get_the_ID(); ?>">
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    <div class="modal-dialog modal-dialog-centered modal-lg bg-transparent rounded-0 border-0">
                        <div class="modal-content bg-transparent rounded-0 border-0">
                            <div class="modal-body p-0 bg-transparent rounded-0 border-0">
                                <?php
                                $video_url = get_field('video_url');
                                $video_file = get_field('upload_video');
                                ?>
                                <?php if ($video_url) {
                                    // Add autoplay and mute parameters to the YouTube URL
                                    $autoplay_url = add_query_arg([
                                        'autoplay' => 1,
                                        'mute' => 1,
                                    ], $video_url);

                                    echo wp_oembed_get($autoplay_url);
                                } elseif ($video_file) {
                                    echo '<video autoplay muted width="100%" preload="metadata">';
                                    echo '<source src="' . esc_url($video_file) . '" type="video/mp4">';
                                    echo 'Your browser does not support the video tag.';
                                    echo '</video>';
                                } ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>



        </div>

        <?php if ($videolibrary_query->max_num_pages > 1): ?>
            <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                <div class="pagination-two">

                    <a class="prev page-numbers" href="<?php echo get_pagenum_link(max(1, get_query_var('paged') - 1)); ?>">
                        <img src="https://draftsite1.com/t2960/wp-content/uploads/2025/07/arrow-next.png" alt="Previous"
                            style="transform:rotate(180deg);">
                    </a>

                    <?php
                    echo paginate_links(array(
                        'total' => $videolibrary_query->max_num_pages,
                        'current' => max(1, get_query_var('paged')),
                        'format' => '?paged=%#%',
                        'show_all' => false,
                        'type' => 'plain',
                        'prev_next' => false,
                        'end_size' => 2,
                        'mid_size' => 2
                    ));
                    ?>

                    <a class="next page-numbers"
                        href="<?php echo get_pagenum_link(min($videolibrary_query->max_num_pages, get_query_var('paged') + 1)); ?>">
                        <img src="https://draftsite1.com/t2960/wp-content/uploads/2025/07/arrow-next.png" alt="Next">
                    </a>
                </div>
            </div>

        <?php endif; ?>

    <?php else:
        echo 'No video library found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('video_library', 'display_videolibrary');


// video library end ----------------


// blog page start ------------------------------------------------------------

function display_blog($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'blog'
    );

    // Selected category
    $selected_category = isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '';

    // WP_Query args
    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );

    if (!empty($selected_category)) {
        $args['category_name'] = $selected_category;
    }

    // Get blog categories
    $categories = get_categories();

    if (!empty($categories)): ?>
        <div class="text-start">
            <div id="category-filter-list" class="blog-filter">
                <?php foreach ($categories as $category):
                    $active_class = ($atts['category'] === $category->slug) ? 'active' : '';
                    ?>
                    <li>
                        <a href="<?php echo esc_url(add_query_arg('category', $category->slug, home_url('/blog'))); ?>"
                            class="filter-btn <?php echo esc_attr($active_class); ?>">
                            <?php echo esc_html($category->name); ?>
                        </a>
                    </li>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif;

    $blog_query = new WP_Query($args);

    ob_start();

    if ($blog_query->have_posts()): ?>
        <div class="blog-page blog-main">
            <div class="row g-md-4 g-3">
                <?php while ($blog_query->have_posts()):
                    $blog_query->the_post(); ?>

                    <div class="col-lg-4 col-md-6 col-sm-6">
                        <div class="news-box" data-post-id="<?php echo get_the_ID(); ?>">
                            <a href="<?php the_permalink(); ?>">
                                <div class="img-box">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('full', array('class' => 'featured d-block w-100'));
                                    } ?>

                                    <?php
                                    $terms = get_the_terms(get_the_ID(), 'category');
                                    if ($terms && !is_wp_error($terms)) { ?>
                                        <?php
                                        foreach ($terms as $term) {
                                            $category_name = strtolower($term->name); ?>

                                            <span class="badge"><?php echo $category_name; ?></span>

                                            <?php
                                        } ?>
                                    <?php }
                                    ?>

                                </div>
                                <div class="news-text">
                                    <h5 class="title"> <?php echo get_the_title(); ?> </h5>
                                    <p class="description">
                                        <?php echo get_the_excerpt(); ?>
                                    </p>
                                    <div class="animated-btn">Learn More <img
                                            src="https://draftsite1.com/t2960/wp-content/uploads/2025/07/arrow-right.svg" alt="">
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
        </div>

        <?php if ($blog_query->max_num_pages > 1): ?>
            <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                <div class="pagination-two">

                    <a class="prev page-numbers" href="<?php echo get_pagenum_link(max(1, get_query_var('paged') - 1)); ?>">
                        <img src="https://draftsite1.com/t2960/wp-content/uploads/2025/07/arrow-next.png" alt="Previous"
                            style="transform:rotate(180deg);">
                    </a>

                    <?php
                    echo paginate_links(array(
                        'total' => $blog_query->max_num_pages,
                        'current' => max(1, get_query_var('paged')),
                        'format' => '?paged=%#%',
                        'show_all' => false,
                        'type' => 'plain',
                        'prev_next' => false,
                        'end_size' => 2,
                        'mid_size' => 2
                    ));
                    ?>

                    <a class="next page-numbers"
                        href="<?php echo get_pagenum_link(min($blog_query->max_num_pages, get_query_var('paged') + 1)); ?>">
                        <img src="https://draftsite1.com/t2960/wp-content/uploads/2025/07/arrow-next.png" alt="Next">
                    </a>
                </div>
            </div>

        <?php endif;

    else:
        echo 'No blog found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('blog', 'display_blog');



// testimonials start
function display_testimonials($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
        ),
        $atts,
        'testimonials'
    );

    // WP_Query args
    $args = array(
        'post_type' => 'our-testimonials',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );


    $testimonials_query = new WP_Query($args);

    ob_start();

    if ($testimonials_query->have_posts()): ?>
        <div class="testimonials-page testimonials-main">
            <div class="row g-md-4 g-3">
                <?php while ($testimonials_query->have_posts()):
                    $testimonials_query->the_post(); ?>

                    <div class="col-lg-4 col-md-6 col-sm-6 mb-5 pb-4">
                        <div class="testimonials-box" id="<?php echo get_the_ID(); ?>">
                            <div class="quote"><span>”</span></div>
                            <p class="mb-5">
                                <?php the_content(); ?>
                            </p>
                            <div class="user-details text-white d-flex align-items-center pt-3">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'featured d-block w-100'));
                                } ?>
                                <div class="ps-3">
                                    <h4 class="mb-0 mt-0"><?php echo get_the_title(); ?></h4>

                                    <?php
                                    $position = get_field('position');
                                    if ($position):
                                        echo '<small class="sub-title">';
                                        echo $position;
                                        echo '</small>';
                                    endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                <?php endwhile; ?>
            </div>
        </div>

        <?php if ($testimonials_query->max_num_pages > 1): ?>
            <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                <div class="pagination-two">

                    <a class="prev page-numbers" href="<?php echo get_pagenum_link(max(1, get_query_var('paged') - 1)); ?>">
                        <img src="https://draftsite1.com/t2960/wp-content/uploads/2025/07/arrow-next.png" alt="Previous"
                            style="transform:rotate(180deg);">
                    </a>

                    <?php
                    echo paginate_links(array(
                        'total' => $testimonials_query->max_num_pages,
                        'current' => max(1, get_query_var('paged')),
                        // 'format' => '?paged=%#%',
                        'format' => 'page/%#%',
                        'show_all' => false,
                        'type' => 'plain',
                        'prev_next' => false,
                        'end_size' => 2,
                        'mid_size' => 2
                    ));
                    ?>

                    <a class="next page-numbers"
                        href="<?php echo get_pagenum_link(min($testimonials_query->max_num_pages, get_query_var('paged') + 1)); ?>">
                        <img src="https://draftsite1.com/t2960/wp-content/uploads/2025/07/arrow-next.png" alt="Next">
                    </a>
                </div>
            </div>

        <?php endif;

    else:
        echo 'No testimonials found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('testimonials', 'display_testimonials');



// Product Featured start -----------

function display_product_featured_ajax($atts)
{
    ob_start();

    $atts = shortcode_atts(
        array(
            'posts_per_page' => 4,
        ),
        $atts,
        'product_featured_ajax'
    );

    // ✅ Get featured categories
    $all_categories = get_terms(array(
        'taxonomy' => 'eproducts-category',
        'hide_empty' => true,
        'parent' => 0,
    ));

    $categories = array();
    $default_category = ''; // First featured slug

    if (!is_wp_error($all_categories)) {
        foreach ($all_categories as $term) {
            $is_featured = get_term_meta($term->term_id, 'featured_category', true);
            if ($is_featured == '1') {
                $categories[] = $term;
                if (empty($default_category)) {
                    $default_category = $term->slug; // Set first featured category
                }
            }
        }
    }

    ?>

    <div class="featured-products">
        <!-- Filter Buttons -->
        <ul class="mb-5 filter">
            <?php foreach ($categories as $category): ?>
                <li>
                    <button class="cats filter-btn <?php echo ($category->slug === $default_category) ? 'active' : ''; ?>"
                        data-category="<?php echo esc_attr($category->slug); ?>">
                        <?php echo esc_html($category->name); ?>
                    </button>
                </li>
            <?php endforeach; ?>
        </ul>

        <!-- Product Grid -->
        <div id="featured-products-list">
            <?php echo display_featured_products_html($default_category, $atts['posts_per_page']); ?>
        </div>
    </div>

    <?php
    return ob_get_clean();
}
add_shortcode('product_featured_ajax', 'display_product_featured_ajax');




function display_featured_products_html($category_slug = '', $limit = 4)
{
    $args = array(
        'post_type' => 'product-enquiry',
        'posts_per_page' => $limit,
        'orderby' => 'date',
        'order' => 'DESC',
        'meta_query' => array(
            array(
                'key' => '_is_ns_featured_post',
                'value' => 'yes',
                'compare' => '='
            )
        )
    );

    if (!empty($category_slug)) {
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'eproducts-category',
                'field' => 'slug',
                'terms' => $category_slug,
            )
        );
    }

    $query = new WP_Query($args);
    ob_start();

    if ($query->have_posts()) {
        echo '<div class="row g-md-4 g-3">';
        while ($query->have_posts()) {
            $query->the_post(); ?>
            <div class="col-lg-3 col-md-3" id="post-<?php the_ID(); ?>">
                <a href="<?php the_permalink(); ?>">
                    <div class="product-card">
                        <div class="img-box">
                            <?php if (has_post_thumbnail())
                                the_post_thumbnail('full'); ?>
                            <div class="hover-overlay">
                                <i class="icon icon-plus" aria-hidden="true"></i>
                            </div>
                        </div>
                        <h6 class="mt-2 product-name"><?php the_title(); ?></h6>
                        <?php if ($price = get_field('price')): ?>
                            <p class="price">$<?php echo esc_html($price); ?></p>
                        <?php endif; ?>
                    </div>
                </a>
            </div>
        <?php }
        echo '</div>';
    } else {
        echo '<p>No featured products found.</p>';
    }

    wp_reset_postdata();
    return ob_get_clean();
}


add_action('wp_ajax_filter_featured_products', 'ajax_filter_featured_products');
add_action('wp_ajax_nopriv_filter_featured_products', 'ajax_filter_featured_products');
function ajax_filter_featured_products()
{
    $category = isset($_POST['category']) ? sanitize_text_field($_POST['category']) : '';
    $limit = isset($_POST['limit']) ? intval($_POST['limit']) : 4;

    echo display_featured_products_html($category, $limit);
    wp_die();
}


function enqueue_featured_product_filter_script()
{
    wp_enqueue_script(
        'featured-products-filter',
        get_template_directory_uri() . '/../hello-elementor-child/featured-products-filter.js',
        array('jquery'),
        null,
        true
    );

    wp_localize_script('featured-products-filter', 'ajax_filter', array(
        'ajax_url' => admin_url('admin-ajax.php'),
    ));
}
add_action('wp_enqueue_scripts', 'enqueue_featured_product_filter_script');

// Product Featured end -----------



// page query product-----
function custom_products_tax_posts_per_page($query)
{
    if (
        !is_admin() &&
        $query->is_main_query() &&
        is_tax('eproducts-category')
    ) {
        $query->set('posts_per_page', 8);
    }
}
add_action('pre_get_posts', 'custom_products_tax_posts_per_page');

// page query product-----





// session for catalogue page start -------------------------------
// Initialize the session if not already started
function start_session()
{
    if (!session_id()) {
        session_start();
    }
}
add_action('init', 'start_session');

// Handle AJAX request to add an item to the quote list
function add_to_quote()
{
    $post_id = intval($_POST['post_id']);
    $quantity = intval($_POST['quantity']);

    // Initialize the quote list if not already present
    if (!isset($_SESSION['quote_list'])) {
        $_SESSION['quote_list'] = array();
    }

    // Check if the item is already in the quote list
    if (isset($_SESSION['quote_list'][$post_id])) {
        $_SESSION['quote_list'][$post_id] += $quantity;
    } else {
        $_SESSION['quote_list'][$post_id] = $quantity;
    }

    wp_die(); // End AJAX request
}
add_action('wp_ajax_add_to_quote', 'add_to_quote');
add_action('wp_ajax_nopriv_add_to_quote', 'add_to_quote');

// session for catalogue page end -------------------------------

// submit catalogue form  in email start -------------------------------

function submit_quote_request()
{
    $name = sanitize_text_field($_POST['name']);
    $email = sanitize_email($_POST['email']);
    $message = sanitize_textarea_field($_POST['message']);
    $quote_list = isset($_SESSION['quote_list']) ? $_SESSION['quote_list'] : array();

    $subject = 'New Quote Request from ' . $name;
    $body = "Name: $name\n";
    $body .= "Email: $email\n\n";
    $body .= "Message: $message\n\n";
    $body .= "Quote Items:\n\n";

    foreach ($quote_list as $post_id => $quantity) {
        $post = get_post($post_id);
        if ($post) {
            $body .= get_the_title($post_id) . " (Quantity: $quantity)\n";
        }
    }

    // wp_mail(get_option('admin_email'), $subject, $body);
    wp_mail('sonu.starwebindia@gmail.com', $subject, $body);

    // Clear the quote list after submission
    $_SESSION['quote_list'] = array();

    // wp_redirect(home_url('/thank-you/')); // Change this to your thank you page URL

    wp_redirect(add_query_arg('quote_submitted', '1', wp_get_referer()));

    
    exit;
}
add_action('admin_post_submit_quote_request', 'submit_quote_request');
add_action('admin_post_nopriv_submit_quote_request', 'submit_quote_request');

// submit catalogue form  in email end -------------------------------



//  catalogue quantity start -------------------------------

// Handle AJAX request to update the quantity of an item in the quote list
function update_quote_quantity()
{
    $post_id = intval($_POST['post_id']);
    $quantity = intval($_POST['quantity']);

    // Update the quantity in the session
    if (isset($_SESSION['quote_list'][$post_id])) {
        $_SESSION['quote_list'][$post_id] = $quantity;
    }

    wp_die(); // End AJAX request
}
add_action('wp_ajax_update_quote_quantity', 'update_quote_quantity');
add_action('wp_ajax_nopriv_update_quote_quantity', 'update_quote_quantity');

// Handle AJAX request to remove an item from the quote list
function remove_from_quote()
{
    $post_id = intval($_POST['post_id']);

    // Remove the item from the session
    if (isset($_SESSION['quote_list'][$post_id])) {
        unset($_SESSION['quote_list'][$post_id]);
    }

    wp_die(); // End AJAX request
}
add_action('wp_ajax_remove_from_quote', 'remove_from_quote');
add_action('wp_ajax_nopriv_remove_from_quote', 'remove_from_quote');

//  Enquiry Product end -------------------------------


// counter  

function custom_counter_inline_script()
{ ?>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            function setupRollingCounter(containerSelector, padLength) {
                const container = document.querySelector(containerSelector);
                if (!container) {
                    console.warn(`Container ${containerSelector} not found.`);
                    return;
                }

                const target = container.getAttribute('data-target').padStart(padLength, '0');
                const digits = [];

                for (let i = 0; i < padLength; i++) {
                    const box = document.createElement('div');
                    box.classList.add(`digit-${containerSelector.slice(-4)}`);

                    const roller = document.createElement('div');
                    roller.classList.add(`roller-${containerSelector.slice(-4)}`);

                    let numbers = [];

                    if (i === 0) {
                        numbers = ['0', '1', target[i]];
                    } else {
                        numbers.push('0');
                        for (let j = 0; j < 5; j++) {
                            numbers.push(String(Math.floor(Math.random() * 10)));
                        }
                        numbers.push(target[i]);
                    }

                    numbers.forEach(n => {
                        const span = document.createElement('span');
                        span.textContent = n;
                        roller.appendChild(span);
                    });

                    box.appendChild(roller);
                    container.appendChild(box);

                    digits.push({
                        wrapper: roller,
                        count: numbers.length,
                        height: 0
                    });
                }

                setTimeout(() => {
                    digits.forEach(d => {
                        d.height = d.wrapper.querySelector('span').offsetHeight;
                    });

                    let direction = 'forward';

                    function animate() {
                        digits.forEach(d => {
                            const offset = direction === 'forward' ? -(d.count - 1) * d.height : 0;
                            d.wrapper.style.transition = 'transform 4s ease-in-out';
                            d.wrapper.style.transform = `translateY(${offset}px)`;
                        });

                        direction = direction === 'forward' ? 'backward' : 'forward';
                    }

                    animate();

                    setInterval(() => {
                        animate();
                    }, 7000);
                }, 300);
            }

            // Run for each counter with their pad lengths
            setupRollingCounter('.rolling-counter-2012', 2);
            setupRollingCounter('.rolling-counter-2013', 3);
            setupRollingCounter('.rolling-counter-2014', 3);
        });
    </script>
<?php }
add_action('wp_footer', 'custom_counter_inline_script');


// counter end 


?>