<?php
/**
 * Template Name: Cart Page
 */

get_header();

?>

<div id="primary" class="content-area">
    <main id="main" class="site-main pt-md-5 pt-4 pb-md-5 pb-4">
        <?php
        $quote_list = isset($_SESSION['quote_list']) ? $_SESSION['quote_list'] : array();

        if (!empty($quote_list)): ?>
            <form id="quoteForm" method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="product-enquiry">
                                <h2 class="page-title mb-5 pb-3 text-start">Product Enquiry</h2>
                                <div class="product-list-header">
                                    <div class="row m-0 d-none d-md-flex">
                                        <div class="p-0 col-md-8">
                                            <h6>PRODUCT</h6>
                                        </div>
                                        <div class="p-0 col-md-4">
                                            <h6 class="text-end">QUANTITY</h6>
                                        </div>
                                    </div>
                                </div>


                                <?php
                                foreach ($quote_list as $post_id => $quantity):
                                    $post = get_post($post_id);
                                    if ($post): ?>
                                        <div class="product-list quote-item" data-post-id="<?php echo esc_attr($post_id); ?>">
                                            <div class="row m-0 align-items-center">
                                                <div class="p-0 col-md-8">
                                                    <div class="d-flex productdetails">
                                                        <?php
                                                        $featured_image = get_the_post_thumbnail($post_id, 'large');
                                                        if ($featured_image) {
                                                            echo '<div class="featured-image me-4">' . $featured_image . '</div>';
                                                        } ?>

                                                        <div>
                                                            <h6><?php echo esc_html(get_the_title($post_id)); ?> </h6>
                                                            <?php /*
                                                            $price = get_field('price');
                                                            if ($price): ?>
                                                                <p class="price">$ <?php echo esc_html($price); ?></p>
                                                            <?php endif; */?>

                                                            <p onclick="removeQuoteItem(<?php echo esc_js($post_id); ?>)"
                                                                class="delete remove">Remove</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="p-0 col-md-4 text-end">
                                                    <div class="quantity-controls quantity-selector">
                                                        <button type="button"
                                                            onclick="updateQuantity(<?php echo esc_js($post_id); ?>, -1)">-</button>
                                                        <input type="number" id="quantity-<?php echo esc_attr($post_id); ?>"
                                                            value="<?php echo esc_attr($quantity); ?>" min="1" readonly />
                                                        <button type="button"
                                                            onclick="updateQuantity(<?php echo esc_js($post_id); ?>, 1)">+</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif;
                                endforeach; ?>
                            </div>
                        </div>


                        <div class="col-lg-6 ps-lg-5">
                            <div class="product-enquiry-form ms-lg-5">
                                <p class="mb-3">
                                    Send us a message and our team will get back to you as soon as possible.
                                </p>
                                <div class="contact-form">
                                    <div class="form-wrap">
                                        <div class="mb-3">
                                            <label for="">Name*</label>
                                            <input type="text" id="name" name="name" placeholder="Name" required />
                                        </div>
                                        <div class="mb-3">
                                            <label for="">Contact Number*</label>
                                            <input type="text" id="phone" name="phone" placeholder="Phone Number"
                                                required />
                                        </div>
                                        <div class="mb-3">
                                            <label for="">Email Address*</label>
                                            <input type="email" id="email" name="email" placeholder="Email" required />
                                        </div>
                                        <div class="mb-3">
                                            <label for="">Subject*</label>
                                            <input type="text" id="subject" name="subject"  value="Product Enquiry"
                                                required readonly/>
                                        </div>

                                        <div class="mb-3">
                                            <label for="">Message*</label>
                                            <textarea id="message" name="message"
                                                rows="10"></textarea>
                                        </div>
                                        <div class="mb-3">
                                            <input type="hidden" name="action" value="submit_quote_request">


                                            <button type="submit" class="elementor-button w-100">
                                                <span> SUBMIT <i aria-hidden="true" class="icon icon-arrow-right"></i>
                                                </span>
                                            </button>

                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </form>
        <?php else: ?>
            <div class="text-center pt-md-5 pb-md-5 pt-4 pb-4">
            <h2 class="title">No items in your Enquiry list.</h2>
            </div>
         
        <?php endif; ?>
    </main>
</div>

<script>
    function updateQuantity(postId, change) {
        var quantityInput = document.getElementById('quantity-' + postId);
        var currentQuantity = parseInt(quantityInput.value);
        var newQuantity = currentQuantity + change;

        if (newQuantity >= 1) { // Ensure quantity doesn't go below 1
            quantityInput.value = newQuantity;

            // Use AJAX to update the quantity in the session
            var xhr = new XMLHttpRequest();
            xhr.open('POST', '<?php echo esc_url(admin_url('admin-ajax.php')); ?>', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    console.log('Quantity updated successfully');
                }
            };
            xhr.send('action=update_quote_quantity&post_id=' + postId + '&quantity=' + newQuantity);
        }
    }

    function removeQuoteItem(postId) {
        // Use AJAX to remove the item from the quote list
        var xhr = new XMLHttpRequest();
        xhr.open('POST', '<?php echo esc_url(admin_url('admin-ajax.php')); ?>', true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4 && xhr.status === 200) {
                // On success, remove the item from the DOM
                var item = document.querySelector('.quote-item[data-post-id="' + postId + '"]');
                if (item) {
                    item.remove();
                }
            }
        };
        xhr.send('action=remove_from_quote&post_id=' + postId);
    }
</script>



<?php if (isset($_GET['quote_submitted']) && $_GET['quote_submitted'] == '1') : ?>
<script>
document.addEventListener("DOMContentLoaded", function () {
    if (typeof PUM !== "undefined" && PUM.open) {
        PUM.open(1648); // Open popup with ID 1648
    }

    // Optional: Remove the query param from the URL
    if (window.history.replaceState) {
        const url = new URL(window.location.href);
        url.searchParams.delete("quote_submitted");
        window.history.replaceState({}, document.title, url.pathname);
    }
});
</script>
<?php endif; ?>



<?php get_footer(); ?>