<?php get_header(); ?>


<div class="single-eproduct-detail pt-md-5 pt-4">

    <?php
    global $post;
    $post_id = get_the_ID();
    while (have_posts()):
        the_post(); ?>
        <div class="container">
            <div class="row">

                <div class="col-12 pb-4 mb-2">
                    <?php function custom_breadcrumbs()
                    {
                        if (!is_single()) {
                            return;
                        }

                        global $post;

                        $breadcrumbs = '<nav aria-label="breadcrumb"><ol class="breadcrumb">';
                        $breadcrumbs .= '<li class="breadcrumb-item"><a href="' . home_url() . '">Home</a></li>';
                        $breadcrumbs .= '<li class="breadcrumb-item"><a href="' . get_permalink(get_page_by_path('Products')) . '">Products</a></li>';
                        $breadcrumbs .= '<li class="breadcrumb-item active" aria-current="page">' . get_the_title() . '</li>';
                        $breadcrumbs .= '</ol></nav>';

                        echo $breadcrumbs;
                    } ?>


                    <?php custom_breadcrumbs(); ?>
                </div>

                <div class="col-lg-6">

                    <?php
                    $thumbnails = [];

                    if (has_post_thumbnail()) {
                        $thumbnail_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
                        $thumbnails[] = $thumbnail_url;
                    }


                    $gallery = get_field('gallery');

                    $gallery_images = [
                        $gallery['first'] ?? null,
                        $gallery['second'] ?? null,
                        $gallery['third'] ?? null,
                        $gallery['fourth'] ?? null
                    ];

                    foreach ($gallery_images as $image) {
                        if (!empty($image['url'])) {
                            $thumbnails[] = $image['url'];
                        }
                    }
                    ?>

                    <?php if (!empty($thumbnails)): ?>
                        <div class="product-details-gallery d-lg-flex">
                            <?php if (count($thumbnails) > 1): ?>
           
                                <div class="thumbnail-slider">
                                    <?php foreach ($thumbnails as $thumb): ?>
                                        <div>
                                            <img src="<?php echo esc_url($thumb); ?>" alt="Thumb" />
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>

                            <div class="product-slider ps-lg-2">
                                <?php foreach ($thumbnails as $main_img): ?>
                                    <div>
                                        <img src="<?php echo esc_url($main_img); ?>" alt="Product Image" />
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    <?php endif; ?>





                </div>

                <!-- Product Details -->
                <div class="col-lg-6 ps-lg-5">
                    <div class="product_details ps-lg-4 mt-md-0 mt-3">
                        <h4 class="title mt-0"> <?php the_title(); ?> </h4>
                        <?php $price = get_field('price');
                        if ($price): ?>
                            <p class="price">$<?php echo esc_html($price); ?></p>
                        <?php endif; ?>
                        <div class="mb-md-5 mb-3">
                            <?php the_content(); ?>
                        </div>

                        <!-- Quantity Selector -->
                        <div class="d-flex align-items-center mb-md-5 mb-3">
                            <label class="mb-0 me-4">QUANTITY</label>

                            <div class="quantity-selector my-2">
                                <button type="button" id="decrease" onclick="decreaseQuantity()"> <i aria-hidden="true"
                                        class="icon icon-minus"></i> </button>
                                <input type="number" id="quantity" name="quantity" value="1" min="1" />
                                <button type="button" id="increase" onclick="increaseQuantity()"> <i aria-hidden="true"
                                        class="icon icon-plus"></i> </button>
                            </div>

                        </div>
                        <button class="elementor-button" id="EnquireNow" onclick="addToQuote(<?php echo $post_id; ?>)">
                            <span> ADD TO ENQUIRY <img
                                    src="https://draftsite1.com/t2960/wp-content/uploads/2025/07/icon-addtocart.svg" alt="">
                            </span>
                        </button>
                    </div>
                </div>
            </div>


            <?php
            $resources = get_field('downloadable_resources');
            if (!empty($resources)): ?>

                <div class="download-re">
                    <div class="row justify-content-center">
                        <div class="col-lg-9">
                            <h2 class="page-title mb-5 pb-3">Downloadable Resources</h2>


                            <?php foreach ($resources as $resource):
                                $title = esc_html($resource['resources_title']);
                                $file_url = esc_url($resource['resources_file']);

                                if (!empty($file_url)):
                                    ?>
                                    <a href="<?php echo $file_url; ?>" class="d-block mb-2" target="_blank" rel="noopener">
                                        <div class="dowlnoad-resource d-flex align-items-center justify-content-between">
                                            <div class="d-flex align-items-center">
                                                <img decoding="async" width="39" height="50"
                                                    src="https://draftsite1.com/t2960/wp-content/uploads/2025/07/icon-pdf-1.svg"
                                                    class="me-4" alt="">
                                                <h6 class="my-0"><?php echo $title; ?></h6>
                                            </div>
                                            <div class="elementor-icon">
                                                <i aria-hidden="true" class="icon icon-right-arrow"></i>
                                            </div>
                                        </div>
                                    </a>
                                    <?php
                                endif;
                            endforeach; ?>

                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <?php
    endwhile;
    ?>







    <div class="related-products">
        <div class="container">
            <?php
            $post_id = get_the_ID();
            $terms = get_the_terms($post_id, 'eproducts-category');

            if ($terms && !is_wp_error($terms)) {
                $category_id = $terms[0]->term_id;

                $args = array(
                    'post_type' => 'product-enquiry',
                    'posts_per_page' => 5,
                    'post__not_in' => array($post_id),
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'eproducts-category',
                            'field' => 'term_id',
                            'terms' => $category_id,
                        ),
                    ),
                    'orderby' => 'rand',
                );

                $related_posts_query = new WP_Query($args);


                if ($related_posts_query->have_posts()) {
                    ?>
                    <h2 class="page-title mb-5 pb-3">Related Products</h2>
                    <div class="related-product-slider ">
                        <?php

                        while ($related_posts_query->have_posts()) {
                            $related_posts_query->the_post();
                            ?>

                            <div class="p-2" id="post-<?php the_ID(); ?>">
                                <a href="<?php the_permalink(); ?>" <?php post_class(); ?>>
                                    <div class="product-card">
                                        <div class="img-box">
                                            <?php if (has_post_thumbnail()): ?>
                                                <?php the_post_thumbnail('full'); ?>
                                            <?php endif; ?>
                                            <div class="hover-overlay">
                                                <i aria-hidden="true" class="icon icon-plus"></i>
                                            </div>
                                        </div>
                                        <h6 class="mt-2 product-name"> <?php the_title(); ?></h6>

                                        <?php
                                        $price = get_field('price');
                                        if ($price): ?>
                                            <p class="price">$<?php echo esc_html($price); ?></p>
                                        <?php endif; ?>
                                    </div>
                                </a>
                            </div>

                        <?php } ?>
                    </div>
                    <?php


                    // Restore original post data
                    wp_reset_postdata();
                }
            }
            ?>
        </div>
    </div>

    <script>
        jQuery(document).ready(function ($) {
            $('.product-slider').slick({
                slidesToShow: 1,
                slidesToScroll: 1,
                arrows: false,
                fade: true,
                asNavFor: '.thumbnail-slider'
            });

            $('.thumbnail-slider').slick({
                slidesToShow: 5,
                slidesToScroll: 1,
                asNavFor: '.product-slider',
                dots: false,
                arrows: false,
                infinite: false,
                centerMode: false,
                focusOnSelect: true,
                vertical: true,
                verticalSwiping: true
            });
            $('.related-product-slider').slick({
                slidesToShow: 4,
                slidesToScroll: 1,
                arrows: true,
                dots: false,
                centerMode: false,
                infinite: false,
                prevArrow: '<button class="left-btn arrowbtn"><i class="icon icon-arrow-left"></i></button>',
                nextArrow: '<button class="right-btn arrowbtn"><i class="icon icon-arrow-right"></i></button>',
                responsive: [{
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 4,
                            slidesToScroll: 1,
                        },
                    },
                    {
                        breakpoint: 1008,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 1,
                        },
                    },
                    {
                        breakpoint: 800,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 1,
                        },
                    },
                    ],

            });
        });
    </script>


    <script>
        function increaseQuantity() {
            var quantityInput = document.getElementById('quantity');
            var currentValue = parseInt(quantityInput.value);
            quantityInput.value = currentValue + 1;
        }

        function decreaseQuantity() {
            var quantityInput = document.getElementById('quantity');
            var currentValue = parseInt(quantityInput.value);
            if (currentValue > 1) { // Prevent decreasing below 1
                quantityInput.value = currentValue - 1;
            }
        }

        function addToQuote(postId) {
            var quantity = document.getElementById('quantity').value;

            // Use AJAX to send data to the server
            var xhr = new XMLHttpRequest();
            xhr.open('POST', '<?php echo admin_url('admin-ajax.php'); ?>', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    // Redirect to the quote page after adding the item to the quote
                    window.location.href = 'https://draftsite1.com/t2960/product-enquiry-cart/';
                }
            };
            xhr.send('action=add_to_quote&post_id=' + postId + '&quantity=' + quantity);
        }
    </script>

</div>


<?php get_footer(); ?>