<?php
get_header(); ?>

<div id="primary" class="content-area">

    <main id="main" class="site-main custom-product-page pt-md-5 pt-4 pb-md-5 pb-4">
        <header class="page-header pt-md-5 pt-4 pb-md-4 pb-4">
            <div class="row">
                <div class="col-md-12 text-center pb-2">
                    <h1 class="page-title"><?php single_term_title(); ?></h1>
                    <p>Explore our range of high-performance products, trusted by industry professionals for quality,
                        reliability, and lasting results.</p>
                </div>
            </div>
        </header>
        <div class="row">
            <div class="col-lg-3 col-md-3 pe-lg-5 sidebar">
                <h5 class="m-0 sidebar-title">CATEGORIES</h5>

                <?php
                $active_category = single_term_title('', false);

                $taxonomy = 'eproducts-category';

                $terms = get_terms(
                    array(
                        'taxonomy' => $taxonomy,
                        'hide_empty' => false, 
                        'parent' => 0, 
                    )
                );

                if (!empty($terms) && !is_wp_error($terms)):
                    $i = 1;
                    ?>
                    <div class="taxonomy-list">

                        <div class="accordion" id="productCategoriesAccordion">
                            <?php
                            foreach ($terms as $term):
                                $term_link = get_term_link($term);
                                $active_class = ($active_category === $term->name) ? 'active' : '';

                                $subcategories = get_terms(
                                    array(
                                        'taxonomy' => $taxonomy,
                                        'hide_empty' => false,
                                        'parent' => $term->term_id,
                                    )
                                );
                                ?>


                                <div class="accordion-item">
                                    <div class="accordion-header" id="heading<?php echo $i; ?>">

                                        <a href="<?php echo esc_url($term_link); ?>" class="main-category <?php echo $active_class; ?>">
                                            <?php echo esc_html($term->name); ?>
                                        </a>

                                        <?php if ($subcategories) { ?>
                                            <button class="accordion-button <?php echo ($i > 1) ? 'collapsed' : ''; ?>"
                                                type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>"
                                                aria-expanded="<?php echo ($i === 1) ? 'true' : 'false'; ?>"
                                                aria-controls="collapse<?php echo $i; ?>"></button>
                                        <?php } ?>
                                    </div>
                                    <?php if ($subcategories) { ?>
                                        <div id="collapse<?php echo $i; ?>"
                                            class="accordion-collapse collapse <?php echo ($i === 1) ? 'show' : ''; ?>"
                                            aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#productCategoriesAccordion">
                                            <div class="accordion-body">
                                                <?php if (!empty($subcategories) && !is_wp_error($subcategories)): ?>
                                                    <ul class="list-unstyled">
                                                        <?php foreach ($subcategories as $subcategory):
                                                            $subcat_link = get_term_link($subcategory);
                                                            $subcat_active_class = ($active_category === $subcategory->name) ? 'active' : '';
                                                            ?>
                                                            <li>
                                                                <a href="<?php echo esc_url($subcat_link); ?>"
                                                                    class="<?php echo esc_attr($subcat_active_class); ?>">
                                                                    <?php echo esc_html($subcategory->name); ?>
                                                                </a>
                                                            </li>
                                                        <?php endforeach; ?>
                                                    </ul>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php } ?>
                                </div>
                                <?php
                                $i++;
                            endforeach; ?>
                        </div>
                    </div>
                    <?php
                else:
                    ?>
                    <p><?php esc_html_e('No categories found', 'textdomain'); ?></p>
                    <?php
                endif;
                ?>
            </div>


            <div class="col-lg-9 col-md-9">
                <div class="row">
                <?php if (have_posts()):
                    $active_category = single_term_title('', false);

                    $term = get_queried_object();
               
                    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

                    $args = array(
                        'post_type' => 'product-enquiry',
                        'posts_per_page' => 9,
                        'paged' => $paged,
                        'tax_query' => array(
                            array(
                                'taxonomy' => $term->taxonomy, 
                                'field' => 'slug',
                                'terms' => $term->slug,
                            ),
                        ),
                    );
                    $query = new WP_Query($args);

                    if ($query->have_posts()):
                        while ($query->have_posts()):
                            $query->the_post();
                            ?>

                            <div class="col-md-4 col-sm-6 mb-4" id="post-<?php the_ID(); ?>">
                                <a href="<?php the_permalink(); ?>" <?php // post_class(); ?>>
                                    <div class="product-card">
                                        <div class="img-box">
                                            <?php if (has_post_thumbnail()): ?>
                                                <?php the_post_thumbnail('full'); ?>
                                            <?php endif; ?>
                                            <div class="hover-overlay">
                                                <i aria-hidden="true" class="icon icon-plus"></i>
                                            </div>
                                        </div>
                                        <h6 class="mt-2 product-name"> <?php the_title(); ?></h6>

                                        <?php
                                        $price = get_field('price');
                                        if ($price): ?>
                                            <p class="price">$<?php echo esc_html($price); ?></p>
                                        <?php endif; ?>
                                    </div>
                                </a>
                            </div>
                            <?php
                        endwhile; ?>

                        <?php if ($query->max_num_pages > 1): ?>
                            <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                                <div class="pagination-two">
                                    <?php
                                    echo paginate_links(array(
                                        'total' => $query->max_num_pages,
                                        'current' => max(1, get_query_var('paged')),
                                        'format' => '?paged=%#%',
                                        'show_all' => false,
                                        'type' => 'plain',
                                        'prev_text' => '<img src="https://draftsite1.com/t2960/wp-content/uploads/2025/07/arrow-next.png" alt="Previous" style="transform: rotate(180deg);">',
                                        'next_text' => '<img src="https://draftsite1.com/t2960/wp-content/uploads/2025/07/arrow-next.png" alt="Next">',
                                        'end_size' => 2,
                                        'mid_size' => 2
                                    ));
                                    ?>
                                </div>
                            </div>
                        <?php endif; ?>



                    <?php else:
                        echo '<p>' . esc_html__('No Products Found', 'textdomain') . '</p>';
                    endif;

                    wp_reset_postdata();

                   else: ?>
                        <p class="nofound"><?php esc_html_e('No Products Found', 'textdomain'); ?></p>
                    <?php endif; ?>

                </div>
            </div>

    </main>
</div>

<?php get_footer(); ?>