<?php
// Enqueue the parent theme's stylesheet

function hello_elementor_child_enqueue_styles()
{
    wp_enqueue_style('hello-elementor-parent-style', get_template_directory_uri() . '/../hello-elementor-child/style.css');
    wp_enqueue_style('hello-elementor-parent-ecommerce', get_template_directory_uri() . '/../hello-elementor-child/ecommerce.css');
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles');


// Enqueue Booststrap 
function enqueue_bootstrap()
{
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');

//  Slick carousel script and styles
function enqueue_slick_scripts()
{
    //  Slick carousel script
    wp_enqueue_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js', array('jquery'), null, true);
    //  Slick carousel CSS
    wp_enqueue_style('slick-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_slick_scripts');

// custom code




// Home slider Start --------------------------------------------
function display_banner_home($atts)
{
    $args = array(
        'post_type' => 'main-slider',
    );

    $mainslider_query = new WP_Query($args);

    ob_start();

    if ($mainslider_query->have_posts()):
        $total_slides = $mainslider_query->post_count;
        $slide_num = 1;
        ?>
        <div id="demo" class="carousel slide carousel-fade hero-banner" data-bs-ride="carousel">
            <div class="carousel-inner">
                <?php
                $first = true;
                $slide_index = 0;
                while ($mainslider_query->have_posts()):
                    $mainslider_query->the_post(); ?>

                    <div class="carousel-item <?php echo $first ? 'active' : ''; ?>">

                        <?php
                        if (has_post_thumbnail()) {
                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                        }
                        ?>

                        <div class="carousel-caption text-start">
                            <h1> <?php the_title(); ?> </h1>
                            <div class="description">
                                <?php the_content(); ?>
                            </div>
                        </div>

                    </div>
                    <?php
                    $first = false;
                    $slide_index++;
                endwhile; ?>
            </div>
            <!-- <div class="arrow-control">
                <span class="carousel-control-prev" data-bs-target="#demo" data-bs-slide="prev">
                    <i class="elementor-icons-manager__tab__item__icon icon icon-left-arrow"></i>
                </span>
                <span class="carousel-control-next" data-bs-target="#demo" data-bs-slide="next">
                    <i class="elementor-icons-manager__tab__item__icon icon icon-arrow-right"></i>
                </span>
            </div> -->


            <script>
                document.addEventListener("DOMContentLoaded", function () {
                    var myCarousel = document.querySelector("#demo");
                    var currentSlideElement = document.querySelector("#current-slide");

                    myCarousel.addEventListener("slid.bs.carousel", function (event) {
                        var activeIndex = event.to + 1; // Carousel index starts from 0, so add 1
                        currentSlideElement.textContent = activeIndex;
                    });
                });
            </script>

        </div>

    <?php else: ?>
        <div>No Slider found.</div>
    <?php endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('banner_home', 'display_banner_home');


// Home slider end --------------------------------------------



// testimonials slider start 
function display_testimonials_slider($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
        ),
        $atts,
        'testimonials'
    );

    $args = array(
        'post_type' => 'testimonials',
        'posts_per_page' => $atts['posts_per_page'],
    );

    $testimonials_query = new WP_Query($args);

    ob_start();

    if ($testimonials_query->have_posts()):
        $total_slides = $testimonials_query->post_count;
        ?>
        <div class="testimonial-slider-outer">
            <div id="demo1" class="carousel slide" data-bs-ride="carousel">
                <div class="carousel-inner">
                    <?php $first = true;
                    $slide_index = 0;
                    ?>
                    <?php while ($testimonials_query->have_posts()):
                        $testimonials_query->the_post();
                        ?>

                        <div class="carousel-item <?php echo $first ? 'active' : ''; ?>">
                            <div class="row justify-content-center">
                                <div class="col-md-9">
                                    <div class="user-details text-white text-center">
                                        <p class="mb-5 description">“ <?php echo get_the_content(); ?> ”</p>
                                        <h4 class="mb-1 author-name">- <?php echo get_the_title(); ?></h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php $first = false; endwhile; ?>
                    <?php

                    $slide_index++;
                    ?>
                </div>

                <button class="carousel-control-prev" type="button" data-bs-target="#demo1" data-bs-slide="prev">
                    <span class="carousel-control-prev-icon"></span>
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#demo1" data-bs-slide="next">
                    <span class="carousel-control-next-icon"></span>
                </button>

                <div class="carousel-indicators">
                    <?php for ($i = 0; $i < $total_slides; $i++): ?>
                        <button type="button" data-bs-target="#demo1" data-bs-slide-to="<?php echo $i; ?>"
                            class="<?php echo $i === 0 ? 'active' : ''; ?>">
                            <?php // echo str_pad($i + 1, 2, '0', STR_PAD_LEFT); ?>
                        </button>
                    <?php endfor; ?>
                </div>


                <script>
                    document.addEventListener("DOMContentLoaded", function () {
                        var myCarousel = document.querySelector("#demo1");
                        var currentSlideElement = document.querySelector("#current-slide");

                        myCarousel.addEventListener("slid.bs.carousel", function (event) {
                            var activeIndex = event.to + 1; // Carousel index starts from 0, so add 1
                            currentSlideElement.textContent = activeIndex;
                        });
                    });
                </script>


            </div>

        </div>


    <?php else:
        echo 'No testimonials found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('testimonials_slider', 'display_testimonials_slider');
// testimonials slider end 



// Testimonial page start ------------------------------------------------------------

function display_testimonials($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 12,
        ),
        $atts,
        'testimonials'
    );

    // Get the current page
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;


    $args = array(
        'post_type' => 'testimonials',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => $paged,
    );

    $testimonials_query = new WP_Query($args);

    ob_start();

    if ($testimonials_query->have_posts()): ?>
        <div class="testimonial-page testimonials-main">
            <div class="row g-4" id="testimonials-container">
                <?php while ($testimonials_query->have_posts()):
                    $testimonials_query->the_post();
                    ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="testimonials-box">
                            <span class="quotes">“</span>
                            <p class="description">
                                <?php echo get_the_content(); ?>
                            </p>
                            <h6 class="author"> <?php echo get_the_title(); ?> </h6>

                            <?php
                            $year = get_field('year');
                            if ($year):
                                echo '<small class="designation">';
                                echo $year;
                                echo '</small>';
                            endif;
                            ?>
                        </div>

                    </div>
                <?php endwhile; ?>
            </div>
        </div>

        <!-- Load More Button -->
        <?php if ($testimonials_query->max_num_pages > 1): ?>
            <div class="text-center theme-link mt-md-5 mt-3 mb-3">
                <button id="load-more-testimonials" class="load-more-testimonials elementor-button load-more px-5 mt-5"
                    data-page="1" data-max-pages="<?php echo $testimonials_query->max_num_pages; ?>">Load More</button>
            </div>
        <?php endif; ?>


    <?php else:
        echo 'No testimonials found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('testimonials', 'display_testimonials');



function load_more_testimonials()
{
    $paged = isset($_POST['page']) ? intval($_POST['page']) : 1;
    $selected_category = isset($_POST['category']) ? sanitize_text_field($_POST['category']) : '';

    $args = array(
        'post_type' => 'testimonials',
        'posts_per_page' => 12,
        'paged' => $paged,
    );

    if (!empty($selected_category)) {
        $args['category_name'] = $selected_category;
    }

    $testimonials_query = new WP_Query($args);

    if ($testimonials_query->have_posts()) {
        while ($testimonials_query->have_posts()):
            $testimonials_query->the_post(); ?>
            <div class="col-lg-4 col-md-6">

                <div class="testimonials-box">
                    <span class="quotes">“</span>
                    <p class="description">
                        <?php echo get_the_content(); ?>
                    </p>
                    <h6 class="author"> <?php echo get_the_title(); ?> </h6>

                    <?php
                    $year = get_field('year');
                    if ($year):
                        echo '<small class="designation">';
                        echo $year;
                        echo '</small>';
                    endif;
                    ?>
                </div>

            </div>
        <?php endwhile;
    } else {
        echo 'No more testimonials found.';
    }
    ?>

    <?php

    wp_reset_postdata();
    wp_die();
}
add_action('wp_ajax_load_more_testimonials', 'load_more_testimonials');
add_action('wp_ajax_nopriv_load_more_testimonials', 'load_more_testimonials');

// testimonial end -----------------



// Enqueue jQuery and custom script for Load More functionality
function enqueue_load_more_scripts()
{
    // Enqueue jQuery (it is included by WordPress, just make sure it's added)
    wp_enqueue_script('jquery');

    // Enqueue custom script for Load More functionality
    wp_enqueue_script('load-more-script', get_template_directory_uri() . '/../hello-elementor-child/custom-script.js', array('jquery'), null, true);

    // Localize script to pass PHP values to JavaScript
    wp_localize_script('load-more-script', 'ajax_params', array(
        'ajax_url' => admin_url('admin-ajax.php'), // WordPress AJAX URL
        'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '', // Pass category if available
    ));
}
add_action('wp_enqueue_scripts', 'enqueue_load_more_scripts');


// Testimonial page End ------------------------------------------------------------



// join team page start ------------------------------------------------------------

function display_jointeam($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 12,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'jointeam'
    );

    // Get the current page


    $args = array(
        'post_type' => 'join-team',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );


    $jointeam_query = new WP_Query($args);

    ob_start();

    ?>

    <div class="job-portal-container">
        <?php



        if ($jointeam_query->have_posts()): ?>


            <?php while ($jointeam_query->have_posts()):
                $jointeam_query->the_post();
                ?>

                <div class="job-portal-box" id="<?php echo get_the_ID(); ?>">
                    <div class="row align-items-center m-0 g-md-0 g-3">
                        <div class="col-md-8">
                            <h2> <?php echo get_the_title(); ?> </h2>
                            <div>

                                <?php
                                $working_time = get_field('working_time');
                                if ($working_time): ?>
                                    <span class="time me-4">
                                        <img src="https://draftsite1.com/tgh-logistics/wp-content/uploads/2025/05/icon-clock.svg" alt=""
                                        class="me-2">
                                        <?php echo $working_time; ?> </span>
                                <?php endif; ?>


                                <?php
                                $location = get_field('location');
                                if ($location): ?>
                                    <span class="time me-4">
                                    <img  src="https://draftsite1.com/tgh-logistics/wp-content/uploads/2025/05/icon-location-pin.svg"
                                        alt="" class="me-2">
                                        <?php echo $location; ?> </span>
                                <?php endif; ?>

                            </div>
                        </div>
                        <div class="col-md-4 text-md-end text-center">
                            <a href="<?php the_permalink(); ?>" class="elementor-button load-more px-5 border-0">Join Us</a>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
        </div>

        <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
            <div class="pagination-two d-inline-block">
                <?php
                echo paginate_links(
                    array(
                        'total' => $jointeam_query->max_num_pages,
                        'current' => max(1, get_query_var('paged')),
                        'format' => '?paged=%#%',
                        'show_all' => false,
                        'type' => 'plain',
                        'prev_text' => '<i aria-hidden="true" class="icon icon-left-arrow"></i>',
                        'next_text' => '<i aria-hidden="true" class="icon icon-right-arrow"></i>',
                        'end_size' => 2,
                        'mid_size' => 2
                    )
                );
                ?>
            </div>
        </div>


    <?php else:
            echo 'No join team found.';
        endif;

        wp_reset_postdata();

        return ob_get_clean();
}
add_shortcode('jointeam', 'display_jointeam');


// join team page End ------------------------------------------------------------





// product-categories start -----------------------------------------

function wpb_woocommerce_product_categories_accordion()
{
    // Get the current queried product category
    $queried_object = get_queried_object();
    $current_category_id = ($queried_object && isset($queried_object->term_id)) ? $queried_object->term_id : 0;

    // Get all parent categories of the current category
    $current_category_parents = [];
    if ($current_category_id) {
        $parent_categories = get_ancestors($current_category_id, 'product_cat');
        $current_category_parents = array_map('intval', $parent_categories);
    }

    // Recursive function to get subcategories with checkboxes
    function get_subcategories($parent_id, $level = 1, $current_category_id, $current_category_parents)
    {
        $args = array(
            'taxonomy' => 'product_cat',
            'orderby' => 'name',
            'order' => 'ASC',
            'parent' => $parent_id,
            'hide_empty' => false
        );
        $sub_categories = get_terms($args);

        if (!empty($sub_categories)) {
            echo '<ul class="list-unstyled ps-2">';
            foreach ($sub_categories as $sub_category) {
                $is_checked = ($sub_category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($sub_category->term_id == $current_category_id) ? 'current-category' : '';

                echo '<li class="' . $active_class . '">';
                echo '<div class="in-menu">';
                echo '<input type="checkbox" class="category-checkbox me-2" data-category-id="' . $sub_category->term_id . '" ' . $is_checked . '> ';

                echo '<a href="' . get_term_link($sub_category) . '">  <span class="customcheck"></span>' . $sub_category->name . '</a>';
                echo '</div>';
                get_subcategories($sub_category->term_id, $level + 1, $current_category_id, $current_category_parents);
                echo '</li>';
            }
            echo '</ul>';
        }
    }

    // Get main product categories (parent categories)
    $args = array(
        'taxonomy' => 'product_cat',
        'orderby' => 'name',
        'order' => 'ASC',
        'parent' => 0,
        'hide_empty' => false
    );
    $product_categories = get_terms($args);

    if ($product_categories) {
        ob_start();
        ?>
        <div class="accordion" id="productCategoriesAccordion">

            <?php
            $shop_page_url = wc_get_page_permalink('shop');
            $is_shop_page = is_shop();
            ?>

            <!-- <div class="accordion-item">
                    <div class="accordion-header <?php //echo $is_shop_page ? 'current-category' : ''; 
                            ?>">
                        <label>
                            <a href="<?php // echo esc_url($shop_page_url); 
                                    ?>" class="main-category">
                                All Product
                            </a>
                        </label>
                    </div>
                </div> -->


            <?php
            $i = 0;
            foreach ($product_categories as $category) {
                $i++;

                // Check if the category has subcategories
                $sub_args = array(
                    'taxonomy' => 'product_cat',
                    'parent' => $category->term_id,
                    'hide_empty' => true
                );
                $sub_categories = get_terms($sub_args);
                $has_subcategories = !empty($sub_categories);

                // Determine if this category should be expanded
                $is_checked = ($category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'current-category' : '';
                $show_collapse = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'show' : '';
                ?>
                <div class="accordion-item <?php echo $active_class; ?>">
                    <div class="accordion-header d-flex align-items-center" id="heading<?php echo $i; ?>">
                        <label for="cat<?php echo $category->term_id; ?>">
                            <input type="checkbox" class="category-checkbox me-2" id="cat<?php echo $category->term_id; ?>"
                                data-category-id="<?php echo $category->term_id; ?>" <?php echo $is_checked; ?>>

                            <a href="<?php echo get_term_link($category); ?>" class="main-category">
                                <?php echo $category->name . ' <span class="count">(' . $category->count . ')</span>'; ?>
                                <span class="customcheck"></span>
                            </a>
                        </label>

                        <?php if ($has_subcategories) { ?>
                            <button class="accordion-button ms-auto <?php echo ($show_collapse == '') ? 'collapsed' : ''; ?>"
                                type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>"
                                aria-expanded="<?php echo ($show_collapse) ? 'true' : 'false'; ?>"
                                aria-controls="collapse<?php echo $i; ?>" data-category-id="<?php echo $category->term_id; ?>">
                                <i class="fa fa-angle-down"></i>
                            </button>
                        <?php } ?>
                    </div>
                    <?php if ($has_subcategories) { ?>
                        <div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse <?php echo $show_collapse; ?>"
                            aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#productCategoriesAccordion">
                            <div class="accordion-body ps-0 pe-0">
                                <?php get_subcategories($category->term_id, 1, $current_category_id, $current_category_parents); ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
                <?php
            }
            ?>
        </div>

        <script>
            document.addEventListener("DOMContentLoaded", function () {
                var savedCategories = JSON.parse(localStorage.getItem("checkedCategories")) || [];

                savedCategories.forEach(function (categoryId) {
                    var checkbox = document.querySelector('.category-checkbox[data-category-id="' + categoryId + '"]');
                    if (checkbox) {
                        checkbox.checked = true;
                    }
                });

                document.querySelectorAll(".category-checkbox").forEach(function (checkbox) {
                    checkbox.addEventListener("change", function () {
                        var categoryId = this.getAttribute("data-category-id");
                        if (this.checked) {
                            if (!savedCategories.includes(categoryId)) {
                                savedCategories.push(categoryId);
                            }
                        } else {
                            savedCategories = savedCategories.filter(id => id !== categoryId);
                        }
                        localStorage.setItem("checkedCategories", JSON.stringify(savedCategories));
                    });
                });

                var activeCategory = localStorage.getItem("activeCategory");
                if (activeCategory) {
                    var activeAccordion = document.querySelector('[data-category-id="' + activeCategory + '"]');
                    if (activeAccordion) {
                        var collapseElement = activeAccordion.getAttribute("data-bs-target");
                        document.querySelector(collapseElement).classList.add("show");
                        activeAccordion.classList.remove("collapsed");
                        activeAccordion.setAttribute("aria-expanded", "true");
                    }
                }

                document.querySelectorAll(".accordion-button").forEach(function (button) {
                    button.addEventListener("click", function () {
                        var categoryId = this.getAttribute("data-category-id");
                        if (document.querySelector(this.getAttribute("data-bs-target")).classList.contains("show")) {
                            localStorage.removeItem("activeCategory");
                        } else {
                            localStorage.setItem("activeCategory", categoryId);
                        }
                    });
                });
            });
        </script>

        <style>
            .current-category>a {
                font-weight: bold;
                color: #ff6600;
            }

            .category-checkbox {
                display: none;
            }

            span.customcheck {
                background: #FFFFFF 0% 0% no-repeat padding-box;
                border: 1px solid #BEC0C5;
                border-radius: 0px;
                width: 15px;
                height: 15px;
                position: relative;
                margin-right: 2px;
                margin-top: 0px;
                top: 2px;
                display: inline-block;
            }

            .current-category [type=checkbox]:checked~a span.customcheck {
                background: #000;
                border-color: #000;
            }

            .current-category [type=checkbox]~a .customcheck:after {
                content: "";
                position: absolute;
            }

            .current-category a input:checked~.customcheck:after {
                display: block;
            }

            .current-category a .customcheck:after {
                left: 5px;
                top: 2px;
                width: 4px;
                height: 8px;
                border: solid white;
                border-width: 0 2px 2px 0;
                -webkit-transform: rotate(45deg);
                -ms-transform: rotate(45deg);
                transform: rotate(45deg);
            }
        </style>
        <?php
        return ob_get_clean();
    }
}

add_shortcode('product_categories_accordion', 'wpb_woocommerce_product_categories_accordion');

// product category for sidebar end -------------------------------

// product quantity 
// Add custom quantity buttons JS
add_action('wp_footer', 'custom_quantity_buttons_script');
function custom_quantity_buttons_script()
{
    if (!is_product())
        return;
    ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const qtyContainers = document.querySelectorAll('.quantity');
            qtyContainers.forEach(qty => {
                const input = qty.querySelector('input.qty');
                if (!input) return;

                // Remove existing buttons (if any)
                if (qty.querySelector('.custom-plus')) return;

                // Create buttons
                const minus = document.createElement('button');
                minus.type = 'button';
                minus.innerHTML = '−';
                minus.className = 'custom-minus';

                const plus = document.createElement('button');
                plus.type = 'button';
                plus.innerHTML = '+';
                plus.className = 'custom-plus';

                // Insert buttons
                qty.insertBefore(minus, input);
                qty.appendChild(plus);

                // Event listeners
                minus.addEventListener('click', () => {
                    if (input.value > 1) input.value = parseInt(input.value) - 1;
                });
                plus.addEventListener('click', () => {
                    input.value = parseInt(input.value) + 1;
                });
            });
        });
    </script>

    <?php
}



add_action('wp_footer', 'hide_gallery_thumbs_if_single_image');
function hide_gallery_thumbs_if_single_image()
{
    if (is_product()): ?>
        <script>
            jQuery(document).ready(function ($) {
                $(window).on('load', function () {
                    var thumbCount = $('.wpgis-slider-nav .slick-slide').length;

                    if (thumbCount <= 1) {
                        $('.wpgis-slider-nav').hide();
                    } else {
                        $('.wpgis-slider-nav').show();
                    }
                });
            });
        </script>

    <?php endif;
}


// for related product --------------

add_filter('woocommerce_product_related_products_heading', 'custom_related_products_title');
function custom_related_products_title($title)
{
    return 'You May Like These, Too'; // Change this to whatever you want
}
function custom_related_products_args( $args ) {
    $args['posts_per_page'] = 3; // Limit to 3 products
    $args['columns'] = 3;        // Display in 3 columns
    return $args;
}
add_filter( 'woocommerce_output_related_products_args', 'custom_related_products_args' );

// for related product --------------

// product slick slider for home 
function slick_products_slider_shortcode($atts) {
    ob_start();
    echo '<div class="slick-product-slider">';
    echo do_shortcode('[products limit="3" columns="1"]'); // You can change limit
    echo '</div>';
    return ob_get_clean();
}
add_shortcode('slick_products', 'slick_products_slider_shortcode');


function add_slick_slider_init_script() {
    ?>
    <script>
        jQuery(document).ready(function($) {
            $('.slick-product-slider .products').slick({
                dots: false,
                    infinite: true,
                    speed: 300,
                    slidesToShow: 3,
                    slidesToScroll: 1,
                    adaptiveHeight: true,
                    prevArrow: '<div class="left-btn arrowbtn"><i class="icon icon-left-arrows"></i></div>',
                    nextArrow: '<div class="right-btn arrowbtn"><i class="icon icon-right-arrow1"></i></div>',
                    responsive: [{
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 3,
                            slidesToScroll: 1,
                        },
                    },
                    {
                        breakpoint: 1008,
                        settings: {
                            slidesToShow: 3,
                            slidesToScroll: 1,
                        },
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 1,
                        },
                    },
                    ],
                });
        });
    </script>
    <?php
}
add_action('wp_footer', 'add_slick_slider_init_script', 100);

// product slick slider for home 







// validation woocommerce start --------------------

add_action('woocommerce_save_account_details_errors', 'validate_my_account_fields', 10, 1);

function validate_my_account_fields($errors)
{
    // Validate First Name
    if (isset($_POST['account_first_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_first_name'])) {
        $errors->add('validation', __('Allowed characters for First Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Last Name
    if (isset($_POST['account_last_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_last_name'])) {
        $errors->add('validation', __('Allowed characters for Last Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Display Name
    if (isset($_POST['account_display_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_display_name'])) {
        $errors->add('validation', __('Allowed characters for Display Name are alphabets and spaces only.', 'woocommerce'));
    }
}




add_action('woocommerce_after_save_address_validation', 'validate_billing_address_fields', 10, 2);

function validate_billing_address_fields($user_id, $address_type)
{
    if ('billing' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $billing_first_name = isset($_POST['billing_first_name']) ? sanitize_text_field($_POST['billing_first_name']) : '';
        $billing_last_name = isset($_POST['billing_last_name']) ? sanitize_text_field($_POST['billing_last_name']) : '';
        $billing_city = isset($_POST['billing_city']) ? sanitize_text_field($_POST['billing_city']) : '';
        $billing_address_1 = isset($_POST['billing_address_1']) ? sanitize_text_field($_POST['billing_address_1']) : '';

        $billing_postcode = isset($_POST['billing_postcode']) ? sanitize_text_field($_POST['billing_postcode']) : '';
        $billing_email = isset($_POST['billing_email']) ? sanitize_email($_POST['billing_email']) : '';

        // Validate Billing First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_first_name)) {
            $validation_errors[] = __('Allowed characters for Billing First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_last_name)) {
            $validation_errors[] = __('Allowed characters for Billing Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_city)) {
            $validation_errors[] = __('Allowed characters for Billing City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $billing_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $billing_postcode)) {
            $validation_errors[] =  __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate Billing Email (Basic Email validation)
        if (!is_email($billing_email)) {
            $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}








add_action('woocommerce_after_save_address_validation', 'validate_shipping_address_fields', 10, 2);

function validate_shipping_address_fields($user_id, $address_type)
{
    if ('shipping' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $shipping_first_name = isset($_POST['shipping_first_name']) ? sanitize_text_field($_POST['shipping_first_name']) : '';
        $shipping_last_name = isset($_POST['shipping_last_name']) ? sanitize_text_field($_POST['shipping_last_name']) : '';
        $shipping_city = isset($_POST['shipping_city']) ? sanitize_text_field($_POST['shipping_city']) : '';
        $shipping_address_1 = isset($_POST['shipping_address_1']) ? sanitize_text_field($_POST['shipping_address_1']) : '';

        $shipping_postcode = isset($_POST['shipping_postcode']) ? sanitize_text_field($_POST['shipping_postcode']) : '';
      //  $shipping_email = isset($_POST['shipping_email']) ? sanitize_email($_POST['shipping_email']) : '';

        // Validate shipping First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_first_name)) {
            $validation_errors[] = __('Allowed characters for shipping First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_last_name)) {
            $validation_errors[] = __('Allowed characters for shipping Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_city)) {
            $validation_errors[] = __('Allowed characters for shipping City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $shipping_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $shipping_postcode)) {
            $validation_errors[] =  __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate shipping Email (Basic Email validation)
        // if (!is_email($shipping_email)) {
        //     $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        // }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}




// validation woocommerce end --------------------




//  form validation start ---------------------

// Validate text fields (only alphabets allowed)
add_filter( 'wpcf7_validate_text', 'alpha_validation_filter_text', 20, 2 );
add_filter( 'wpcf7_validate_text*', 'alpha_validation_filter_text', 20, 2 );

function alpha_validation_filter_text( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'names' === $tag->name ) {
        $name_of_the_input = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input) ) {
            $result->invalidate( $tag, "Allowed characters are Alphabets only." );
        }
    }

    if ( 'company' === $tag->name ) {
        $name_of_the_input = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input) ) {
            $result->invalidate( $tag, "Allowed characters are Alphabets only." );
        }
    }

    if ( 'position' === $tag->name ) {
        $name_of_the_input = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input) ) {
            $result->invalidate( $tag, "Allowed characters are Alphabets only." );
        }
    }


    return $result;
}

// Validate phone number (must be exactly 10 digits)
add_filter( 'wpcf7_validate_tel', 'numeric_phone_validation_filter', 20, 2 );
add_filter( 'wpcf7_validate_tel*', 'numeric_phone_validation_filter', 20, 2 );

function numeric_phone_validation_filter( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'phone' === $tag->name ) {
        $phone_number = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! preg_match( '/^\d{10}$/', $phone_number ) ) {
            $result->invalidate( $tag, "Phone number must contain exactly 10 digits." );
        }
    }

    return $result;
}



// Validate email (must be a valid email format)
add_filter( 'wpcf7_validate_email', 'validate_email_filter', 20, 2 );
add_filter( 'wpcf7_validate_email*', 'validate_email_filter', 20, 2 );

function validate_email_filter( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'email' === $tag->name ) {
        $email = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! filter_var( $email, FILTER_VALIDATE_EMAIL ) ) {
            $result->invalidate( $tag, "Please enter a valid email address." );
        }
    }

    return $result;
}


// Validate textarea field (message)
add_filter( 'wpcf7_validate_textarea', 'validate_textarea_filter', 20, 2 );
add_filter( 'wpcf7_validate_textarea*', 'validate_textarea_filter', 20, 2 );

function validate_textarea_filter( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'message' === $tag->name ) {
        $message = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        // Allowed characters: alphabets, spaces, common punctuation marks
        if ( ! preg_match( '/^[a-zA-Z0-9\s.,!?()-]+$/', $message ) ) {
            $result->invalidate( $tag, "Message contains invalid characters. Only letters, numbers, spaces, and punctuation are allowed." );
        }

        // Min 10 characters, Max 500 characters
        if ( strlen( $message ) < 10 || strlen( $message ) > 500 ) {
            $result->invalidate( $tag, "Message must be between 10 and 500 characters." );
        }
    }

    return $result;
}


//  form validation end ------------------------




add_filter('woocommerce_package_rates', 'hide_shipping_when_free_is_available', 100);
function hide_shipping_when_free_is_available($rates) {
    $free = array();
    
    foreach ($rates as $rate_id => $rate) {
        if ('free_shipping' === $rate->method_id) {
            $free[$rate_id] = $rate;
            break;
        }
    }

    return !empty($free) ? $free : $rates;
}







add_action('wp_footer', function () {
    if (!is_cart()) return;
    ?>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
        const interval = setInterval(function () {
            const cartItems = document.querySelector('.wc-block-cart-items');

            if (cartItems && !document.querySelector('#custom-update-cart')) {
                // Create the Update Cart button
                const btn = document.createElement('button');
                btn.textContent = 'Update Cart';
                btn.id = 'custom-update-cart';
                btn.class = 'elementor-button';
                btn.type = 'button';
                btn.style = 'display: block;';

                // Insert the button after cart items
                cartItems.parentNode.insertBefore(btn, cartItems.nextSibling);

                // Refresh the page when clicked
                btn.addEventListener('click', function () {
                    location.reload(); // ✅ Force page reload
                });

                clearInterval(interval);
            }
        }, 300);
    });
    </script>
    <?php
});


?>


