<?php
defined('ABSPATH') || exit;

get_header('shop');
?>
<div class="shop-page">


<div class="banner-main">
    <?php
    if (is_product_category()) {
        $category = get_queried_object();

        if ($category && isset($category->term_id)) {
            $thumbnail_id = get_term_meta($category->term_id, 'thumbnail_id', true);
            $image_url = wp_get_attachment_url($thumbnail_id);
            if ($image_url) {
                echo '<img src="' . esc_url($image_url) . '" class="w-100">';
            } else {
                // Fallback image if no thumbnail is set
                echo '<img src="https://draftsite1.com/thor-international/wp-content/uploads/2025/04/Banner-4.jpg" class="w-100">';
            }
        }
    } else {
        // Default image for non-category pages
        echo '<img src="https://draftsite1.com/thor-international/wp-content/uploads/2025/04/Banner-4.jpg" class="w-100">';
    }
    ?>

    <div class="container banner-resources">
        <div class="col-lg-12">
            <h6 class="elementor-heading-title elementor-size-default">OUR PRODUCTS</h6>

            <?php if (is_product_category()) {
                $category = get_queried_object();
                if ($category) {
                    echo '<h1 class="elementor-heading-title elementor-size-default">' . esc_html($category->name) . '</h1>';
                }
            } else {
                echo '<h1>Shop</h1>';
            } ?>
        </div>
    </div>
</div>





    <div class="shop-inner-section">

        <div class="container">


            <div class="row g-md-3 g-3">
                <div class="col-md-4 pe-md-5">
                    <div class="fiter_shop">
                        <h2> Product Categories </h2>
                        <?php echo do_shortcode('[product_categories_accordion]'); ?>

                    </div>
                </div>
                <div class="col-md-8">
                    <div class="custom-product-grid" id="products">
                        <?php if (woocommerce_product_loop()): ?>
                            <?php
                            do_action('woocommerce_before_shop_loop');
                            woocommerce_product_loop_start();
                            if (wc_get_loop_prop('total')) {
                                while (have_posts()) {
                                    the_post();
                                    do_action('woocommerce_shop_loop');
                                    wc_get_template_part('content', 'product');
                                }
                            }
                            woocommerce_product_loop_end();
                            do_action('woocommerce_after_shop_loop');
                            ?>
                        <?php else: ?>
                            <?php do_action('woocommerce_no_products_found'); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
<div class="comman-section-shop">
    <?php echo do_shortcode('[hfe_template id="265"]'); ?>
</div>





<?php
do_action('woocommerce_after_main_content');

get_footer('shop'); ?>


<style>
    .woocommerce-page .content-area {
        display: none;
    }
</style>