jQuery(document).ready(function ($) {

    function fetchBrands(category = '', search = '') {
        $.ajax({
            url: brands_ajax_obj.ajaxurl,
            type: 'GET',
            data: {
                action: 'filter_brands',
                category: category,
                s: search,
                nonce: brands_ajax_obj.nonce
            },
            beforeSend: function () {
                $('.brands_list-page').html('<p>Loading...</p>');
            },
            success: function (response) {
                $('.brands_list-page').html(response);
            }
        });
    }

    // Handle category click
    $('.filter-btns').on('click', 'a', function (e) {
        e.preventDefault();
        const category = $(this).data('category');
        fetchBrands(category, $('input[name="s"]').val());
    });

    // Handle search form submit
    $('.brans-search').on('submit', function (e) {
        e.preventDefault();
        const searchVal = $(this).find('input[name="s"]').val();
        const category = $('.filter-btns a.active').data('category') || '';
        fetchBrands(category, searchVal);
    });
});
